/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.api.RecentProjects;
import org.netbeans.modules.project.ui.api.UnloadedProjectInformation;
import org.netbeans.modules.welcome.content.ActionButton;
import org.netbeans.modules.welcome.content.BundleSupport;
import org.netbeans.modules.welcome.content.Constants;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class RecentProjectsPanel
extends JPanel
implements Constants {
    private static final int MAX_PROJECTS = 10;
    private PropertyChangeListener changeListener;

    public RecentProjectsPanel() {
        super(new BorderLayout());
        this.setOpaque(false);
    }

    public void addNotify() {
        super.addNotify();
        this.removeAll();
        this.add((Component)this.rebuildContent(), "Center");
        RecentProjects.getDefault().addPropertyChangeListener(this.getPropertyChangeListener());
    }

    public void removeNotify() {
        super.removeNotify();
        RecentProjects.getDefault().removePropertyChangeListener(this.getPropertyChangeListener());
    }

    private PropertyChangeListener getPropertyChangeListener() {
        if (null == this.changeListener) {
            this.changeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("RecentProjectInformation".equals(propertyChangeEvent.getPropertyName())) {
                        RecentProjectsPanel.this.removeAll();
                        RecentProjectsPanel.this.add((Component)RecentProjectsPanel.this.rebuildContent(), "Center");
                        RecentProjectsPanel.this.invalidate();
                        RecentProjectsPanel.this.revalidate();
                        RecentProjectsPanel.this.repaint();
                    }
                }
            };
        }
        return this.changeListener;
    }

    private JPanel rebuildContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        int n = 0;
        List list = RecentProjects.getDefault().getRecentProjectInformation();
        for (UnloadedProjectInformation unloadedProjectInformation : list) {
            this.addProject(jPanel, n++, unloadedProjectInformation);
            if (n < 10) continue;
            break;
        }
        if (0 == n) {
            jPanel.add((Component)new JLabel(BundleSupport.getLabel("NoRecentProject")), new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        } else {
            jPanel.add((Component)new JLabel(), new GridBagConstraints(0, n, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return jPanel;
    }

    private void addProject(JPanel jPanel, int n, UnloadedProjectInformation unloadedProjectInformation) {
        OpenProjectAction openProjectAction = new OpenProjectAction(unloadedProjectInformation);
        ActionButton actionButton = new ActionButton(openProjectAction, true, unloadedProjectInformation.getURL().toString());
        actionButton.setFont(BUTTON_FONT);
        actionButton.getAccessibleContext().setAccessibleName(actionButton.getText());
        actionButton.getAccessibleContext().setAccessibleDescription(BundleSupport.getAccessibilityDescription("RecentProject", actionButton.getText()));
        jPanel.add((Component)actionButton, new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    private class OpenProjectAction
    extends AbstractAction {
        private UnloadedProjectInformation project;

        public OpenProjectAction(UnloadedProjectInformation unloadedProjectInformation) {
            super(unloadedProjectInformation.getDisplayName(), unloadedProjectInformation.getIcon());
            this.project = unloadedProjectInformation;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            URL uRL = this.project.getURL();
            Project project = null;
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject != null && fileObject.isFolder()) {
                try {
                    project = ProjectManager.getDefault().findProject(fileObject);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (project != null) {
                OpenProjects.getDefault().open(new Project[]{project}, false);
            } else {
                String string = BundleSupport.getMessage("ERR_InvalidProject", this.project.getDisplayName());
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                RecentProjectsPanel.this.rebuildContent();
            }
        }
    }
}

