/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.List;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.editor.util.GapList;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenListList
extends GapList<EmbeddedTokenList<?>> {
    private final TokenHierarchyOperation operation;
    private final LanguagePath languagePath;
    private boolean joinSections;
    private int childrenCount;
    private static final EmbeddedTokenList<?>[] EMPTY_TOKEN_LIST_ARRAY = new EmbeddedTokenList[0];

    public TokenListList(TokenHierarchyOperation<?, ?> tokenHierarchyOperation, LanguagePath languagePath) {
        super(4);
        this.operation = tokenHierarchyOperation;
        this.languagePath = languagePath;
        assert (languagePath.size() >= 2);
        Language<?> language = languagePath.innerLanguage();
        if (languagePath.size() > 2) {
            Object object = null;
            TokenListList tokenListList = tokenHierarchyOperation.tokenListList(languagePath.parent());
            for (int i = 0; i < tokenListList.size(); ++i) {
                TokenList tokenList = (TokenList)tokenListList.get(i);
                object = this.scanTokenList(tokenList, language, object);
            }
        } else {
            this.scanTokenList(tokenHierarchyOperation.rootTokenList(), language, null);
        }
    }

    private Object scanTokenList(TokenList<?> tokenList, Language<?> language, Object object) {
        int n = tokenList.tokenCount();
        for (int i = 0; i < n; ++i) {
            EmbeddedTokenList<?> embeddedTokenList = EmbeddingContainer.embeddedTokenList(tokenList, i, language);
            if (embeddedTokenList == null) continue;
            this.add(embeddedTokenList);
            if (embeddedTokenList.embedding().joinSections()) {
                this.joinSections = true;
                if (embeddedTokenList.isInited()) continue;
                embeddedTokenList.init(object);
                object = LexerUtilsConstants.endState(embeddedTokenList, object);
                continue;
            }
            object = null;
        }
        return object;
    }

    public LanguagePath languagePath() {
        return this.languagePath;
    }

    public boolean joinSections() {
        return this.joinSections;
    }

    public void setJoinSections(boolean bl) {
        this.joinSections = bl;
    }

    public void increaseChildrenCount() {
        ++this.childrenCount;
    }

    public void decreaseChildrenCount() {
        --this.childrenCount;
    }

    public boolean hasChildren() {
        return this.childrenCount > 0;
    }

    public Object relexState(int n) {
        Object object = LexerUtilsConstants.INVALID_STATE;
        for (int i = n - 1; i >= 0 && object == LexerUtilsConstants.INVALID_STATE; --i) {
            object = LexerUtilsConstants.endState((EmbeddedTokenList)this.get(i));
        }
        if (object == LexerUtilsConstants.INVALID_STATE) {
            object = null;
        }
        return object;
    }

    public EmbeddedTokenList<?> getOrNull(int n) {
        return n < this.size() ? (EmbeddedTokenList)this.get(n) : null;
    }

    public EmbeddedTokenList<?>[] replace(int n, int n2, List<? extends TokenList<?>> list) {
        Object[] objectArray;
        if (n2 > 0) {
            objectArray = new EmbeddedTokenList[n2];
            this.copyElements(n, n + n2, objectArray, 0);
            this.remove(n, n2);
        } else {
            objectArray = EMPTY_TOKEN_LIST_ARRAY;
        }
        List<? extends TokenList<?>> list2 = list;
        this.addAll(n, list2);
        return objectArray;
    }

    void childAdded() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    TokenHierarchyOperation operation() {
        return this.operation;
    }

    int modCount() {
        return this.operation.modCount();
    }

    public int findIndex(int n) {
        int n2 = this.size() - 1;
        int n3 = 0;
        while (n3 <= n2) {
            int n4 = n3 + n2 >> 1;
            EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)this.get(n4);
            embeddedTokenList.embeddingContainer().updateStatus();
            int n5 = embeddedTokenList.startOffset() - n;
            if (n5 < 0) {
                n3 = n4 + 1;
                continue;
            }
            if (n5 > 0) {
                n2 = n4 - 1;
                continue;
            }
            n3 = n4;
            break;
        }
        return n3;
    }

    public int findIndexDuringUpdate(EmbeddedTokenList embeddedTokenList, int n, int n2) {
        int n3 = this.size() - 1;
        int n4 = 0;
        int n5 = embeddedTokenList.startOffset();
        if (n5 > n && embeddedTokenList.embeddingContainer().isRemoved()) {
            n5 = Math.max(n5 - n2, n);
        }
        block0: while (n4 <= n3) {
            int n6;
            int n7 = n4 + n3 >> 1;
            EmbeddedTokenList embeddedTokenList2 = (EmbeddedTokenList)this.get(n7);
            embeddedTokenList2.embeddingContainer().updateStatusImpl();
            int n8 = embeddedTokenList2.startOffset();
            if (n8 > n && embeddedTokenList2.embeddingContainer().isRemoved()) {
                n8 = Math.max(n8 - n2, n);
            }
            if ((n6 = n8 - n5) < 0) {
                n4 = n7 + 1;
                continue;
            }
            if (n6 > 0) {
                n3 = n7 - 1;
                continue;
            }
            n4 = n7;
            if (embeddedTokenList2 == embeddedTokenList) break;
            --n4;
            while (n4 >= 0) {
                embeddedTokenList2 = (EmbeddedTokenList)this.get(n4);
                if (embeddedTokenList2 == embeddedTokenList) {
                    return n4;
                }
                embeddedTokenList2.embeddingContainer().updateStatusImpl();
                n8 = embeddedTokenList2.startOffset();
                if (n8 > n && embeddedTokenList2.embeddingContainer().isRemoved()) {
                    n8 = Math.max(n8 - n2, n);
                }
                if (n8 != n) break;
                --n4;
            }
            for (n4 = n7 + 1; n4 < this.size(); ++n4) {
                embeddedTokenList2 = (EmbeddedTokenList)this.get(n4);
                if (embeddedTokenList2 == embeddedTokenList) {
                    return n4;
                }
                embeddedTokenList2.embeddingContainer().updateStatusImpl();
                n8 = embeddedTokenList2.startOffset();
                if (n8 > n && embeddedTokenList2.embeddingContainer().isRemoved()) {
                    n8 = Math.max(n8 - n2, n);
                }
                if (n8 != n) break block0;
            }
        }
        return n4;
    }

    public String checkConsistency() {
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)this.get(i);
            embeddedTokenList.embeddingContainer().updateStatusImpl();
            if (embeddedTokenList.startOffset() < n) {
                return "TOKEN-LIST-LIST Invalid start offset at index=" + i + ": etl[" + i + "].startOffset()=" + embeddedTokenList.startOffset() + " < lastEndOffset=" + n + "\n" + (Object)((Object)this);
            }
            if (embeddedTokenList.startOffset() > embeddedTokenList.endOffset()) {
                return "TOKEN-LIST-LIST Invalid end offset at index=" + i + ": etl[" + i + "].startOffset()=" + embeddedTokenList.startOffset() + " > etl[" + i + "].endOffset()=" + embeddedTokenList.endOffset() + "\n" + (Object)((Object)this);
            }
            if (embeddedTokenList.embeddingContainer() == null) {
                return "TOKEN-LIST-LIST Null ec at index=" + i + "\n" + (Object)((Object)this);
            }
            if (embeddedTokenList.embeddingContainer().isRemoved()) {
                return "TOKEN-LIST-LIST Removed ec fat index=" + i + "\n" + (Object)((Object)this);
            }
            n = embeddedTokenList.endOffset();
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(2048);
        stringBuilder.append("TokenListList for ");
        stringBuilder.append(this.languagePath().mimePath());
        if (this.joinSections()) {
            stringBuilder.append(", joinSections");
        }
        if (this.hasChildren()) {
            stringBuilder.append(", hasChildren");
        }
        stringBuilder.append('\n');
        int n = ArrayUtilities.digitCount((int)this.size());
        for (int i = 0; i < this.size(); ++i) {
            EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)this.get(i);
            ArrayUtilities.appendBracketedIndex((StringBuilder)stringBuilder, (int)i, (int)n);
            embeddedTokenList.embeddingContainer().updateStatus();
            stringBuilder.append(embeddedTokenList.toStringHeader());
            EmbeddingContainer<?> embeddingContainer = embeddedTokenList.embeddingContainer();
            if (embeddingContainer != null && embeddingContainer.isRemoved()) {
                stringBuilder.append(", <--REMOVED-->");
            }
            stringBuilder.append('\n');
            LexerUtilsConstants.appendTokenListIndented(stringBuilder, embeddedTokenList, 4);
        }
        return stringBuilder.toString();
    }
}

