/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.ui.customizer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiProjectProperties;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.VisualArchiveIncludesSupport;

public final class VisualPropertySupport {
    private static final String WRONG_TYPE = "WrongType";
    private JbiProjectProperties webProperties;
    private HashMap component2property;
    private ComponentListener componentListener;
    private int comboType;
    private String[] comboValues;

    public VisualPropertySupport(JbiProjectProperties jbiProjectProperties) {
        this.webProperties = jbiProjectProperties;
        this.component2property = new HashMap(10);
        this.componentListener = new ComponentListener();
    }

    public void register(JCheckBox jCheckBox, String string) {
        Boolean bl = (Boolean)this.getAsType(string, Boolean.class);
        this.component2property.put(jCheckBox, string);
        jCheckBox.setSelected(bl != null && bl != false);
        jCheckBox.removeActionListener(this.componentListener);
        jCheckBox.addActionListener(this.componentListener);
    }

    public void register(JTextField jTextField, String string) {
        String string2 = (String)this.getAsType(string, String.class);
        this.component2property.put(jTextField.getDocument(), string);
        jTextField.setText(string2 != null ? string2 : "");
        jTextField.getDocument().addDocumentListener(this.componentListener);
    }

    public void register(JComboBox jComboBox, String[] stringArray, String string) {
        this.comboType = 0;
        String string2 = (String)this.getAsType(string, String.class);
        this.component2property.put(jComboBox, string);
        jComboBox.removeAllItems();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox.addItem(stringArray[i]);
            if (!stringArray[i].equals(string2)) continue;
            n = i;
        }
        jComboBox.setSelectedIndex(n);
        jComboBox.removeActionListener(this.componentListener);
        jComboBox.addActionListener(this.componentListener);
    }

    public void register(JComboBox jComboBox, ComboBoxModel comboBoxModel, ListCellRenderer listCellRenderer, String string, Class clazz) {
        this.comboType = 0;
        Object object = this.getAsType(string, clazz);
        this.component2property.put(jComboBox, string);
        jComboBox.removeAllItems();
        jComboBox.setModel(comboBoxModel);
        if (listCellRenderer != null) {
            jComboBox.setRenderer(listCellRenderer);
        }
        jComboBox.setSelectedItem(object);
        jComboBox.removeActionListener(this.componentListener);
        jComboBox.addActionListener(this.componentListener);
    }

    public void register(JComboBox jComboBox, String[] stringArray, String[] stringArray2, String string) {
        this.comboType = 1;
        this.comboValues = stringArray2;
        String string2 = (String)this.getAsType(string, String.class);
        this.component2property.put(jComboBox, string);
        jComboBox.removeAllItems();
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox.addItem(stringArray[i]);
            if (!stringArray2[i].equals(string2)) continue;
            n = i;
        }
        jComboBox.setSelectedIndex(n);
        jComboBox.removeActionListener(this.componentListener);
        jComboBox.addActionListener(this.componentListener);
    }

    public void register(VisualArchiveIncludesSupport visualArchiveIncludesSupport, String string) {
        List list = (List)this.getAsType(string, List.class);
        this.component2property.put(visualArchiveIncludesSupport, string);
        visualArchiveIncludesSupport.setVisualWarItems(list != null ? list : Collections.EMPTY_LIST);
        visualArchiveIncludesSupport.removeActionListener(this.componentListener);
        visualArchiveIncludesSupport.addActionListener(this.componentListener);
    }

    private static Boolean readValue(JCheckBox jCheckBox) {
        return jCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
    }

    private static String readValue(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            assert (false) : "Invalid document ";
            return "";
        }
    }

    private static Object readValue(JComboBox jComboBox) {
        return jComboBox.getSelectedItem();
    }

    private Object getAsType(String string, Class clazz) {
        return this.getAsType(string, clazz, true);
    }

    private Object getAsType(String string, Class clazz, boolean bl) {
        Object object = this.webProperties.get(string);
        if (object == null || clazz.isInstance(object)) {
            return object;
        }
        if (bl) {
            throw new IllegalArgumentException("Value of property: " + string + " exbected to be: " + clazz.getName() + " but was: " + object.getClass().getName() + "!");
        }
        return WRONG_TYPE;
    }

    private class ComponentListener
    implements ActionListener,
    DocumentListener {
        private ComponentListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = (String)VisualPropertySupport.this.component2property.get(object);
            if (string != null) {
                if (object instanceof JCheckBox) {
                    VisualPropertySupport.this.webProperties.put(string, VisualPropertySupport.readValue((JCheckBox)object));
                } else if (object instanceof JComboBox) {
                    if (((JComboBox)object).getItemCount() == 0) {
                        return;
                    }
                    switch (VisualPropertySupport.this.comboType) {
                        case 0: {
                            VisualPropertySupport.this.webProperties.put(string, VisualPropertySupport.readValue((JComboBox)object));
                            break;
                        }
                        case 1: {
                            int n = ((JComboBox)object).getSelectedIndex();
                            if (n == -1) break;
                            VisualPropertySupport.this.webProperties.put(string, VisualPropertySupport.this.comboValues[n]);
                        }
                    }
                } else if (object instanceof VisualArchiveIncludesSupport) {
                    VisualPropertySupport.this.webProperties.put(string, ((VisualArchiveIncludesSupport)object).getVisualWarItems());
                }
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            String string = (String)VisualPropertySupport.this.component2property.get(document);
            if (string != null) {
                VisualPropertySupport.this.webProperties.put(string, VisualPropertySupport.readValue(document));
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }
    }
}

