/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.compapp.projects.jbi.api.JbiProjectConstants;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

public class VisualClassPathItem {
    public static final int TYPE_JAR = 0;
    public static final int TYPE_LIBRARY = 1;
    public static final int TYPE_ARTIFACT = 2;
    public static final int TYPE_CLASSPATH = 3;
    private static String RESOURCE_ICON_JAR = "org/netbeans/modules/compapp/projects/jbi/ui/resources/jar.gif";
    private static String RESOURCE_ICON_LIBRARY = "org/netbeans/modules/compapp/projects/jbi/ui/resources/libraries.gif";
    private static String RESOURCE_ICON_ARTIFACT = "org/netbeans/modules/compapp/projects/jbi/ui/resources/projectDependencies.gif";
    private static String RESOURCE_ICON_CLASSPATH = "org/netbeans/modules/compapp/projects/jbi/ui/resources/j2seProject.gif";
    private static Icon ICON_JAR = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_JAR));
    private static Icon ICON_LIBRARY = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_LIBRARY));
    private static Icon ICON_ARTIFACT = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_ARTIFACT));
    private static Icon ICON_CLASSPATH = new ImageIcon(Utilities.loadImage((String)RESOURCE_ICON_CLASSPATH));
    private int type;
    private Object cpElement;
    private String raw;
    private String eval;
    private String shortName;
    private String projectName;
    private boolean inDeployment;
    private String asaType;
    private String asaDescription;
    private String asaTarget;
    private Icon projIcon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VisualClassPathItem(Object object, int n, String string, String string2, boolean bl) {
        this.cpElement = object;
        this.type = n;
        this.raw = string;
        this.eval = string2;
        this.inDeployment = bl;
        this.shortName = string2 != null ? string2 : string;
        this.projectName = "";
        this.asaType = "";
        if (object instanceof AntArtifact) {
            AntArtifact antArtifact;
            String string3;
            int n2;
            this.shortName = new File(this.shortName).getName();
            AntArtifact antArtifact2 = (AntArtifact)object;
            ProjectInformation projectInformation = (ProjectInformation)antArtifact2.getProject().getLookup().lookup(ProjectInformation.class);
            if (projectInformation != null) {
                this.projectName = projectInformation.getDisplayName();
                if (this.shortName.equals("SEDeployment.jar")) {
                    this.shortName = this.projectName + ".jar";
                }
                this.projIcon = projectInformation.getIcon();
            }
            if ((n2 = (string3 = antArtifact2.getType()).indexOf(58)) > 0) {
                this.asaType = string3.substring(n2 + 1);
            } else {
                antArtifact = VisualClassPathItem.getJavaEEAntArtifact(antArtifact2);
                if (antArtifact != null) {
                    this.asaType = "sun-javaee-engine";
                    antArtifact2 = antArtifact;
                    this.cpElement = antArtifact;
                }
            }
            antArtifact = antArtifact2.getProject().getProjectDirectory();
            FileObject fileObject = antArtifact.getFileObject("nbproject/project.properties");
            if (fileObject != null) {
                InputStream inputStream = null;
                try {
                    Properties properties = new Properties();
                    inputStream = fileObject.getInputStream();
                    properties.load(inputStream);
                    this.asaDescription = properties.getProperty("jbi.service-unit.description");
                    if (this.asaDescription == null) {
                        this.asaDescription = properties.getProperty("com.sun.jbi.ui.devtool.jbi.description.application-sub-assembly");
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    public static VisualClassPathItem create(AntArtifact antArtifact, String string) {
        return new VisualClassPathItem(antArtifact, 2, antArtifact.getArtifactLocations()[0].toString(), string, false);
    }

    public static boolean isJavaEEProjectAntArtifact(AntArtifact antArtifact) {
        AntArtifactProvider antArtifactProvider;
        Project project = antArtifact.getProject();
        if (project != null && (antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class)) != null) {
            AntArtifact[] antArtifactArray = antArtifactProvider.getBuildArtifacts();
            Iterator<String> iterator = null;
            String string2 = null;
            if (antArtifactArray != null) {
                for (int i = 0; i < antArtifactArray.length; ++i) {
                    for (String string2 : JbiProjectConstants.JAVA_EE_AA_TYPES) {
                        if (!antArtifactArray[i].getType().startsWith(string2)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static AntArtifact getJavaEEAntArtifact(AntArtifact antArtifact) {
        AntArtifactProvider antArtifactProvider;
        Project project = antArtifact.getProject();
        AntArtifact antArtifact2 = null;
        if (project != null && (antArtifactProvider = (AntArtifactProvider)project.getLookup().lookup(AntArtifactProvider.class)) != null) {
            AntArtifact[] antArtifactArray = antArtifactProvider.getBuildArtifacts();
            Iterator<String> iterator = null;
            String string2 = null;
            if (antArtifactArray != null) {
                for (int i = 0; i < antArtifactArray.length; ++i) {
                    for (String string2 : JbiProjectConstants.JAVA_EE_AA_TYPES) {
                        if (!antArtifactArray[i].getType().startsWith(string2)) continue;
                        antArtifact2 = antArtifactArray[i];
                        return antArtifact2;
                    }
                }
            }
        }
        return antArtifact2;
    }

    public Object getObject() {
        return this.cpElement;
    }

    public AntArtifact getAntArtifact() {
        return (AntArtifact)this.getObject();
    }

    public int getType() {
        return this.type;
    }

    public String getRaw() {
        return this.raw;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getAsaType() {
        return this.asaType;
    }

    public String getShortName() {
        return this.shortName;
    }

    public boolean isInDeployment() {
        return this.inDeployment;
    }

    public void setInDeployment(boolean bl) {
        this.inDeployment = bl;
    }

    public String getEvaluated() {
        return this.eval == null ? this.getRaw() : this.eval;
    }

    public boolean canDelete() {
        return this.getType() != 3;
    }

    public Icon getIcon() {
        switch (this.getType()) {
            case 0: {
                return ICON_JAR;
            }
            case 1: {
                return ICON_LIBRARY;
            }
            case 2: {
                return ICON_ARTIFACT;
            }
            case 3: {
                return ICON_CLASSPATH;
            }
        }
        return null;
    }

    public Icon getProjectIcon() {
        return this.projIcon;
    }

    public int hashCode() {
        int n = this.getType();
        switch (this.getType()) {
            case 2: {
                if (this.getObject() != null) {
                    AntArtifact antArtifact = (AntArtifact)this.getObject();
                    n += antArtifact.getType().hashCode();
                    n += antArtifact.getScriptLocation().hashCode();
                    n += antArtifact.getArtifactLocations()[0].hashCode();
                    break;
                }
                n += this.getRaw().hashCode();
                break;
            }
            default: {
                if (this.getObject() != null) {
                    n += this.getObject().hashCode();
                    break;
                }
                n += this.getRaw().hashCode();
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VisualClassPathItem)) {
            return false;
        }
        VisualClassPathItem visualClassPathItem = (VisualClassPathItem)object;
        if (this.getType() != visualClassPathItem.getType()) {
            return false;
        }
        switch (this.getType()) {
            case 2: {
                AntArtifact antArtifact = (AntArtifact)this.getObject();
                AntArtifact antArtifact2 = (AntArtifact)visualClassPathItem.getObject();
                if (antArtifact == null && antArtifact2 == null) {
                    return true;
                }
                if (antArtifact == null && antArtifact2 != null) {
                    return false;
                }
                if (antArtifact != null && antArtifact2 == null) {
                    return false;
                }
                if (!antArtifact.getType().equals(antArtifact2.getType())) {
                    return false;
                }
                if (!antArtifact.getScriptLocation().equals(antArtifact2.getScriptLocation())) {
                    return false;
                }
                return antArtifact.getArtifactLocations()[0].equals(antArtifact2.getArtifactLocations()[0]);
            }
        }
        return this.getObject().equals(visualClassPathItem.getObject());
    }

    public String toString() {
        switch (this.getType()) {
            case 0: {
                return this.getEvaluated();
            }
            case 1: {
                return ((Library)this.getObject()).getDisplayName();
            }
            case 2: {
                return this.shortName;
            }
            case 3: {
                return this.getEvaluated();
            }
        }
        return this.getEvaluated();
    }

    public String getAsaDescription() {
        return this.asaDescription;
    }

    public void setAsaDescription(String string) {
        this.asaDescription = string;
    }

    public String getAsaTarget() {
        return this.asaTarget;
    }

    public void setAsaTarget(String string) {
        this.asaTarget = string;
    }
}

