/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.codegen.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.compapp.javaee.annotation.handler.AnnotationHandler;
import org.netbeans.modules.compapp.javaee.annotation.handler.ClassFileLoader;
import org.netbeans.modules.compapp.javaee.annotation.handler.JarClassFileLoader;
import org.netbeans.modules.compapp.javaee.annotation.handler.WebServiceClientHanlder;
import org.netbeans.modules.compapp.javaee.annotation.handler.WebServiceHandler;
import org.netbeans.modules.compapp.javaee.annotation.handler.WebserviceRefHandler;
import org.netbeans.modules.compapp.javaee.codegen.model.Endpoint;
import org.netbeans.modules.compapp.javaee.codegen.model.EndpointCfg;
import org.netbeans.modules.compapp.javaee.codegen.model.JavaEEProject;
import org.netbeans.modules.compapp.javaee.sunresources.SunResourcesUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractProject
implements JavaEEProject {
    protected String projectDir;
    protected String jarPath;
    protected JavaEEProject.ProjectType projType;
    protected List<URL> classpathURLs;
    protected List<AnnotationHandler> hanlders = new Vector<AnnotationHandler>();
    protected Set<String> annotations = new HashSet<String>();
    protected boolean deployThruCA = true;
    protected String resourceFolder = null;
    protected List<Endpoint> epts = null;
    protected List<EndpointCfg> epCfgs = null;
    protected static final String SU_NAME = "javaee_su.jar";
    protected static final String JBI_XML_ENTRY = "META-INF/jbi.xml";
    protected static final String JBI_XML = "jbi.xml";
    private static final String JBI_DEFAULT_NS = "http://java.sun.com/xml/ns/jbi";
    private static final String JBI_VERSION = "1.0";
    private static final String SU_FILE_EXT = "jar";
    private static final String ATTR_VERSION = "version";
    private static final String ELEM_SERVICES = "services";
    private static final String ELEM_JBI = "jbi";
    private static final String CONSUMER = "consumer";
    private static final String CONSUMES = "consumes";
    private static final String EP_NAME = "endpoint-name";
    private static final String INTERFACE_NAME = "interface-name";
    private static final String MAPPING_ELEM = "ept-mapping";
    public static final String MAPPING_ELEMS = "ept-mappings";
    private static final String MAPPING_EXT = "javaee_ext";
    public static final String MAPPING_JAVA_ELEM = "java-ept";
    public static final String MAPPING_NS = "http://javaee.serviceengine.sun.com/endpoint/naming/extension";
    private static final String MAPPING_PREFIX = "javaee_";
    private static final String MAPPING_WSDL_ELEM = "wsdl-ept";
    private static final String PROVIDER = "provider";
    private static final String PROVIDES = "provides";
    private static final String PVT_EPS_ELEM = "private-endpoints";
    private static final String PVT_EP_ELEM = "private-endpoint";
    private static final String SERVICE_NAME = "service-name";
    private static final String TYPE = "type";
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_COLON = "xmlns:";
    protected static final String RES_XML_ENTRY = "META-INF/sun-resources.xml";
    private static Logger logger = Logger.getLogger(AbstractProject.class.getName());

    public AbstractProject(String string) {
        this.jarPath = string;
        this.init();
    }

    protected AbstractProject() {
        this.init();
    }

    @Override
    public void setProjectDir(String string) {
        this.projectDir = string;
    }

    @Override
    public void setJarPath(String string) {
        this.jarPath = string;
    }

    @Override
    public void setProjectType(JavaEEProject.ProjectType projectType) {
        this.projType = projectType;
    }

    @Override
    public JavaEEProject.ProjectType getProjectType() {
        return this.projType;
    }

    @Override
    public void addSubproject(JavaEEProject javaEEProject) {
        throw new UnsupportedOperationException("addSubproject() is not supported for this type project.");
    }

    @Override
    public void isDeployThruCA(boolean bl) {
        this.deployThruCA = bl;
    }

    @Override
    public boolean isDeployThruCA() {
        return this.deployThruCA;
    }

    @Override
    public void setEndpointOverrides(List<EndpointCfg> list) {
        this.epCfgs = list;
    }

    @Override
    public List<EndpointCfg> getEndpointOverrides() {
        return this.epCfgs;
    }

    @Override
    public List<Endpoint> getEndpoints() {
        return this.epts;
    }

    @Override
    public List<Endpoint> getWebservicesEndpoints() throws IOException {
        this.scanForEndpoints();
        Iterator<AnnotationHandler> iterator = this.hanlders.iterator();
        AnnotationHandler annotationHandler = null;
        HashSet<Endpoint> hashSet = new HashSet<Endpoint>();
        ArrayList<Endpoint> arrayList = new ArrayList<Endpoint>();
        while (iterator.hasNext()) {
            annotationHandler = iterator.next();
            hashSet.addAll(annotationHandler.getEndPoints());
        }
        this.removeLocalConsumers(hashSet);
        arrayList.addAll(hashSet);
        return arrayList;
    }

    private void removeLocalConsumers(Set<Endpoint> set) {
        if (set != null && set.size() > 0) {
            HashSet<Endpoint> hashSet = new HashSet<Endpoint>();
            Iterator<Endpoint> iterator = set.iterator();
            Endpoint endpoint = null;
            Endpoint endpoint2 = null;
            while (iterator.hasNext()) {
                endpoint = iterator.next();
                endpoint2 = null;
                if (endpoint.getEndPointType() != Endpoint.EndPointType.Consumer) continue;
                endpoint2 = new Endpoint(endpoint);
                endpoint2.setEndPointType(Endpoint.EndPointType.Provider);
                if (!set.contains(endpoint2)) continue;
                endpoint2.setEndPointType(Endpoint.EndPointType.Consumer);
                hashSet.add(endpoint2);
            }
            set.removeAll(hashSet);
        }
    }

    protected String renameToSvcUnitExtension(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = -1;
        if (string != null && (n = string.lastIndexOf(".")) >= 0) {
            stringBuffer.append(string.substring(0, n + 1));
            stringBuffer.append(SU_FILE_EXT);
        }
        return stringBuffer.toString();
    }

    protected void createFolderIfNotExists(String string) {
        File file = new File(string);
        file.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createJar(String string, String string2) throws Exception {
        this.epts = this.getWebservicesEndpoints();
        String string3 = null;
        if (this.deployThruCA) {
            try {
                string3 = this.scanForResources();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Object var4_5 = null;
        ZipOutputStream zipOutputStream = null;
        FileOutputStream fileOutputStream = null;
        JarEntry jarEntry = null;
        String string4 = SU_NAME;
        File file = new File(this.jarPath);
        File file2 = null;
        string4 = this.renameToSvcUnitExtension(file.getName());
        String string5 = null;
        try {
            file2 = new File(string, string4);
            string5 = file2.getAbsolutePath();
            fileOutputStream = new FileOutputStream(file2);
            zipOutputStream = new JarOutputStream(fileOutputStream);
            jarEntry = new JarEntry(JBI_XML_ENTRY);
            ((JarOutputStream)zipOutputStream).putNextEntry(jarEntry);
            this.writeJBIXMLUsingDOM(this.epts, zipOutputStream);
            if (this.deployThruCA && string3 != null && !"".equals(string3)) {
                jarEntry = new JarEntry(RES_XML_ENTRY);
                ((JarOutputStream)zipOutputStream).putNextEntry(jarEntry);
                this.writeResourcesFile(string3, zipOutputStream);
            }
            if (string2 != null) {
                FileOutputStream fileOutputStream2 = null;
                try {
                    this.createFolderIfNotExists(string2);
                    File file3 = new File(string2 + File.separator + JBI_XML);
                    fileOutputStream2 = new FileOutputStream(file3);
                    this.writeJBIXMLUsingDOM(this.epts, fileOutputStream2);
                    fileOutputStream2.flush();
                    fileOutputStream2.close();
                    fileOutputStream2 = null;
                }
                catch (Exception exception) {
                    logger.log(Level.SEVERE, "Writing jbi.xml.", exception);
                }
                finally {
                    try {
                        fileOutputStream2.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.copyJar((JarOutputStream)zipOutputStream);
        }
        finally {
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (Exception exception) {}
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return string5;
    }

    @Override
    public String getJarName() {
        String string = null;
        File file = new File(this.jarPath);
        string = file.getName();
        int n = -1;
        if (string != null && (n = string.lastIndexOf(".")) >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyJar(JarOutputStream jarOutputStream) throws IOException {
        byte[] byArray = new byte[5120];
        int n = 0;
        JarFile jarFile = null;
        if (this.deployThruCA) {
            File file = new File(this.jarPath);
            try {
                jarFile = new JarFile(file);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    jarOutputStream.putNextEntry(jarEntry);
                    while ((n = inputStream.read(byArray)) != -1) {
                        jarOutputStream.write(byArray, 0, n);
                    }
                }
            }
            finally {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanForEndpoints() throws IOException {
        JarFile jarFile = new JarFile(this.jarPath);
        try {
            JarClassFileLoader jarClassFileLoader = new JarClassFileLoader(jarFile, "");
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (!jarEntry.getName().endsWith(".class")) continue;
                logger.finest("Checking Annotation in:" + jarEntry.getName());
                this.handleAnnotations(jarClassFileLoader, jarEntry);
            }
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void addAnnotationHandler(AnnotationHandler annotationHandler) {
        String string = annotationHandler.getAnnotationClassConstant();
        this.annotations.add(string);
        this.hanlders.add(annotationHandler);
    }

    protected void removeAnnotationHandler(AnnotationHandler annotationHandler) {
        String string = annotationHandler.getAnnotationClassConstant();
        this.annotations.remove(string);
        this.hanlders.remove(annotationHandler);
    }

    protected URL getClassPathURL() {
        URL uRL = null;
        try {
            uRL = new URL("jar:file:" + this.jarPath + "!/");
        }
        catch (Exception exception) {
            logger.warning("Error while getting to to:" + this.jarPath);
        }
        return uRL;
    }

    protected void resetHandlers() {
        Iterator<AnnotationHandler> iterator = this.hanlders.iterator();
        AnnotationHandler annotationHandler = null;
        while (iterator.hasNext()) {
            annotationHandler = iterator.next();
            annotationHandler.resetEndPoints();
        }
    }

    protected void handleAnnotations(ClassFileLoader classFileLoader, JarEntry jarEntry) {
        try {
            ClassFile classFile = classFileLoader.getClassFileUsingJarEntry(jarEntry);
            for (AnnotationHandler annotationHandler : this.hanlders) {
                annotationHandler.handle(classFileLoader, classFile);
            }
        }
        catch (Throwable throwable) {
            logger.log(Level.WARNING, "Error while loading class:" + jarEntry.getName(), throwable);
        }
    }

    @Override
    public void setClassPathURLs(List<URL> list) {
        this.classpathURLs = list;
    }

    protected void init() {
        WebServiceHandler webServiceHandler = new WebServiceHandler();
        WebserviceRefHandler webserviceRefHandler = new WebserviceRefHandler();
        WebServiceClientHanlder webServiceClientHanlder = new WebServiceClientHanlder();
        this.annotations.add(webServiceHandler.getAnnotationClassConstant());
        this.annotations.add(webserviceRefHandler.getAnnotationClassConstant());
        this.annotations.add(webServiceClientHanlder.getAnnotationClassConstant());
        this.hanlders.add(webServiceHandler);
        this.hanlders.add(webserviceRefHandler);
        this.hanlders.add(webServiceClientHanlder);
    }

    private boolean isActivateJavaEEHttpPort(Endpoint endpoint) {
        int n;
        boolean bl = true;
        if (this.epCfgs != null && this.epCfgs.contains(endpoint) && (n = this.epCfgs.indexOf(endpoint)) > -1) {
            EndpointCfg endpointCfg = this.epCfgs.get(n);
            bl = endpointCfg.isActivateJavaEEHttpPort();
        }
        return bl;
    }

    private boolean isActivateForNMR(Endpoint endpoint) {
        int n;
        boolean bl = true;
        if (this.epCfgs != null && this.epCfgs.contains(endpoint) && (n = this.epCfgs.indexOf(endpoint)) > -1) {
            EndpointCfg endpointCfg = this.epCfgs.get(n);
            bl = endpointCfg.isActivateForNMR();
        }
        return bl;
    }

    protected void writeJBIXMLUsingDOM(List<Endpoint> list, OutputStream outputStream) throws IOException {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Map<String, String> map = this.getNamespacePrefixes(list);
            Iterator<Map.Entry<String, String>> iterator = null;
            Map.Entry<String, String> entry2 = null;
            Iterator<Endpoint> iterator2 = null;
            Endpoint endpoint2 = null;
            String string = null;
            String string2 = null;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(ELEM_JBI);
            Element element2 = null;
            Element element3 = null;
            element.setAttribute(XMLNS, JBI_DEFAULT_NS);
            String string3 = null;
            for (Map.Entry<String, String> entry2 : map.entrySet()) {
                string3 = XMLNS_COLON + entry2.getValue();
                element.setAttribute(string3, entry2.getKey());
            }
            element.setAttribute("xmlns:javaee_ext", MAPPING_NS);
            element.setAttribute(ATTR_VERSION, JBI_VERSION);
            document.appendChild(element);
            element2 = document.createElement(ELEM_SERVICES);
            element2.setAttribute("binding-component", "false");
            element.appendChild(element2);
            Element element4 = document.createElement("javaee_ext:ept-mappings");
            Element element5 = document.createElement("javaee_ext:private-endpoints");
            for (Endpoint endpoint2 : list) {
                if (!endpoint2.getEndPointType().equals((Object)Endpoint.EndPointType.Provider)) continue;
                element3 = document.createElement(PROVIDES);
                element3.setAttribute(EP_NAME, MAPPING_PREFIX + endpoint2.getEndPointName());
                string = map.get(endpoint2.getInterfaceName().getNamespaceURI());
                element3.setAttribute(INTERFACE_NAME, string + ":" + endpoint2.getInterfaceName().getLocalPart());
                object4 = document.createElement("javaee_ext:ept-mapping");
                object3 = document.createElement("javaee_ext:java-ept");
                object2 = document.createElement("javaee_ext:wsdl-ept");
                object3.setAttribute(EP_NAME, MAPPING_PREFIX + endpoint2.getEndPointName());
                object2.setAttribute(EP_NAME, endpoint2.getEndPointName());
                object3.setAttribute(INTERFACE_NAME, string + ":" + endpoint2.getInterfaceName().getLocalPart());
                object2.setAttribute(INTERFACE_NAME, string + ":" + endpoint2.getInterfaceName().getLocalPart());
                string2 = map.get(endpoint2.getServiceName().getNamespaceURI());
                element3.setAttribute(SERVICE_NAME, string2 + ":" + endpoint2.getServiceName().getLocalPart());
                element2.appendChild(element3);
                object3.setAttribute(SERVICE_NAME, string2 + ":" + endpoint2.getServiceName().getLocalPart());
                object2.setAttribute(SERVICE_NAME, string2 + ":" + endpoint2.getServiceName().getLocalPart());
                object3.setAttribute(TYPE, PROVIDER);
                object2.setAttribute(TYPE, PROVIDER);
                object4.appendChild((Node)object3);
                object4.appendChild((Node)object2);
                element4.appendChild((Node)object4);
                if (this.isActivateJavaEEHttpPort(endpoint2)) continue;
                object = document.createElement("javaee_ext:private-endpoint");
                object.setAttribute(EP_NAME, endpoint2.getEndPointName());
                object.setAttribute(INTERFACE_NAME, string + ":" + endpoint2.getInterfaceName().getLocalPart());
                object.setAttribute(SERVICE_NAME, string2 + ":" + endpoint2.getServiceName().getLocalPart());
                element5.appendChild((Node)object);
            }
            for (Endpoint endpoint2 : list) {
                if (!endpoint2.getEndPointType().equals((Object)Endpoint.EndPointType.Consumer) || !this.isActivateForNMR(endpoint2)) continue;
                element3 = document.createElement(CONSUMES);
                element3.setAttribute(EP_NAME, MAPPING_PREFIX + endpoint2.getEndPointName());
                string = map.get(endpoint2.getInterfaceName().getNamespaceURI());
                element3.setAttribute(INTERFACE_NAME, string + ":" + endpoint2.getInterfaceName().getLocalPart());
                object4 = document.createElement("javaee_ext:ept-mapping");
                object3 = document.createElement("javaee_ext:java-ept");
                object2 = document.createElement("javaee_ext:wsdl-ept");
                object3.setAttribute(EP_NAME, MAPPING_PREFIX + endpoint2.getEndPointName());
                object2.setAttribute(EP_NAME, endpoint2.getEndPointName());
                object3.setAttribute(INTERFACE_NAME, string + ":" + endpoint2.getInterfaceName().getLocalPart());
                object2.setAttribute(INTERFACE_NAME, string + ":" + endpoint2.getInterfaceName().getLocalPart());
                string2 = map.get(endpoint2.getServiceName().getNamespaceURI());
                element3.setAttribute(SERVICE_NAME, string2 + ":" + endpoint2.getServiceName().getLocalPart());
                element2.appendChild(element3);
                object3.setAttribute(SERVICE_NAME, string2 + ":" + endpoint2.getServiceName().getLocalPart());
                object2.setAttribute(SERVICE_NAME, string2 + ":" + endpoint2.getServiceName().getLocalPart());
                object3.setAttribute(TYPE, CONSUMER);
                object2.setAttribute(TYPE, CONSUMER);
                object4.appendChild((Node)object3);
                object4.appendChild((Node)object2);
                element4.appendChild((Node)object4);
            }
            element2.appendChild(element4);
            element2.appendChild(element5);
            object4 = TransformerFactory.newInstance();
            object3 = ((TransformerFactory)object4).newTransformer();
            object2 = new DOMSource(document);
            object = new StreamResult(outputStream);
            ((Transformer)object3).setOutputProperty("method", "xml");
            ((Transformer)object3).setOutputProperty("encoding", "UTF-8");
            ((Transformer)object3).setOutputProperty("media-type", "text/xml");
            ((Transformer)object3).setOutputProperty("standalone", "yes");
            ((Transformer)object3).setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            ((Transformer)object3).setOutputProperty("indent", "yes");
            ((Transformer)object3).transform((Source)object2, (Result)object);
            outputStream.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Exception while writing jbi.xml:" + exception.getMessage());
        }
    }

    private Map<String, String> getNamespacePrefixes(List<Endpoint> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        int n = 0;
        Iterator<Endpoint> iterator = list.iterator();
        Endpoint endpoint = null;
        QName qName = null;
        while (iterator.hasNext()) {
            endpoint = iterator.next();
            qName = endpoint.getInterfaceName();
            if (qName != null && (string = qName.getNamespaceURI()) != null && hashMap.get(string) == null) {
                hashMap.put(string, "ns" + n++);
            }
            if ((qName = endpoint.getServiceName()) == null || (string = qName.getNamespaceURI()) == null || hashMap.get(string) != null) continue;
            hashMap.put(string, "ns" + n++);
        }
        return hashMap;
    }

    protected String scanForResources() throws Exception {
        return SunResourcesUtil.scanForSunResources(this.resourceFolder);
    }

    protected void writeResourcesFile(String string, OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.print(string);
        printWriter.flush();
    }

    @Override
    public void setResourceFolder(String string) {
        this.resourceFolder = string;
    }
}

