/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.parser.DocCommentScanner;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Paths;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.JavadocClassReader;
import com.sun.tools.javadoc.JavadocEnter;
import com.sun.tools.javadoc.JavadocMemberEnter;
import com.sun.tools.javadoc.JavadocTodo;
import com.sun.tools.javadoc.Messager;
import com.sun.tools.javadoc.ModifierFilter;
import com.sun.tools.javadoc.RootDocImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavadocTool
extends JavaCompiler {
    DocEnv docenv;
    final Context context;
    final Messager messager;
    final JavadocClassReader reader;
    final JavadocEnter enter;
    final Annotate annotate;
    private final Paths paths;
    private static final char pathSep = File.pathSeparatorChar;
    static final boolean surrogatesSupported = JavadocTool.surrogatesSupported();

    protected JavadocTool(Context context) {
        super(context);
        this.context = context;
        this.messager = Messager.instance0(context);
        this.reader = JavadocClassReader.instance0(context);
        this.enter = JavadocEnter.instance0(context);
        this.annotate = Annotate.instance(context);
        this.paths = Paths.instance(context);
    }

    @Override
    protected boolean keepComments() {
        return true;
    }

    public static JavadocTool make0(Context context) {
        Log messager = null;
        try {
            JavadocClassReader.preRegister(context);
            JavadocEnter.preRegister(context);
            JavadocMemberEnter.preRegister(context);
            JavadocTodo.preRegister(context);
            messager = Messager.instance0(context);
            DocCommentScanner.Factory.preRegister(context);
            return new JavadocTool(context);
        }
        catch (Symbol.CompletionFailure ex) {
            messager.error(-1, ex.getMessage(), new Object[0]);
            return null;
        }
    }

    public RootDocImpl getRootDocImpl(String doclocale, String encoding, ModifierFilter filter, List<String> javaNames, List<String[]> options, boolean breakiterator, List<String> subPackages, List<String> excludedPackages, boolean docClasses, boolean legacyDoclet, boolean quiet) throws IOException {
        this.docenv = DocEnv.instance(this.context);
        this.docenv.showAccess = filter;
        this.docenv.quiet = quiet;
        this.docenv.breakiterator = breakiterator;
        this.docenv.setLocale(doclocale);
        this.docenv.setEncoding(encoding);
        this.docenv.docClasses = docClasses;
        this.docenv.legacyDoclet = legacyDoclet;
        this.reader.sourceCompleter = docClasses ? null : this;
        ListBuffer<String> names = new ListBuffer<String>();
        ListBuffer<JCTree.JCCompilationUnit> classTrees = new ListBuffer<JCTree.JCCompilationUnit>();
        ListBuffer<JCTree.JCCompilationUnit> packTrees = new ListBuffer<JCTree.JCCompilationUnit>();
        try {
            List<String> it = javaNames;
            while (it.nonEmpty()) {
                String name = (String)it.head;
                if (!docClasses && name.endsWith(".java") && new File(name).exists()) {
                    this.docenv.notice("main.Loading_source_file", name);
                    JCTree.JCCompilationUnit tree = this.parse(name);
                    classTrees.append(tree);
                } else if (this.isValidPackageName(name)) {
                    names = names.append(name);
                } else if (name.endsWith(".java")) {
                    this.docenv.error(null, "main.file_not_found", name);
                } else {
                    this.docenv.error(null, "main.illegal_package_name", name);
                }
                it = it.tail;
            }
            if (!docClasses) {
                this.searchSubPackages(subPackages, names, excludedPackages);
                List<String> packs = names.toList();
                while (packs.nonEmpty()) {
                    this.parsePackageClasses((String)packs.head, packTrees, excludedPackages);
                    packs = packs.tail;
                }
                if (this.messager.nerrors() != 0) {
                    return null;
                }
                this.docenv.notice("main.Building_tree");
                this.enter.main(classTrees.toList().appendList(packTrees.toList()));
            }
        }
        catch (Abort ex) {
            // empty catch block
        }
        if (this.messager.nerrors() != 0) {
            return null;
        }
        if (docClasses) {
            return new RootDocImpl(this.docenv, javaNames, options);
        }
        return new RootDocImpl(this.docenv, this.listClasses(classTrees.toList()), names.toList(), options);
    }

    boolean isValidPackageName(String s) {
        int index;
        while ((index = s.indexOf(46)) != -1) {
            if (!JavadocTool.isValidClassName(s.substring(0, index))) {
                return false;
            }
            s = s.substring(index + 1);
        }
        return JavadocTool.isValidClassName(s);
    }

    private void parsePackageClasses(String name, ListBuffer<JCTree.JCCompilationUnit> trees, List<String> excludedPackages) throws IOException {
        if (excludedPackages.contains(name)) {
            return;
        }
        boolean hasFiles = false;
        this.docenv.notice("main.Loading_source_files_for_package", name);
        name = name.replace('.', File.separatorChar);
        for (File pathname : this.paths.sourceSearchPath()) {
            File f = new File(pathname, name);
            String[] names = f.list();
            if (names == null) continue;
            String dir = f.getAbsolutePath();
            if (!dir.endsWith(File.separator)) {
                dir = dir + File.separator;
            }
            for (int j = 0; j < names.length; ++j) {
                if (!JavadocTool.isValidJavaSourceFile(names[j])) continue;
                String fn = dir + names[j];
                trees.append(this.parse(fn));
                hasFiles = true;
            }
        }
        if (!hasFiles) {
            this.messager.warning(null, "main.no_source_files_for_package", name.replace(File.separatorChar, '.'));
        }
    }

    private void searchSubPackages(List<String> subPackages, ListBuffer<String> packages, List<String> excludedPackages) {
        ArrayList<File> pathnames = new ArrayList<File>();
        if (this.paths.sourcePath() != null) {
            for (File elt : this.paths.sourcePath()) {
                pathnames.add(elt);
            }
        }
        for (File elt : this.paths.userClassPath()) {
            pathnames.add(elt);
        }
        for (String subPackage : subPackages) {
            this.searchSubPackage(subPackage, packages, excludedPackages, pathnames);
        }
    }

    private void searchSubPackage(String packageName, ListBuffer<String> packages, List<String> excludedPackages, Collection<File> pathnames) {
        if (excludedPackages.contains(packageName)) {
            return;
        }
        String packageFilename = packageName.replace('.', File.separatorChar);
        boolean addedPackage = false;
        for (File pathname : pathnames) {
            File f = new File(pathname, packageFilename);
            String[] filenames = f.list();
            if (filenames == null) continue;
            for (String filename : filenames) {
                if (!addedPackage && (JavadocTool.isValidJavaSourceFile(filename) || JavadocTool.isValidJavaClassFile(filename)) && !packages.contains(packageName)) {
                    packages.append(packageName);
                    addedPackage = true;
                    continue;
                }
                if (!JavadocTool.isValidClassName(filename) || !new File(f, filename).isDirectory()) continue;
                this.searchSubPackage(packageName + "." + filename, packages, excludedPackages, pathnames);
            }
        }
    }

    private static boolean isValidJavaClassFile(String file) {
        if (!file.endsWith(".class")) {
            return false;
        }
        String clazzName = file.substring(0, file.length() - ".class".length());
        return JavadocTool.isValidClassName(clazzName);
    }

    private static boolean isValidJavaSourceFile(String file) {
        if (!file.endsWith(".java")) {
            return false;
        }
        String clazzName = file.substring(0, file.length() - ".java".length());
        return JavadocTool.isValidClassName(clazzName);
    }

    private static boolean surrogatesSupported() {
        try {
            boolean b = Character.isHighSurrogate('a');
            return true;
        }
        catch (NoSuchMethodError ex) {
            return false;
        }
    }

    public static boolean isValidClassName(String s) {
        if (s.length() < 1) {
            return false;
        }
        if (s.equals("package-info")) {
            return true;
        }
        if (surrogatesSupported) {
            int cp = s.codePointAt(0);
            if (!Character.isJavaIdentifierStart(cp)) {
                return false;
            }
            for (int j = Character.charCount(cp); j < s.length(); j += Character.charCount(cp)) {
                cp = s.codePointAt(j);
                if (Character.isJavaIdentifierPart(cp)) continue;
                return false;
            }
        } else {
            if (!Character.isJavaIdentifierStart(s.charAt(0))) {
                return false;
            }
            for (int j = 1; j < s.length(); ++j) {
                if (Character.isJavaIdentifierPart(s.charAt(j))) continue;
                return false;
            }
        }
        return true;
    }

    List<JCTree.JCClassDecl> listClasses(List<JCTree.JCCompilationUnit> trees) {
        ListBuffer<JCTree.JCClassDecl> result = new ListBuffer<JCTree.JCClassDecl>();
        for (JCTree.JCCompilationUnit t : trees) {
            for (JCTree def : t.defs) {
                if (def.getTag() != 3) continue;
                result.append((JCTree.JCClassDecl)def);
            }
        }
        return result.toList();
    }
}

