/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.parser;

import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.parser.EndPosParser;
import com.sun.tools.javac.parser.Keywords;
import com.sun.tools.javac.parser.Lexer;
import com.sun.tools.javac.parser.Token;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.CancelService;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Convert;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    final Stack<AnonScope> anonScopes = new Stack();
    private static final int infixPrecedenceLevels = 10;
    private Lexer S;
    protected TreeMaker F;
    private Log log;
    private Keywords keywords;
    private Source source;
    private Name.Table names;
    private final CancelService cancelService;
    boolean allowGenerics;
    boolean allowVarargs;
    boolean allowAsserts;
    boolean allowEnums;
    boolean allowForeach;
    boolean allowStaticImport;
    boolean allowAnnotations;
    boolean allowStringFolding;
    boolean keepDocComments;
    static final int EXPR = 1;
    static final int TYPE = 2;
    static final int NOPARAMS = 4;
    static final int TYPEARG = 8;
    private int mode = 0;
    private int lastmode = 0;
    private JCTree.JCErroneous errorTree;
    Map<JCTree, String> docComments;
    private int errorEndPos = -1;
    ListBuffer<JCTree.JCExpression[]> odStackSupply = new ListBuffer();
    ListBuffer<int[]> posStackSupply = new ListBuffer();
    ListBuffer<Token[]> opStackSupply = new ListBuffer();

    protected Parser(Factory fac, Lexer S, boolean keepDocComments, CancelService cancelService) {
        this.S = S;
        S.nextToken();
        this.F = fac.F;
        this.log = fac.log;
        this.names = fac.names;
        this.keywords = fac.keywords;
        this.source = fac.source;
        Options options = fac.options;
        this.allowGenerics = this.source.allowGenerics();
        this.allowVarargs = this.source.allowVarargs();
        this.allowAsserts = this.source.allowAsserts();
        this.allowEnums = this.source.allowEnums();
        this.allowForeach = this.source.allowForeach();
        this.allowStaticImport = this.source.allowStaticImport();
        this.allowAnnotations = this.source.allowAnnotations();
        this.allowStringFolding = options.get("disableStringFolding") == null;
        this.keepDocComments = keepDocComments;
        if (keepDocComments) {
            this.docComments = new HashMap<JCTree, String>();
        }
        this.errorTree = this.F.Erroneous();
        this.cancelService = cancelService;
    }

    private void skip(boolean stopAtImport, boolean stopAtMemberDecl, boolean stopAtIdentifier, boolean stopAtStatement) {
        while (true) {
            switch (this.S.token()) {
                case SEMI: {
                    this.S.nextToken();
                    return;
                }
                case PUBLIC: 
                case FINAL: 
                case ABSTRACT: 
                case MONKEYS_AT: 
                case EOF: 
                case CLASS: 
                case INTERFACE: 
                case ENUM: {
                    return;
                }
                case IMPORT: {
                    if (!stopAtImport) break;
                    return;
                }
                case LBRACE: 
                case RBRACE: 
                case PRIVATE: 
                case PROTECTED: 
                case STATIC: 
                case TRANSIENT: 
                case NATIVE: 
                case VOLATILE: 
                case SYNCHRONIZED: 
                case STRICTFP: 
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case VOID: {
                    if (!stopAtMemberDecl) break;
                    return;
                }
                case IDENTIFIER: {
                    if (!stopAtIdentifier) break;
                    return;
                }
                case CASE: 
                case DEFAULT: 
                case IF: 
                case FOR: 
                case WHILE: 
                case DO: 
                case TRY: 
                case SWITCH: 
                case RETURN: 
                case THROW: 
                case BREAK: 
                case CONTINUE: 
                case ELSE: 
                case FINALLY: 
                case CATCH: 
                case THIS: 
                case SUPER: {
                    if (!stopAtStatement) break;
                    return;
                }
            }
            this.S.nextToken();
        }
    }

    private JCTree.JCErroneous syntaxError(int pos, String key, Object ... arg) {
        return this.syntaxError(pos, List.<JCTree>nil(), key, arg);
    }

    private JCTree.JCErroneous syntaxError(int pos, List<JCTree> errs, String key, Object ... arg) {
        JCTree last;
        this.setErrorEndPos(pos);
        this.reportSyntaxError(pos, key, arg);
        if (errs != null && (last = errs.last()) != null) {
            this.storeEnd(last, pos);
        }
        return this.toP(this.F.at(this.S.prevEndPos()).Erroneous(errs));
    }

    private void reportSyntaxError(int pos, String key, Object ... arg) {
        if (pos > this.S.errPos() || pos == -1) {
            if (this.S.token() == Token.EOF) {
                this.log.error(pos, "premature.eof", new Object[0]);
            } else {
                this.log.error(pos, key, arg);
            }
        }
        this.S.errPos(pos);
    }

    private JCTree.JCErroneous syntaxError(String key) {
        return this.syntaxError(this.S.pos(), key, new Object[0]);
    }

    private JCTree.JCErroneous syntaxError(String key, String arg) {
        return this.syntaxError(this.S.pos(), key, arg);
    }

    public void accept(Token token) {
        if (this.S.token() == token) {
            this.S.nextToken();
        } else {
            this.setErrorEndPos(this.S.pos());
            this.reportSyntaxError(this.S.prevEndPos(), "expected", this.keywords.token2string(token));
        }
    }

    JCTree.JCExpression illegal(int pos) {
        this.setErrorEndPos(pos);
        if ((this.mode & 1) != 0) {
            return this.syntaxError(pos, "illegal.start.of.expr", new Object[0]);
        }
        return this.syntaxError(pos, "illegal.start.of.type", new Object[0]);
    }

    JCTree.JCExpression illegal() {
        return this.illegal(this.S.pos());
    }

    void checkNoMods(long mods) {
        if (mods != 0L) {
            long lowestMod = mods & -mods;
            this.log.error(this.S.pos(), "mod.not.allowed.here", Flags.toString(lowestMod).trim());
        }
    }

    void attach(JCTree tree, String dc) {
        if (this.keepDocComments && dc != null) {
            this.docComments.put(tree, dc);
        }
    }

    private void setErrorEndPos(int errPos) {
        if (errPos > this.errorEndPos) {
            this.errorEndPos = errPos;
        }
    }

    protected int getErrorEndPos() {
        return this.errorEndPos;
    }

    protected void storeEnd(JCTree tree, int endpos) {
    }

    protected <T extends JCTree> T to(T t) {
        return t;
    }

    protected <T extends JCTree> T toP(T t) {
        return t;
    }

    public int getStartPos(JCTree tree) {
        return TreeInfo.getStartPos(tree);
    }

    public int getEndPos(JCTree tree) {
        return -1;
    }

    Name ident() {
        if (this.S.token() == Token.IDENTIFIER) {
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        if (this.S.token() == Token.ASSERT) {
            if (this.allowAsserts) {
                this.log.error(this.S.pos(), "assert.as.identifier", new Object[0]);
                this.S.nextToken();
                return this.names.error;
            }
            this.log.warning(this.S.pos(), "assert.as.identifier", new Object[0]);
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        if (this.S.token() == Token.ENUM) {
            if (this.allowEnums) {
                this.log.error(this.S.pos(), "enum.as.identifier", new Object[0]);
                this.S.nextToken();
                return this.names.error;
            }
            this.log.warning(this.S.pos(), "enum.as.identifier", new Object[0]);
            Name name = this.S.name();
            this.S.nextToken();
            return name;
        }
        this.accept(Token.IDENTIFIER);
        return this.names.error;
    }

    public JCTree.JCExpression qualident() {
        JCTree.JCExpression t = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
        while (this.S.token() == Token.DOT) {
            int pos = this.S.pos();
            this.S.nextToken();
            t = this.toP(this.F.at(pos).Select(t, this.ident()));
        }
        return t;
    }

    JCTree.JCExpression literal(Name prefix, int pos) {
        JCTree.JCExpression t = this.errorTree;
        switch (this.S.token()) {
            case INTLITERAL: {
                try {
                    t = this.F.at(pos).Literal(4, Convert.string2int(this.strval(prefix), this.S.radix()));
                }
                catch (NumberFormatException ex) {
                    this.log.error(this.S.pos(), "int.number.too.large", this.strval(prefix));
                }
                break;
            }
            case LONGLITERAL: {
                try {
                    t = this.F.at(pos).Literal(5, new Long(Convert.string2long(this.strval(prefix), this.S.radix())));
                }
                catch (NumberFormatException ex) {
                    this.log.error(this.S.pos(), "int.number.too.large", this.strval(prefix));
                }
                break;
            }
            case FLOATLITERAL: {
                Float n;
                String proper = this.S.radix() == 16 ? "0x" + this.S.stringVal() : this.S.stringVal();
                try {
                    n = Float.valueOf(proper);
                }
                catch (NumberFormatException ex) {
                    n = Float.valueOf(Float.NaN);
                }
                if (n.floatValue() == 0.0f && !this.isZero(proper)) {
                    this.log.error(this.S.pos(), "fp.number.too.small", new Object[0]);
                    break;
                }
                if (n.floatValue() == Float.POSITIVE_INFINITY) {
                    this.log.error(this.S.pos(), "fp.number.too.large", new Object[0]);
                    break;
                }
                t = this.F.at(pos).Literal(6, n);
                break;
            }
            case DOUBLELITERAL: {
                Double n;
                String proper = this.S.radix() == 16 ? "0x" + this.S.stringVal() : this.S.stringVal();
                try {
                    n = Double.valueOf(proper);
                }
                catch (NumberFormatException ex) {
                    n = Double.NaN;
                }
                if (n == 0.0 && !this.isZero(proper)) {
                    this.log.error(this.S.pos(), "fp.number.too.small", new Object[0]);
                    break;
                }
                if (n == Double.POSITIVE_INFINITY) {
                    this.log.error(this.S.pos(), "fp.number.too.large", new Object[0]);
                    break;
                }
                t = this.F.at(pos).Literal(7, n);
                break;
            }
            case CHARLITERAL: {
                t = this.F.at(pos).Literal(2, this.S.stringVal().charAt(0) + '\u0000');
                break;
            }
            case STRINGLITERAL: {
                t = this.F.at(pos).Literal(10, this.S.stringVal());
                break;
            }
            case TRUE: 
            case FALSE: {
                t = this.F.at(pos).Literal(8, this.S.token() == Token.TRUE ? 1 : 0);
                break;
            }
            case NULL: {
                t = this.F.at(pos).Literal(17, null);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (t == this.errorTree) {
            t = this.F.at(pos).Erroneous();
        }
        this.storeEnd(t, this.S.endPos());
        this.S.nextToken();
        return t;
    }

    boolean isZero(String s) {
        int i;
        if (s.length() == 1) {
            return '0' == s.charAt(0);
        }
        char[] cs = s.toCharArray();
        int base = Character.toLowerCase(s.charAt(1)) == 'x' ? 16 : 10;
        int n = i = base == 16 ? 2 : 0;
        while (i < cs.length && (cs[i] == '0' || cs[i] == '.')) {
            ++i;
        }
        return i >= cs.length || Character.digit(cs[i], base) <= 0;
    }

    String strval(Name prefix) {
        String s = this.S.stringVal();
        return prefix.len == 0 ? s : prefix + s;
    }

    public JCTree.JCExpression expression() {
        return this.term(1);
    }

    public JCTree.JCExpression type() {
        return this.term(2);
    }

    JCTree.JCExpression term(int newmode) {
        int prevmode = this.mode;
        this.mode = newmode;
        JCTree.JCExpression t = this.term();
        this.lastmode = this.mode;
        this.mode = prevmode;
        return t;
    }

    JCTree.JCExpression term() {
        JCTree.JCExpression t = this.term1();
        if ((this.mode & 1) != 0 && this.S.token() == Token.EQ || Token.PLUSEQ.compareTo(this.S.token()) <= 0 && this.S.token().compareTo(Token.GTGTGTEQ) <= 0) {
            return this.termRest(t);
        }
        return t;
    }

    JCTree.JCExpression termRest(JCTree.JCExpression t) {
        switch (this.S.token()) {
            case EQ: {
                int pos = this.S.pos();
                this.S.nextToken();
                this.mode = 1;
                JCTree.JCExpression t1 = this.term();
                return this.toP(this.F.at(pos).Assign(t, t1));
            }
            case PLUSEQ: 
            case SUBEQ: 
            case STAREQ: 
            case SLASHEQ: 
            case PERCENTEQ: 
            case AMPEQ: 
            case BAREQ: 
            case CARETEQ: 
            case LTLTEQ: 
            case GTGTEQ: 
            case GTGTGTEQ: {
                int pos = this.S.pos();
                Token token = this.S.token();
                this.S.nextToken();
                this.mode = 1;
                JCTree.JCExpression t1 = this.term();
                return this.F.at(pos).Assignop(Parser.optag(token), t, t1);
            }
        }
        return t;
    }

    JCTree.JCExpression term1() {
        JCTree.JCExpression t = this.term2();
        if ((this.mode & 1) != 0 && this.S.token() == Token.QUES) {
            this.mode = 1;
            return this.term1Rest(t);
        }
        return t;
    }

    JCTree.JCExpression term1Rest(JCTree.JCExpression t) {
        if (this.S.token() == Token.QUES) {
            int pos = this.S.pos();
            this.S.nextToken();
            JCTree.JCExpression t1 = this.term();
            this.accept(Token.COLON);
            JCTree.JCExpression t2 = this.term1();
            return this.F.at(pos).Conditional(t, t1, t2);
        }
        return t;
    }

    JCTree.JCExpression term2() {
        JCTree.JCExpression t = this.term3();
        if ((this.mode & 1) != 0 && Parser.prec(this.S.token()) >= 4) {
            this.mode = 1;
            return this.term2Rest(t, 4);
        }
        return t;
    }

    JCTree.JCExpression term2Rest(JCTree.JCExpression t, int minprec) {
        StringBuffer buf;
        List savedOd = this.odStackSupply.elems;
        JCTree.JCExpression[] odStack = this.newOdStack();
        List savedPos = this.posStackSupply.elems;
        int[] posStack = this.newPosStack();
        List savedOp = this.opStackSupply.elems;
        Token[] opStack = this.newOpStack();
        int top = 0;
        odStack[0] = t;
        int startPos = this.S.pos();
        Token topOp = Token.ERROR;
        while (Parser.prec(this.S.token()) >= minprec) {
            opStack[top] = topOp;
            topOp = this.S.token();
            int pos = this.S.pos();
            this.S.nextToken();
            odStack[++top] = topOp == Token.INSTANCEOF ? this.type() : this.term3();
            posStack[top - 1] = pos;
            while (top > 0 && Parser.prec(topOp) >= Parser.prec(this.S.token())) {
                odStack[top - 1] = this.makeOp(posStack[top - 1], topOp, odStack[top - 1], odStack[top]);
                topOp = opStack[--top];
            }
        }
        assert (top == 0);
        t = odStack[0];
        if (t.getTag() == 69 && (buf = this.foldStrings(t)) != null) {
            t = this.toP(this.F.at(startPos).Literal(10, buf.toString()));
        }
        this.odStackSupply.elems = savedOd;
        this.posStackSupply.elems = savedPos;
        this.opStackSupply.elems = savedOp;
        return t;
    }

    private JCTree.JCExpression makeOp(int pos, Token topOp, JCTree.JCExpression od1, JCTree.JCExpression od2) {
        if (topOp == Token.INSTANCEOF) {
            return this.F.at(pos).TypeTest(od1, od2);
        }
        return this.F.at(pos).Binary(Parser.optag(topOp), od1, od2);
    }

    protected StringBuffer foldStrings(JCTree tree) {
        if (!this.allowStringFolding) {
            return null;
        }
        List<String> buf = List.nil();
        while (true) {
            if (tree.getTag() == 36) {
                JCTree.JCLiteral lit = (JCTree.JCLiteral)tree;
                if (lit.typetag != 10) break;
                StringBuffer sbuf = new StringBuffer((String)lit.value);
                while (buf.nonEmpty()) {
                    sbuf.append((String)buf.head);
                    buf = buf.tail;
                }
                return sbuf;
            }
            if (tree.getTag() != 69) break;
            JCTree.JCBinary op = (JCTree.JCBinary)tree;
            if (op.rhs.getTag() != 36) break;
            JCTree.JCLiteral lit = (JCTree.JCLiteral)op.rhs;
            if (lit.typetag != 10) break;
            buf = buf.prepend((String)lit.value);
            tree = op.lhs;
        }
        return null;
    }

    private JCTree.JCExpression[] newOdStack() {
        if (this.odStackSupply.elems == this.odStackSupply.last) {
            this.odStackSupply.append(new JCTree.JCExpression[11]);
        }
        JCTree.JCExpression[] odStack = (JCTree.JCExpression[])this.odStackSupply.elems.head;
        this.odStackSupply.elems = this.odStackSupply.elems.tail;
        return odStack;
    }

    private int[] newPosStack() {
        if (this.posStackSupply.elems == this.posStackSupply.last) {
            this.posStackSupply.append(new int[11]);
        }
        int[] posStack = (int[])this.posStackSupply.elems.head;
        this.posStackSupply.elems = this.posStackSupply.elems.tail;
        return posStack;
    }

    private Token[] newOpStack() {
        if (this.opStackSupply.elems == this.opStackSupply.last) {
            this.opStackSupply.append(new Token[11]);
        }
        Token[] opStack = (Token[])this.opStackSupply.elems.head;
        this.opStackSupply.elems = this.opStackSupply.elems.tail;
        return opStack;
    }

    protected JCTree.JCExpression term3() {
        JCTree.JCExpression t;
        int pos = this.S.pos();
        int prevmode = this.mode;
        List<JCTree.JCExpression> typeArgs = this.typeArgumentsOpt(1);
        if (typeArgs != null && this.S.pos() <= this.errorEndPos) {
            this.mode = prevmode;
            return this.F.at(pos).Erroneous(typeArgs);
        }
        switch (this.S.token()) {
            case QUES: {
                if ((this.mode & 2) != 0 && (this.mode & 0xC) == 8) {
                    this.mode = 2;
                    return this.typeArgument();
                }
                return this.illegal();
            }
            case BANG: 
            case TILDE: 
            case PLUSPLUS: 
            case SUBSUB: 
            case PLUS: 
            case SUB: {
                if (typeArgs == null && (this.mode & 1) != 0) {
                    Token token = this.S.token();
                    this.S.nextToken();
                    this.mode = 1;
                    if (token == Token.SUB && (this.S.token() == Token.INTLITERAL || this.S.token() == Token.LONGLITERAL) && this.S.radix() == 10) {
                        this.mode = 1;
                        t = this.literal(this.names.hyphen, pos);
                        break;
                    }
                    JCTree.JCExpression t2 = this.term3();
                    return this.F.at(pos).Unary(Parser.unoptag(token), t2);
                }
                return this.illegal();
            }
            case LPAREN: {
                if (typeArgs == null && (this.mode & 1) != 0) {
                    this.S.nextToken();
                    this.mode = 7;
                    t = this.term3();
                    if ((this.mode & 2) != 0 && this.S.token() == Token.LT) {
                        int op = 62;
                        int pos1 = this.S.pos();
                        this.S.nextToken();
                        this.mode &= 3;
                        this.mode |= 8;
                        JCTree.JCExpression t1 = this.term3();
                        if ((this.mode & 2) != 0 && (this.S.token() == Token.COMMA || this.S.token() == Token.GT)) {
                            this.mode = 2;
                            ListBuffer<JCTree.JCExpression> args = new ListBuffer<JCTree.JCExpression>();
                            args.append(t1);
                            while (this.S.token() == Token.COMMA) {
                                this.S.nextToken();
                                args.append(this.typeArgument());
                            }
                            this.accept(Token.GT);
                            t = this.F.at(pos1).TypeApply(t, args.toList());
                            this.checkGenerics();
                            t = this.bracketsOpt(this.toP(t));
                        } else if ((this.mode & 1) != 0) {
                            this.mode = 1;
                            t = this.F.at(pos1).Binary(op, t, this.term2Rest(t1, 11));
                            t = this.termRest(this.term1Rest(this.term2Rest(t, 4)));
                        } else {
                            this.accept(Token.GT);
                        }
                    } else {
                        t = this.termRest(this.term1Rest(this.term2Rest(t, 4)));
                    }
                    this.accept(Token.RPAREN);
                    this.lastmode = this.mode;
                    this.mode = 1;
                    if ((this.lastmode & 1) == 0) {
                        JCTree.JCExpression t1 = this.term3();
                        return this.F.at(pos).TypeCast(t, t1);
                    }
                    if ((this.lastmode & 2) != 0) {
                        switch (this.S.token()) {
                            case ENUM: 
                            case BYTE: 
                            case SHORT: 
                            case CHAR: 
                            case INT: 
                            case LONG: 
                            case FLOAT: 
                            case DOUBLE: 
                            case BOOLEAN: 
                            case VOID: 
                            case IDENTIFIER: 
                            case THIS: 
                            case SUPER: 
                            case INTLITERAL: 
                            case LONGLITERAL: 
                            case FLOATLITERAL: 
                            case DOUBLELITERAL: 
                            case CHARLITERAL: 
                            case STRINGLITERAL: 
                            case TRUE: 
                            case FALSE: 
                            case NULL: 
                            case BANG: 
                            case TILDE: 
                            case LPAREN: 
                            case NEW: 
                            case ASSERT: {
                                JCTree.JCExpression t1 = this.term3();
                                return this.F.at(pos).TypeCast(t, t1);
                            }
                        }
                    }
                } else {
                    return this.illegal();
                }
                t = this.toP(this.F.at(pos).Parens(t));
                break;
            }
            case THIS: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.to(this.F.at(pos).Ident(this.names._this));
                    this.S.nextToken();
                    t = typeArgs == null ? this.argumentsOpt(null, t) : this.arguments(typeArgs, t);
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case SUPER: {
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.superSuffix(typeArgs, this.to(this.F.at(pos).Ident(this.names._super)));
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case INTLITERAL: 
            case LONGLITERAL: 
            case FLOATLITERAL: 
            case DOUBLELITERAL: 
            case CHARLITERAL: 
            case STRINGLITERAL: 
            case TRUE: 
            case FALSE: 
            case NULL: {
                if (typeArgs == null && (this.mode & 1) != 0) {
                    this.mode = 1;
                    t = this.literal(this.names.empty, this.S.pos());
                    break;
                }
                return this.illegal();
            }
            case NEW: {
                if (typeArgs != null) {
                    return this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    this.S.nextToken();
                    if (this.S.token() == Token.LT) {
                        typeArgs = this.typeArguments();
                    }
                    t = this.creator(pos, typeArgs);
                    typeArgs = null;
                    break;
                }
                return this.illegal();
            }
            case ENUM: 
            case IDENTIFIER: 
            case ASSERT: {
                if (typeArgs != null) {
                    return this.illegal();
                }
                t = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
                block27: while (true) {
                    pos = this.S.pos();
                    switch (this.S.token()) {
                        case LBRACKET: {
                            this.S.nextToken();
                            if (this.S.token() == Token.RBRACKET) {
                                this.S.nextToken();
                                t = this.bracketsOpt(t);
                                t = this.toP(this.F.at(pos).TypeArray(t));
                                t = this.bracketsSuffix(t);
                                break block27;
                            }
                            if ((this.mode & 1) != 0) {
                                this.mode = 1;
                                JCTree.JCExpression t1 = this.term();
                                t = this.to(this.F.at(pos).Indexed(t, t1));
                            }
                            this.accept(Token.RBRACKET);
                            break block27;
                        }
                        case LPAREN: {
                            if ((this.mode & 1) == 0) break block27;
                            this.mode = 1;
                            t = this.arguments(typeArgs, t);
                            typeArgs = null;
                            break block27;
                        }
                        case DOT: {
                            this.S.nextToken();
                            typeArgs = this.typeArgumentsOpt(1);
                            if ((this.mode & 1) != 0) {
                                switch (this.S.token()) {
                                    case CLASS: {
                                        if (typeArgs != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        t = this.to(this.F.at(pos).Select(t, this.names._class));
                                        this.S.nextToken();
                                        break block27;
                                    }
                                    case THIS: {
                                        if (typeArgs != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        t = this.to(this.F.at(pos).Select(t, this.names._this));
                                        this.S.nextToken();
                                        break block27;
                                    }
                                    case SUPER: {
                                        this.mode = 1;
                                        t = this.to(this.F.at(pos).Select(t, this.names._super));
                                        t = this.superSuffix(typeArgs, t);
                                        typeArgs = null;
                                        break block27;
                                    }
                                    case NEW: {
                                        if (typeArgs != null) {
                                            return this.illegal();
                                        }
                                        this.mode = 1;
                                        int pos1 = this.S.pos();
                                        this.S.nextToken();
                                        if (this.S.token() == Token.LT) {
                                            typeArgs = this.typeArguments();
                                        }
                                        t = this.innerCreator(pos1, typeArgs, t);
                                        typeArgs = null;
                                        break block27;
                                    }
                                }
                            }
                            t = this.toP(this.F.at(pos).Select(t, this.ident()));
                            continue block27;
                        }
                    }
                    break;
                }
                if (typeArgs != null) {
                    this.illegal();
                }
                t = this.typeArgumentsOpt(t);
                break;
            }
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (typeArgs != null) {
                    this.illegal();
                }
                t = this.bracketsSuffix(this.bracketsOpt(this.basicType()));
                break;
            }
            case VOID: {
                if (typeArgs != null) {
                    this.illegal();
                }
                if ((this.mode & 1) != 0) {
                    this.S.nextToken();
                    if (this.S.token() == Token.DOT) {
                        JCTree.JCPrimitiveTypeTree ti = this.toP(this.F.at(pos).TypeIdent(9));
                        t = this.bracketsSuffix(ti);
                        break;
                    }
                    return this.illegal(pos);
                }
                return this.illegal();
            }
            default: {
                return this.illegal();
            }
        }
        if (typeArgs != null) {
            this.illegal();
        }
        while (true) {
            int pos1 = this.S.pos();
            if (this.S.token() == Token.LBRACKET) {
                this.S.nextToken();
                if ((this.mode & 2) != 0) {
                    int oldmode = this.mode;
                    this.mode = 2;
                    if (this.S.token() == Token.RBRACKET) {
                        this.S.nextToken();
                        t = this.bracketsOpt(t);
                        t = this.toP(this.F.at(pos1).TypeArray(t));
                        return t;
                    }
                    this.mode = oldmode;
                }
                if ((this.mode & 1) != 0) {
                    this.mode = 1;
                    JCTree.JCExpression t1 = this.term();
                    t = this.to(this.F.at(pos1).Indexed(t, t1));
                }
                this.accept(Token.RBRACKET);
                continue;
            }
            if (this.S.token() != Token.DOT) break;
            this.S.nextToken();
            typeArgs = this.typeArgumentsOpt(1);
            if (this.S.token() == Token.SUPER && (this.mode & 1) != 0) {
                this.mode = 1;
                t = this.to(this.F.at(pos1).Select(t, this.names._super));
                this.S.nextToken();
                t = this.arguments(typeArgs, t);
                typeArgs = null;
                continue;
            }
            if (this.S.token() == Token.NEW && (this.mode & 1) != 0) {
                if (typeArgs != null) {
                    return this.illegal();
                }
                this.mode = 1;
                int pos2 = this.S.pos();
                this.S.nextToken();
                if (this.S.token() == Token.LT) {
                    typeArgs = this.typeArguments();
                }
                t = this.innerCreator(pos2, typeArgs, t);
                typeArgs = null;
                continue;
            }
            t = this.toP(this.F.at(pos1).Select(t, this.ident()));
            t = this.argumentsOpt(typeArgs, this.typeArgumentsOpt(t));
            typeArgs = null;
        }
        while ((this.S.token() == Token.PLUSPLUS || this.S.token() == Token.SUBSUB) && (this.mode & 1) != 0) {
            this.mode = 1;
            t = this.to(this.F.at(this.S.pos()).Unary(this.S.token() == Token.PLUSPLUS ? 52 : 53, t));
            this.S.nextToken();
        }
        return this.toP(t);
    }

    JCTree.JCExpression superSuffix(List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        this.S.nextToken();
        if (this.S.token() == Token.LPAREN || typeArgs != null) {
            t = this.arguments(typeArgs, t);
        } else {
            int pos = this.S.pos();
            this.accept(Token.DOT);
            typeArgs = this.S.token() == Token.LT ? this.typeArguments() : null;
            t = this.toP(this.F.at(pos).Select(t, this.ident()));
            t = this.argumentsOpt(typeArgs, t);
        }
        return t;
    }

    JCTree.JCPrimitiveTypeTree basicType() {
        JCTree.JCPrimitiveTypeTree t = this.to(this.F.at(this.S.pos()).TypeIdent(Parser.typetag(this.S.token())));
        this.S.nextToken();
        return t;
    }

    JCTree.JCExpression argumentsOpt(List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        if ((this.mode & 1) != 0 && this.S.token() == Token.LPAREN || typeArgs != null) {
            this.mode = 1;
            return this.arguments(typeArgs, t);
        }
        return t;
    }

    List<JCTree.JCExpression> arguments() {
        ListBuffer args = ListBuffer.lb();
        if (this.S.token() == Token.LPAREN) {
            this.S.nextToken();
            if (this.S.token() != Token.RPAREN) {
                args.append(this.expression());
                while (this.S.token() == Token.COMMA) {
                    this.S.nextToken();
                    args.append(this.expression());
                }
            }
            this.accept(Token.RPAREN);
        } else {
            this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Token.LPAREN));
        }
        return args.toList();
    }

    JCTree.JCMethodInvocation arguments(List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        int pos = this.S.pos();
        List<JCTree.JCExpression> args = this.arguments();
        return this.toP(this.F.at(pos).Apply(typeArgs, t, args));
    }

    JCTree.JCExpression typeArgumentsOpt(JCTree.JCExpression t) {
        if (this.S.token() == Token.LT && (this.mode & 2) != 0 && (this.mode & 4) == 0) {
            this.mode = 2;
            this.checkGenerics();
            return this.typeArguments(t);
        }
        return t;
    }

    List<JCTree.JCExpression> typeArgumentsOpt() {
        return this.typeArgumentsOpt(2);
    }

    List<JCTree.JCExpression> typeArgumentsOpt(int useMode) {
        if (this.S.token() == Token.LT) {
            this.checkGenerics();
            if ((this.mode & useMode) == 0 || (this.mode & 4) != 0) {
                this.illegal();
            }
            this.mode = useMode;
            return this.typeArguments();
        }
        return null;
    }

    List<JCTree.JCExpression> typeArguments() {
        ListBuffer args = ListBuffer.lb();
        if (this.S.token() == Token.LT) {
            this.S.nextToken();
            args.append((this.mode & 1) == 0 ? this.typeArgument() : this.type());
            while (this.S.token() == Token.COMMA) {
                this.S.nextToken();
                args.append((this.mode & 1) == 0 ? this.typeArgument() : this.type());
            }
            switch (this.S.token()) {
                case GTGTGTEQ: {
                    this.S.token(Token.GTGTEQ);
                    break;
                }
                case GTGTEQ: {
                    this.S.token(Token.GTEQ);
                    break;
                }
                case GTEQ: {
                    this.S.token(Token.EQ);
                    break;
                }
                case GTGTGT: {
                    this.S.token(Token.GTGT);
                    break;
                }
                case GTGT: {
                    this.S.token(Token.GT);
                    break;
                }
                default: {
                    this.accept(Token.GT);
                    break;
                }
            }
        } else {
            this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Token.LT));
        }
        return args.toList();
    }

    JCTree.JCExpression typeArgument() {
        if (this.S.token() != Token.QUES) {
            return this.type();
        }
        int pos = this.S.pos();
        this.S.nextToken();
        if (this.S.token() == Token.EXTENDS) {
            JCTree.TypeBoundKind t = this.to(this.F.at(this.S.pos()).TypeBoundKind(BoundKind.EXTENDS));
            this.S.nextToken();
            return this.F.at(pos).Wildcard(t, this.type());
        }
        if (this.S.token() == Token.SUPER) {
            JCTree.TypeBoundKind t = this.to(this.F.at(this.S.pos()).TypeBoundKind(BoundKind.SUPER));
            this.S.nextToken();
            return this.F.at(pos).Wildcard(t, this.type());
        }
        if (this.S.token() == Token.IDENTIFIER) {
            this.reportSyntaxError(this.S.prevEndPos(), "expected3", this.keywords.token2string(Token.GT), this.keywords.token2string(Token.EXTENDS), this.keywords.token2string(Token.SUPER));
            JCTree.TypeBoundKind t = this.F.at(-1).TypeBoundKind(BoundKind.UNBOUND);
            JCTree.JCExpression wc = this.toP(this.F.at(pos).Wildcard(t, null));
            JCTree.JCIdent id = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
            return this.F.at(pos).Erroneous(List.of(wc, id));
        }
        JCTree.TypeBoundKind t = this.F.at(-1).TypeBoundKind(BoundKind.UNBOUND);
        return this.toP(this.F.at(pos).Wildcard(t, null));
    }

    JCTree.JCTypeApply typeArguments(JCTree.JCExpression t) {
        int pos = this.S.pos();
        List<JCTree.JCExpression> args = this.typeArguments();
        return this.toP(this.F.at(pos).TypeApply(t, args));
    }

    private JCTree.JCExpression bracketsOpt(JCTree.JCExpression t) {
        if (this.S.token() == Token.LBRACKET) {
            int pos = this.S.pos();
            this.S.nextToken();
            t = this.bracketsOptCont(t, pos);
            this.F.at(pos);
        }
        return t;
    }

    private JCTree.JCArrayTypeTree bracketsOptCont(JCTree.JCExpression t, int pos) {
        this.accept(Token.RBRACKET);
        t = this.bracketsOpt(t);
        return this.toP(this.F.at(pos).TypeArray(t));
    }

    JCTree.JCExpression bracketsSuffix(JCTree.JCExpression t) {
        if ((this.mode & 1) != 0 && this.S.token() == Token.DOT) {
            this.mode = 1;
            int pos = this.S.pos();
            this.S.nextToken();
            this.accept(Token.CLASS);
            if (this.S.pos() == this.errorEndPos) {
                Name name = null;
                if (this.S.token() == Token.IDENTIFIER) {
                    name = this.S.name();
                    this.S.nextToken();
                } else {
                    name = this.names.error;
                }
                t = this.F.at(pos).Erroneous(List.of(this.toP(this.F.at(pos).Select(t, name))));
            } else {
                t = this.toP(this.F.at(pos).Select(t, this.names._class));
            }
        } else if ((this.mode & 2) != 0) {
            this.mode = 2;
        } else {
            this.syntaxError(this.S.pos(), "dot.class.expected", new Object[0]);
        }
        return t;
    }

    JCTree.JCExpression creator(int newpos, List<JCTree.JCExpression> typeArgs) {
        switch (this.S.token()) {
            case BYTE: 
            case SHORT: 
            case CHAR: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                if (typeArgs != null) break;
                return this.arrayCreatorRest(newpos, this.basicType());
            }
        }
        JCTree.JCExpression t = this.qualident();
        int oldmode = this.mode;
        this.mode = 2;
        if (this.S.token() == Token.LT) {
            this.checkGenerics();
            t = this.typeArguments(t);
        }
        while (this.S.token() == Token.DOT) {
            int pos = this.S.pos();
            this.S.nextToken();
            t = this.toP(this.F.at(pos).Select(t, this.ident()));
            if (this.S.token() != Token.LT) continue;
            this.checkGenerics();
            t = this.typeArguments(t);
        }
        this.mode = oldmode;
        if (this.S.token() == Token.LBRACKET) {
            JCTree.JCExpression e = this.arrayCreatorRest(newpos, t);
            if (typeArgs != null) {
                int pos = newpos;
                if (!typeArgs.isEmpty() && ((JCTree.JCExpression)typeArgs.head).pos != -1) {
                    pos = ((JCTree.JCExpression)typeArgs.head).pos;
                }
                this.setErrorEndPos(this.S.prevEndPos());
                this.reportSyntaxError(pos, "cannot.create.array.with.type.arguments", new Object[0]);
                return this.toP(this.F.at(newpos).Erroneous(typeArgs.prepend(e)));
            }
            return e;
        }
        if (this.S.token() == Token.LPAREN) {
            return this.classCreatorRest(newpos, null, typeArgs, t);
        }
        this.errorEndPos = this.S.pos();
        this.reportSyntaxError(this.S.pos(), "expected2", this.keywords.token2string(Token.LPAREN), this.keywords.token2string(Token.LBRACKET));
        t = this.toP(this.F.at(newpos).NewClass(null, typeArgs, t, List.<JCTree.JCExpression>nil(), null));
        return this.toP(this.F.at(newpos).Erroneous(List.of(t)));
    }

    JCTree.JCExpression innerCreator(int newpos, List<JCTree.JCExpression> typeArgs, JCTree.JCExpression encl) {
        JCTree.JCExpression t = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
        if (this.S.token() == Token.LT) {
            this.checkGenerics();
            t = this.typeArguments(t);
        }
        return this.classCreatorRest(newpos, encl, typeArgs, t);
    }

    JCTree.JCExpression arrayCreatorRest(int newpos, JCTree.JCExpression elemtype) {
        this.accept(Token.LBRACKET);
        if (this.S.token() == Token.RBRACKET) {
            this.accept(Token.RBRACKET);
            elemtype = this.bracketsOpt(elemtype);
            if (this.S.token() == Token.LBRACE) {
                return this.arrayInitializer(newpos, elemtype);
            }
            return this.syntaxError(this.S.pos(), List.of(this.toP(this.F.at(newpos).NewArray(elemtype, List.<JCTree.JCExpression>nil(), null))), "array.dimension.missing", new Object[0]);
        }
        ListBuffer<JCTree.JCExpression> dims = new ListBuffer<JCTree.JCExpression>();
        dims.append(this.expression());
        this.accept(Token.RBRACKET);
        while (this.S.token() == Token.LBRACKET) {
            int pos = this.S.pos();
            this.S.nextToken();
            if (this.S.token() == Token.RBRACKET) {
                elemtype = this.bracketsOptCont(elemtype, pos);
                continue;
            }
            dims.append(this.expression());
            this.accept(Token.RBRACKET);
        }
        return this.toP(this.F.at(newpos).NewArray(elemtype, dims.toList(), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree.JCExpression classCreatorRest(int newpos, JCTree.JCExpression encl, List<JCTree.JCExpression> typeArgs, JCTree.JCExpression t) {
        List<JCTree.JCExpression> args = this.arguments();
        JCTree.JCClassDecl body = null;
        if (this.S.token() == Token.LBRACE) {
            this.anonScopes.push(new AnonScope(this.names.empty));
            int pos = 0;
            List<JCTree> defs = null;
            JCTree.JCModifiers mods = null;
            try {
                pos = this.S.pos();
                defs = this.classOrInterfaceBody(this.names.empty, false);
                mods = this.F.at(-1).Modifiers(0L);
                Object var11_10 = null;
                this.anonScopes.pop();
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                this.anonScopes.pop();
                throw throwable;
            }
            body = this.toP(this.F.at(pos).AnonymousClassDef(mods, defs, this.anonScopes.peek().assignNumber()));
        }
        return this.toP(this.F.at(newpos).NewClass(encl, typeArgs, t, args, body));
    }

    JCTree.JCExpression arrayInitializer(int newpos, JCTree.JCExpression t) {
        this.accept(Token.LBRACE);
        ListBuffer<JCTree.JCExpression> elems = new ListBuffer<JCTree.JCExpression>();
        if (this.S.token() == Token.COMMA) {
            this.S.nextToken();
        } else if (this.S.token() != Token.RBRACE) {
            elems.append(this.variableInitializer());
            while (this.S.token() == Token.COMMA) {
                this.S.nextToken();
                if (this.S.token() == Token.RBRACE) break;
                elems.append(this.variableInitializer());
            }
            if (this.S.pos() <= this.errorEndPos) {
                this.skip(false, true, true, true);
            }
        }
        this.accept(Token.RBRACE);
        return this.toP(this.F.at(newpos).NewArray(t, List.<JCTree.JCExpression>nil(), elems.toList()));
    }

    public JCTree.JCExpression variableInitializer() {
        return this.S.token() == Token.LBRACE ? this.arrayInitializer(this.S.pos(), null) : this.expression();
    }

    JCTree.JCExpression parExpression() {
        this.accept(Token.LPAREN);
        JCTree.JCExpression t = this.expression();
        this.accept(Token.RPAREN);
        return t;
    }

    JCTree.JCBlock block(int pos, long flags) {
        this.accept(Token.LBRACE);
        List<JCTree.JCStatement> stats = this.blockStatements();
        JCTree.JCBlock t = this.F.at(pos).Block(flags, stats);
        while (this.S.token() == Token.CASE || this.S.token() == Token.DEFAULT) {
            this.syntaxError("orphaned", this.keywords.token2string(this.S.token()));
            this.switchBlockStatementGroups();
        }
        t.endpos = this.S.pos();
        this.accept(Token.RBRACE);
        return this.toP(t);
    }

    public JCTree.JCBlock block() {
        return this.block(this.S.pos(), 0L);
    }

    List<JCTree.JCStatement> blockStatements() {
        int lastErrPos = -1;
        ListBuffer<JCTree.JCStatement> stats = new ListBuffer<JCTree.JCStatement>();
        while (true) {
            int pos = this.S.pos();
            switch (this.S.token()) {
                case EOF: 
                case RBRACE: 
                case CASE: 
                case DEFAULT: {
                    return stats.toList();
                }
                case SEMI: 
                case LBRACE: 
                case SYNCHRONIZED: 
                case IF: 
                case FOR: 
                case WHILE: 
                case DO: 
                case TRY: 
                case SWITCH: 
                case RETURN: 
                case THROW: 
                case BREAK: 
                case CONTINUE: 
                case ELSE: 
                case FINALLY: 
                case CATCH: {
                    stats.append(this.statement());
                    break;
                }
                case FINAL: 
                case MONKEYS_AT: {
                    String dc = this.S.docComment();
                    JCTree.JCModifiers mods = this.modifiersOpt();
                    if (this.S.token() == Token.INTERFACE || this.S.token() == Token.CLASS || this.allowEnums && this.S.token() == Token.ENUM) {
                        stats.append(this.classOrInterfaceOrEnumDeclaration(mods, dc));
                        break;
                    }
                    JCTree.JCExpression t = this.type();
                    stats.appendList(this.variableDeclarators(mods, t, new ListBuffer()));
                    this.storeEnd((JCTree)stats.elems.last(), this.S.endPos());
                    this.accept(Token.SEMI);
                    break;
                }
                case ABSTRACT: 
                case STRICTFP: {
                    String dc = this.S.docComment();
                    JCTree.JCModifiers mods = this.modifiersOpt();
                    if (this.S.token() == Token.INTERFACE || this.S.token() == Token.CLASS || this.allowEnums && this.S.token() == Token.ENUM) {
                        stats.append(this.classOrInterfaceOrEnumDeclaration(mods, dc));
                        break;
                    }
                    this.setErrorEndPos(this.S.pos());
                    break;
                }
                case CLASS: 
                case INTERFACE: {
                    stats.append(this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(), this.S.docComment()));
                    break;
                }
                case ENUM: 
                case ASSERT: {
                    if (this.allowEnums && this.S.token() == Token.ENUM) {
                        this.log.error(this.S.pos(), "local.enum", new Object[0]);
                        stats.append(this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(), this.S.docComment()));
                        break;
                    }
                    if (this.allowAsserts && this.S.token() == Token.ASSERT) {
                        stats.append(this.statement());
                        break;
                    }
                }
                default: {
                    Name name = this.S.name();
                    JCTree.JCExpression t = this.term(3);
                    if (this.S.token() == Token.COLON && t.getTag() == 35) {
                        this.S.nextToken();
                        JCTree.JCStatement stat = this.statement();
                        stats.append(this.F.at(pos).Labelled(name, stat));
                        break;
                    }
                    if ((this.lastmode & 2) != 0 && (this.S.token() == Token.IDENTIFIER || this.S.token() == Token.ASSERT || this.S.token() == Token.ENUM)) {
                        pos = this.S.pos();
                        JCTree.JCModifiers mods = this.F.at(-1).Modifiers(0L);
                        this.F.at(pos);
                        stats.appendList(this.variableDeclarators(mods, t, new ListBuffer()));
                        this.accept(Token.SEMI);
                        this.storeEnd((JCTree)stats.elems.last(), this.S.prevEndPos());
                        break;
                    }
                    this.accept(Token.SEMI);
                    stats.append(this.toP(this.F.at(pos).Exec(this.checkExprStat(t))));
                }
            }
            if (this.S.pos() == lastErrPos) {
                return stats.toList();
            }
            if (this.S.pos() <= this.errorEndPos) {
                this.skip(false, true, true, true);
                lastErrPos = this.S.pos();
            }
            this.S.resetDeprecatedFlag();
        }
    }

    public JCTree.JCStatement statement() {
        int pos = this.S.pos();
        switch (this.S.token()) {
            case LBRACE: {
                return this.block();
            }
            case IF: {
                this.S.nextToken();
                JCTree.JCExpression cond = this.parExpression();
                JCTree.JCStatement thenpart = this.statement();
                JCTree.JCStatement elsepart = null;
                if (this.S.token() == Token.ELSE) {
                    this.S.nextToken();
                    elsepart = this.statement();
                }
                return this.F.at(pos).If(cond, thenpart, elsepart);
            }
            case FOR: {
                List<Object> inits;
                this.S.nextToken();
                this.accept(Token.LPAREN);
                List<Object> list = inits = this.S.token() == Token.SEMI ? List.nil() : this.forInit();
                if (inits.length() == 1 && ((JCTree.JCStatement)inits.head).getTag() == 5 && ((JCTree.JCVariableDecl)inits.head).init == null && this.S.token() == Token.COLON) {
                    this.checkForeach();
                    JCTree.JCVariableDecl var = (JCTree.JCVariableDecl)inits.head;
                    this.accept(Token.COLON);
                    JCTree.JCExpression expr = this.expression();
                    this.accept(Token.RPAREN);
                    if (this.errorEndPos >= this.S.pos()) {
                        this.storeEnd(expr, this.errorEndPos);
                    }
                    JCTree.JCStatement body = this.statement();
                    return this.F.at(pos).ForeachLoop(var, expr, body);
                }
                this.accept(Token.SEMI);
                if (this.errorEndPos >= this.S.pos() && inits.length() > 0) {
                    this.storeEnd((JCTree)inits.last(), this.errorEndPos);
                }
                JCTree.JCExpression cond = this.S.token() == Token.SEMI ? null : this.expression();
                this.accept(Token.SEMI);
                if (this.errorEndPos >= this.S.pos()) {
                    this.storeEnd(cond, this.errorEndPos);
                }
                List<Object> steps = this.S.token() == Token.RPAREN ? List.nil() : this.forUpdate();
                this.accept(Token.RPAREN);
                if (this.errorEndPos >= this.S.pos() && steps.length() > 0) {
                    this.storeEnd((JCTree)steps.last(), this.errorEndPos);
                }
                JCTree.JCStatement body = this.statement();
                return this.F.at(pos).ForLoop(inits, cond, steps, body);
            }
            case WHILE: {
                this.S.nextToken();
                JCTree.JCExpression cond = this.parExpression();
                JCTree.JCStatement body = this.statement();
                return this.F.at(pos).WhileLoop(cond, body);
            }
            case DO: {
                this.S.nextToken();
                JCTree.JCStatement body = this.statement();
                this.accept(Token.WHILE);
                JCTree.JCExpression cond = this.parExpression();
                this.accept(Token.SEMI);
                JCTree.JCDoWhileLoop t = this.toP(this.F.at(pos).DoLoop(body, cond));
                return t;
            }
            case TRY: {
                this.S.nextToken();
                JCTree.JCBlock body = this.block();
                ListBuffer<JCTree.JCCatch> catchers = new ListBuffer<JCTree.JCCatch>();
                JCTree.JCBlock finalizer = null;
                if (this.S.token() == Token.CATCH || this.S.token() == Token.FINALLY) {
                    while (this.S.token() == Token.CATCH) {
                        catchers.append(this.catchClause());
                    }
                    if (this.S.token() == Token.FINALLY) {
                        this.S.nextToken();
                        finalizer = this.block();
                    }
                } else {
                    this.log.error(pos, "try.without.catch.or.finally", new Object[0]);
                }
                return this.F.at(pos).Try(body, catchers.toList(), finalizer);
            }
            case SWITCH: {
                this.S.nextToken();
                JCTree.JCExpression selector = this.parExpression();
                this.accept(Token.LBRACE);
                List<JCTree.JCCase> cases = this.switchBlockStatementGroups();
                JCTree.JCSwitch t = this.to(this.F.at(pos).Switch(selector, cases));
                this.accept(Token.RBRACE);
                return t;
            }
            case SYNCHRONIZED: {
                this.S.nextToken();
                JCTree.JCExpression lock = this.parExpression();
                JCTree.JCBlock body = this.block();
                return this.F.at(pos).Synchronized(lock, body);
            }
            case RETURN: {
                this.S.nextToken();
                JCTree.JCExpression result = this.S.token() == Token.SEMI ? null : this.expression();
                this.accept(Token.SEMI);
                JCTree.JCReturn t = this.toP(this.F.at(pos).Return(result));
                return t;
            }
            case THROW: {
                this.S.nextToken();
                JCTree.JCExpression exc = this.expression();
                this.accept(Token.SEMI);
                JCTree.JCThrow t = this.toP(this.F.at(pos).Throw(exc));
                return t;
            }
            case BREAK: {
                this.S.nextToken();
                Name label = this.S.token() == Token.IDENTIFIER || this.S.token() == Token.ASSERT || this.S.token() == Token.ENUM ? this.ident() : null;
                this.accept(Token.SEMI);
                JCTree.JCBreak t = this.toP(this.F.at(pos).Break(label));
                return t;
            }
            case CONTINUE: {
                this.S.nextToken();
                Name label = this.S.token() == Token.IDENTIFIER || this.S.token() == Token.ASSERT || this.S.token() == Token.ENUM ? this.ident() : null;
                this.accept(Token.SEMI);
                JCTree.JCContinue t = this.toP(this.F.at(pos).Continue(label));
                return t;
            }
            case SEMI: {
                this.S.nextToken();
                return this.toP(this.F.at(pos).Skip());
            }
            case ELSE: {
                return this.toP(this.F.Exec(this.syntaxError("else.without.if")));
            }
            case FINALLY: {
                return this.toP(this.F.Exec(this.syntaxError("finally.without.try")));
            }
            case CATCH: {
                return this.toP(this.F.Exec(this.syntaxError("catch.without.try")));
            }
            case ASSERT: {
                if (!this.allowAsserts || this.S.token() != Token.ASSERT) break;
                this.S.nextToken();
                JCTree.JCExpression assertion = this.expression();
                JCTree.JCExpression message = null;
                if (this.S.token() == Token.COLON) {
                    this.S.nextToken();
                    message = this.expression();
                }
                this.accept(Token.SEMI);
                JCTree.JCAssert t = this.toP(this.F.at(pos).Assert(assertion, message));
                return t;
            }
        }
        Name name = this.S.name();
        JCTree.JCExpression expr = this.expression();
        if (this.S.token() == Token.COLON && expr.getTag() == 35) {
            this.S.nextToken();
            JCTree.JCStatement stat = this.statement();
            return this.F.at(pos).Labelled(name, stat);
        }
        JCTree.JCExpressionStatement stat = this.to(this.F.at(pos).Exec(this.checkExprStat(expr)));
        if (this.S.token() != Token.SEMI) {
            this.storeEnd(stat, this.S.pos());
        }
        this.accept(Token.SEMI);
        return stat;
    }

    JCTree.JCCatch catchClause() {
        int pos = this.S.pos();
        this.accept(Token.CATCH);
        this.accept(Token.LPAREN);
        JCTree.JCVariableDecl formal = this.variableDeclaratorId(this.optFinal(0x200000000L), this.qualident());
        this.accept(Token.RPAREN);
        JCTree.JCBlock body = this.block();
        return this.F.at(pos).Catch(formal, body);
    }

    List<JCTree.JCCase> switchBlockStatementGroups() {
        ListBuffer<JCTree.JCCase> cases = new ListBuffer<JCTree.JCCase>();
        block5: while (true) {
            int pos = this.S.pos();
            switch (this.S.token()) {
                case CASE: {
                    this.S.nextToken();
                    JCTree.JCExpression pat = this.expression();
                    this.accept(Token.COLON);
                    List<JCTree.JCStatement> stats = this.blockStatements();
                    JCTree.JCCase c = this.F.at(pos).Case(pat, stats);
                    if (stats.isEmpty()) {
                        this.storeEnd(c, this.S.prevEndPos());
                    }
                    cases.append(c);
                    continue block5;
                }
                case DEFAULT: {
                    this.S.nextToken();
                    this.accept(Token.COLON);
                    List<JCTree.JCStatement> stats = this.blockStatements();
                    JCTree.JCCase c = this.F.at(pos).Case(null, stats);
                    if (stats.isEmpty()) {
                        this.storeEnd(c, this.S.prevEndPos());
                    }
                    cases.append(c);
                    continue block5;
                }
                case EOF: 
                case RBRACE: {
                    return cases.toList();
                }
            }
            this.S.nextToken();
            this.syntaxError(pos, "expected3", this.keywords.token2string(Token.CASE), this.keywords.token2string(Token.DEFAULT), this.keywords.token2string(Token.RBRACE));
        }
    }

    <T extends ListBuffer<? super JCTree.JCExpressionStatement>> T moreStatementExpressions(int pos, JCTree.JCExpression first, T stats) {
        stats.append((JCTree.JCExpressionStatement)this.toP(this.F.at(pos).Exec(this.checkExprStat(first))));
        while (this.S.token() == Token.COMMA) {
            this.S.nextToken();
            pos = this.S.pos();
            JCTree.JCExpression t = this.expression();
            stats.append((JCTree.JCExpressionStatement)this.toP(this.F.at(pos).Exec(this.checkExprStat(t))));
        }
        return stats;
    }

    List<JCTree.JCStatement> forInit() {
        ListBuffer stats = ListBuffer.lb();
        int pos = this.S.pos();
        if (this.S.token() == Token.FINAL || this.S.token() == Token.MONKEYS_AT) {
            return this.variableDeclarators(this.optFinal(0L), this.type(), stats).toList();
        }
        JCTree.JCExpression t = this.term(3);
        if ((this.lastmode & 2) != 0 && (this.S.token() == Token.IDENTIFIER || this.S.token() == Token.ASSERT || this.S.token() == Token.ENUM)) {
            return this.variableDeclarators(this.modifiersOpt(), t, stats).toList();
        }
        return this.moreStatementExpressions(pos, t, stats).toList();
    }

    List<JCTree.JCExpressionStatement> forUpdate() {
        return this.moreStatementExpressions(this.S.pos(), this.expression(), new ListBuffer()).toList();
    }

    List<JCTree.JCAnnotation> annotationsOpt() {
        if (this.S.token() != Token.MONKEYS_AT) {
            return List.nil();
        }
        ListBuffer<JCTree.JCAnnotation> buf = new ListBuffer<JCTree.JCAnnotation>();
        while (this.S.token() == Token.MONKEYS_AT) {
            int pos = this.S.pos();
            this.S.nextToken();
            buf.append(this.annotation(pos));
        }
        return buf.toList();
    }

    JCTree.JCModifiers modifiersOpt() {
        return this.modifiersOpt(null);
    }

    JCTree.JCModifiers modifiersOpt(JCTree.JCModifiers partial) {
        long flags;
        long l = flags = partial == null ? 0L : partial.flags;
        if (this.S.deprecatedFlag()) {
            flags |= 0x20000L;
            this.S.resetDeprecatedFlag();
        }
        ListBuffer<JCTree.JCAnnotation> annotations = new ListBuffer<JCTree.JCAnnotation>();
        if (partial != null) {
            annotations.appendList(partial.annotations);
        }
        int pos = this.S.pos();
        int lastPos = -1;
        block18: while (true) {
            long flag;
            switch (this.S.token()) {
                case PRIVATE: {
                    flag = 2L;
                    break;
                }
                case PROTECTED: {
                    flag = 4L;
                    break;
                }
                case PUBLIC: {
                    flag = 1L;
                    break;
                }
                case STATIC: {
                    flag = 8L;
                    break;
                }
                case TRANSIENT: {
                    flag = 128L;
                    break;
                }
                case FINAL: {
                    flag = 16L;
                    break;
                }
                case ABSTRACT: {
                    flag = 1024L;
                    break;
                }
                case NATIVE: {
                    flag = 256L;
                    break;
                }
                case VOLATILE: {
                    flag = 64L;
                    break;
                }
                case SYNCHRONIZED: {
                    flag = 32L;
                    break;
                }
                case STRICTFP: {
                    flag = 2048L;
                    break;
                }
                case MONKEYS_AT: {
                    flag = 8192L;
                    break;
                }
                default: {
                    break block18;
                }
            }
            if ((flags & flag) != 0L) {
                this.log.error(this.S.pos(), "repeated.modifier", new Object[0]);
            }
            lastPos = this.S.pos();
            this.S.nextToken();
            if (flag == 8192L) {
                this.checkAnnotations();
                if (this.S.token() != Token.INTERFACE) {
                    JCTree.JCAnnotation ann = this.annotation(lastPos);
                    if (flags == 0L && annotations.isEmpty()) {
                        pos = ann.pos;
                    }
                    annotations.append(ann);
                    lastPos = ann.pos;
                    flag = 0L;
                }
            }
            flags |= flag;
        }
        if (flags == 0L && annotations.isEmpty()) {
            pos = -1;
        }
        switch (this.S.token()) {
            case ENUM: {
                if (!this.allowEnums) break;
                flags |= 0x4000L;
                break;
            }
            case INTERFACE: {
                flags |= 0x200L;
                break;
            }
        }
        JCTree.JCModifiers mods = this.F.at(pos).Modifiers(flags, annotations.toList());
        if (pos != -1) {
            this.storeEnd(mods, this.S.prevEndPos());
        }
        return mods;
    }

    JCTree.JCAnnotation annotation(int pos) {
        this.checkAnnotations();
        JCTree.JCExpression ident = this.qualident();
        int identEndPos = this.S.prevEndPos();
        boolean hasParens = this.S.token() == Token.LPAREN;
        List<JCTree.JCExpression> fieldValues = this.annotationFieldValuesOpt();
        JCTree.JCAnnotation ann = this.F.at(pos).Annotation(ident, fieldValues);
        this.storeEnd(ann, hasParens ? this.S.prevEndPos() : identEndPos);
        return ann;
    }

    List<JCTree.JCExpression> annotationFieldValuesOpt() {
        return this.S.token() == Token.LPAREN ? this.annotationFieldValues() : List.nil();
    }

    List<JCTree.JCExpression> annotationFieldValues() {
        this.accept(Token.LPAREN);
        ListBuffer<JCTree.JCExpression> buf = new ListBuffer<JCTree.JCExpression>();
        if (this.S.token() != Token.RPAREN) {
            buf.append(this.annotationFieldValue());
            while (this.S.token() == Token.COMMA) {
                this.S.nextToken();
                buf.append(this.annotationFieldValue());
            }
        }
        this.accept(Token.RPAREN);
        return buf.toList();
    }

    JCTree.JCExpression annotationFieldValue() {
        if (this.S.token() == Token.IDENTIFIER) {
            this.mode = 1;
            JCTree.JCExpression t1 = this.term1();
            if (t1.getTag() == 35 && this.S.token() == Token.EQ) {
                int pos = this.S.pos();
                this.accept(Token.EQ);
                return this.toP(this.F.at(pos).Assign(t1, this.annotationValue()));
            }
            return t1;
        }
        return this.annotationValue();
    }

    JCTree.JCExpression annotationValue() {
        switch (this.S.token()) {
            case MONKEYS_AT: {
                int pos = this.S.pos();
                this.S.nextToken();
                return this.annotation(pos);
            }
            case LBRACE: {
                int pos = this.S.pos();
                this.accept(Token.LBRACE);
                ListBuffer<JCTree.JCExpression> buf = new ListBuffer<JCTree.JCExpression>();
                if (this.S.token() != Token.RBRACE) {
                    buf.append(this.annotationValue());
                    while (this.S.token() == Token.COMMA) {
                        this.S.nextToken();
                        if (this.S.token() == Token.RPAREN) break;
                        buf.append(this.annotationValue());
                    }
                }
                this.accept(Token.RBRACE);
                return this.toP(this.F.at(pos).NewArray(null, List.<JCTree.JCExpression>nil(), buf.toList()));
            }
        }
        this.mode = 1;
        return this.term1();
    }

    public <T extends ListBuffer<? super JCTree.JCVariableDecl>> T variableDeclarators(JCTree.JCModifiers mods, JCTree.JCExpression type, T vdefs) {
        return this.variableDeclaratorsRest(this.S.pos(), mods, type, this.ident(), false, null, vdefs);
    }

    <T extends ListBuffer<? super JCTree.JCVariableDecl>> T variableDeclaratorsRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, boolean reqInit, String dc, T vdefs) {
        vdefs.append((JCTree.JCVariableDecl)this.variableDeclaratorRest(pos, mods, type, name, reqInit, dc));
        while (this.S.token() == Token.COMMA) {
            this.storeEnd((JCTree)vdefs.elems.last(), this.S.endPos());
            this.S.nextToken();
            vdefs.append((JCTree.JCVariableDecl)this.variableDeclarator(mods, type, reqInit, dc));
        }
        return vdefs;
    }

    JCTree.JCVariableDecl variableDeclarator(JCTree.JCModifiers mods, JCTree.JCExpression type, boolean reqInit, String dc) {
        return this.variableDeclaratorRest(this.S.pos(), mods, type, this.ident(), reqInit, dc);
    }

    JCTree.JCVariableDecl variableDeclaratorRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, boolean reqInit, String dc) {
        type = this.bracketsOpt(type);
        JCTree.JCExpression init = null;
        if (this.S.token() == Token.EQ) {
            this.S.nextToken();
            init = this.variableInitializer();
        } else if (reqInit) {
            this.syntaxError(this.S.pos(), "expected", this.keywords.token2string(Token.EQ));
        }
        JCTree.JCVariableDecl result = this.toP(this.F.at(pos).VarDef(mods, name, type, init));
        this.attach(result, dc);
        return result;
    }

    JCTree.JCVariableDecl variableDeclaratorId(JCTree.JCModifiers mods, JCTree.JCExpression type) {
        int pos = this.S.pos();
        Name name = this.ident();
        if ((mods.flags & 0x400000000L) == 0L) {
            type = this.bracketsOpt(type);
        }
        return this.toP(this.F.at(pos).VarDef(mods, name, type, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCTree.JCCompilationUnit compilationUnit() {
        JCTree.JCCompilationUnit jCCompilationUnit;
        try {
            int pos = this.S.pos();
            JCTree.JCExpression pid = null;
            String dc = this.S.docComment();
            JCTree.JCModifiers mods = null;
            List<JCTree.JCAnnotation> packageAnnotations = List.nil();
            if (this.S.token() == Token.MONKEYS_AT) {
                mods = this.modifiersOpt();
            }
            if (this.S.token() == Token.PACKAGE) {
                if (mods != null) {
                    this.checkNoMods(mods.flags);
                    packageAnnotations = mods.annotations;
                    mods = null;
                }
                this.S.nextToken();
                pid = this.qualident();
                this.accept(Token.SEMI);
            }
            ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
            boolean checkForImports = true;
            while (this.S.token() != Token.EOF) {
                if (this.S.pos() <= this.errorEndPos) {
                    this.skip(checkForImports, false, false, false);
                    if (this.S.token() == Token.EOF) break;
                }
                if (checkForImports && mods == null && this.S.token() == Token.IMPORT) {
                    defs.append(this.importDeclaration());
                    continue;
                }
                JCTree def = this.typeDeclaration(mods);
                defs.append(def);
                if (def instanceof JCTree.JCClassDecl) {
                    checkForImports = false;
                }
                mods = null;
            }
            JCTree.JCCompilationUnit toplevel = this.F.at(pos).TopLevel(packageAnnotations, pid, defs.toList());
            this.attach(toplevel, dc);
            if (defs.elems.isEmpty()) {
                this.storeEnd(toplevel, this.S.prevEndPos());
            }
            if (this.keepDocComments) {
                toplevel.docComments = this.docComments;
            }
            jCCompilationUnit = toplevel;
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.anonScopes.clear();
            throw throwable;
        }
        this.anonScopes.clear();
        return jCCompilationUnit;
    }

    JCTree importDeclaration() {
        int pos = this.S.pos();
        this.S.nextToken();
        boolean importStatic = false;
        if (this.S.token() == Token.STATIC) {
            this.checkStaticImports();
            importStatic = true;
            this.S.nextToken();
        }
        JCTree.JCExpression pid = this.toP(this.F.at(this.S.pos()).Ident(this.ident()));
        do {
            int pos1 = this.S.pos();
            this.accept(Token.DOT);
            if (this.S.token() == Token.STAR) {
                pid = this.to(this.F.at(pos1).Select(pid, this.names.asterisk));
                this.S.nextToken();
                break;
            }
            pid = this.toP(this.F.at(pos1).Select(pid, this.ident()));
        } while (this.S.token() == Token.DOT);
        this.accept(Token.SEMI);
        return this.toP(this.F.at(pos).Import(pid, importStatic));
    }

    JCTree typeDeclaration(JCTree.JCModifiers mods) {
        int pos = this.S.pos();
        if (mods == null && this.S.token() == Token.SEMI) {
            this.S.nextToken();
            return this.toP(this.F.at(pos).Skip());
        }
        String dc = this.S.docComment();
        return this.classOrInterfaceOrEnumDeclaration(this.modifiersOpt(mods), dc);
    }

    JCTree.JCStatement classOrInterfaceOrEnumDeclaration(JCTree.JCModifiers mods, String dc) {
        List<JCTree> errs;
        if (this.S.token() == Token.CLASS) {
            return this.classDeclaration(mods, dc);
        }
        if (this.S.token() == Token.INTERFACE) {
            return this.interfaceDeclaration(mods, dc);
        }
        if (this.allowEnums) {
            List<JCTree> errs2;
            if (this.S.token() == Token.ENUM) {
                return this.enumDeclaration(mods, dc);
            }
            int pos = this.S.pos();
            if (this.S.token() == Token.IDENTIFIER) {
                errs2 = List.of(mods, this.toP(this.F.at(pos).Ident(this.ident())));
                this.setErrorEndPos(this.S.pos());
            } else {
                errs2 = List.of(mods);
            }
            return this.toP(this.F.Exec(this.syntaxError(pos, errs2, "expected3", this.keywords.token2string(Token.CLASS), this.keywords.token2string(Token.INTERFACE), this.keywords.token2string(Token.ENUM))));
        }
        if (this.S.token() == Token.ENUM) {
            this.log.error(this.S.pos(), "enums.not.supported.in.source", this.source.name);
            this.allowEnums = true;
            mods.flags |= 0x4000L;
            return this.enumDeclaration(mods, dc);
        }
        int pos = this.S.pos();
        if (this.S.token() == Token.IDENTIFIER) {
            errs = List.of(mods, this.toP(this.F.at(pos).Ident(this.ident())));
            this.setErrorEndPos(this.S.pos());
        } else {
            errs = List.of(mods);
        }
        return this.toP(this.F.Exec(this.syntaxError(pos, errs, "expected2", this.keywords.token2string(Token.CLASS), this.keywords.token2string(Token.INTERFACE))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree.JCClassDecl classDeclaration(JCTree.JCModifiers mods, String dc) {
        if (this.cancelService != null) {
            this.cancelService.abortIfCanceled();
        }
        int pos = this.S.pos();
        this.accept(Token.CLASS);
        Name name = this.ident();
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        JCTree.JCExpression extending = null;
        if (this.S.token() == Token.EXTENDS) {
            this.S.nextToken();
            extending = this.type();
        }
        List<JCTree.JCExpression> implementing = List.nil();
        if (this.S.token() == Token.IMPLEMENTS) {
            this.S.nextToken();
            implementing = this.typeList();
        }
        List<JCTree> defs = null;
        this.anonScopes.push(new AnonScope(name));
        try {
            defs = this.classOrInterfaceBody(name, false);
            Object var10_9 = null;
            this.anonScopes.pop();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.anonScopes.pop();
            throw throwable;
        }
        JCTree.JCClassDecl result = this.toP(this.F.at(pos).ClassDef(mods, name, typarams, extending, implementing, defs));
        if (!this.anonScopes.isEmpty() && this.anonScopes.peek().localClass) {
            result.index = this.anonScopes.peek().assignLocalNumber(name);
        }
        this.attach(result, dc);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree.JCClassDecl interfaceDeclaration(JCTree.JCModifiers mods, String dc) {
        if (this.cancelService != null) {
            this.cancelService.abortIfCanceled();
        }
        int pos = this.S.pos();
        this.accept(Token.INTERFACE);
        Name name = this.ident();
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        List<JCTree.JCExpression> extending = List.nil();
        if (this.S.token() == Token.EXTENDS) {
            this.S.nextToken();
            extending = this.typeList();
        }
        List<JCTree> defs = null;
        this.anonScopes.push(new AnonScope(name));
        try {
            defs = this.classOrInterfaceBody(name, true);
            Object var9_8 = null;
            this.anonScopes.pop();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.anonScopes.pop();
            throw throwable;
        }
        JCTree.JCClassDecl result = this.toP(this.F.at(pos).ClassDef(mods, name, typarams, null, extending, defs));
        if (!this.anonScopes.isEmpty() && this.anonScopes.peek().localClass) {
            result.index = this.anonScopes.peek().assignLocalNumber(name);
        }
        this.attach(result, dc);
        return result;
    }

    JCTree.JCClassDecl enumDeclaration(JCTree.JCModifiers mods, String dc) {
        if (this.cancelService != null) {
            this.cancelService.abortIfCanceled();
        }
        int pos = this.S.pos();
        this.accept(Token.ENUM);
        JCTree.JCModifiers newMods = this.F.at(mods.pos).Modifiers(mods.flags | 0x4000L, mods.annotations);
        this.storeEnd(newMods, this.getEndPos(mods));
        Name name = this.ident();
        return this.enumDeclaration(newMods, dc, pos, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree.JCClassDecl enumDeclaration(JCTree.JCModifiers mods, String dc, int pos, Name name) {
        List<JCTree.JCExpression> implementing = List.nil();
        if (this.S.token() == Token.IMPLEMENTS) {
            this.S.nextToken();
            implementing = this.typeList();
        }
        List<JCTree> defs = null;
        this.anonScopes.push(new AnonScope(name));
        try {
            defs = this.enumBody(name);
            Object var8_7 = null;
            this.anonScopes.pop();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.anonScopes.pop();
            throw throwable;
        }
        JCTree.JCClassDecl result = this.toP(this.F.at(pos).ClassDef(mods, name, List.<JCTree.JCTypeParameter>nil(), null, implementing, defs));
        if (!this.anonScopes.isEmpty() && this.anonScopes.peek().localClass) {
            result.index = this.anonScopes.peek().assignLocalNumber(name);
        }
        this.attach(result, dc);
        return result;
    }

    List<JCTree> enumBody(Name enumName) {
        this.accept(Token.LBRACE);
        if (this.S.pos() <= this.errorEndPos) {
            this.skip(false, true, false, false);
            if (this.S.token() == Token.LBRACE) {
                this.S.nextToken();
            }
        }
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        if (this.S.token() == Token.COMMA) {
            this.S.nextToken();
        } else if (this.S.token() != Token.RBRACE && this.S.token() != Token.SEMI) {
            defs.append(this.enumeratorDeclaration(enumName));
            while (this.S.token() == Token.COMMA) {
                this.S.nextToken();
                if (this.S.token() == Token.RBRACE || this.S.token() == Token.SEMI) break;
                defs.append(this.enumeratorDeclaration(enumName));
            }
            if (this.S.token() != Token.SEMI && this.S.token() != Token.RBRACE) {
                defs.append(this.syntaxError(this.S.pos(), "expected3", this.keywords.token2string(Token.COMMA), this.keywords.token2string(Token.RBRACE), this.keywords.token2string(Token.SEMI)));
                this.S.nextToken();
            }
        }
        if (this.S.token() == Token.SEMI) {
            this.S.nextToken();
            while (this.S.token() != Token.RBRACE && this.S.token() != Token.EOF) {
                defs.appendList(this.classOrInterfaceBodyDeclaration(enumName, false));
                if (this.S.pos() > this.errorEndPos) continue;
                this.skip(false, true, true, false);
            }
        }
        this.accept(Token.RBRACE);
        return defs.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree enumeratorDeclaration(Name enumName) {
        String dc = this.S.docComment();
        int flags = 16409;
        if (this.S.deprecatedFlag()) {
            flags |= 0x20000;
            this.S.resetDeprecatedFlag();
        }
        int pos = this.S.pos();
        List<JCTree.JCAnnotation> annotations = this.annotationsOpt();
        JCTree.JCModifiers mods = this.F.at(annotations.isEmpty() ? -1 : pos).Modifiers(flags, annotations);
        List<JCTree.JCExpression> typeArgs = this.typeArgumentsOpt();
        int identPos = this.S.pos();
        Name name = this.ident();
        int createPos = this.S.pos();
        List<Object> args = this.S.token() == Token.LPAREN ? this.arguments() : List.nil();
        JCTree.JCClassDecl body = null;
        if (this.S.token() == Token.LBRACE) {
            JCTree.JCModifiers mods1 = null;
            List<JCTree> defs = null;
            this.anonScopes.push(new AnonScope(this.names.empty));
            try {
                mods1 = this.F.at(-1).Modifiers(16392L);
                defs = this.classOrInterfaceBody(this.names.empty, false);
                Object var16_15 = null;
                this.anonScopes.pop();
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                this.anonScopes.pop();
                throw throwable;
            }
            body = this.toP(this.F.at(identPos).AnonymousClassDef(mods1, defs, this.anonScopes.peek().assignNumber()));
        }
        if (args.isEmpty() && body == null) {
            createPos = -1;
        }
        JCTree.JCIdent ident = this.F.at(-1).Ident(enumName);
        JCTree.JCNewClass create = this.F.at(createPos).NewClass(null, typeArgs, ident, args, body);
        if (createPos != -1) {
            this.storeEnd(create, this.S.prevEndPos());
        }
        ident = this.F.at(-1).Ident(enumName);
        JCTree.JCVariableDecl result = this.toP(this.F.at(pos).VarDef(mods, name, ident, create));
        this.attach(result, dc);
        return result;
    }

    List<JCTree.JCExpression> typeList() {
        ListBuffer<JCTree.JCExpression> ts = new ListBuffer<JCTree.JCExpression>();
        ts.append(this.type());
        while (this.S.token() == Token.COMMA) {
            this.S.nextToken();
            ts.append(this.type());
        }
        return ts.toList();
    }

    List<JCTree> classOrInterfaceBody(Name className, boolean isInterface) {
        this.accept(Token.LBRACE);
        if (this.S.pos() <= this.errorEndPos) {
            this.skip(false, true, false, false);
            if (this.S.token() == Token.LBRACE) {
                this.S.nextToken();
            }
        }
        ListBuffer<JCTree> defs = new ListBuffer<JCTree>();
        while (this.S.token() != Token.RBRACE && this.S.token() != Token.EOF) {
            defs.appendList(this.classOrInterfaceBodyDeclaration(className, isInterface));
            if (this.S.pos() > this.errorEndPos) continue;
            if (this.S.token() == Token.LBRACE && isInterface) {
                this.S.nextToken();
            }
            this.skip(false, true, true, false);
        }
        this.accept(Token.RBRACE);
        return defs.toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JCTree> classOrInterfaceBodyDeclaration(Name className, boolean isInterface) {
        JCTree.JCExpression type;
        boolean isVoid;
        if (this.S.token() == Token.SEMI) {
            JCTree.JCBlock block = this.F.at(this.S.pos()).Block(0L, List.<JCTree.JCStatement>nil());
            this.storeEnd(block, this.S.endPos());
            this.S.nextToken();
            return List.of(block);
        }
        String dc = this.S.docComment();
        int pos = this.S.pos();
        JCTree.JCModifiers mods = this.modifiersOpt();
        if (this.S.token() == Token.CLASS || this.S.token() == Token.INTERFACE || this.allowEnums && this.S.token() == Token.ENUM) {
            return List.of(this.classOrInterfaceOrEnumDeclaration(mods, dc));
        }
        if (this.S.token() == Token.LBRACE && !isInterface && (mods.flags & 0xFFFL & 0xFFFFFFFFFFFFFFF7L) == 0L && mods.annotations.isEmpty()) {
            AnonScope as = this.anonScopes.peek();
            as.localClass = true;
            try {
                List<JCTree> list = List.of(this.block(pos, mods.flags));
                Object var9_11 = null;
                as.localClass = false;
                return list;
            }
            catch (Throwable throwable) {
                Object var9_12 = null;
                as.localClass = false;
                throw throwable;
            }
        }
        pos = this.S.pos();
        List<JCTree.JCTypeParameter> typarams = this.typeParametersOpt();
        if (typarams.length() > 0 && mods.pos == -1) {
            mods.pos = pos;
        }
        Token token = this.S.token();
        Name name = this.S.name();
        pos = this.S.pos();
        boolean bl = isVoid = token == Token.VOID;
        if (isVoid) {
            type = this.to(this.F.at(pos).TypeIdent(9));
            this.S.nextToken();
        } else {
            type = this.type();
        }
        if (this.S.token() == Token.LPAREN && !isInterface && type.getTag() == 35) {
            if (isInterface || name != className) {
                this.log.error(pos, "invalid.meth.decl.ret.type.req", new Object[0]);
                return List.of(this.methodDeclaratorRest(pos, mods, null, name, typarams, isInterface, true, dc));
            }
            return List.of(this.methodDeclaratorRest(pos, mods, null, this.names.init, typarams, isInterface, true, dc));
        }
        pos = this.S.pos();
        name = this.ident();
        if (this.S.token() == Token.LPAREN) {
            return List.of(this.methodDeclaratorRest(pos, mods, type, name, typarams, isInterface, isVoid, dc));
        }
        if (token == Token.ENUM && typarams.isEmpty() && (this.S.token() == Token.LBRACE || this.S.token() == Token.IMPLEMENTS)) {
            this.log.error(pos, "enums.not.supported.in.source", this.source.name);
            this.allowEnums = true;
            JCTree.JCModifiers newMods = this.F.at(mods.pos).Modifiers(mods.flags | 0x4000L, mods.annotations);
            this.storeEnd(newMods, this.getEndPos(mods));
            return List.of(this.enumDeclaration(newMods, dc, pos, name));
        }
        if (!isVoid && typarams.isEmpty()) {
            List<JCTree> defs = this.variableDeclaratorsRest(pos, mods, type, name, isInterface, dc, new ListBuffer()).toList();
            this.accept(Token.SEMI);
            this.storeEnd((JCTree)defs.last(), this.S.prevEndPos());
            return defs;
        }
        pos = this.S.pos();
        List<JCTree> err = isVoid ? List.of(this.toP(this.F.at(pos).MethodDef(mods, name, type, typarams, List.<JCTree.JCVariableDecl>nil(), List.<JCTree.JCExpression>nil(), null, null))) : List.nil();
        return List.of(this.syntaxError(this.S.pos(), err, "expected", this.keywords.token2string(Token.LPAREN)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree methodDeclaratorRest(int pos, JCTree.JCModifiers mods, JCTree.JCExpression type, Name name, List<JCTree.JCTypeParameter> typarams, boolean isInterface, boolean isVoid, String dc) {
        JCTree.JCExpression defaultValue;
        AnonScope as;
        if (this.cancelService != null) {
            this.cancelService.abortIfCanceled();
        }
        List<JCTree.JCVariableDecl> params = this.formalParameters();
        if (!isVoid) {
            type = this.bracketsOpt(type);
        }
        List<JCTree.JCExpression> thrown = List.nil();
        if (this.S.token() == Token.THROWS) {
            this.S.nextToken();
            thrown = this.qualidentList();
        }
        JCTree.JCBlock body = null;
        if (this.S.token() == Token.LBRACE) {
            as = this.anonScopes.peek();
            as.localClass = true;
            try {
                body = this.block();
                Object var15_13 = null;
                as.localClass = false;
            }
            catch (Throwable throwable) {
                Object var15_14 = null;
                as.localClass = false;
                throw throwable;
            }
            defaultValue = null;
        } else {
            if (this.S.token() == Token.DEFAULT) {
                this.accept(Token.DEFAULT);
                defaultValue = this.annotationValue();
            } else {
                defaultValue = null;
            }
            this.accept(Token.SEMI);
            if (this.S.pos() <= this.errorEndPos) {
                this.skip(false, true, false, false);
                if (this.S.token() == Token.LBRACE) {
                    as = this.anonScopes.peek();
                    as.localClass = true;
                    try {
                        body = this.block();
                        Object var17_17 = null;
                        as.localClass = false;
                    }
                    catch (Throwable throwable) {
                        Object var17_18 = null;
                        as.localClass = false;
                        throw throwable;
                    }
                }
            }
        }
        JCTree.JCMethodDecl result = this.toP(this.F.at(pos).MethodDef(mods, name, type, typarams, params, thrown, body, defaultValue));
        this.attach(result, dc);
        return result;
    }

    List<JCTree.JCExpression> qualidentList() {
        ListBuffer<JCTree.JCExpression> ts = new ListBuffer<JCTree.JCExpression>();
        ts.append(this.qualident());
        while (this.S.token() == Token.COMMA) {
            this.S.nextToken();
            ts.append(this.qualident());
        }
        return ts.toList();
    }

    List<JCTree.JCTypeParameter> typeParametersOpt() {
        if (this.S.token() == Token.LT) {
            this.checkGenerics();
            ListBuffer<JCTree.JCTypeParameter> typarams = new ListBuffer<JCTree.JCTypeParameter>();
            this.S.nextToken();
            typarams.append(this.typeParameter());
            while (this.S.token() == Token.COMMA) {
                this.S.nextToken();
                typarams.append(this.typeParameter());
            }
            this.accept(Token.GT);
            return typarams.toList();
        }
        return List.nil();
    }

    JCTree.JCTypeParameter typeParameter() {
        int pos = this.S.pos();
        Name name = this.ident();
        ListBuffer<JCTree.JCExpression> bounds = new ListBuffer<JCTree.JCExpression>();
        if (this.S.token() == Token.EXTENDS) {
            this.S.nextToken();
            bounds.append(this.type());
            while (this.S.token() == Token.AMP) {
                this.S.nextToken();
                bounds.append(this.type());
            }
        }
        return this.toP(this.F.at(pos).TypeParameter(name, bounds.toList()));
    }

    List<JCTree.JCVariableDecl> formalParameters() {
        ListBuffer<JCTree.JCVariableDecl> params = new ListBuffer<JCTree.JCVariableDecl>();
        JCTree.JCVariableDecl lastParam = null;
        this.accept(Token.LPAREN);
        if (this.S.token() != Token.RPAREN) {
            lastParam = this.formalParameter();
            params.append(lastParam);
            while ((lastParam.mods.flags & 0x400000000L) == 0L && this.S.token() == Token.COMMA) {
                this.S.nextToken();
                lastParam = this.formalParameter();
                params.append(lastParam);
            }
        }
        this.accept(Token.RPAREN);
        return params.toList();
    }

    JCTree.JCModifiers optFinal(long flags) {
        JCTree.JCModifiers mods = this.modifiersOpt();
        this.checkNoMods(mods.flags & 0xFFFFFFFFFFFDFFEFL);
        mods.flags |= flags;
        return mods;
    }

    JCTree.JCVariableDecl formalParameter() {
        JCTree.JCModifiers mods = this.optFinal(0x200000000L);
        JCTree.JCExpression type = this.type();
        if (this.S.token() == Token.ELLIPSIS) {
            this.checkVarargs();
            mods.flags |= 0x400000000L;
            type = this.to(this.F.at(this.S.pos()).TypeArray(type));
            this.S.nextToken();
        }
        return this.variableDeclaratorId(mods, type);
    }

    protected JCTree.JCExpression checkExprStat(JCTree.JCExpression t) {
        switch (t.getTag()) {
            case 26: 
            case 27: 
            case 30: 
            case 45: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 74: 
            case 75: 
            case 76: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: {
                return t;
            }
        }
        this.log.error(t.pos, "not.stmt", new Object[0]);
        return this.F.at(t.pos).Erroneous(List.of(t));
    }

    static int prec(Token token) {
        int oc = Parser.optag(token);
        return oc >= 0 ? TreeInfo.opPrec(oc) : -1;
    }

    static int optag(Token token) {
        switch (token) {
            case BARBAR: {
                return 55;
            }
            case AMPAMP: {
                return 56;
            }
            case BAR: {
                return 57;
            }
            case BAREQ: {
                return 74;
            }
            case CARET: {
                return 58;
            }
            case CARETEQ: {
                return 75;
            }
            case AMP: {
                return 59;
            }
            case AMPEQ: {
                return 76;
            }
            case EQEQ: {
                return 60;
            }
            case BANGEQ: {
                return 61;
            }
            case LT: {
                return 62;
            }
            case GT: {
                return 63;
            }
            case LTEQ: {
                return 64;
            }
            case GTEQ: {
                return 65;
            }
            case LTLT: {
                return 66;
            }
            case LTLTEQ: {
                return 83;
            }
            case GTGT: {
                return 67;
            }
            case GTGTEQ: {
                return 84;
            }
            case GTGTGT: {
                return 68;
            }
            case GTGTGTEQ: {
                return 85;
            }
            case PLUS: {
                return 69;
            }
            case PLUSEQ: {
                return 86;
            }
            case SUB: {
                return 70;
            }
            case SUBEQ: {
                return 87;
            }
            case STAR: {
                return 71;
            }
            case STAREQ: {
                return 88;
            }
            case SLASH: {
                return 72;
            }
            case SLASHEQ: {
                return 89;
            }
            case PERCENT: {
                return 73;
            }
            case PERCENTEQ: {
                return 90;
            }
            case INSTANCEOF: {
                return 32;
            }
        }
        return -1;
    }

    static int unoptag(Token token) {
        switch (token) {
            case PLUS: {
                return 46;
            }
            case SUB: {
                return 47;
            }
            case BANG: {
                return 48;
            }
            case TILDE: {
                return 49;
            }
            case PLUSPLUS: {
                return 50;
            }
            case SUBSUB: {
                return 51;
            }
        }
        return -1;
    }

    static int typetag(Token token) {
        switch (token) {
            case BYTE: {
                return 1;
            }
            case CHAR: {
                return 2;
            }
            case SHORT: {
                return 3;
            }
            case INT: {
                return 4;
            }
            case LONG: {
                return 5;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case BOOLEAN: {
                return 8;
            }
        }
        return -1;
    }

    void checkGenerics() {
        if (!this.allowGenerics) {
            this.log.error(this.S.pos(), "generics.not.supported.in.source", this.source.name);
            this.allowGenerics = true;
        }
    }

    void checkVarargs() {
        if (!this.allowVarargs) {
            this.log.error(this.S.pos(), "varargs.not.supported.in.source", this.source.name);
            this.allowVarargs = true;
        }
    }

    void checkForeach() {
        if (!this.allowForeach) {
            this.log.error(this.S.pos(), "foreach.not.supported.in.source", this.source.name);
            this.allowForeach = true;
        }
    }

    void checkStaticImports() {
        if (!this.allowStaticImport) {
            this.log.error(this.S.pos(), "static.import.not.supported.in.source", this.source.name);
            this.allowStaticImport = true;
        }
    }

    void checkAnnotations() {
        if (!this.allowAnnotations) {
            this.log.error(this.S.pos(), "annotations.not.supported.in.source", this.source.name);
            this.allowAnnotations = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory {
        protected static final Context.Key<Factory> parserFactoryKey = new Context.Key();
        final TreeMaker F;
        final Log log;
        final Keywords keywords;
        final Source source;
        final Name.Table names;
        final Options options;
        private final CancelService cancelSevice;

        public static Factory instance(Context context) {
            Factory instance = context.get(parserFactoryKey);
            if (instance == null) {
                instance = new Factory(context);
            }
            return instance;
        }

        protected Factory(Context context) {
            context.put(parserFactoryKey, this);
            this.F = TreeMaker.instance(context);
            this.log = Log.instance(context);
            this.names = Name.Table.instance(context);
            this.keywords = Keywords.instance(context);
            this.source = Source.instance(context);
            this.options = Options.instance(context);
            this.cancelSevice = CancelService.instance(context);
        }

        public Parser newParser(Lexer S, boolean keepDocComments, boolean genEndPos) {
            return this.newParser(S, keepDocComments, genEndPos, false);
        }

        public Parser newParser(Lexer S, boolean keepDocComments, int firstAnnonClassIndex, Map<JCTree, Integer> endPos) {
            Parser p = endPos == null ? new Parser(this, S, keepDocComments, this.cancelSevice) : new EndPosParser(this, S, keepDocComments, this.cancelSevice, endPos);
            p.anonScopes.push(new AnonScope(this.names.empty, firstAnnonClassIndex));
            return p;
        }

        public Parser newParser(Lexer S, boolean keepDocComments, boolean genEndPos, boolean partial) {
            Parser p = !genEndPos ? new Parser(this, S, keepDocComments, this.cancelSevice) : new EndPosParser(this, S, keepDocComments, this.cancelSevice);
            if (partial) {
                p.anonScopes.push(new AnonScope(this.names.empty, -1));
            }
            return p;
        }
    }

    private static class AnonScope {
        public boolean localClass;
        private final Name parentDecl;
        private int currentNumber;
        private Map<Name, Integer> localClasses;

        public AnonScope(Name name) {
            this(name, 1);
        }

        public AnonScope(Name name, int startNumber) {
            assert (name != null);
            this.parentDecl = name;
            this.currentNumber = startNumber;
        }

        public int assignNumber() {
            int ret = this.currentNumber;
            if (this.currentNumber != -1) {
                ++this.currentNumber;
            }
            return ret;
        }

        public int assignLocalNumber(Name name) {
            Integer num;
            if (this.localClasses == null) {
                this.localClasses = new HashMap<Name, Integer>();
            }
            num = (num = this.localClasses.get(name)) == null ? Integer.valueOf(1) : Integer.valueOf(num + 1);
            this.localClasses.put(name, num);
            return num;
        }

        public String toString() {
            return String.format("%s : %d", this.parentDecl.toString(), this.currentNumber);
        }
    }
}

