/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.ErrorManager;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Lookup
implements ContextProvider {
    public static final String NOTIFY_LOAD_FIRST = "load first";
    public static final String NOTIFY_LOAD_LAST = "load last";
    public static final String NOTIFY_UNLOAD_FIRST = "unload first";
    public static final String NOTIFY_UNLOAD_LAST = "unload last";
    private static boolean verbose = System.getProperty("netbeans.debugger.registration") != null;

    Lookup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lookupFirst(String string, Class<T> clazz) {
        List<T> list;
        List<T> list2 = list = this.lookup(string, clazz);
        synchronized (list2) {
            if (list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }
    }

    @Override
    public abstract <T> List<? extends T> lookup(String var1, Class<T> var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LookupList<T>
    extends ArrayList<T> {
        protected Set<String> hiddenClassNames;
        private LinkedHashMap<T, String> instanceClassNames = new LinkedHashMap();

        public LookupList(Set<String> set) {
            this.hiddenClassNames = set;
        }

        void add(T t, String string) {
            super.add(t);
            this.instanceClassNames.put(t, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends T> collection) {
            if (collection instanceof LookupList) {
                LookupList lookupList;
                LookupList lookupList2 = lookupList = (LookupList)collection;
                synchronized (lookupList2) {
                    LookupList lookupList3 = this;
                    synchronized (lookupList3) {
                        String string;
                        Set<String> set = lookupList.hiddenClassNames;
                        if (set != null) {
                            Iterator<String> iterator = set.iterator();
                            block6: while (iterator.hasNext()) {
                                String string2 = iterator.next();
                                if (!this.instanceClassNames.containsValue(string2)) continue;
                                Object object = this.instanceClassNames.keySet().iterator();
                                while (iterator.hasNext()) {
                                    string = object.next();
                                    if (!string2.equals(this.instanceClassNames.get(string))) continue;
                                    this.remove(string);
                                    this.instanceClassNames.remove(string);
                                    continue block6;
                                }
                            }
                            if (this.hiddenClassNames != null) {
                                this.hiddenClassNames.addAll(set);
                            } else {
                                this.hiddenClassNames = set;
                            }
                        }
                        this.ensureCapacity(this.size() + lookupList.size());
                        boolean bl = false;
                        for (Object object : lookupList) {
                            string = lookupList.instanceClassNames.get(object);
                            if (this.hiddenClassNames != null && this.hiddenClassNames.contains(string)) continue;
                            this.add(object, string);
                            bl = true;
                        }
                        return bl;
                    }
                }
            }
            return super.addAll(collection);
        }

        @Override
        public void clear() {
            super.clear();
            this.instanceClassNames.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MetaInf
    extends Lookup {
        private static final String HIDDEN = "-hidden";
        private String rootFolder;
        private Map<String, List<String>> registrationCache = new HashMap<String, List<String>>();
        private HashMap<String, Object> instanceCache = new HashMap();
        private Lookup context;
        private Lookup.Result<ModuleInfo> moduleLookupResult;
        private ModuleChangeListener modulesChangeListener;
        private Map<ClassLoader, ModuleChangeListener> moduleChangeListeners = new HashMap<ClassLoader, ModuleChangeListener>();
        private Map<ModuleInfo, ModuleChangeListener> disabledModuleChangeListeners = new HashMap<ModuleInfo, ModuleChangeListener>();
        private Set<MetaInfLookupList> lookupLists = new WeakSet();

        MetaInf(String string) {
            this.rootFolder = string;
            this.moduleLookupResult = org.openide.util.Lookup.getDefault().lookupResult(ModuleInfo.class);
            this.modulesChangeListener = new ModuleChangeListener(null);
            this.moduleLookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.modulesChangeListener, this.moduleLookupResult));
        }

        void setContext(Lookup lookup) {
            this.context = lookup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> List<? extends T> lookup(String string, Class<T> clazz) {
            MetaInfLookupList<T> metaInfLookupList = new MetaInfLookupList<T>(string, clazz);
            Set<MetaInfLookupList> set = this.lookupLists;
            synchronized (set) {
                this.lookupLists.add(metaInfLookupList);
            }
            return metaInfLookupList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> list(String string, Class<?> clazz) {
            String string2 = clazz.getName();
            String string3 = "META-INF/debugger/" + (this.rootFolder == null ? "" : this.rootFolder + "/") + (string == null ? "" : string + "/") + string2;
            Map<String, List<String>> map = this.registrationCache;
            synchronized (map) {
                List<String> list = this.registrationCache.get(string3);
                if (list == null) {
                    list = this.loadMetaInf(string3);
                    this.registrationCache.put(string3, list);
                }
                return list;
            }
        }

        private static Set<String> getHiddenClassNames(List list) {
            HashSet<String> hashSet = null;
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)list.get(i);
                if (!string.endsWith(HIDDEN)) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                hashSet.add(string.substring(0, string.length() - HIDDEN.length()));
            }
            return hashSet;
        }

        private List<String> loadMetaInf(String string) {
            ArrayList<String> arrayList = new ArrayList<String>();
            try {
                ClassLoader classLoader = (ClassLoader)org.openide.util.Lookup.getDefault().lookup(ClassLoader.class);
                String string2 = "\nR lookup " + string;
                Enumeration<URL> enumeration = classLoader.getResources(string);
                HashSet<URL> hashSet = new HashSet<URL>();
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    if (hashSet.contains(uRL)) continue;
                    hashSet.add(uRL);
                    InputStream inputStream = uRL.openStream();
                    if (inputStream == null) continue;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    String string3 = bufferedReader.readLine();
                    while (string3 != null) {
                        if (!string3.startsWith("#") && string3.length() != 0) {
                            if (verbose) {
                                string2 = string2 + "\nR  service " + string3 + " found";
                            }
                            arrayList.add(string3);
                        }
                        string3 = bufferedReader.readLine();
                    }
                }
                if (verbose) {
                    System.out.println(string2);
                }
                return arrayList;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new InternalError("Can not read from Meta-inf!");
            }
        }

        /*
         * WARNING - void declaration
         */
        private Object createInstance(String string) {
            try {
                ClassLoader classLoader = (ClassLoader)org.openide.util.Lookup.getDefault().lookup(ClassLoader.class);
                String string2 = null;
                if (string.endsWith("()")) {
                    int n = string.lastIndexOf(46);
                    if (n < 0) {
                        ErrorManager.getDefault().log("Bad service - dot before method name is missing: '" + string + "'.");
                        return null;
                    }
                    string2 = string.substring(n + 1, string.length() - 2).trim();
                    string = string.substring(0, n);
                }
                Class<?> clazz = classLoader.loadClass(string);
                Object object = null;
                if (string2 != null) {
                    void var6_16;
                    void var6_14;
                    Object object2 = null;
                    if (this.context != null) {
                        try {
                            Method method = clazz.getDeclaredMethod(string2, Lookup.class);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (var6_14 == null) {
                        try {
                            Method method = clazz.getDeclaredMethod(string2, new Class[0]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (var6_16 != null) {
                        Object[] objectArray;
                        if (var6_16.getParameterTypes().length == 0) {
                            objectArray = new Object[]{};
                        } else {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = this.context;
                        }
                        object = var6_16.invoke(null, objectArray);
                    }
                }
                if (object == null && this.context != null) {
                    for (Constructor<?> constructor : clazz.getConstructors()) {
                        if (constructor.getParameterTypes().length != 1) continue;
                        try {
                            object = constructor.newInstance(this.context);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            if (!verbose) continue;
                            System.out.println("\nservice: " + string);
                            illegalAccessException.printStackTrace();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (!verbose) continue;
                            System.out.println("\nservice: " + string);
                            illegalArgumentException.printStackTrace();
                        }
                    }
                }
                if (object == null) {
                    object = clazz.newInstance();
                }
                if (verbose) {
                    System.out.println("\nR  instance " + object + " created");
                }
                return object;
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)classNotFoundException, "The service " + string + " is not found."));
            }
            catch (InstantiationException instantiationException) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)instantiationException, "The service " + string + " can not be instantiated."));
            }
            catch (IllegalAccessException illegalAccessException) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)illegalAccessException, "The service " + string + " can not be accessed."));
            }
            catch (InvocationTargetException invocationTargetException) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)invocationTargetException, "The service " + string + " can not be created."));
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                ErrorManager.getDefault().notify(ErrorManager.getDefault().annotate((Throwable)exceptionInInitializerError, "The service " + string + " can not be initialized."));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void listenOn(ClassLoader classLoader) {
            Map<ClassLoader, ModuleChangeListener> map = this.moduleChangeListeners;
            synchronized (map) {
                if (!this.moduleChangeListeners.containsKey(classLoader)) {
                    for (ModuleInfo moduleInfo : this.moduleLookupResult.allInstances()) {
                        if (!moduleInfo.isEnabled() || moduleInfo.getClassLoader() != classLoader) continue;
                        ModuleChangeListener moduleChangeListener = new ModuleChangeListener(classLoader);
                        moduleInfo.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)moduleChangeListener, (Object)moduleInfo));
                        this.moduleChangeListeners.put(classLoader, moduleChangeListener);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void listenOnDisabledModules() {
            Map<ClassLoader, ModuleChangeListener> map = this.moduleChangeListeners;
            synchronized (map) {
                for (ModuleInfo moduleInfo : this.moduleLookupResult.allInstances()) {
                    if (moduleInfo.isEnabled() || this.disabledModuleChangeListeners.containsKey(moduleInfo)) continue;
                    ModuleChangeListener moduleChangeListener = new ModuleChangeListener(null);
                    moduleInfo.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)moduleChangeListener, (Object)moduleInfo));
                    this.disabledModuleChangeListeners.put(moduleInfo, moduleChangeListener);
                }
            }
        }

        public static Comparator<MetaInfLookupList> getMetaInfLookupListComparator(final boolean bl) {
            return new Comparator<MetaInfLookupList>(){

                @Override
                public int compare(MetaInfLookupList metaInfLookupList, MetaInfLookupList metaInfLookupList2) {
                    if (bl) {
                        return metaInfLookupList.notifyLoadOrder - metaInfLookupList2.notifyLoadOrder;
                    }
                    return metaInfLookupList.notifyUnloadOrder - metaInfLookupList2.notifyUnloadOrder;
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class MetaInfLookupList<T>
        extends LookupList<T>
        implements Customizer {
            private String folder;
            private final Class<T> service;
            private List<PropertyChangeListener> propertyChangeListeners;
            public int notifyLoadOrder;
            public int notifyUnloadOrder;

            public MetaInfLookupList(String string, Class<T> clazz) {
                this(metaInf.list(string, clazz), clazz);
                this.folder = string;
            }

            private MetaInfLookupList(List<String> list, Class<T> clazz) {
                this(list, MetaInf.getHiddenClassNames(list), clazz);
            }

            private MetaInfLookupList(List<String> list, Set<String> set, Class<T> clazz) {
                super(set);
                this.notifyLoadOrder = 0;
                this.notifyUnloadOrder = 0;
                assert (clazz != null);
                this.service = clazz;
                this.fillInstances(list, set);
                MetaInf.this.listenOnDisabledModules();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void fillInstances(List<String> list, Set<String> set) {
                for (String string : list) {
                    if (string.endsWith(MetaInf.HIDDEN) || set != null && set.contains(string)) continue;
                    Object object = null;
                    HashMap hashMap = MetaInf.this.instanceCache;
                    synchronized (hashMap) {
                        object = MetaInf.this.instanceCache.get(string);
                        if (object == null) {
                            object = MetaInf.this.createInstance(string);
                            MetaInf.this.instanceCache.put(string, object);
                        }
                    }
                    if (object == null) continue;
                    try {
                        this.add(this.service.cast(object), string);
                    }
                    catch (ClassCastException classCastException) {
                        Logger.getLogger(Lookup.class.getName()).log(Level.WARNING, null, classCastException);
                    }
                    MetaInf.this.listenOn(object.getClass().getClassLoader());
                }
            }

            private synchronized void refreshContent() {
                Set set;
                this.clear();
                List list = MetaInf.this.list(this.folder, this.service);
                this.hiddenClassNames = set = MetaInf.getHiddenClassNames(list);
                this.fillInstances(list, set);
                this.firePropertyChange();
            }

            @Override
            public void setObject(Object object) {
                if (Lookup.NOTIFY_LOAD_FIRST == object) {
                    this.notifyLoadOrder = -1;
                } else if (Lookup.NOTIFY_LOAD_LAST == object) {
                    this.notifyLoadOrder = 1;
                } else if (Lookup.NOTIFY_UNLOAD_FIRST == object) {
                    this.notifyUnloadOrder = -1;
                } else if (Lookup.NOTIFY_UNLOAD_LAST == object) {
                    this.notifyUnloadOrder = 1;
                } else {
                    throw new IllegalArgumentException(object.toString());
                }
            }

            @Override
            public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                if (this.propertyChangeListeners == null) {
                    this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
                }
                this.propertyChangeListeners.add(propertyChangeListener);
            }

            @Override
            public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.propertyChangeListeners.remove(propertyChangeListener);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void firePropertyChange() {
                ArrayList<PropertyChangeListener> arrayList;
                Serializable serializable = this;
                synchronized (serializable) {
                    if (this.propertyChangeListeners == null) {
                        return;
                    }
                    arrayList = new ArrayList<PropertyChangeListener>(this.propertyChangeListeners);
                }
                serializable = new PropertyChangeEvent(this, "content", null, null);
                for (PropertyChangeListener propertyChangeListener : arrayList) {
                    propertyChangeListener.propertyChange((PropertyChangeEvent)serializable);
                }
            }
        }

        private final class ModuleChangeListener
        implements PropertyChangeListener,
        LookupListener {
            private ClassLoader cl;
            private RequestProcessor.Task refreshListEnabled;
            private RequestProcessor.Task refreshListDisabled;
            private RequestProcessor rp;

            public ModuleChangeListener(ClassLoader classLoader) {
                this.cl = classLoader;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Object object;
                if (!"enabled".equals(propertyChangeEvent.getPropertyName())) {
                    return;
                }
                this.clearCaches(this.cl);
                ModuleInfo moduleInfo = (ModuleInfo)propertyChangeEvent.getSource();
                if (!moduleInfo.isEnabled() && this.cl != null) {
                    object = MetaInf.this.moduleChangeListeners;
                    synchronized (object) {
                        MetaInf.this.moduleChangeListeners.remove(this.cl);
                        MetaInf.this.disabledModuleChangeListeners.put(moduleInfo, this);
                    }
                    this.cl = null;
                } else if (moduleInfo.isEnabled()) {
                    this.cl = moduleInfo.getClassLoader();
                    object = MetaInf.this.moduleChangeListeners;
                    synchronized (object) {
                        MetaInf.this.disabledModuleChangeListeners.remove(moduleInfo);
                        MetaInf.this.moduleChangeListeners.put(this.cl, this);
                    }
                }
                object = this;
                synchronized (object) {
                    if (moduleInfo.isEnabled()) {
                        if (this.refreshListEnabled == null) {
                            if (this.rp == null) {
                                this.rp = new RequestProcessor("Debugger Services Refresh", 1);
                            }
                            this.refreshListEnabled = this.rp.create(new Runnable(){

                                public void run() {
                                    ModuleChangeListener.this.refreshLists(true);
                                }
                            });
                        }
                        this.refreshListEnabled.schedule(100);
                    } else {
                        if (this.refreshListDisabled == null) {
                            if (this.rp == null) {
                                this.rp = new RequestProcessor("Debugger Services Refresh", 1);
                            }
                            this.refreshListDisabled = this.rp.create(new Runnable(){

                                public void run() {
                                    ModuleChangeListener.this.refreshLists(false);
                                }
                            });
                        }
                        this.refreshListDisabled.schedule(100);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent lookupEvent) {
                this.clearCaches(null);
                Map map = MetaInf.this.moduleChangeListeners;
                synchronized (map) {
                    MetaInf.this.moduleChangeListeners.clear();
                    MetaInf.this.disabledModuleChangeListeners.clear();
                }
                this.refreshLists(true);
                MetaInf.this.listenOnDisabledModules();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void clearCaches(ClassLoader classLoader) {
                Map map = MetaInf.this.registrationCache;
                synchronized (map) {
                    MetaInf.this.registrationCache.clear();
                }
                if (classLoader != null) {
                    map = MetaInf.this.instanceCache;
                    synchronized (map) {
                        ArrayList arrayList = new ArrayList(MetaInf.this.instanceCache.size());
                        arrayList.addAll(MetaInf.this.instanceCache.keySet());
                        for (String string : arrayList) {
                            Object v = MetaInf.this.instanceCache.get(string);
                            if (v.getClass().getClassLoader() != classLoader) continue;
                            MetaInf.this.instanceCache.remove(string);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void refreshLists(boolean bl) {
                ArrayList arrayList;
                Set set = MetaInf.this.lookupLists;
                synchronized (set) {
                    arrayList = new ArrayList(MetaInf.this.lookupLists.size());
                    arrayList.addAll(MetaInf.this.lookupLists);
                }
                Collections.sort(arrayList, MetaInf.getMetaInfLookupListComparator(bl));
                for (MetaInfLookupList metaInfLookupList : arrayList) {
                    metaInfLookupList.refreshContent();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Compound
    extends Lookup {
        private ContextProvider l1;
        private ContextProvider l2;

        Compound(ContextProvider contextProvider, ContextProvider contextProvider2) {
            this.l1 = contextProvider;
            this.l2 = contextProvider2;
            this.setContext(this);
        }

        @Override
        public <T> List<? extends T> lookup(String string, Class<T> clazz) {
            return new CompoundLookupList<T>(string, clazz);
        }

        void setContext(Lookup lookup) {
            if (this.l1 instanceof Compound) {
                ((Compound)this.l1).setContext(lookup);
            }
            if (this.l1 instanceof MetaInf) {
                ((MetaInf)this.l1).setContext(lookup);
            }
            if (this.l2 instanceof Compound) {
                ((Compound)this.l2).setContext(lookup);
            }
            if (this.l2 instanceof MetaInf) {
                ((MetaInf)this.l2).setContext(lookup);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class CompoundLookupList<T>
        extends LookupList<T>
        implements Customizer,
        PropertyChangeListener {
            private String folder;
            private Class<T> service;
            private List<PropertyChangeListener> propertyChangeListeners;
            private Customizer sublist1;
            private Customizer sublist2;

            public CompoundLookupList(String string, Class<T> clazz) {
                super((Set<String>)null);
                this.folder = string;
                this.service = clazz;
                this.setUp();
            }

            private synchronized void setUp() {
                this.clear();
                List<T> list = Compound.this.l1.lookup(this.folder, this.service);
                List<T> list2 = Compound.this.l2.lookup(this.folder, this.service);
                this.addAll(list);
                this.addAll(list2);
                this.sublist1 = list instanceof Customizer ? (Customizer)((Object)list) : null;
                this.sublist2 = list2 instanceof Customizer ? (Customizer)((Object)list2) : null;
            }

            @Override
            public synchronized void setObject(Object object) {
                if (this.sublist1 != null) {
                    this.sublist1.setObject(object);
                }
                if (this.sublist2 != null) {
                    this.sublist2.setObject(object);
                }
            }

            @Override
            public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                if (this.propertyChangeListeners == null) {
                    this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
                    if (this.sublist1 != null) {
                        this.sublist1.addPropertyChangeListener(this);
                    }
                    if (this.sublist2 != null) {
                        this.sublist2.addPropertyChangeListener(this);
                    }
                }
                this.propertyChangeListeners.add(propertyChangeListener);
            }

            @Override
            public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.propertyChangeListeners.remove(propertyChangeListener);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ArrayList<PropertyChangeListener> arrayList;
                this.setUp();
                Serializable serializable = this;
                synchronized (serializable) {
                    if (this.propertyChangeListeners == null) {
                        return;
                    }
                    arrayList = new ArrayList<PropertyChangeListener>(this.propertyChangeListeners);
                }
                serializable = new PropertyChangeEvent(this, "content", null, null);
                for (PropertyChangeListener propertyChangeListener : arrayList) {
                    propertyChangeListener.propertyChange((PropertyChangeEvent)serializable);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Instance
    extends Lookup {
        private Object[] services;

        Instance(Object[] objectArray) {
            this.services = objectArray;
        }

        @Override
        public <T> List<? extends T> lookup(String string, Class<T> clazz) {
            ArrayList<T> arrayList = new ArrayList<T>();
            for (Object object : this.services) {
                if (!clazz.isInstance(object)) continue;
                arrayList.add(clazz.cast(object));
                if (!verbose) continue;
                System.out.println("\nR  instance " + object + " found");
            }
            return arrayList;
        }
    }
}

