/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.inspector.InspectorFolderPath;
import org.netbeans.modules.vmd.api.inspector.InspectorFolderPresenter;
import org.netbeans.modules.vmd.api.inspector.InspectorOrderingController;
import org.netbeans.modules.vmd.api.inspector.InspectorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.inspector.FolderRegistry;
import org.netbeans.modules.vmd.inspector.InspectorFolderWrapper;
import org.netbeans.modules.vmd.inspector.InspectorUI;
import org.openide.nodes.Node;
import org.openide.util.WeakSet;
import org.openide.util.datatransfer.NewType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InspectorWrapperTree
implements FolderRegistry.Listener {
    private Collection<InspectorFolder> globalFolders;
    private FolderRegistry registry;
    private DesignDocument document;
    private InspectorFolderWrapper rootFolderWrapper;
    private WeakSet<DesignComponent> componentsToDelete;
    private WeakSet<DesignComponent> componentsToAdd;
    private WeakSet<DesignComponent> componentsToUndo;
    private WeakSet<InspectorFolderWrapper> foldersToUpdate;
    private WeakSet<DesignComponent> deletedComponentsCash;
    private WeakSet<InspectorFolderWrapper> foldersToExtend = new WeakSet();
    private boolean lock = true;
    private InspectorUI ui;

    InspectorWrapperTree(DesignDocument designDocument, InspectorUI inspectorUI) {
        this.foldersToUpdate = new WeakSet();
        this.componentsToAdd = new WeakSet();
        this.componentsToDelete = new WeakSet();
        this.componentsToUndo = new WeakSet();
        this.document = designDocument;
        this.rootFolderWrapper = new InspectorFolderWrapper(designDocument, new RootFolder());
        this.rootFolderWrapper.resolveFolder(designDocument);
        this.ui = inspectorUI;
    }

    synchronized void buildTree(final DesignEvent designEvent) {
        this.lock = true;
        this.document.getTransactionManager().readAccess(new Runnable(){

            public void run() {
                if (InspectorWrapperTree.this.rootFolderWrapper.getChildren() != null && designEvent != null) {
                    if (designEvent.getFullyAffectedComponents() != null && !designEvent.getFullyAffectedComponents().isEmpty()) {
                        InspectorWrapperTree.this.addFoldersToUpdate(designEvent.getFullyAffectedComponents(), InspectorWrapperTree.this.rootFolderWrapper);
                    }
                    InspectorWrapperTree.this.updateChangedDescriptors(designEvent.getCreatedComponents(), designEvent.getFullyAffectedComponents());
                    InspectorWrapperTree.this.dive(InspectorFolderPath.createInspectorPath().add(InspectorWrapperTree.this.rootFolderWrapper.getFolder()), InspectorWrapperTree.this.rootFolderWrapper);
                    InspectorWrapperTree.this.updateTreeStructureView();
                    InspectorWrapperTree.this.ui.expandNodes((Collection<InspectorFolderWrapper>)InspectorWrapperTree.this.foldersToExtend);
                } else {
                    InspectorWrapperTree.this.updateChangedDescriptors(InspectorWrapperTree.this.markAllComponentsAsToAdd(), null);
                    InspectorWrapperTree.this.dive(InspectorFolderPath.createInspectorPath().add(InspectorWrapperTree.this.rootFolderWrapper.getFolder()), InspectorWrapperTree.this.rootFolderWrapper);
                    InspectorWrapperTree.this.updateTreeStructureView();
                    List<InspectorFolderWrapper> list = InspectorWrapperTree.this.rootFolderWrapper.getChildren();
                    if (list != null) {
                        InspectorWrapperTree.this.ui.expandNodes(list);
                    }
                }
            }
        });
        this.foldersToUpdate.clear();
        this.foldersToExtend.clear();
        this.componentsToAdd.clear();
        this.componentsToDelete.clear();
        this.componentsToUndo.clear();
        this.lock = false;
    }

    private void addFoldersToUpdate(Collection<DesignComponent> collection, InspectorFolderWrapper inspectorFolderWrapper) {
        if (inspectorFolderWrapper.getChildren() == null) {
            return;
        }
        for (InspectorFolderWrapper inspectorFolderWrapper2 : inspectorFolderWrapper.getChildren()) {
            this.addFoldersToUpdate(collection, inspectorFolderWrapper2);
            if (!collection.contains(inspectorFolderWrapper2.getComponent())) continue;
            this.foldersToUpdate.add((Object)inspectorFolderWrapper2);
        }
    }

    boolean isLocked() {
        return this.lock;
    }

    private void dive(InspectorFolderPath inspectorFolderPath, InspectorFolderWrapper inspectorFolderWrapper) {
        WeakSet weakSet;
        List<InspectorFolderWrapper> list = inspectorFolderWrapper.getFolder() instanceof RootFolder ? this.componentsRecursion(inspectorFolderPath, inspectorFolderWrapper, this.document.getRootComponent()) : this.componentsChildrenDive(inspectorFolderPath, inspectorFolderWrapper, this.document.getRootComponent());
        if (list == null) {
            list = this.registryDescriptorsDive(inspectorFolderPath, inspectorFolderWrapper);
        } else {
            weakSet = this.registryDescriptorsDive(inspectorFolderPath, inspectorFolderWrapper);
            if (weakSet != null) {
                list.addAll((Collection<InspectorFolderWrapper>)weakSet);
            }
        }
        if (list == null) {
            list = inspectorFolderWrapper.getChildren();
        } else {
            this.foldersToUpdate.add((Object)inspectorFolderWrapper);
            weakSet = inspectorFolderWrapper.getChildren();
            if (weakSet != null) {
                list.addAll((Collection<InspectorFolderWrapper>)weakSet);
            }
        }
        if (list != null) {
            weakSet = null;
            for (InspectorFolderWrapper inspectorFolderWrapper2 : list) {
                if (this.componentsToDelete != null && inspectorFolderWrapper2.getFolder().getComponentID() != null) {
                    for (DesignComponent designComponent : this.componentsToDelete) {
                        if (!inspectorFolderWrapper2.getFolder().getComponentID().equals(designComponent.getComponentID())) continue;
                        if (weakSet == null) {
                            weakSet = new WeakSet();
                        }
                        weakSet.add((Object)inspectorFolderWrapper2);
                        if (this.deletedComponentsCash == null) {
                            this.deletedComponentsCash = new WeakSet();
                        }
                        this.deletedComponentsCash.add((Object)this.document.getComponentByUID(designComponent.getComponentID()));
                        this.foldersToUpdate.add((Object)inspectorFolderWrapper);
                    }
                }
                inspectorFolderPath.add(inspectorFolderWrapper2.getFolder());
                this.dive(inspectorFolderPath, inspectorFolderWrapper2);
                inspectorFolderPath.remove(inspectorFolderWrapper2.getFolder());
            }
            if (weakSet != null) {
                list.removeAll((Collection<?>)weakSet);
                for (InspectorFolderWrapper inspectorFolderWrapper2 : weakSet) {
                    inspectorFolderWrapper2.terminate();
                }
            }
            inspectorFolderWrapper.setChildren(list);
        }
    }

    private List<InspectorFolderWrapper> componentsChildrenDive(InspectorFolderPath inspectorFolderPath, InspectorFolderWrapper inspectorFolderWrapper, DesignComponent designComponent) {
        List<InspectorFolderWrapper> list = null;
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            List<InspectorFolderWrapper> list2;
            if (this.componentsToAdd.contains((Object)designComponent2) || this.componentsToUndo.contains((Object)designComponent2)) {
                list2 = this.componentsRecursion(inspectorFolderPath, inspectorFolderWrapper, designComponent2);
                if (list == null) {
                    list = list2;
                } else if (list2 != null) {
                    list.addAll(list2);
                }
            }
            if (!InspectorRegistry.getInstance(this.document).getComponentsToUpdate().isEmpty() && InspectorRegistry.getInstance(this.document).getComponentsToUpdate().contains(designComponent2)) {
                if (list == null) {
                    list = this.changedComponentsRecursion(inspectorFolderPath, inspectorFolderWrapper, designComponent2);
                } else {
                    list2 = this.changedComponentsRecursion(inspectorFolderPath, inspectorFolderWrapper, designComponent2);
                    if (list2 != null) {
                        list.addAll(list2);
                    }
                }
            }
            if (list == null) {
                list = this.componentsChildrenDive(inspectorFolderPath, inspectorFolderWrapper, designComponent2);
                continue;
            }
            list2 = this.componentsChildrenDive(inspectorFolderPath, inspectorFolderWrapper, designComponent2);
            if (list2 == null) continue;
            list.addAll(list2);
        }
        return list;
    }

    private List<InspectorFolderWrapper> componentsRecursion(InspectorFolderPath inspectorFolderPath, InspectorFolderWrapper inspectorFolderWrapper, DesignComponent designComponent) {
        InspectorFolderWrapper inspectorFolderWrapper2;
        ArrayList<InspectorFolderWrapper> arrayList = null;
        for (DesignComponent designComponent2 : this.componentsToAdd) {
            if (designComponent2.getComponentID() != designComponent.getComponentID()) continue;
            for (InspectorFolderPresenter inspectorFolderPresenter : designComponent2.getPresenters(InspectorFolderPresenter.class)) {
                if (inspectorFolderPresenter == null || !inspectorFolderPresenter.getFolder().isInside(inspectorFolderPath, inspectorFolderPresenter.getFolder(), designComponent2) || inspectorFolderPresenter.getFolder().getComponentID() == null || inspectorFolderWrapper.getChildrenFolders() != null && inspectorFolderWrapper.getChildrenFolders().contains(inspectorFolderPresenter.getFolder())) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<InspectorFolderWrapper>();
                }
                inspectorFolderWrapper2 = new InspectorFolderWrapper(this.document, inspectorFolderPresenter.getFolder());
                arrayList.add(inspectorFolderWrapper2);
                this.foldersToUpdate.add((Object)inspectorFolderWrapper);
                this.foldersToExtend.add((Object)inspectorFolderWrapper);
            }
        }
        for (DesignComponent designComponent2 : this.componentsToUndo) {
            if (designComponent2.getComponentID() != designComponent.getComponentID()) continue;
            for (InspectorFolderPresenter inspectorFolderPresenter : designComponent2.getPresenters(InspectorFolderPresenter.class)) {
                if (inspectorFolderPresenter == null || !inspectorFolderPresenter.getFolder().isInside(inspectorFolderPath, inspectorFolderPresenter.getFolder(), designComponent2) || inspectorFolderPresenter.getFolder().getComponentID() == null) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                inspectorFolderWrapper2 = new InspectorFolderWrapper(this.document, inspectorFolderPresenter.getFolder());
                arrayList.add(inspectorFolderWrapper2);
                this.foldersToUpdate.add((Object)inspectorFolderWrapper);
                this.foldersToExtend.add((Object)inspectorFolderWrapper);
                this.deletedComponentsCash.remove((Object)designComponent2);
            }
        }
        return arrayList;
    }

    private List<InspectorFolderWrapper> changedComponentsRecursion(InspectorFolderPath inspectorFolderPath, InspectorFolderWrapper inspectorFolderWrapper, DesignComponent designComponent) {
        ArrayList<InspectorFolderWrapper> arrayList = null;
        for (InspectorFolderPresenter inspectorFolderPresenter : designComponent.getPresenters(InspectorFolderPresenter.class)) {
            if (inspectorFolderPresenter == null || !inspectorFolderPresenter.getFolder().isInside(inspectorFolderPath, inspectorFolderPresenter.getFolder(), designComponent)) continue;
            if (inspectorFolderPresenter.getFolder().getComponentID() != null) {
                if (!inspectorFolderWrapper.removeChild(inspectorFolderPresenter.getFolder())) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<InspectorFolderWrapper>();
                }
                InspectorFolderWrapper inspectorFolderWrapper2 = new InspectorFolderWrapper(this.document, inspectorFolderPresenter.getFolder());
                arrayList.add(inspectorFolderWrapper2);
                inspectorFolderPath.add(inspectorFolderWrapper2.getFolder());
                this.rebulidDive(inspectorFolderPath, inspectorFolderWrapper2);
                inspectorFolderPath.remove(inspectorFolderWrapper2.getFolder());
                this.foldersToUpdate.add((Object)inspectorFolderWrapper);
                continue;
            }
            throw new IllegalArgumentException("Argument ComponentID is null: component: " + designComponent);
        }
        return arrayList;
    }

    private List<InspectorFolderWrapper> registryDescriptorsDive(InspectorFolderPath inspectorFolderPath, InspectorFolderWrapper inspectorFolderWrapper) {
        ArrayList<InspectorFolderWrapper> arrayList = null;
        if (this.globalFolders == null) {
            return null;
        }
        for (InspectorFolder inspectorFolder : this.globalFolders) {
            if (!inspectorFolder.isInside(inspectorFolderPath, inspectorFolder, null) || inspectorFolderWrapper.getChildrenFolders() != null && inspectorFolderWrapper.getChildrenFolders().contains(inspectorFolder)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<InspectorFolderWrapper>();
            }
            InspectorFolderWrapper inspectorFolderWrapper2 = new InspectorFolderWrapper(this.document, inspectorFolder);
            arrayList.add(inspectorFolderWrapper2);
        }
        return arrayList;
    }

    private void rebulidDive(InspectorFolderPath inspectorFolderPath, InspectorFolderWrapper inspectorFolderWrapper) {
        List<InspectorFolderWrapper> list;
        List<InspectorFolderWrapper> list2 = inspectorFolderWrapper.getFolder() instanceof RootFolder ? this.rebulidComponentsRecursion(inspectorFolderPath, inspectorFolderWrapper, this.document.getRootComponent()) : this.rebulidComponentsChildrenDive(inspectorFolderPath, inspectorFolderWrapper, this.document.getRootComponent());
        if (list2 == null) {
            list2 = this.registryDescriptorsDive(inspectorFolderPath, inspectorFolderWrapper);
        } else {
            list = this.registryDescriptorsDive(inspectorFolderPath, inspectorFolderWrapper);
            if (list != null) {
                list2.addAll(list);
            }
        }
        if (list2 == null) {
            list2 = inspectorFolderWrapper.getChildren();
        } else {
            list = inspectorFolderWrapper.getChildren();
            if (list != null) {
                list2.addAll(list);
            }
        }
        if (list2 != null) {
            for (InspectorFolderWrapper inspectorFolderWrapper2 : list2) {
                inspectorFolderPath.add(inspectorFolderWrapper2.getFolder());
                this.rebulidDive(inspectorFolderPath, inspectorFolderWrapper2);
                inspectorFolderPath.remove(inspectorFolderWrapper2.getFolder());
            }
            inspectorFolderWrapper.setChildren(list2);
        }
    }

    private List<InspectorFolderWrapper> rebulidComponentsChildrenDive(InspectorFolderPath inspectorFolderPath, InspectorFolderWrapper inspectorFolderWrapper, DesignComponent designComponent) {
        List<InspectorFolderWrapper> list = null;
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            List<InspectorFolderWrapper> list2 = this.rebulidComponentsRecursion(inspectorFolderPath, inspectorFolderWrapper, designComponent2);
            if (list == null) {
                list = list2;
            } else if (list2 != null) {
                list.addAll(list2);
            }
            if (list == null) {
                list = this.rebulidComponentsChildrenDive(inspectorFolderPath, inspectorFolderWrapper, designComponent2);
                continue;
            }
            List<InspectorFolderWrapper> list3 = this.rebulidComponentsChildrenDive(inspectorFolderPath, inspectorFolderWrapper, designComponent2);
            if (list3 == null) continue;
            list.addAll(list3);
        }
        return list;
    }

    private List<InspectorFolderWrapper> rebulidComponentsRecursion(InspectorFolderPath inspectorFolderPath, InspectorFolderWrapper inspectorFolderWrapper, DesignComponent designComponent) {
        ArrayList<InspectorFolderWrapper> arrayList = null;
        for (InspectorFolderPresenter inspectorFolderPresenter : designComponent.getPresenters(InspectorFolderPresenter.class)) {
            if (inspectorFolderPresenter == null || !inspectorFolderPresenter.getFolder().isInside(inspectorFolderPath, inspectorFolderPresenter.getFolder(), designComponent) || inspectorFolderPresenter.getFolder().getComponentID() == null || inspectorFolderWrapper.getChildrenFolders() != null && inspectorFolderWrapper.getChildrenFolders().contains(inspectorFolderPresenter.getFolder())) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<InspectorFolderWrapper>();
            }
            InspectorFolderWrapper inspectorFolderWrapper2 = new InspectorFolderWrapper(this.document, inspectorFolderPresenter.getFolder());
            arrayList.add(inspectorFolderWrapper2);
            this.foldersToUpdate.add((Object)inspectorFolderWrapper);
            this.foldersToExtend.add((Object)inspectorFolderWrapper);
        }
        return arrayList;
    }

    private void updateChangedDescriptors(Collection<DesignComponent> collection, Collection<DesignComponent> collection2) {
        if (collection != null) {
            for (DesignComponent designComponent : collection) {
                if (designComponent.getPresenters(InspectorFolderPresenter.class).isEmpty()) continue;
                this.componentsToAdd.add((Object)designComponent);
            }
        }
        if (collection2 != null) {
            for (DesignComponent designComponent : collection2) {
                if (this.deletedComponentsCash != null && this.deletedComponentsCash.contains((Object)designComponent)) {
                    this.componentsToUndo.add((Object)designComponent);
                }
                if (designComponent == null || designComponent.getParentComponent() != null) continue;
                this.componentsToDelete.add((Object)designComponent);
            }
        }
        InspectorRegistry.getInstance(this.document).remove((Collection<DesignComponent>)this.componentsToAdd);
        InspectorRegistry.getInstance(this.document).remove((Collection<DesignComponent>)this.componentsToDelete);
    }

    private void updateTreeStructureView() {
        this.updateTreeStructureView(this.rootFolderWrapper);
        this.rootFolderWrapper.resolveFolder(this.document);
        this.warmUp((Node)this.rootFolderWrapper.getNode());
    }

    private void updateTreeStructureView(InspectorFolderWrapper inspectorFolderWrapper) {
        if (inspectorFolderWrapper.getChildren() != null) {
            for (InspectorFolderWrapper inspectorFolderWrapper2 : inspectorFolderWrapper.getChildren()) {
                this.updateTreeStructureView(inspectorFolderWrapper2);
                if (!this.foldersToUpdate.contains((Object)inspectorFolderWrapper2)) continue;
                inspectorFolderWrapper2.resolveFolder(this.document);
            }
        }
        if (inspectorFolderWrapper.getChildren() == null || inspectorFolderWrapper.getChildren().isEmpty()) {
            inspectorFolderWrapper.resolveFolder(this.document);
        }
    }

    private void warmUp(Node node) {
        for (Node node2 : node.getChildren().getNodes()) {
            this.warmUp(node2);
        }
    }

    private void updateRegistredFolders() {
        if (this.registry == null) {
            return;
        }
        this.registry.readAccess(new Runnable(){

            public void run() {
                InspectorWrapperTree.this.globalFolders = InspectorWrapperTree.this.registry.getFolders();
            }
        });
    }

    InspectorFolderWrapper getRootWrapperFolder() {
        return this.rootFolderWrapper;
    }

    @Override
    public void notifyRegistryContentChange() {
        this.updateRegistredFolders();
    }

    Collection<Node> getSelectedNodes() {
        return this.getSelectedNodes(this.rootFolderWrapper);
    }

    private Collection<Node> getSelectedNodes(InspectorFolderWrapper inspectorFolderWrapper) {
        if (inspectorFolderWrapper == null || inspectorFolderWrapper.getChildren() == null) {
            return null;
        }
        HashSet<Node> hashSet = new HashSet<Node>();
        if (this.document.getSelectedComponents().isEmpty()) {
            return hashSet;
        }
        for (InspectorFolderWrapper inspectorFolderWrapper2 : inspectorFolderWrapper.getChildren()) {
            if (inspectorFolderWrapper2.getChildren() != null) {
                hashSet.addAll(this.getSelectedNodes(inspectorFolderWrapper2));
            }
            for (DesignComponent designComponent : this.document.getSelectedComponents()) {
                Long l = inspectorFolderWrapper2.getFolder().getComponentID();
                if (l == null || l.longValue() != designComponent.getComponentID() || !inspectorFolderWrapper2.getFolder().getDisplayName().equals(InfoPresenter.getDisplayName((DesignComponent)designComponent))) continue;
                hashSet.add((Node)inspectorFolderWrapper2.getNode());
            }
        }
        return hashSet;
    }

    private Collection<DesignComponent> markAllComponentsAsToAdd() {
        HashSet<DesignComponent> hashSet = new HashSet<DesignComponent>();
        if (this.document.getRootComponent() != null) {
            this.markAllComponentsAsToAdd(hashSet, this.document.getRootComponent());
        }
        return hashSet;
    }

    private Collection<DesignComponent> markAllComponentsAsToAdd(Collection<DesignComponent> collection, DesignComponent designComponent) {
        collection.add(designComponent);
        for (DesignComponent designComponent2 : designComponent.getComponents()) {
            this.markAllComponentsAsToAdd(collection, designComponent2);
        }
        return collection;
    }

    void terminate() {
        if (this.rootFolderWrapper != null) {
            this.terminateChildern(this.rootFolderWrapper);
            this.globalFolders = null;
            this.registry = null;
            this.document = null;
            this.componentsToDelete = null;
            this.componentsToAdd = null;
            this.componentsToUndo = null;
            this.foldersToUpdate = null;
            this.deletedComponentsCash = null;
            this.foldersToExtend = null;
            this.rootFolderWrapper = null;
            this.ui = null;
            this.lock = false;
        }
    }

    private void terminateChildern(InspectorFolderWrapper inspectorFolderWrapper) {
        if (inspectorFolderWrapper.getChildren() != null) {
            for (InspectorFolderWrapper inspectorFolderWrapper2 : inspectorFolderWrapper.getChildren()) {
                this.terminateChildern(inspectorFolderWrapper2);
            }
        }
        inspectorFolderWrapper.terminate();
    }

    private class RootFolder
    extends InspectorFolder {
        private RootFolder() {
        }

        public TypeID getTypeID() {
            return new TypeID(TypeID.Kind.PRIMITIVE, "");
        }

        public Long getComponentID() {
            return null;
        }

        public Image getIcon() {
            return new Image(){

                public void flush() {
                }

                public Graphics getGraphics() {
                    return null;
                }

                public int getHeight(ImageObserver imageObserver) {
                    return 0;
                }

                public Object getProperty(String string, ImageObserver imageObserver) {
                    return null;
                }

                public ImageProducer getSource() {
                    return null;
                }

                public int getWidth(ImageObserver imageObserver) {
                    return 0;
                }
            };
        }

        public String getDisplayName() {
            return "ROOT FOLDER - SHOULD BE HIDDEN";
        }

        public Action[] getActions() {
            return null;
        }

        public NewType[] getNewTypes() {
            return null;
        }

        public boolean canRename() {
            return false;
        }

        public boolean isInside(InspectorFolderPath inspectorFolderPath, InspectorFolder inspectorFolder, DesignComponent designComponent) {
            return false;
        }

        public String getName() {
            return "ROOT FOLDER - SHOULD BE HIDDEN";
        }

        public InspectorOrderingController[] getOrderingControllers() {
            return null;
        }

        public String getHtmlDisplayName() {
            return "ROOT FOLDER - SHOULD BE HIDDEN";
        }
    }
}

