/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.classpath;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.classpath.ClassPathSupport;
import org.netbeans.modules.java.j2seproject.ui.customizer.J2SEProjectProperties;
import org.netbeans.spi.java.project.classpath.ProjectClassPathModifierImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class J2SEProjectClassPathModifier
extends ProjectClassPathModifierImplementation {
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    private final J2SEProject project;
    private final UpdateHelper helper;
    private final ReferenceHelper refHelper;
    private final PropertyEvaluator eval;
    private final ClassPathSupport cs;
    private static final Logger LOG = Logger.getLogger(J2SEProjectClassPathModifier.class.getName());

    public J2SEProjectClassPathModifier(J2SEProject j2SEProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper) {
        assert (j2SEProject != null);
        assert (updateHelper != null);
        assert (propertyEvaluator != null);
        assert (referenceHelper != null);
        this.project = j2SEProject;
        this.helper = updateHelper;
        this.eval = propertyEvaluator;
        this.refHelper = referenceHelper;
        this.cs = new ClassPathSupport(propertyEvaluator, referenceHelper, updateHelper.getAntProjectHelper(), updateHelper, J2SEProjectProperties.WELL_KNOWN_PATHS, "${reference.");
    }

    protected SourceGroup[] getExtensibleSourceGroups() {
        Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
        assert (sources != null);
        return sources.getSourceGroups("java");
    }

    protected String[] getExtensibleClassPathTypes(SourceGroup sourceGroup) {
        return new String[]{"classpath/compile", "classpath/execute"};
    }

    protected boolean removeRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException {
        return this.handleRoots(J2SEProjectClassPathModifier.convertURLsToURIs((URL[])uRLArray), this.getClassPathProperty(sourceGroup, string), 2, true);
    }

    protected boolean removeRoots(URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException {
        return this.handleRoots(uRIArray, this.getClassPathProperty(sourceGroup, string), 2, true);
    }

    protected boolean addRoots(URL[] uRLArray, SourceGroup sourceGroup, String string) throws IOException {
        return this.handleRoots(J2SEProjectClassPathModifier.convertURLsToURIs((URL[])uRLArray), this.getClassPathProperty(sourceGroup, string), 1, true);
    }

    protected boolean addRoots(URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException {
        return this.handleRoots(uRIArray, this.getClassPathProperty(sourceGroup, string), 1, true);
    }

    public boolean handleRoots(final URI[] uRIArray, final String string, final int n, final boolean bl) throws IOException {
        assert (uRIArray != null) : "The classPathRoots cannot be null";
        assert (string != null);
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws Exception {
                    EditableProperties editableProperties = J2SEProjectClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                    String string3 = editableProperties.getProperty(string);
                    List<ClassPathSupport.Item> list = J2SEProjectClassPathModifier.this.cs.itemsList(string3);
                    boolean bl2 = false;
                    for (int i = 0; i < uRIArray.length; ++i) {
                        Object object;
                        String string2;
                        if (bl) {
                            string2 = J2SEProjectClassPathModifier.this.performSharabilityHeuristics(uRIArray[i], J2SEProjectClassPathModifier.this.project.getAntProjectHelper());
                        } else {
                            object = LibrariesSupport.getArchiveFile((URI)uRIArray[i]);
                            if (object == null) {
                                object = uRIArray[i];
                            }
                            string2 = LibrariesSupport.convertURIToFilePath((URI)object);
                        }
                        object = ClassPathSupport.Item.create(string2, null);
                        if (n == 1 && !list.contains(object)) {
                            list.add((ClassPathSupport.Item)object);
                            bl2 = true;
                            continue;
                        }
                        if (n != 2) continue;
                        if (list.remove(object)) {
                            bl2 = true;
                            continue;
                        }
                        Iterator<ClassPathSupport.Item> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            ClassPathSupport.Item item = iterator.next();
                            if (!item.isBroken() || item.getType() != 0 || !string2.equals(item.getFilePath())) continue;
                            iterator.remove();
                            bl2 = true;
                        }
                    }
                    if (bl2) {
                        String[] stringArray = J2SEProjectClassPathModifier.this.cs.encodeToStrings(list.iterator());
                        editableProperties = J2SEProjectClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                        editableProperties.setProperty(string, stringArray);
                        J2SEProjectClassPathModifier.this.helper.putProperties("nbproject/project.properties", editableProperties);
                        ProjectManager.getDefault().saveProject((Project)J2SEProjectClassPathModifier.this.project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)exception);
        }
    }

    protected boolean removeAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException {
        return this.handleAntArtifacts(antArtifactArray, uRIArray, this.getClassPathProperty(sourceGroup, string), 2);
    }

    protected boolean addAntArtifacts(AntArtifact[] antArtifactArray, URI[] uRIArray, SourceGroup sourceGroup, String string) throws IOException {
        return this.handleAntArtifacts(antArtifactArray, uRIArray, this.getClassPathProperty(sourceGroup, string), 1);
    }

    public boolean handleAntArtifacts(final AntArtifact[] antArtifactArray, final URI[] uRIArray, final String string, final int n) throws IOException {
        assert (antArtifactArray != null) : "Artifacts cannot be null";
        assert (uRIArray != null) : "ArtifactElements cannot be null";
        assert (antArtifactArray.length == uRIArray.length) : "Each artifact has to have corresponding artifactElement";
        assert (string != null);
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws Exception {
                    EditableProperties editableProperties = J2SEProjectClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                    String string2 = editableProperties.getProperty(string);
                    List<ClassPathSupport.Item> list = J2SEProjectClassPathModifier.this.cs.itemsList(string2);
                    boolean bl = false;
                    for (int i = 0; i < antArtifactArray.length; ++i) {
                        assert (antArtifactArray[i] != null);
                        assert (uRIArray[i] != null);
                        ClassPathSupport.Item item = ClassPathSupport.Item.create(antArtifactArray[i], uRIArray[i], null);
                        if (n == 1 && !list.contains(item)) {
                            list.add(item);
                            bl = true;
                            continue;
                        }
                        if (n != 2 || !list.contains(item)) continue;
                        list.remove(item);
                        bl = true;
                    }
                    if (bl) {
                        String[] stringArray = J2SEProjectClassPathModifier.this.cs.encodeToStrings(list.iterator());
                        editableProperties = J2SEProjectClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                        editableProperties.setProperty(string, stringArray);
                        J2SEProjectClassPathModifier.this.helper.putProperties("nbproject/project.properties", editableProperties);
                        ProjectManager.getDefault().saveProject((Project)J2SEProjectClassPathModifier.this.project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            IOException iOException = new IOException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)exception);
        }
    }

    protected boolean removeLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException {
        return this.handleLibraries(libraryArray, this.getClassPathProperty(sourceGroup, string), 2);
    }

    protected boolean addLibraries(Library[] libraryArray, SourceGroup sourceGroup, String string) throws IOException {
        return this.handleLibraries(libraryArray, this.getClassPathProperty(sourceGroup, string), 1);
    }

    public boolean handleLibraries(final Library[] libraryArray, final String string, final int n) throws IOException {
        assert (libraryArray != null) : "Libraries cannot be null";
        assert (string != null);
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    EditableProperties editableProperties = J2SEProjectClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                    String string2 = editableProperties.getProperty(string);
                    List<ClassPathSupport.Item> list = J2SEProjectClassPathModifier.this.cs.itemsList(string2);
                    ArrayList<ClassPathSupport.Item> arrayList = new ArrayList<ClassPathSupport.Item>(libraryArray.length);
                    for (int i = 0; i < libraryArray.length; ++i) {
                        ClassPathSupport.Item item;
                        assert (libraryArray[i] != null);
                        Object object = libraryArray[i];
                        if (J2SEProjectClassPathModifier.this.project.getAntProjectHelper().isSharableProject()) {
                            if (object.getManager().getLocation() == null) {
                                LOG.log(Level.FINE, "Client is adding global library [" + object + "] to sharable project.", new Exception());
                                item = J2SEProjectClassPathModifier.this.refHelper.getProjectLibraryManager().getLibrary(object.getName());
                                object = item != null ? item : J2SEProjectClassPathModifier.this.refHelper.copyLibrary(object);
                            } else if (!object.getManager().getLocation().equals(J2SEProjectClassPathModifier.this.refHelper.getProjectLibraryManager().getLocation())) {
                                throw new UnsupportedOperationException("Adding library '" + object.getName() + "' from '" + object.getManager().getLocation() + "' to project '" + J2SEProjectClassPathModifier.this.project.getProjectDirectory() + "' is not supported because project libraries are defined in '" + J2SEProjectClassPathModifier.this.refHelper.getProjectLibraryManager().getLocation() + "'");
                            }
                        }
                        item = ClassPathSupport.Item.create(object, null);
                        if (n == 1 && !list.contains(item)) {
                            list.add(item);
                            arrayList.add(item);
                            continue;
                        }
                        if (n != 2 || !list.contains(item)) continue;
                        list.remove(item);
                        arrayList.add(item);
                    }
                    if (!arrayList.isEmpty()) {
                        String[] stringArray = J2SEProjectClassPathModifier.this.cs.encodeToStrings(list.iterator());
                        editableProperties = J2SEProjectClassPathModifier.this.helper.getProperties("nbproject/project.properties");
                        editableProperties.setProperty(string, stringArray);
                        J2SEProjectClassPathModifier.this.helper.putProperties("nbproject/project.properties", editableProperties);
                        ProjectManager.getDefault().saveProject((Project)J2SEProjectClassPathModifier.this.project);
                        return true;
                    }
                    return false;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private String getClassPathProperty(SourceGroup sourceGroup, String string) {
        assert (sourceGroup != null) : "SourceGroup cannot be null";
        assert (string != null) : "Type cannot be null";
        String string2 = this.project.getClassPathProvider().getPropertyName(sourceGroup, string);
        if (string2 == null) {
            throw new UnsupportedOperationException("Modification of [" + sourceGroup.getRootFolder().getPath() + ", " + string + "] is not supported");
        }
        return string2;
    }
}

