/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XRefResultSet {
    private final Map<ContextScope, Collection<ContextEntry>> scopeEntries = new HashMap<ContextScope, Collection<ContextEntry>>(ContextScope.values().length);
    private final Map<ContextScope, Integer> scopes = new HashMap<ContextScope, Integer>(ContextScope.values().length);

    public static Collection<ContextScope> sortedContextScopes(XRefResultSet xRefResultSet, boolean bl) {
        ArrayList<ContextScope> arrayList = new ArrayList<ContextScope>(ContextScope.values().length);
        for (ContextScope contextScope : ContextScope.values()) {
            boolean bl2 = false;
            int n = bl ? xRefResultSet.getEntries(contextScope).size() : xRefResultSet.getNumberOfContexts(contextScope, false);
            for (int i = 0; i < arrayList.size(); ++i) {
                ContextScope contextScope2 = (ContextScope)((Object)arrayList.get(i));
                int n2 = bl ? xRefResultSet.getEntries(contextScope2).size() : xRefResultSet.getNumberOfContexts(contextScope2, false);
                if (n2 > n) continue;
                arrayList.add(i, contextScope);
                bl2 = true;
                break;
            }
            if (bl2) continue;
            arrayList.add(contextScope);
        }
        return arrayList;
    }

    public XRefResultSet() {
        for (ContextScope contextScope : ContextScope.values()) {
            this.scopeEntries.put(contextScope, new ArrayList(1024));
            this.scopes.put(contextScope, new Integer(0));
        }
    }

    public final void addEntry(ContextScope contextScope, ContextEntry contextEntry) {
        this.scopeEntries.get((Object)contextScope).add(contextEntry);
    }

    public final Collection<ContextEntry> getEntries(ContextScope contextScope) {
        return this.scopeEntries.get((Object)contextScope);
    }

    public final void incrementScopeCounter(ContextScope contextScope) {
        int n = this.scopes.get((Object)contextScope);
        this.scopes.put(contextScope, ++n);
    }

    public final int getNumberOfAllContexts() {
        int n = 0;
        for (int n2 : this.scopes.values()) {
            n += n2;
        }
        return n;
    }

    public final int getNumberOfContexts(ContextScope contextScope, boolean bl) {
        int n = this.scopes.get((Object)contextScope);
        if (bl && n != 0) {
            assert (n > 0);
            n = n * 100 / this.getNumberOfAllContexts();
        }
        return n;
    }

    public static final class ContextEntry {
        public final DeclarationKind declaration;
        public final DeclarationScope declarationScope;
        public final IncludeLevel declarationIncludeLevel;
        public final UsageStatistics usageStatistics;
        public static final ContextEntry UNRESOLVED = new ContextEntry(DeclarationKind.UNRESOLVED, DeclarationScope.UNRESOLVED, IncludeLevel.UNRESOLVED, UsageStatistics.UNKNOWN);

        public ContextEntry(DeclarationKind declarationKind, DeclarationScope declarationScope, IncludeLevel includeLevel, UsageStatistics usageStatistics) {
            this.declaration = declarationKind;
            this.declarationScope = declarationScope;
            this.declarationIncludeLevel = includeLevel;
            this.usageStatistics = usageStatistics;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UsageStatistics {
        FIRST_USAGE,
        SECOND_USAGE,
        NEXT_USAGE,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IncludeLevel {
        THIS_FILE,
        PROJECT_DIRECT,
        LIBRARY_DIRECT,
        PROJECT_DEEP,
        LIBRARY_DEEP,
        UNRESOLVED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeclarationScope {
        FUNCTION_THIS,
        CLASSIFIER_THIS,
        CLASSIFIER_PARENT,
        PROJECT_CLASSIFIER,
        LIBRARY_CLASSIFIER,
        NAMESPACE_THIS,
        NAMESPACE_PARENT,
        PROJECT_NAMESPACE,
        LIBRARY_NAMESPACE,
        FILE_THIS,
        PROJECT_FILE,
        LIBRARY_FILE,
        PROJECT_GLOBAL,
        LIBRARY_GLOBAL,
        UNRESOLVED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeclarationKind {
        CLASSIFIER,
        ENUMERATOR,
        VARIABLE,
        PARAMETER,
        FUNCTION,
        NAMESPACE,
        CLASS_FORWARD,
        MACRO,
        UNRESOLVED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContextScope {
        GLOBAL_FUNCTION,
        NAMESPACE_FUNCTION,
        FILE_LOCAL_FUNCTION,
        METHOD,
        CONSTRUCTOR,
        INLINED_METHOD,
        INLINED_CONSTRUCTOR,
        UNRESOLVED;

    }
}

