/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectNameBasedKey;

abstract class ProjectFileNameBasedKey
extends ProjectNameBasedKey {
    protected final int fileNameIndex;

    protected ProjectFileNameBasedKey(String string, String string2) {
        super(string);
        assert (string2 != null);
        this.fileNameIndex = KeyUtilities.getFileIdByName(this.unitIndex, string2);
    }

    protected ProjectFileNameBasedKey(FileImpl fileImpl) {
        this(ProjectFileNameBasedKey.getProjectName(fileImpl), fileImpl.getAbsolutePath());
    }

    protected static String getProjectName(FileImpl fileImpl) {
        assert (fileImpl != null);
        ProjectBase projectBase = fileImpl.getProjectImpl();
        assert (projectBase != null);
        return projectBase == null ? "<No Project Name>" : ((Object)projectBase.getUniqueName()).toString();
    }

    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeInt(this.fileNameIndex);
    }

    protected ProjectFileNameBasedKey(DataInput dataInput) throws IOException {
        super(dataInput);
        this.fileNameIndex = dataInput.readInt();
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 17 * n + this.fileNameIndex;
        return n;
    }

    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        ProjectFileNameBasedKey projectFileNameBasedKey = (ProjectFileNameBasedKey)object;
        return this.fileNameIndex == projectFileNameBasedKey.fileNameIndex;
    }

    protected String getFileName() {
        return KeyUtilities.getFileNameById(this.unitIndex, this.fileNameIndex);
    }

    protected String getFileNameSafe() {
        return KeyUtilities.getFileNameByIdSafe(this.unitIndex, this.fileNameIndex);
    }

    public int getDepth() {
        assert (super.getDepth() == 0);
        return 1;
    }

    public CharSequence getAt(int n) {
        assert (super.getDepth() == 0 && n < this.getDepth());
        return this.getFileName();
    }
}

