/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.memory;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryEvent;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryListener;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryNotifier;

class LowMemoryNotifierImpl
extends LowMemoryNotifier
implements NotificationListener {
    private Logger logger;
    private Collection listeners = new LinkedList();
    private static final MemoryPoolMXBean pool = LowMemoryNotifierImpl.findHeapPool();

    public LowMemoryNotifierImpl() {
        this.logger = Logger.getLogger(this.getClass().getPackage().getName());
        String string = System.getProperty(this.logger.getName());
        if (string != null) {
            try {
                this.logger.setLevel(Level.parse(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else {
            this.logger.setLevel(Level.SEVERE);
        }
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        if (memoryMXBean instanceof NotificationEmitter) {
            NotificationEmitter notificationEmitter = (NotificationEmitter)((Object)memoryMXBean);
            notificationEmitter.addNotificationListener(this, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(LowMemoryListener lowMemoryListener) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(lowMemoryListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(LowMemoryListener lowMemoryListener) {
        this.logger.info("LowMemoryNotifierImpl.removeListener " + lowMemoryListener);
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(lowMemoryListener);
        }
    }

    public void setThresholdPercentage(double d) {
        this.logger.info("LowMemoryNotifierImpl.setThresholdPercentage " + d);
        assert (0.0 < d && d < 1.0);
        long l = pool.getUsage().getMax();
        long l2 = (long)((double)l * d);
        pool.setUsageThreshold(l2);
    }

    public void handleNotification(Notification notification, Object object) {
        this.logger.info("LowMemoryNotifierImpl.handleNotification " + notification);
        if ("java.management.memory.threshold.exceeded".equals(notification.getType())) {
            long l = pool.getUsage().getMax();
            long l2 = pool.getUsage().getUsed();
            this.logger.info("LowMemoryNotifierImpl.handleNotification " + l + '/' + l2);
            this.fireMemoryLow(l, l2);
        }
    }

    private static MemoryPoolMXBean findHeapPool() {
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            if (memoryPoolMXBean.getType() != MemoryType.HEAP || !memoryPoolMXBean.isUsageThresholdSupported()) continue;
            return memoryPoolMXBean;
        }
        return null;
    }

    private void fireMemoryLow(long l, long l2) {
        LowMemoryEvent lowMemoryEvent = new LowMemoryEvent(this, l, l2);
        LowMemoryListener[] lowMemoryListenerArray = this.getListeners();
        for (int i = 0; i < lowMemoryListenerArray.length; ++i) {
            lowMemoryListenerArray[i].memoryLow(lowMemoryEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LowMemoryListener[] getListeners() {
        Collection collection = this.listeners;
        synchronized (collection) {
            LowMemoryListener[] lowMemoryListenerArray = new LowMemoryListener[this.listeners.size()];
            this.listeners.toArray(lowMemoryListenerArray);
            return lowMemoryListenerArray;
        }
    }
}

