/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.repository.DeclarationContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.UniqueNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeclarationContainer
extends ProjectComponent
implements Persistent,
SelfPersistent {
    private SortedMap<CharSequence, Object> declarations = new TreeMap<CharSequence, Object>(CharSequenceKey.Comparator);
    private ReadWriteLock declarationsLock = new ReentrantReadWriteLock();
    private Map<CharSequence, Set<CsmUID<? extends CsmFriend>>> friends = new ConcurrentHashMap<CharSequence, Set<CsmUID<? extends CsmFriend>>>();

    public DeclarationContainer(ProjectBase projectBase) {
        super(new DeclarationContainerKey(((Object)projectBase.getUniqueName()).toString()));
        this.put();
    }

    public DeclarationContainer(DataInput dataInput) throws IOException {
        super(dataInput);
        this.read(dataInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeclaration(CsmDeclaration csmDeclaration) {
        CharSequence charSequence = CharSequenceKey.create((CharSequence)csmDeclaration.getUniqueName());
        Object var3_3 = null;
        try {
            this.declarationsLock.writeLock().lock();
            var3_3 = this.declarations.get(charSequence);
            if (var3_3 instanceof CsmUID[]) {
                CsmUID[] csmUIDArray = var3_3;
                int n = csmUIDArray.length;
                CsmUID csmUID = null;
                int n2 = n;
                for (int i = 0; i < n; ++i) {
                    CsmUID csmUID2 = csmUIDArray[i];
                    if (this.isSameFile((CsmUID<CsmOffsetableDeclaration>)csmUID2, (CsmOffsetableDeclaration)csmDeclaration)) {
                        csmUIDArray[i] = null;
                        --n2;
                        continue;
                    }
                    csmUID = csmUID2;
                }
                if (n2 == 0) {
                    this.declarations.remove(charSequence);
                } else if (n2 == 1) {
                    this.declarations.put(charSequence, csmUID);
                } else {
                    CsmUID[] csmUIDArray2 = new CsmUID[n2];
                    n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        CsmUID csmUID3 = csmUIDArray[i];
                        if (csmUID3 == null) continue;
                        csmUIDArray2[n2] = csmUID3;
                        ++n2;
                    }
                    this.declarations.put(charSequence, csmUIDArray2);
                }
            } else if (var3_3 instanceof CsmUID) {
                this.declarations.remove(charSequence);
            }
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        this.removeFriend(csmDeclaration);
        this.put();
    }

    private void removeFriend(CsmDeclaration csmDeclaration) {
        CsmFriendFunction csmFriendFunction;
        CharSequence charSequence;
        Set<CsmUID<? extends CsmFriend>> set;
        if (CsmKindUtilities.isFriendClass((CsmObject)csmDeclaration)) {
            CsmFriendClass csmFriendClass = (CsmFriendClass)csmDeclaration;
            CharSequence charSequence2 = CharSequenceKey.create((CharSequence)csmFriendClass.getName());
            Set<CsmUID<? extends CsmFriend>> set2 = this.friends.get(charSequence2);
            if (set2 != null) {
                set2.remove(csmFriendClass.getUID());
                if (set2.size() == 0) {
                    this.friends.remove(charSequence2);
                }
            }
        } else if (CsmKindUtilities.isFriendMethod((CsmObject)csmDeclaration) && (set = this.friends.get(charSequence = CharSequenceKey.create((CharSequence)(csmFriendFunction = (CsmFriendFunction)csmDeclaration).getSignature()))) != null) {
            set.remove(csmFriendFunction.getUID());
            if (set.size() == 0) {
                this.friends.remove(charSequence);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CharSequence charSequence = UniqueNameCache.getManager().getString(csmOffsetableDeclaration.getUniqueName());
        CsmUID csmUID = RepositoryUtils.put((CsmIdentifiable)csmOffsetableDeclaration);
        assert (csmUID != null);
        try {
            this.declarationsLock.writeLock().lock();
            Object v = this.declarations.get(charSequence);
            if (v instanceof CsmUID[]) {
                CsmUID[] csmUIDArray = (CsmUID[])v;
                boolean bl = false;
                for (int i = 0; i < csmUIDArray.length; ++i) {
                    if (!this.isSameFile((CsmUID<CsmOffsetableDeclaration>)csmUIDArray[i], (CsmUID<CsmOffsetableDeclaration>)csmUID)) continue;
                    csmUIDArray[i] = csmUID;
                    bl = true;
                    break;
                }
                if (!bl) {
                    CsmUID[] csmUIDArray2 = new CsmUID[csmUIDArray.length + 1];
                    csmUIDArray2[0] = csmUID;
                    for (int i = 0; i < csmUIDArray.length; ++i) {
                        csmUIDArray2[i + 1] = csmUIDArray[i];
                    }
                    this.declarations.put(charSequence, csmUIDArray2);
                }
            } else if (v instanceof CsmUID) {
                CsmUID csmUID2 = (CsmUID)v;
                if (this.isSameFile((CsmUID<CsmOffsetableDeclaration>)csmUID2, (CsmUID<CsmOffsetableDeclaration>)csmUID)) {
                    this.declarations.put(charSequence, csmUID);
                } else {
                    CsmUID[] csmUIDArray = new CsmUID[]{csmUID, csmUID2};
                    this.declarations.put(charSequence, csmUIDArray);
                }
            } else {
                this.declarations.put(charSequence, csmUID);
            }
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        this.putFriend((CsmDeclaration)csmOffsetableDeclaration);
    }

    private void putFriend(CsmDeclaration csmDeclaration) {
        if (CsmKindUtilities.isFriendClass((CsmObject)csmDeclaration)) {
            CsmFriendClass csmFriendClass = (CsmFriendClass)csmDeclaration;
            CharSequence charSequence = CharSequenceKey.create((CharSequence)csmFriendClass.getName());
            Set<CsmUID<? extends CsmFriend>> set = this.friends.get(charSequence);
            if (set == null) {
                set = new HashSet<CsmUID<? extends CsmFriend>>();
                this.friends.put(charSequence, set);
            }
            set.add((CsmUID<? extends CsmFriend>)csmFriendClass.getUID());
        } else if (CsmKindUtilities.isFriendMethod((CsmObject)csmDeclaration)) {
            CsmFriendFunction csmFriendFunction = (CsmFriendFunction)csmDeclaration;
            CharSequence charSequence = CharSequenceKey.create((CharSequence)csmFriendFunction.getSignature());
            Set<CsmUID<? extends CsmFriend>> set = this.friends.get(charSequence);
            if (set == null) {
                set = new HashSet<CsmUID<? extends CsmFriend>>();
                this.friends.put(charSequence, set);
            }
            set.add((CsmUID<? extends CsmFriend>)csmFriendFunction.getUID());
        }
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmOffsetableDeclaration> getDeclarationsRange(CharSequence charSequence, CharSequence charSequence2) {
        ArrayList arrayList = new ArrayList();
        charSequence = CharSequenceKey.create((CharSequence)charSequence);
        charSequence2 = CharSequenceKey.create((CharSequence)charSequence2);
        try {
            this.declarationsLock.readLock().lock();
            for (Map.Entry<CharSequence, Object> entry : this.declarations.subMap(charSequence, charSequence2).entrySet()) {
                Object object = entry.getValue();
                if (object instanceof CsmUID[]) {
                    CsmUID[] csmUIDArray;
                    for (CsmUID csmUID : csmUIDArray = (CsmUID[])object) {
                        arrayList.add(csmUID);
                    }
                    continue;
                }
                if (!(object instanceof CsmUID)) continue;
                arrayList.add((CsmUID)object);
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return UIDCsmConverter.UIDsToDeclarations(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmFriend> findFriends(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        Object object;
        CharSequence charSequence = null;
        if (CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration)) {
            object = (CsmClass)csmOffsetableDeclaration;
            charSequence = object.getName();
        } else if (CsmKindUtilities.isFunction((CsmObject)csmOffsetableDeclaration)) {
            object = (CsmFunction)csmOffsetableDeclaration;
            charSequence = object.getSignature();
        }
        if (charSequence != null) {
            Collection<Object> collection;
            charSequence = CharSequenceKey.create((CharSequence)charSequence);
            object = new ArrayList();
            try {
                this.declarationsLock.readLock().lock();
                collection = this.friends.get(charSequence);
                if (collection != null) {
                    object.addAll(collection);
                }
            }
            finally {
                this.declarationsLock.readLock().unlock();
            }
            if (object.size() > 0) {
                collection = new ArrayList();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    CsmFriendClass csmFriendClass;
                    CsmUID csmUID = (CsmUID)iterator.next();
                    CsmFriend csmFriend = (CsmFriend)csmUID.getObject();
                    if (CsmKindUtilities.isFriendClass((CsmObject)csmFriend)) {
                        csmFriendClass = (CsmFriendClass)csmFriend;
                        if (!csmOffsetableDeclaration.equals(csmFriendClass.getReferencedClass())) continue;
                        collection.add((CsmUID<? extends CsmFriend>)csmFriendClass);
                        continue;
                    }
                    if (!CsmKindUtilities.isFriendMethod((CsmObject)csmFriend) || !csmOffsetableDeclaration.equals((csmFriendClass = (CsmFriendFunction)csmFriend).getReferencedFunction())) continue;
                    collection.add(csmFriendClass);
                }
                return collection;
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmOffsetableDeclaration> findDeclarations(CharSequence charSequence) {
        ArrayList arrayList = new ArrayList();
        charSequence = CharSequenceKey.create((CharSequence)charSequence);
        try {
            this.declarationsLock.readLock().lock();
            Object v = this.declarations.get(charSequence);
            if (v instanceof CsmUID[]) {
                CsmUID[] csmUIDArray;
                for (CsmUID csmUID : csmUIDArray = (CsmUID[])v) {
                    arrayList.add(csmUID);
                }
            } else if (v instanceof CsmUID) {
                arrayList.add((CsmUID)v);
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return UIDCsmConverter.UIDsToDeclarations(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmDeclaration getDeclaration(CharSequence charSequence) {
        CsmUID csmUID = null;
        charSequence = CharSequenceKey.create((CharSequence)charSequence);
        try {
            this.declarationsLock.readLock().lock();
            Object v = this.declarations.get(charSequence);
            if (v instanceof CsmUID[]) {
                csmUID = ((CsmUID[])v)[0];
            } else if (v instanceof CsmUID) {
                csmUID = (CsmUID)v;
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        Object t = UIDCsmConverter.UIDtoDeclaration(csmUID);
        assert (t != null || csmUID == null) : "no declaration for UID " + csmUID;
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDeclarations() {
        try {
            this.declarationsLock.writeLock().lock();
            this.declarations.clear();
            this.put();
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        try {
            this.declarationsLock.readLock().lock();
            UIDObjectFactory.getDefaultFactory().writeStringToArrayUIDMap(this.declarations, dataOutput, false);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
    }

    private void read(DataInput dataInput) throws IOException {
        UIDObjectFactory.getDefaultFactory().readStringToArrayUIDMap(this.declarations, dataInput, UniqueNameCache.getManager());
    }

    private boolean isSameFile(CsmUID<CsmOffsetableDeclaration> csmUID, CsmUID<CsmOffsetableDeclaration> csmUID2) {
        return this.isSameFile((CsmOffsetableDeclaration)csmUID.getObject(), (CsmOffsetableDeclaration)csmUID2.getObject());
    }

    private boolean isSameFile(CsmUID<CsmOffsetableDeclaration> csmUID, CsmOffsetableDeclaration csmOffsetableDeclaration) {
        return this.isSameFile((CsmOffsetableDeclaration)csmUID.getObject(), csmOffsetableDeclaration);
    }

    private boolean isSameFile(CsmOffsetableDeclaration csmOffsetableDeclaration, CsmOffsetableDeclaration csmOffsetableDeclaration2) {
        if (csmOffsetableDeclaration != null && csmOffsetableDeclaration2 != null) {
            CsmFile csmFile = csmOffsetableDeclaration.getContainingFile();
            CsmFile csmFile2 = csmOffsetableDeclaration2.getContainingFile();
            if (csmFile != null && csmFile != null) {
                return csmFile.equals(csmFile2);
            }
        }
        return false;
    }
}

