/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.swing.event.ChangeListener;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class AbstractFileBuffer
implements FileBuffer {
    private final CharSequence absPath;

    protected AbstractFileBuffer(File file) {
        this.absPath = FilePathCache.getString((CharSequence)file.getAbsolutePath());
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public File getFile() {
        return new File(((Object)this.absPath).toString());
    }

    public abstract int getLength();

    public abstract String getText(int var1, int var2) throws IOException;

    public abstract String getText() throws IOException;

    public final Reader getReader() throws IOException {
        File file = this.getFile();
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        Charset charset = fileObject != null ? FileEncodingQuery.getEncoding((FileObject)fileObject) : FileEncodingQuery.getDefaultEncoding();
        InputStream inputStream = this.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        return inputStreamReader;
    }

    public abstract InputStream getInputStream() throws IOException;

    public abstract boolean isFileBased();

    public abstract long lastModified();

    protected void write(DataOutput dataOutput) throws IOException {
        assert (this.absPath != null);
        dataOutput.writeUTF(((Object)this.absPath).toString());
    }

    protected AbstractFileBuffer(DataInput dataInput) throws IOException {
        this.absPath = FilePathCache.getString((CharSequence)dataInput.readUTF());
        assert (this.absPath != null);
    }
}

