/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmValidable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.BuiltinTypes;
import org.netbeans.modules.cnd.modelimpl.csm.Instantiation;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.parser.FakeAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.utils.cache.TextCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeImpl
extends OffsetableBase
implements CsmType,
Resolver.SafeClassifierProvider {
    private final byte pointerDepth;
    private final boolean reference;
    private final byte arrayDepth;
    private final boolean _const;
    private final CharSequence classifierText;
    private final List<CsmType> instantiationParams = new ArrayList<CsmType>();
    private CharSequence[] qname = null;
    private int firstOffset;
    private CsmUID<CsmClassifier> classifierUID;

    TypeImpl(CsmClassifier csmClassifier, int n, boolean bl, int n2, AST aST, CsmFile csmFile) {
        super(aST, csmFile);
        this._setClassifier(csmClassifier);
        this.pointerDepth = (byte)n;
        this.reference = bl;
        this.arrayDepth = (byte)n2;
        this._const = TypeImpl.initIsConst(aST);
        if (csmClassifier == null) {
            this._setClassifier(this.initClassifier(aST));
            this.classifierText = this.initClassifierText(aST);
        } else {
            CharSequence charSequence = csmClassifier.getName();
            this.classifierText = charSequence == null || charSequence.length() == 0 ? this.initClassifierText(aST) : charSequence;
        }
    }

    TypeImpl(CsmClassifier csmClassifier, int n, boolean bl, int n2, AST aST, CsmFile csmFile, CsmOffsetable csmOffsetable) {
        super(csmFile, csmOffsetable);
        this._setClassifier(csmClassifier);
        this.pointerDepth = (byte)n;
        this.reference = bl;
        this.arrayDepth = (byte)n2;
        this._const = TypeImpl.initIsConst(aST);
        if (csmClassifier == null) {
            this._setClassifier(this.initClassifier(aST));
            this.classifierText = this.initClassifierText(aST);
        } else {
            CharSequence charSequence = csmClassifier.getName();
            this.classifierText = charSequence == null || charSequence.length() == 0 ? this.initClassifierText(aST) : charSequence;
        }
    }

    TypeImpl(AST aST, CsmFile csmFile, int n, boolean bl, int n2) {
        super(aST, csmFile);
        this.pointerDepth = (byte)n;
        this.reference = bl;
        this.arrayDepth = (byte)n2;
        this._const = TypeImpl.initIsConst(aST);
        this._setClassifier(this.initClassifier(aST));
        this.classifierText = this.initClassifierText(aST);
    }

    @Override
    protected CsmAST getEndAst(AST aST) {
        AST aST2 = aST;
        if (aST2 == null) {
            return null;
        }
        if ((aST2 = this.getLastNode(aST2)) instanceof CsmAST) {
            return (CsmAST)aST2;
        }
        return super.getEndAst(aST);
    }

    private AST getLastNode(AST aST) {
        AST aST2;
        for (AST aST3 = aST2 = aST; aST3 != null; aST3 = aST3.getNextSibling()) {
            switch (aST3.getType()) {
                case 281: 
                case 314: {
                    return AstUtil.getLastChildRecursively(aST2);
                }
            }
            aST2 = aST3;
        }
        return null;
    }

    public boolean isReference() {
        return this.reference;
    }

    public boolean isPointer() {
        return this.pointerDepth > 0;
    }

    public List<CsmType> getInstantiationParams() {
        return this.instantiationParams;
    }

    public boolean isInstantiation() {
        return !this.instantiationParams.isEmpty();
    }

    private static boolean initIsConst(AST aST) {
        if (aST != null) {
            for (AST aST2 = aST; aST2 != null; aST2 = aST2.getNextSibling()) {
                switch (aST2.getType()) {
                    case 50: 
                    case 51: 
                    case 52: {
                        return true;
                    }
                    case 281: 
                    case 314: {
                        return false;
                    }
                }
            }
        }
        return false;
    }

    public boolean isConst() {
        return this._const;
    }

    public String getCanonicalText() {
        return this.decorateText(this.classifierText, this, true, null).toString();
    }

    @Override
    public CharSequence getText() {
        return this.decorateText(this.classifierText, this, false, null).toString();
    }

    protected StringBuilder getText(boolean bl, CharSequence charSequence) {
        return this.decorateText(this.classifierText, this, bl, charSequence);
    }

    public StringBuilder decorateText(CharSequence charSequence, CsmType csmType, boolean bl, CharSequence charSequence2) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        if (csmType.isConst()) {
            stringBuilder.append("const ");
        }
        stringBuilder.append(charSequence);
        for (n = 0; n < csmType.getPointerDepth(); ++n) {
            stringBuilder.append('*');
        }
        if (csmType.isReference()) {
            stringBuilder.append('&');
        }
        for (n = 0; n < csmType.getArrayDepth(); ++n) {
            stringBuilder.append(bl ? "*" : "[]");
        }
        if (charSequence2 != null) {
            stringBuilder.append(' ');
            stringBuilder.append(charSequence2);
        }
        return stringBuilder;
    }

    private CharSequence initClassifierText(AST aST) {
        if (aST == null) {
            CsmClassifier csmClassifier = this._getClassifier();
            return csmClassifier == null ? "" : csmClassifier.getName();
        }
        StringBuilder stringBuilder = new StringBuilder();
        TypeImpl.addText(stringBuilder, AstRenderer.getFirstSiblingSkipQualifiers(aST));
        return TextCache.getString((CharSequence)stringBuilder.toString());
    }

    private static void addText(StringBuilder stringBuilder, AST aST) {
        if (!(aST instanceof FakeAST)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(aST.getText());
        }
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            TypeImpl.addText(stringBuilder, aST2);
        }
    }

    public CsmClassifier getClassifier() {
        return this.getClassifier(null);
    }

    public CharSequence getClassifierText() {
        return this.classifierText;
    }

    @Override
    public CsmClassifier getClassifier(Resolver resolver) {
        CsmClassifier csmClassifier = this._getClassifier();
        if (csmClassifier == null || csmClassifier instanceof CsmValidable && !((CsmValidable)csmClassifier).isValid()) {
            this._setClassifier(null);
            if (this.qname != null) {
                this._setClassifier(this.renderClassifier(this.qname, resolver));
            } else if (this.classifierText.length() > 0) {
                this._setClassifier(this.renderClassifier(new CharSequence[]{this.classifierText}, resolver));
            }
            csmClassifier = this._getClassifier();
        }
        if (this.isInstantiation() && CsmKindUtilities.isTemplate((CsmObject)csmClassifier) && !((CsmTemplate)csmClassifier).getTemplateParameters().isEmpty()) {
            csmClassifier = (CsmClassifier)Instantiation.create((CsmTemplate)csmClassifier, this);
        }
        return csmClassifier;
    }

    private CsmClassifier renderClassifier(CharSequence[] charSequenceArray, Resolver resolver) {
        CsmClassifier csmClassifier = null;
        Resolver resolver2 = ResolverFactory.createResolver(this.getContainingFile(), this.firstOffset, resolver);
        CsmObject csmObject = resolver2.resolve(charSequenceArray, 2);
        if (CsmKindUtilities.isClassifier((CsmObject)csmObject)) {
            csmClassifier = (CsmClassifier)csmObject;
        }
        if (csmClassifier == null) {
            csmClassifier = ((ProjectBase)this.getContainingFile().getProject()).getDummyForUnresolved(charSequenceArray, this.getContainingFile(), this.firstOffset);
        }
        return csmClassifier;
    }

    private CsmClassifier initClassifier(AST aST) {
        AST aST2 = AstRenderer.getFirstSiblingSkipQualifiers(aST);
        if (aST2 == null || aST2.getType() != 252 && aST2.getType() != 253 && aST2.getType() != 281) {
            return null;
        }
        if (aST2.getType() == 252) {
            return BuiltinTypes.getBuiltIn(aST2);
        }
        try {
            CsmAST csmAST = (CsmAST)aST2.getFirstChild();
            if (csmAST == null) {
                return null;
            }
            this.firstOffset = csmAST.getOffset();
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            for (CsmAST csmAST2 = csmAST; csmAST2 != null; csmAST2 = csmAST2.getNextSibling()) {
                if (n == 0 && csmAST2.getType() == 203) {
                    arrayList.add(csmAST2.getText());
                    continue;
                }
                if (csmAST2.getType() == 145) {
                    ++n;
                    continue;
                }
                if (csmAST2.getType() == 147) {
                    --n;
                    continue;
                }
                if (n == 0) {
                    if (csmAST2.getType() == 176 || !TraceFlags.DEBUG) continue;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append('[').append(csmAST2.getText());
                    if (csmAST2.getNumberOfChildren() == 0) {
                        stringBuilder.append(", line=").append(csmAST2.getLine());
                        stringBuilder.append(", column=").append(csmAST2.getColumn());
                    }
                    stringBuilder.append(']');
                    System.err.println("Incorect token: expected '::', found " + stringBuilder.toString());
                    continue;
                }
                if (csmAST2.getType() != 252 && csmAST2.getType() != 253) continue;
                this.instantiationParams.add(AstRenderer.renderType((AST)csmAST2, this.getContainingFile()));
            }
            this.qname = arrayList.toArray(new String[arrayList.size()]);
        }
        catch (Exception exception) {
            DiagnosticExceptoins.register(exception);
        }
        return null;
    }

    public int getArrayDepth() {
        return this.arrayDepth;
    }

    public int getPointerDepth() {
        return this.pointerDepth;
    }

    private CsmClassifier _getClassifier() {
        CsmClassifier csmClassifier = UIDCsmConverter.UIDtoDeclaration(this.classifierUID);
        return csmClassifier;
    }

    private void _setClassifier(CsmClassifier csmClassifier) {
        this.classifierUID = UIDCsmConverter.declarationToUID(csmClassifier);
        assert (this.classifierUID != null || csmClassifier == null);
    }

    public boolean isBuiltInBased(boolean bl) {
        CsmClassifier csmClassifier;
        if (bl) {
            csmClassifier = this.getClassifier();
            if (CsmKindUtilities.isTypedef((CsmObject)csmClassifier)) {
                return ((CsmTypedef)csmClassifier).getType().isBuiltInBased(true);
            }
        } else {
            csmClassifier = this._getClassifier();
        }
        return CsmKindUtilities.isBuiltIn((CsmObject)csmClassifier);
    }

    public String toString() {
        return "TYPE " + this.getText() + this.getOffsetString();
    }

    String getVariableDisplayName(String string) {
        return this.decorateText(this.classifierText, this, false, string).toString();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeInt(this.pointerDepth);
        dataOutput.writeBoolean(this.reference);
        dataOutput.writeInt(this.arrayDepth);
        dataOutput.writeBoolean(this._const);
        assert (this.classifierText != null);
        dataOutput.writeUTF(((Object)this.classifierText).toString());
        PersistentUtils.writeStrings(this.qname, dataOutput);
        dataOutput.writeInt(this.firstOffset);
        PersistentUtils.writeTypes(this.instantiationParams, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.classifierUID, dataOutput);
    }

    public TypeImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.pointerDepth = (byte)dataInput.readInt();
        this.reference = dataInput.readBoolean();
        this.arrayDepth = (byte)dataInput.readInt();
        this._const = dataInput.readBoolean();
        this.classifierText = NameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.classifierText != null);
        this.qname = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.firstOffset = dataInput.readInt();
        PersistentUtils.readTypes(this.instantiationParams, dataInput);
        this.classifierUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

