/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import antlr.collections.AST;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NamespaceDefinitionImpl
extends OffsetableDeclarationBase<CsmNamespaceDefinition>
implements CsmNamespaceDefinition,
MutableDeclarationsContainer,
Disposable {
    private List<CsmUID<CsmOffsetableDeclaration>> declarations = Collections.synchronizedList(new ArrayList());
    private final CharSequence name;
    private NamespaceImpl namespaceRef;
    private final CsmUID<CsmNamespace> namespaceUID;

    public NamespaceDefinitionImpl(AST aST, CsmFile csmFile, NamespaceImpl namespaceImpl) {
        super(aST, csmFile);
        assert (aST.getType() == 242);
        this.name = NameCache.getManager().getString((CharSequence)aST.getText());
        NamespaceImpl namespaceImpl2 = ((ProjectBase)csmFile.getProject()).findNamespaceCreateIfNeeded(namespaceImpl, this.name);
        this.namespaceUID = UIDCsmConverter.namespaceToUID(namespaceImpl2);
        assert (this.namespaceUID != null);
        this.namespaceRef = null;
        if (namespaceImpl2 instanceof NamespaceImpl) {
            namespaceImpl2.addNamespaceDefinition(this);
        }
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.NAMESPACE_DEFINITION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        Collection<CsmOffsetableDeclaration> collection;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            collection = UIDCsmConverter.UIDsToDeclarations(this.declarations);
        }
        return collection;
    }

    @Override
    public void addDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmUID csmUID = RepositoryUtils.put((CsmIdentifiable)csmOffsetableDeclaration);
        assert (csmUID != null);
        this.declarations.add((CsmUID<CsmOffsetableDeclaration>)csmUID);
        RepositoryUtils.put(this);
    }

    @Override
    public void removeDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        CsmUID<CsmOffsetableDeclaration> csmUID = UIDCsmConverter.declarationToUID(csmOffsetableDeclaration);
        assert (csmUID != null);
        boolean bl = this.declarations.remove(csmUID);
        assert (bl);
        RepositoryUtils.remove(csmUID);
        RepositoryUtils.put(this);
    }

    public CharSequence getQualifiedName() {
        return this.getNamespace().getQualifiedName();
    }

    public CsmNamespace getNamespace() {
        return this._getNamespaceImpl();
    }

    public CharSequence getName() {
        return this.name;
    }

    public CsmScope getScope() {
        return this.getContainingFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<CsmUID<CsmOffsetableDeclaration>> list;
        Collection<CsmOffsetableDeclaration> collection;
        super.dispose();
        this.onDispose();
        Object object = this.declarations;
        synchronized (object) {
            collection = this.getDeclarations();
            list = this.declarations;
            this.declarations = Collections.synchronizedList(new ArrayList());
        }
        Utils.disposeAll(collection);
        RepositoryUtils.remove(list);
        object = this._getNamespaceImpl();
        assert (object != null);
        ((NamespaceImpl)object).removeNamespaceDefinition(this);
    }

    private void onDispose() {
        if (TraceFlags.RESTORE_CONTAINER_FROM_UID) {
            this.namespaceRef = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(this.namespaceUID);
            assert (this.namespaceRef != null || this.namespaceUID == null) : "no object for UID " + this.namespaceUID;
        }
    }

    private NamespaceImpl _getNamespaceImpl() {
        NamespaceImpl namespaceImpl = this.namespaceRef;
        if (namespaceImpl == null) {
            namespaceImpl = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(this.namespaceUID);
            assert (namespaceImpl != null || this.namespaceUID == null) : "null object for UID " + this.namespaceUID;
        }
        return namespaceImpl;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        uIDObjectFactory.writeUIDCollection(this.declarations, dataOutput, true);
        assert (this.namespaceUID != null);
        uIDObjectFactory.writeUID(this.namespaceUID, dataOutput);
        assert (this.name != null);
        dataOutput.writeUTF(((Object)this.name).toString());
    }

    public NamespaceDefinitionImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        this.declarations = uIDObjectFactory.readUIDCollection(Collections.synchronizedList(new ArrayList()), dataInput);
        this.namespaceUID = uIDObjectFactory.readUID(dataInput);
        assert (this.namespaceUID != null);
        this.namespaceRef = null;
        this.name = NameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.name != null);
    }
}

