/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.cache.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

abstract class AbstractCacheIndex
implements Serializable {
    private static final long serialVersionUID = -7790789617759717718L;
    private Object indexLock = new Object();
    private Map<CharSequence, Object> index = new HashMap<CharSequence, Object>();

    protected AbstractCacheIndex() {
    }

    protected abstract CharSequence getIndexKey(Object var1);

    protected abstract Object createValue(CharSequence var1, Object var2);

    protected abstract CharSequence getBaseCacheName(Object var1);

    protected abstract boolean isEqual(Object var1, CharSequence var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object get(Object object) {
        CharSequence charSequence = this.getIndexKey(object);
        assert (charSequence != null);
        Object object2 = this.indexLock;
        synchronized (object2) {
            assert (this.index != null);
            return this.index.get(charSequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object put(Object object) {
        CharSequence charSequence = this.getIndexKey(object);
        CharSequence charSequence2 = this.getBaseCacheName(object);
        Object object2 = this.createUniqValueImpl(charSequence2, object);
        assert (charSequence != null && charSequence.length() > 0);
        assert (object2 != null);
        Object object3 = this.indexLock;
        synchronized (object3) {
            assert (this.index != null);
            this.index.put(charSequence, object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object createUniqValueImpl(CharSequence charSequence, Object object) {
        assert (charSequence != null);
        assert (charSequence.length() > 0);
        int n = 0;
        CharSequence charSequence2 = charSequence;
        while (true) {
            boolean bl = false;
            Object object2 = this.indexLock;
            synchronized (object2) {
                Iterator<Object> iterator = this.index.values().iterator();
                while (iterator.hasNext() && !bl) {
                    Object object3 = iterator.next();
                    if (!this.isEqual(object3, charSequence2)) continue;
                    bl = true;
                }
            }
            if (!bl) {
                return this.createValue(charSequence2, object);
            }
            charSequence2 = ((Object)charSequence).toString() + n++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(File file) {
        ObjectInputStream objectInputStream = null;
        try {
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                inputStream = new BufferedInputStream(inputStream);
                objectInputStream = new ObjectInputStream(inputStream);
            }
            finally {
                if (inputStream != null && objectInputStream == null) {
                    inputStream.close();
                }
            }
            if (objectInputStream != null) {
                this.loadData(objectInputStream);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadData(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        if (n >= 1) {
            Map map = (Map)objectInputStream.readObject();
            Object object = this.indexLock;
            synchronized (object) {
                this.index = map;
            }
        }
        assert (this.index != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(File file) {
        ObjectOutputStream objectOutputStream = null;
        try {
            OutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(file);
                outputStream = new BufferedOutputStream(outputStream);
                objectOutputStream = new ObjectOutputStream(outputStream);
            }
            finally {
                if (outputStream != null && objectOutputStream == null) {
                    outputStream.close();
                }
            }
            if (objectOutputStream != null) {
                this.saveData(objectOutputStream);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveData(ObjectOutputStream objectOutputStream) throws IOException {
        int n = 1;
        objectOutputStream.writeInt(n);
        Object object = this.indexLock;
        synchronized (object) {
            objectOutputStream.writeObject(this.index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.indexLock;
        synchronized (object) {
            return this.index.toString();
        }
    }
}

