/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu.statistics.drilldown;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.DrillDownPieChartModel;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.IDrillDown;

public class ProjectPieChartModel
extends DrillDownPieChartModel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.Bundle");
    private static final String SELF_BADGE_TEXT = messages.getString("ProjectPieChartModel_SelfBadgeText");

    public ProjectPieChartModel(IDrillDown iDrillDown) {
        super(iDrillDown);
    }

    public String getItemName(int n) {
        return this.getItemNameAt(this.getMappedIndex(n));
    }

    public double getItemValue(int n) {
        double d = this.getItemValueAt(this.getMappedIndex(n));
        System.out.println("Getting value for category n." + n + "  : " + d);
        return d;
    }

    public double getItemValueRel(int n) {
        long l = this.drillDown.getCurrentTime(false);
        long l2 = 0L;
        for (int i = 0; i < this.drillDown.getSubmarks().size(); ++i) {
            l2 = (long)((double)l2 + this.getItemValueAt(i));
        }
        if (l2 != l) {
            System.err.println("time mismatch: " + l + " != " + l2);
        }
        if (l == 0L) {
            return 1.0;
        }
        return this.getItemValueAt(this.getMappedIndex(n)) / (double)l;
    }

    public boolean isSelectable(int n) {
        if (this.drillDown.getSubmarks().size() <= n) {
            return false;
        }
        if (n != -1) {
            return this.drillDown.canDrilldown((Mark)this.drillDown.getSubmarks().get(n));
        }
        return false;
    }

    private String getItemNameAt(int n) {
        if (this.drillDown.getSubmarks().size() <= n) {
            return "";
        }
        if ((n == -1 || this.drillDown.isCurrent((Mark)this.drillDown.getSubmarks().get(n))) && !this.drillDown.isInSelf()) {
            return MessageFormat.format(SELF_BADGE_TEXT, this.drillDown.getCurrentMark().description);
        }
        return ((Mark)this.drillDown.getSubmarks().get((int)n)).description;
    }

    private double getItemValueAt(int n) {
        if (this.drillDown.getSubmarks().size() <= n) {
            return 0.0;
        }
        if ((n == -1 || this.drillDown.isCurrent((Mark)this.drillDown.getSubmarks().get(n))) && !this.drillDown.isInSelf()) {
            return this.drillDown.getCurrentTime(true);
        }
        return this.drillDown.getMarkTime((Mark)this.drillDown.getSubmarks().get(n), false);
    }
}

