/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu.statistics.drilldown;

import java.awt.Color;
import java.util.List;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.lib.profiler.ui.charts.AbstractPieChartModel;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.DrillDownListener;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.IDrillDown;

public abstract class DrillDownPieChartModel
extends AbstractPieChartModel
implements DrillDownListener {
    private static Color[] COLORS = new Color[]{new Color(0x99FF99), new Color(0x99CC99), new Color(0x666633), new Color(0x336666), new Color(0x6699CC), new Color(0x9999CC), new Color(0xFFCCFF), new Color(0xCC9999), new Color(0x660099), new Color(26112)};
    protected IDrillDown drillDown;
    private Object itemMapLock = new Object();
    private int[] itemMap = null;
    private int itemCount = 0;

    public DrillDownPieChartModel(IDrillDown iDrillDown) {
        this.setDrillDown(iDrillDown);
    }

    public void setDrillDown(IDrillDown iDrillDown) {
        if (this.drillDown != null) {
            this.drillDown.removeListener(this);
        }
        this.drillDown = iDrillDown;
        this.updateItemMap();
        this.drillDown.addListener(this);
    }

    public Color getItemColor(int n) {
        if (n == -1) {
            return Color.BLACK;
        }
        return COLORS[n % COLORS.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getItemCount() {
        Object object = this.itemMapLock;
        synchronized (object) {
            return this.itemCount;
        }
    }

    public String getItemDescription(int n) {
        if (n == -1 || this.getMappedIndex(n) == -1) {
            return "";
        }
        return ((Mark)this.drillDown.getSubmarks().get((int)this.getMappedIndex((int)n))).description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataChanged() {
        Object object = this.itemMapLock;
        synchronized (object) {
            this.updateItemMap();
        }
        this.fireChartDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drillDownPathChanged(List list) {
        Object object = this.itemMapLock;
        synchronized (object) {
            this.updateItemMap();
        }
        this.fireChartDataChanged();
    }

    public void drilldown(int n) {
        if (n == -1 || this.getMappedIndex(n) == -1) {
            return;
        }
        if (this.drillDown.getSubmarks().isEmpty()) {
            return;
        }
        this.drillDown.drilldown((Mark)this.drillDown.getSubmarks().get(this.getMappedIndex(n)));
    }

    public void drillup() {
        this.drillDown.drillup();
    }

    public void drillup(int n) {
        if (n == -1 || this.getMappedIndex(n) == -1) {
            return;
        }
        this.drillDown.drillup((Mark)this.drillDown.getSubmarks().get(this.getMappedIndex(n)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasData() {
        Object object = this.itemMapLock;
        synchronized (object) {
            return this.drillDown != null && this.itemCount > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getMappedIndex(int n) {
        Object object = this.itemMapLock;
        synchronized (object) {
            if (n < 0 || n >= this.itemMap.length) {
                return -1;
            }
            return this.itemMap[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateItemMap() {
        Object object = this.itemMapLock;
        synchronized (object) {
            int n = 0;
            int n2 = 0;
            int[] nArray = new int[this.drillDown.getSubmarks().size()];
            for (Mark mark : this.drillDown.getSubmarks()) {
                if (this.drillDown.getMarkTime(mark, false) > 0L) {
                    nArray[n2++] = n;
                }
                ++n;
            }
            this.itemCount = n2 > 0 ? n2 : 0;
            this.itemMap = nArray;
        }
    }
}

