/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu.statistics.drilldown;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.RuntimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.lib.profiler.ui.charts.PieChart;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.cpu.StatisticsPanel;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModule;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.DrillDownListener;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.IDrillDown;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.ProjectPieChartModel;

public class DrillDownPanel
extends StatisticalModule {
    private DrillDownListener listener = new DrillDownListener(){

        public void dataChanged() {
        }

        public void drillDownPathChanged(List list) {
            DrillDownPanel.this.updateCrumbNav();
        }
    };
    private HTMLTextArea crumbNav;
    private IDrillDown ddModel;
    private PieChart pieChart;
    private ProjectPieChartModel pieModel = null;
    private StatisticsPanel panel = null;
    private int lastNavigableCategory;

    public DrillDownPanel(IDrillDown iDrillDown) {
        this.ddModel = iDrillDown;
        this.ddModel.addListener(this.listener);
        this.initComponents();
    }

    public void addSnippet(StatisticalModule statisticalModule) {
        this.panel.addSnippet(statisticalModule);
    }

    public void pause() {
    }

    public void refresh(RuntimeCPUCCTNode runtimeCPUCCTNode) {
    }

    public void removeSnippet(StatisticalModule statisticalModule) {
        this.panel.removeSnippet(statisticalModule);
    }

    public void resume() {
    }

    private synchronized HTMLTextArea getCrumbNav() {
        if (this.crumbNav == null) {
            this.crumbNav = new HTMLTextArea();
            this.crumbNav.setOpaque(false);
            this.crumbNav.addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    String string = hyperlinkEvent.getURL().getQuery();
                    if (hyperlinkEvent.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                        return;
                    }
                    int n = hyperlinkEvent.getURL().getQuery().lastIndexOf(61);
                    if (n <= -1) {
                        return;
                    }
                    int n2 = Integer.parseInt(string.substring(n + 1));
                    DrillDownPanel.this.ddModel.drillup((Mark)DrillDownPanel.this.ddModel.getDrillDownPath().get(n2));
                }
            });
            this.updateCrumbNav();
        }
        return this.crumbNav;
    }

    private synchronized PieChart getPieChart() {
        if (this.pieChart == null) {
            this.pieChart = new PieChart();
            this.pieModel = new ProjectPieChartModel(this.ddModel);
            this.pieChart.setModel(this.pieModel);
        }
        return this.pieChart;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.panel = new StatisticsPanel(this.getCrumbNav(), this.getPieChart(), new Runnable(){

            public void run() {
                DrillDownPanel.this.navigateOneLevelBack();
            }
        });
        this.panel.addListener(new StatisticsPanel.Listener(){

            public void itemClicked(int n) {
                DrillDownPanel.this.pieModel.drilldown(n);
            }
        });
        this.add((Component)this.panel, "Center");
    }

    private void navigateOneLevelBack() {
        if (this.lastNavigableCategory != -1) {
            this.ddModel.drillup((Mark)this.ddModel.getDrillDownPath().get(this.lastNavigableCategory));
        }
    }

    private synchronized void updateCrumbNav() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        this.lastNavigableCategory = -1;
        Iterator iterator = this.ddModel.getDrillDownPath().iterator();
        while (iterator.hasNext()) {
            Mark mark = (Mark)iterator.next();
            if (iterator.hasNext()) {
                stringBuilder.append("<a href=\"http://localhost/category?id=").append(n).append("\">").append(mark.description).append("</a>").append("/");
                this.lastNavigableCategory = n;
            } else {
                stringBuilder.append(mark.description);
            }
            this.crumbNav.setText(stringBuilder.toString());
            ++n;
        }
    }
}

