/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.FlatProfilePanel;

public class LiveFlatProfileCollectorPanel
extends FlatProfilePanel
implements LiveResultsPanel {
    private JPopupMenu popup;
    private TargetAppRunner runner = null;
    private boolean firstTime = true;
    private boolean updateResultsInProgress = false;
    private boolean updateResultsPending = false;

    public LiveFlatProfileCollectorPanel(TargetAppRunner targetAppRunner, CPUResUserActionsHandler cPUResUserActionsHandler, CPUSelectionHandler cPUSelectionHandler) {
        super(cPUResUserActionsHandler, cPUSelectionHandler);
        this.runner = targetAppRunner;
        this.initComponents();
    }

    public void setDataToDisplay(FlatProfileContainer flatProfileContainer) {
        this.threadId = -1;
        this.flatProfileContainer = flatProfileContainer;
        this.collectingTwoTimeStamps = this.flatProfileContainer.isCollectingTwoTimeStamps();
        this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterStrings(this.filterString), this.filterType, this.valueFilterValue);
        this.prepareResults(this.firstTime);
        this.firstTime = false;
        this.setResultsAvailable(this.hasData());
    }

    public BufferedImage getViewImage(boolean bl) {
        if (bl) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    public String getViewName() {
        return "cpu-live";
    }

    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    public void handleRemove() {
    }

    public void handleShutdown() {
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = false;
            this.popup.setVisible(false);
        }
    }

    public boolean hasData() {
        return this.flatProfileContainer != null && this.flatProfileContainer.getNRows() > 0;
    }

    public boolean hasView() {
        return this.resTable != null;
    }

    public void prepareResults() {
        super.prepareResults();
    }

    public boolean supports(int n) {
        return n == 2 || n == 3;
    }

    public void updateLiveResults() {
        FlatProfileProvider flatProfileProvider;
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = true;
            return;
        }
        if (this.updateResultsInProgress) {
            return;
        }
        this.updateResultsInProgress = true;
        String string = null;
        if (this.resTable != null) {
            int n = this.resTable.getSelectedRow();
            if (n >= this.resTable.getRowCount()) {
                n = -1;
                this.resTable.clearSelection();
            }
            if (n != -1) {
                string = this.resTable.getValueAt(n, 0).toString();
            }
        }
        if ((flatProfileProvider = this.runner.getProfilerClient().getFlatProfileProvider()) != null) {
            FlatProfileContainer flatProfileContainer = flatProfileProvider.createFlatProfile();
            int n = 2;
            boolean bl = false;
            do {
                bl = false;
                if (flatProfileContainer != null) {
                    this.setDataToDisplay(flatProfileContainer);
                    if (string != null) {
                        this.resTable.selectRowByContents(string, 0, false);
                    }
                } else {
                    bl = true;
                }
                if (!bl) continue;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    bl = false;
                }
            } while (--n > 0 && bl);
        }
        this.updateResultsInProgress = false;
    }

    protected String[] getMethodClassNameAndSig(int n, int n2) {
        ProfilingSessionStatus profilingSessionStatus = this.runner.getProfilingSessionStatus();
        String string = profilingSessionStatus.getInstrMethodClasses()[n];
        if (n2 == 0) {
            String string2 = profilingSessionStatus.getInstrMethodNames() != null ? profilingSessionStatus.getInstrMethodNames()[n] : null;
            String string3 = profilingSessionStatus.getInstrMethodSignatures() != null ? profilingSessionStatus.getInstrMethodSignatures()[n] : null;
            return new String[]{string, string2, string3};
        }
        return new String[]{string, null, null};
    }

    protected JPopupMenu createPopupMenu() {
        if (this.popup == null) {
            this.popup = super.createPopupMenu();
        }
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (LiveFlatProfileCollectorPanel.this.updateResultsPending) {
                            LiveFlatProfileCollectorPanel.this.updateLiveResults();
                            LiveFlatProfileCollectorPanel.this.updateResultsPending = false;
                        }
                    }
                });
            }
        });
        return this.popup;
    }

    protected void obtainResults() {
        if (!this.collectingTwoTimeStamps && this.sortBy == 3) {
            this.sortBy = 2;
        }
        this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterStrings(this.filterString), this.filterType, this.valueFilterValue);
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
    }

    protected void showReverseCallGraph(int n, int n2, int n3, int n4, boolean bl) {
        throw new IllegalStateException();
    }

    protected boolean supportsReverseCallGraph() {
        return false;
    }

    protected boolean supportsSubtreeCallGraph() {
        return false;
    }

    void setSelectedRowString(String string) {
        if (string != null) {
            this.resTable.selectRowByContents(string, 0, false);
        }
    }

    String getSelectedRowString() {
        String string = null;
        if (this.resTable != null) {
            int n = this.resTable.getSelectedRow();
            if (n >= this.resTable.getRowCount()) {
                n = -1;
                this.resTable.clearSelection();
            }
            if (n != -1) {
                string = this.resTable.getValueAt(n, 0).toString();
            }
        }
        return string;
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(800, 600));
    }
}

