/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.components.ThinBevelBorder;

public class DiscreteProgress
extends JPanel {
    private Color disabledColor = new Color(220, 220, 220);
    private Color enabledColor = new Color(128, 128, 255);
    private int activeUnits = 0;
    private int totalUnits = 10;
    private int unitHeight = 13;
    private int unitWidth = 10;

    public DiscreteProgress() {
        super(new BorderLayout());
        this.setBorder(new ThinBevelBorder(1));
        this.setOpaque(false);
    }

    public void setActiveUnits(int n) {
        if (this.activeUnits != n) {
            this.activeUnits = n;
            this.repaint();
        }
    }

    public int getActiveUnits() {
        return this.activeUnits;
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.totalUnits * this.unitWidth + this.totalUnits - 1 + 4, this.unitHeight + 4);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        DiscreteProgress discreteProgress = new DiscreteProgress();
        JFrame jFrame = new JFrame("Decimal Progress Test Frame");
        jFrame.getContentPane().add(discreteProgress);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void paintComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        for (int i = 0; i < this.totalUnits; ++i) {
            graphics.setColor(i < this.activeUnits ? this.enabledColor : this.disabledColor);
            graphics.fillRect(n + i * this.unitWidth + i, n2, this.unitWidth, this.unitHeight);
        }
    }
}

