/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.drawingarea.dataobject;

import java.io.IOException;
import java.util.Arrays;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.uml.drawingarea.dataobject.DiagramDataObject;
import org.netbeans.modules.uml.ui.support.ProductHelper;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.windows.CloneableOpenSupport;

public class DiagramEditorSupport
extends DataEditorSupport
implements EditorCookie.Observable,
CloseCookie,
PrintCookie {
    private final CookieSet cookies;
    private DiagramDataObject diagramDataObject;

    public DiagramEditorSupport(MultiDataObject.Entry entry, DiagramDataObject diagramDataObject, CookieSet cookieSet) {
        super((DataObject)diagramDataObject, (CloneableEditorSupport.Env)new Environment((DataObject)diagramDataObject));
        this.setMIMEType("text/xml");
        this.diagramDataObject = diagramDataObject;
        this.cookies = cookieSet;
    }

    public void openDiagramEditor() {
        try {
            FileObject fileObject = this.diagramDataObject.getDiagramFile();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            String string = FileUtil.toFile((FileObject)fileObject).getCanonicalPath();
            if (Arrays.asList(projectArray).contains(project)) {
                ProductHelper.getProductDiagramManager().openDiagram(string, false, null);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static final class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -1L;

        public Environment(DataObject dataObject) {
            super(dataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((DiagramDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(DiagramEditorSupport.class);
        }
    }
}

