/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.project.spi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xslt.project.spi.ProjectsFilesChangeListener;
import org.netbeans.modules.xslt.project.spi.ProjectsFilesChangesSupport;
import org.netbeans.modules.xslt.tmap.util.Util;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

public class ProjectsFilesChangeHandler {
    private Lock writeLock = new ReentrantReadWriteLock().writeLock();
    private Project myCurrentProject;
    private ProjectsFileChangeListener myFileChangeListener;
    private static HashMap<String, Object> SUPPORTED_EXTS = new HashMap();
    private ProjectsFilesChangesSupport myChangesSupport = new ProjectsFilesChangesSupport();
    private LinkedHashSet<FileObject> supportedFos = new LinkedHashSet();
    private Set<FileObject> subscribedFos = new HashSet<FileObject>();

    public ProjectsFilesChangeHandler(Project project) {
        if (project == null) {
            throw new IllegalStateException("context project shouldn't be null");
        }
        this.myCurrentProject = project;
        this.myFileChangeListener = new ProjectsFileChangeListener();
    }

    public void subscribes() {
        this.subscribes(this.myCurrentProject);
    }

    public void subscribes(Project project) {
        if (project == null) {
            return;
        }
        FileObject[] fileObjectArray = Util.getProjectSources((Project)project);
        if (fileObjectArray == null) {
            return;
        }
        for (FileObject fileObject : fileObjectArray) {
            this.subscribes(fileObject);
        }
    }

    private void subscribes(FileObject fileObject) {
        if (fileObject == null) {
            return;
        }
        fileObject.addFileChangeListener((FileChangeListener)this.myFileChangeListener);
        this.add2cache(fileObject);
        FileObject[] fileObjectArray = null;
        if (fileObject.isFolder()) {
            fileObjectArray = fileObject.getChildren();
        }
        if (fileObjectArray != null) {
            for (FileObject fileObject2 : fileObjectArray) {
                this.subscribes(fileObject2);
            }
        }
    }

    public void addProjectsFilesChangeListener(ProjectsFilesChangeListener projectsFilesChangeListener) {
        this.myChangesSupport.addPropertyChangeListener(projectsFilesChangeListener);
    }

    public void removeProjectsFilesChangeListener(ProjectsFilesChangeListener projectsFilesChangeListener) {
        this.myChangesSupport.removePropertyChangeListener(projectsFilesChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add2cache(FileObject fileObject) {
        assert (fileObject != null);
        this.writeLock.lock();
        try {
            boolean bl;
            this.subscribedFos.add(fileObject);
            if (ProjectsFilesChangeHandler.isSupportedFo(fileObject) && (bl = this.supportedFos.add(fileObject))) {
                // empty if block
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(FileObject fileObject) {
        assert (fileObject != null);
        this.writeLock.lock();
        try {
            this.subscribedFos.remove(fileObject);
            boolean bl = this.supportedFos.remove(fileObject);
            if (bl) {
                // empty if block
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void clearCache() {
        this.subscribedFos.clear();
        this.supportedFos.clear();
    }

    public void unsubscribes() {
        for (FileObject fileObject : this.subscribedFos) {
            fileObject.removeFileChangeListener((FileChangeListener)this.myFileChangeListener);
        }
        this.clearCache();
        this.myChangesSupport.removeAllPropertyChangeListener();
    }

    private static boolean isSupportedFo(FileObject fileObject) {
        if (fileObject == null || fileObject.isFolder() || fileObject.isVirtual()) {
            return false;
        }
        String string = fileObject.getExt();
        return string != null && SUPPORTED_EXTS.get(string) != null;
    }

    static {
        SUPPORTED_EXTS.put("wsdl", Boolean.TRUE);
        SUPPORTED_EXTS.put("xsd", Boolean.TRUE);
    }

    private class ProjectsFileChangeListener
    implements FileChangeListener {
        private ProjectsFileChangeListener() {
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            ProjectsFilesChangeHandler.this.subscribes(fileObject);
        }

        public void fileDataCreated(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            ProjectsFilesChangeHandler.this.add2cache(fileObject);
            if (ProjectsFilesChangeHandler.isSupportedFo(fileObject)) {
                ProjectsFilesChangeHandler.this.myChangesSupport.fireFileAdded(fileObject);
            }
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
            FileObject fileObject = fileEvent.getFile();
            if (ProjectsFilesChangeHandler.isSupportedFo(fileObject)) {
                fileObject.removeFileChangeListener((FileChangeListener)this);
                ProjectsFilesChangeHandler.this.myChangesSupport.fireFileDeleted(fileObject);
                ProjectsFilesChangeHandler.this.removeFromCache(fileObject);
            }
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            FileObject fileObject = fileRenameEvent.getFile();
            if (ProjectsFilesChangeHandler.isSupportedFo(fileObject)) {
                ProjectsFilesChangeHandler.this.myChangesSupport.fireFileRenamed(fileRenameEvent);
            }
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        }
    }
}

