/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.ui;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.ui.ElementHeaderFormater;

public final class ElementHeaders {
    public static final String ANNOTATIONS = "%annotations%";
    public static final String NAME = "%name%";
    public static final String TYPE = "%type%";
    public static final String THROWS = "%throws%";
    public static final String IMPLEMENTS = "%implements%";
    public static final String EXTENDS = "%extends%";
    public static final String TYPEPARAMETERS = "%typeparameters%";
    public static final String FLAGS = "%flags%";
    public static final String PARAMETERS = "%parameters%";

    private ElementHeaders() {
    }

    public static String getHeader(TreePath treePath, CompilationInfo compilationInfo, String string) {
        assert (compilationInfo != null);
        assert (treePath != null);
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element != null) {
            return ElementHeaders.getHeader(element, compilationInfo, string);
        }
        return null;
    }

    public static String getHeader(Element element, CompilationInfo compilationInfo, String string) {
        assert (element != null);
        assert (compilationInfo != null);
        assert (string != null);
        Tree tree = compilationInfo.getTrees().getTree(element);
        if (tree != null) {
            if (tree.getKind() == Tree.Kind.METHOD) {
                return ElementHeaderFormater.getMethodHeader((MethodTree)((MethodTree)tree), (CompilationInfo)compilationInfo, (String)string);
            }
            if (tree.getKind() == Tree.Kind.CLASS) {
                return ElementHeaderFormater.getClassHeader((ClassTree)((ClassTree)tree), (CompilationInfo)compilationInfo, (String)string);
            }
            if (tree.getKind() == Tree.Kind.VARIABLE) {
                return ElementHeaderFormater.getVariableHeader((VariableTree)((VariableTree)tree), (CompilationInfo)compilationInfo, (String)string);
            }
        }
        return string.replaceAll(NAME, element.getSimpleName().toString()).replaceAll("%[a-z]*%", "");
    }

    public static int getDistance(String string, String string2) {
        int n;
        int n2;
        int n3 = string.length();
        int n4 = string2.length();
        if (n3 == 0) {
            return n4;
        }
        if (n4 == 0) {
            return n3;
        }
        int[][] nArray = new int[n3 + 1][n4 + 1];
        for (n2 = 0; n2 <= n3; ++n2) {
            nArray[n2][0] = n2;
        }
        for (n = 0; n <= n4; ++n) {
            nArray[0][n] = n;
        }
        for (n2 = 1; n2 <= n3; ++n2) {
            char c = string.charAt(n2 - 1);
            for (n = 1; n <= n4; ++n) {
                char c2 = string2.charAt(n - 1);
                int n5 = c == c2 ? 0 : 1;
                nArray[n2][n] = ElementHeaders.min(nArray[n2 - 1][n] + 1, nArray[n2][n - 1] + 1, nArray[n2 - 1][n - 1] + n5);
            }
        }
        return nArray[n3][n4];
    }

    private static int min(int n, int n2, int n3) {
        int n4 = n;
        if (n2 < n4) {
            n4 = n2;
        }
        if (n3 < n4) {
            n4 = n3;
        }
        return n4;
    }
}

