/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.model;

import com.sun.webui.jsf.model.FileChooserItem;
import com.sun.webui.jsf.model.ResourceItem;
import com.sun.webui.jsf.model.ResourceModel;
import com.sun.webui.jsf.model.ResourceModelException;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.FilterUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;

public class FileChooserModel
implements ResourceModel,
Serializable {
    private static final String WINDOWS_OS = "window";
    private static final String SPACE = String.valueOf('\u00a0');
    private static final String WINDOWS_ROOT = "c:\\";
    private static final String UNIX_ROOT = "/";
    private static final String DEFAULT_SERVER = "localhost";
    private String root = null;
    private String separatorString = File.separator;
    private String currentDir = null;
    private String filterValue = "*";
    private String sortValue = null;
    private boolean folderChooser = false;
    private boolean typeSet = false;
    private String serverName = null;
    private transient Collator collator = null;

    public FileChooserModel() {
        FacesContext context = FacesContext.getCurrentInstance();
        this.root = this.isWindows() ? WINDOWS_ROOT : UNIX_ROOT;
        try {
            this.serverName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ukhe) {
            this.serverName = DEFAULT_SERVER;
        }
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name").toUpperCase();
        return osName.startsWith(WINDOWS_OS.toUpperCase());
    }

    public String getAbsoluteRoot() {
        return this.root;
    }

    public String[] getRoots() {
        File[] roots = File.listRoots();
        int len = roots.length;
        boolean isWindows = this.isWindows();
        if (isWindows) {
            ++len;
        }
        String[] strRoots = new String[len];
        for (int i = 0; i < roots.length; ++i) {
            strRoots[i] = roots[i].getPath();
        }
        if (isWindows) {
            strRoots[len] = File.separator;
        }
        return strRoots;
    }

    public void setAbsoluteRoot(String absRoot) {
        if (absRoot != null) {
            this.root = absRoot;
        }
    }

    public String getSeparatorString() {
        return this.separatorString;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        if (serverName != null) {
            this.serverName = serverName;
        }
    }

    public String getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(String filterValue) {
        if (filterValue != null) {
            this.validateFilterValue(filterValue);
            this.filterValue = filterValue;
        }
    }

    public String getSortValue() {
        return this.sortValue;
    }

    public void setSortValue(String sortValue) {
        if (sortValue != null) {
            this.validateSortValue(sortValue);
            this.sortValue = sortValue;
        }
    }

    public String getCurrentDir() {
        if (this.currentDir != null) {
            return this.currentDir;
        }
        return this.getAbsoluteRoot();
    }

    public void setCurrentDir(String dir) throws ResourceModelException {
        if (dir != null && dir.length() > 0) {
            this.validateFolder(dir);
            this.currentDir = dir;
        }
    }

    public ResourceItem[] getFolderContent(String folder, boolean disableFiles, boolean disableFolders) {
        int i;
        FacesContext context = FacesContext.getCurrentInstance();
        Vector<FileChooserItem> optList = new Vector<FileChooserItem>();
        ResourceItem[] fileEntries = null;
        FilterUtil filter = new FilterUtil(this.getFilterValue());
        boolean filesExist = false;
        if (folder == null) {
            folder = this.getCurrentDir();
        }
        if (folder == null) {
            return null;
        }
        File file = new File(folder);
        File[] fileList = file.listFiles();
        if (fileList == null || fileList.length == 0) {
            return null;
        }
        ArrayList<File> justFiles = new ArrayList<File>();
        ArrayList<File> justDirs = new ArrayList<File>();
        for (int i2 = 0; i2 < fileList.length; ++i2) {
            if (fileList[i2].isDirectory()) {
                justDirs.add(fileList[i2]);
                continue;
            }
            justFiles.add(fileList[i2]);
        }
        File[] fileArray = new File[justFiles.size()];
        for (int i3 = 0; i3 < justFiles.size(); ++i3) {
            fileArray[i3] = (File)justFiles.get(i3);
        }
        File[] dirArray = new File[justDirs.size()];
        for (int i4 = 0; i4 < justDirs.size(); ++i4) {
            dirArray[i4] = (File)justDirs.get(i4);
        }
        this.sort(fileArray, this.getSortValue());
        this.sort(dirArray, this.getSortValue());
        for (int count = 0; count < justDirs.size(); ++count) {
            fileList[count] = dirArray[count];
        }
        for (int j = 0; j < justFiles.size(); ++j) {
            fileList[count + j] = fileArray[j];
        }
        for (i = 0; i < fileList.length; ++i) {
            String name = fileList[i].getName();
            boolean bSelectable = false;
            boolean bIsDirectory = fileList[i].isDirectory();
            boolean disabled = false;
            if (!bIsDirectory) {
                if (!filter.accept(fileList[i])) continue;
                bSelectable = true;
                if (disableFiles) {
                    disabled = true;
                }
            } else {
                bSelectable = true;
            }
            FileChooserItem item = this.getItem(fileList[i], context, disabled);
            optList.addElement(item);
            filesExist = true;
        }
        if (filesExist) {
            fileEntries = new FileChooserItem[optList.size()];
            for (i = 0; i < optList.size(); ++i) {
                fileEntries[i] = (FileChooserItem)optList.elementAt(i);
            }
            return fileEntries;
        }
        return null;
    }

    public ResourceItem getResourceItem(String itemKey) {
        FacesContext context = FacesContext.getCurrentInstance();
        String resource = null;
        String[] strArray = itemKey.split("=");
        if (strArray == null) {
            return null;
        }
        resource = strArray.length == 2 ? strArray[1] : strArray[0];
        File f = new File(resource);
        return this.getItem(f, context, false);
    }

    public boolean isFolderType(String path) {
        File f = new File(path);
        return f.isDirectory();
    }

    public boolean canRead(String resourceName) {
        File f = new File(resourceName);
        return f.canRead();
    }

    public boolean canWrite(String resourceName) {
        File f = new File(resourceName);
        return f.canWrite();
    }

    protected FileChooserItem getItem(File file, FacesContext context, boolean disabled) {
        Theme theme = this.getTheme();
        int fileNameLen = Integer.parseInt(theme.getMessage("filechooser.fileNameLen"));
        int fileSizeLen = Integer.parseInt(theme.getMessage("filechooser.fileSizeLen"));
        int fileDateLen = Integer.parseInt(theme.getMessage("filechooser.fileDateLen"));
        Locale locale = context.getViewRoot().getLocale();
        SimpleDateFormat dateFormat = null;
        try {
            String defaultPattern = ThemeUtilities.getTheme(context).getMessage("filechooser.dateFormat");
            dateFormat = new SimpleDateFormat(defaultPattern, locale);
        }
        catch (Exception e) {
            dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale);
            String pattern = ComponentUtilities.getDefaultDatePattern(dateFormat.toPattern(), locale);
            dateFormat.applyPattern(pattern);
        }
        SimpleDateFormat timeFormat = null;
        try {
            String tf = theme.getMessage("filechooser.timeFormat");
            timeFormat = new SimpleDateFormat(tf, locale);
        }
        catch (Exception e) {
            timeFormat = (SimpleDateFormat)SimpleDateFormat.getTimeInstance(3, locale);
            String pattern = timeFormat.toPattern();
            pattern = pattern.replaceFirst("[ ]*a[ ]*", "");
            pattern = pattern.replaceFirst("[hH]+", "HH");
            timeFormat.applyPattern(pattern);
        }
        String name = file.getName();
        String value = null;
        if (file.isDirectory()) {
            name = name + File.separator;
            value = "folder=" + file.getAbsolutePath();
        } else {
            value = "file=" + file.getAbsolutePath();
        }
        name = this.getDisplayString(name, fileNameLen);
        String size = Long.toString(file.length());
        size = this.getDisplayString(size, fileSizeLen);
        Date modifiedDate = new Date(file.lastModified());
        String date = dateFormat.format(modifiedDate);
        String time = timeFormat.format(modifiedDate);
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(name).append(SPACE).append(SPACE).append(SPACE).append(size).append(SPACE).append(SPACE).append(date).append(SPACE).append(time);
        FileChooserItem item = new FileChooserItem(file);
        item.setItemKey(value);
        item.setItemLabel(buffer.toString());
        item.setItemDisabled(disabled);
        return item;
    }

    private String getDisplayString(String str, int maxLen) {
        int length = str.length();
        if (length < maxLen) {
            int spaceCount = maxLen - length;
            for (int j = 0; j < spaceCount; ++j) {
                str = str + SPACE;
            }
        } else if (length > maxLen) {
            int shownLen = maxLen - 3;
            str = str.substring(0, shownLen);
            str = str + "...";
        }
        return str;
    }

    protected void sort(File[] fileList, String sortValue) {
        if (fileList == null || fileList.length == 0) {
            return;
        }
        if (fileList.length == 1) {
            return;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = context.getViewRoot().getLocale();
        this.collator = Collator.getInstance(locale);
        this.collator.setStrength(1);
        if (sortValue == null) {
            sortValue = "alphabetica";
        }
        SortRule sr = null;
        if (sortValue.equals("alphabetica")) {
            sr = new SortRule(){

                public boolean compare(File file1, File file2) {
                    return FileChooserModel.this.collator.compare(file1.getName(), file2.getName()) >= 0;
                }
            };
        } else if (sortValue.equals("alphabeticd")) {
            sr = new SortRule(){

                public boolean compare(File file1, File file2) {
                    return FileChooserModel.this.collator.compare(file2.getName(), file1.getName()) >= 0;
                }
            };
        } else if (sortValue.equals("sizea")) {
            sr = new SortRule(){

                public boolean compare(File file1, File file2) {
                    if (file1.length() == file2.length()) {
                        return FileChooserModel.this.collator.compare(file1.getName(), file2.getName()) >= 0;
                    }
                    return file1.length() > file2.length();
                }
            };
        } else if (sortValue.equals("sized")) {
            sr = new SortRule(){

                public boolean compare(File file1, File file2) {
                    if (file1.length() == file2.length()) {
                        return FileChooserModel.this.collator.compare(file1.getName(), file2.getName()) >= 0;
                    }
                    return file1.length() < file2.length();
                }
            };
        } else if (sortValue.equals("timea")) {
            sr = new SortRule(){

                public boolean compare(File file1, File file2) {
                    if (file1.lastModified() == file2.lastModified()) {
                        return FileChooserModel.this.collator.compare(file1.getName(), file2.getName()) >= 0;
                    }
                    return file1.lastModified() > file2.lastModified();
                }
            };
        } else if (sortValue.equals("timed")) {
            sr = new SortRule(){

                public boolean compare(File file1, File file2) {
                    if (file1.lastModified() == file2.lastModified()) {
                        return FileChooserModel.this.collator.compare(file1.getName(), file2.getName()) >= 0;
                    }
                    return file1.lastModified() < file2.lastModified();
                }
            };
        }
        for (int i = fileList.length - 1; i >= 0; --i) {
            for (int j = 0; j < i; ++j) {
                if (!sr.compare(fileList[j], fileList[j + 1])) continue;
                File tmp = fileList[j];
                fileList[j] = fileList[j + 1];
                fileList[j + 1] = tmp;
            }
        }
    }

    public String getParentFolder() {
        File parent = null;
        String parentDir = null;
        try {
            parent = new File(this.getCurrentDir());
            parentDir = parent.getParent();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return parentDir;
    }

    public String getEscapeChar() {
        return this.getSeparatorString().equals(UNIX_ROOT) ? "\\" : UNIX_ROOT;
    }

    public String getDelimiterChar() {
        return ",";
    }

    protected void validateFolder(String folder) throws ResourceModelException {
        if (!this.canRead(folder)) {
            throw new ResourceModelException(this.createFacesMessage("filechooser.cannotCompleteErrSum", "filechooser.cannot_read_folder", null, new String[]{folder}));
        }
    }

    protected void validateSortValue(String sortValue) throws ResourceModelException {
    }

    protected void validateFilterValue(String filterValue) throws ResourceModelException {
    }

    public Object[] getSelectedContent(String[] content, boolean selectFolders) throws ResourceModelException {
        File parent = null;
        try {
            parent = new File(this.getCurrentDir());
        }
        catch (Exception e) {
            this.throwException(e, "filechooser.cannotCompleteErrSum", selectFolders ? "filechooser.folderSelectError" : "filechooser.fileSelectError", null, null);
        }
        if (selectFolders) {
            return this.getSelectedFolders(parent, content);
        }
        return this.getSelectedFiles(parent, content);
    }

    protected File[] getSelectedFolders(File parent, String[] folders) throws ResourceModelException {
        ArrayList<File> folderArray = new ArrayList<File>();
        for (int i = 0; i < folders.length; ++i) {
            try {
                File folder = new File(folders[i]);
                if (!folder.isAbsolute()) {
                    folder = new File(parent, folders[i]);
                }
                if (!folder.canRead()) {
                    throw new ResourceModelException(this.createFacesMessage("filechooser.cannotCompleteErrSum", "filechooser.cannot_read_selected_folder", null, new String[]{folders[i]}));
                }
                if (!folder.isDirectory()) {
                    throw new ResourceModelException(this.createFacesMessage("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFile", null, null));
                }
                folderArray.add(folder);
                continue;
            }
            catch (ResourceModelException fcme) {
                throw fcme;
            }
            catch (Exception e) {
                this.throwException(e, "filechooser.cannotCompleteErrSum", "filechooser.fileSelectError", null, null);
            }
        }
        return folderArray.toArray(new File[0]);
    }

    protected File[] getSelectedFiles(File parent, String[] files) {
        String newCurrentDir = null;
        ArrayList<File> filesArray = new ArrayList<File>();
        for (int i = 0; i < files.length; ++i) {
            try {
                File file = new File(files[i]);
                if (!file.isAbsolute()) {
                    file = new File(parent, files[i]);
                } else if (newCurrentDir == null) {
                    newCurrentDir = file.getParent();
                }
                if (!file.canRead()) {
                    throw new ResourceModelException(this.createFacesMessage("filechooser.cannotCompleteErrSum", "filechooser.cannot_read_selected_file", null, new String[]{files[i]}));
                }
                if (file.isDirectory()) {
                    newCurrentDir = null;
                    if (files.length == 1) {
                        this.setCurrentDir(file.getPath());
                        break;
                    }
                    throw new ResourceModelException(this.createFacesMessage("filechooser.cannotCompleteErrSum", "filechooser.cannotSelectFolder", null, null));
                }
                filesArray.add(file);
                continue;
            }
            catch (ResourceModelException fcme) {
                throw fcme;
            }
            catch (Exception e) {
                this.throwException(e, "filechooser.cannotCompleteErrSum", "filechooser.folderSelectError", null, null);
            }
        }
        if (newCurrentDir != null) {
            this.setCurrentDir(newCurrentDir);
        }
        return filesArray.toArray(new File[0]);
    }

    private void throwException(Exception e, String summKey, String detKey, String[] summArg, String[] detArg) throws ResourceModelException {
        FacesMessage fmsg = this.createFacesMessage(summKey, detKey, summArg, detArg);
        Throwable cause = e.getCause();
        if (cause != null) {
            throw new ResourceModelException(fmsg, cause);
        }
        throw new ResourceModelException(fmsg);
    }

    private FacesMessage createFacesMessage(String summary, String detail, String[] summaryArgs, String[] detailArgs) {
        Theme theme = this.getTheme();
        String summaryMsg = theme.getMessage(summary, summaryArgs);
        String detailMsg = theme.getMessage(detail, detailArgs);
        FacesMessage fmsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, summaryMsg, detailMsg);
        return fmsg;
    }

    private Theme getTheme() {
        FacesContext context = FacesContext.getCurrentInstance();
        return ThemeUtilities.getTheme(context);
    }

    static interface SortRule {
        public boolean compare(File var1, File var2);
    }
}

