/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.xml.schema.model.Annotation;
import org.netbeans.modules.xml.schema.model.Documentation;
import org.netbeans.modules.xml.schema.model.Enumeration;
import org.netbeans.modules.xml.schema.model.SchemaComponentFactory;
import org.netbeans.modules.xml.schema.model.SchemaComponentReference;
import org.netbeans.modules.xml.schema.model.SimpleRestriction;
import org.netbeans.modules.xml.schema.ui.nodes.categorized.customizer.AbstractSchemaComponentCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumerationCustomizer<T extends SimpleRestriction>
extends AbstractSchemaComponentCustomizer<T> {
    static final long serialVersionUID = 1L;
    public JButton addButton;
    public JButton removeButton;
    public JScrollPane valuePane;
    public JTable valueTable;
    private TableModelListener tableListener;
    private transient EnumData enumData;

    public EnumerationCustomizer(SchemaComponentReference<T> schemaComponentReference) {
        super(schemaComponentReference);
        this.initComponents();
        this.initializeModel();
        this.initializeUISelection();
        this.addListeners();
    }

    public void applyChanges() throws IOException {
        if (this.valueTable.getCellEditor() != null) {
            this.valueTable.getCellEditor().stopCellEditing();
        }
        if (this.enumData != null && this.enumData.isChanged()) {
            this.enumData.save();
        }
    }

    public void reset() {
        this.removeListeners();
        this.initializeModel();
        this.initializeUISelection();
        this.addListeners();
        this.setSaveEnabled(false);
        this.setResetEnabled(false);
    }

    private void initializeModel() {
        this.enumData = new EnumData((SimpleRestriction)this.getReference().get(), (DefaultTableModel)this.valueTable.getModel());
    }

    private void initializeUISelection() {
        Collection collection = ((SimpleRestriction)this.getReference().get()).getEnumerations();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.valueTable.getModel();
        int n = defaultTableModel.getRowCount();
        if (n > 0) {
            int n2 = n - 1;
            while (n2 >= 0) {
                defaultTableModel.removeRow(n2--);
            }
        }
        for (Enumeration enumeration : collection) {
            String string = enumeration.getValue();
            String string2 = null;
            if (enumeration.getAnnotation() != null && !enumeration.getAnnotation().getDocumentationElements().isEmpty()) {
                string2 = ((Documentation)enumeration.getAnnotation().getDocumentationElements().iterator().next()).getContentFragment();
            }
            defaultTableModel.addRow(new String[]{string, string2});
        }
    }

    private void addListeners() {
        if (this.tableListener == null) {
            this.tableListener = new TableModelListener(){

                public void tableChanged(TableModelEvent tableModelEvent) {
                    if (EnumerationCustomizer.this.enumData == null) {
                        return;
                    }
                    if (tableModelEvent.getType() == 0) {
                        for (int i = tableModelEvent.getFirstRow(); i <= tableModelEvent.getLastRow(); ++i) {
                            EnumerationCustomizer.this.enumData.modify(tableModelEvent.getFirstRow());
                        }
                        EnumerationCustomizer.this.determineValidity();
                    } else if (tableModelEvent.getType() == 1) {
                        for (int i = tableModelEvent.getFirstRow(); i <= tableModelEvent.getLastRow(); ++i) {
                            EnumerationCustomizer.this.enumData.add();
                        }
                        EnumerationCustomizer.this.determineValidity();
                    } else if (tableModelEvent.getType() == -1) {
                        for (int i = tableModelEvent.getLastRow(); i >= tableModelEvent.getFirstRow(); --i) {
                            EnumerationCustomizer.this.enumData.remove(i);
                        }
                        EnumerationCustomizer.this.determineValidity();
                    }
                }
            };
        }
        this.valueTable.getModel().addTableModelListener(this.tableListener);
    }

    private void removeListeners() {
        this.valueTable.getModel().removeTableModelListener(this.tableListener);
    }

    private void determineValidity() {
        boolean bl;
        boolean bl2 = bl = this.enumData != null && this.enumData.isChanged();
        if (!bl) {
            this.setSaveEnabled(false);
            this.setResetEnabled(false);
            return;
        }
        this.setResetEnabled(true);
        this.setSaveEnabled(true);
    }

    private void initComponents() {
        this.valuePane = new JScrollPane();
        this.valueTable = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.valuePane.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.valueTable.setBorder(BorderFactory.createLineBorder(new Color(128, 128, 128)));
        this.valueTable.setModel(new DefaultTableModel(new Object[0][], new String[]{NbBundle.getMessage(EnumerationCustomizer.class, (String)"LBL_Enumeration_Value"), NbBundle.getMessage(EnumerationCustomizer.class, (String)"LBL_Enumeration_Description")}));
        this.valueTable.setToolTipText(NbBundle.getBundle(EnumerationCustomizer.class).getString("HINT_Enumeration_Table"));
        this.valueTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (EnumerationCustomizer.this.valueTable.getSelectedRowCount() <= 0) {
                    EnumerationCustomizer.this.removeButton.setEnabled(false);
                } else {
                    EnumerationCustomizer.this.removeButton.setEnabled(true);
                }
            }
        });
        this.valuePane.setViewportView(this.valueTable);
        this.valueTable.getAccessibleContext().setAccessibleName(NbBundle.getBundle(EnumerationCustomizer.class).getString("HINT_Enumeration_Table"));
        this.valueTable.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(EnumerationCustomizer.class).getString("HINT_Enumeration_Table"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(EnumerationCustomizer.class, (String)"LBL_Enumeration_AddValue"));
        this.addButton.setToolTipText(NbBundle.getBundle(EnumerationCustomizer.class).getString("HINT_Enumeration_AddValue"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnumerationCustomizer.this.addButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(EnumerationCustomizer.class, (String)"LBL_Enumeration_RemoveValue"));
        this.removeButton.setToolTipText(NbBundle.getBundle(EnumerationCustomizer.class).getString("HINT_Enumeration_RemoveValue"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EnumerationCustomizer.this.removeButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.valuePane, -1, 280, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton))).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.addButton, this.removeButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.valuePane, -1, 414, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.removeButton).add((Component)this.addButton)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.addButton, this.removeButton}, 2);
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.valueTable.getSelectedRows();
        if (nArray == null || nArray.length < 1) {
            return;
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.valueTable.getModel();
        for (int i = nArray.length; i > 0; --i) {
            defaultTableModel.removeRow(nArray[i - 1]);
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.valueTable.getModel();
        defaultTableModel.addRow(new String[]{"", ""});
        if (this.valueTable.getCellEditor() != null) {
            this.valueTable.getCellEditor().stopCellEditing();
        }
        this.valueTable.requestFocusInWindow();
        this.valueTable.changeSelection(this.valueTable.getRowCount() - 1, 0, false, false);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(EnumerationCustomizer.class);
    }

    private static class EnumData {
        private ArrayList<Enumeration> enums = new ArrayList(0);
        private ArrayList<State> states = new ArrayList(0);
        private SimpleRestriction str;
        private DefaultTableModel tModel;

        EnumData(SimpleRestriction simpleRestriction, DefaultTableModel defaultTableModel) {
            for (Enumeration enumeration : simpleRestriction.getEnumerations()) {
                this.enums.add(enumeration);
                this.states.add(State.UNMODIFIED);
            }
            this.str = simpleRestriction;
            this.tModel = defaultTableModel;
        }

        int getRealIndex(int n) {
            int n2 = -1;
            for (int i = 0; i < this.states.size(); ++i) {
                if (this.states.get(i) != State.REMOVED) {
                    ++n2;
                }
                if (n2 != n) continue;
                return i;
            }
            return n;
        }

        void add() {
            this.states.add(State.ADDED);
            this.enums.add(null);
        }

        void remove(int n) {
            int n2 = this.getRealIndex(n);
            if (this.enums.get(n2) == null) {
                this.enums.remove(n2);
                this.states.remove(n2);
            } else {
                this.states.set(n2, State.REMOVED);
            }
        }

        void modify(int n) {
            String string = (String)this.tModel.getValueAt(n, 0);
            String string2 = (String)this.tModel.getValueAt(n, 1);
            int n2 = this.getRealIndex(n);
            Enumeration enumeration = this.enums.get(n2);
            if (enumeration != null) {
                String string3 = enumeration.getValue();
                if (!string.equals(enumeration.getValue())) {
                    this.states.set(n2, State.MODIFIED);
                    return;
                }
                String string4 = null;
                if (enumeration.getAnnotation() != null && !enumeration.getAnnotation().getDocumentationElements().isEmpty()) {
                    string4 = ((Documentation)enumeration.getAnnotation().getDocumentationElements().iterator().next()).getContentFragment();
                }
                if (string4 != null && !string4.equals(string2) || string2 != null && !string2.equals(string4)) {
                    this.states.set(n2, State.MODIFIED);
                    return;
                }
                this.states.set(n2, State.UNMODIFIED);
            }
        }

        boolean isChanged() {
            return this.states.contains((Object)State.ADDED) || this.states.contains((Object)State.REMOVED) || this.states.contains((Object)State.MODIFIED);
        }

        void save() {
            SchemaComponentFactory schemaComponentFactory = this.str.getModel().getFactory();
            block9: for (int i = 0; i < this.states.size(); ++i) {
                State state = this.states.get(i);
                switch (state) {
                    case ADDED: {
                        Annotation annotation;
                        Documentation documentation;
                        Enumeration enumeration = schemaComponentFactory.createEnumeration();
                        this.enums.set(i, enumeration);
                        this.str.addEnumeration(enumeration);
                        enumeration.setValue((String)this.tModel.getValueAt(i, 0));
                        String string = (String)this.tModel.getValueAt(i, 1);
                        if (string != null && !"".equals(string)) {
                            try {
                                documentation = schemaComponentFactory.createDocumentation();
                                documentation.setContentFragment(string);
                                annotation = schemaComponentFactory.createAnnotation();
                                annotation.addDocumentation(documentation);
                                enumeration.setAnnotation(annotation);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        this.states.set(i, State.UNMODIFIED);
                        continue block9;
                    }
                    case REMOVED: {
                        this.str.removeEnumeration(this.enums.get(i));
                        this.enums.remove(i);
                        this.states.remove(i--);
                        continue block9;
                    }
                    case MODIFIED: {
                        Annotation annotation;
                        Documentation documentation;
                        Enumeration enumeration = this.enums.get(i);
                        assert (enumeration != null);
                        enumeration.setValue((String)this.tModel.getValueAt(i, 0));
                        String string = (String)this.tModel.getValueAt(i, 1);
                        if (string != null && !"".equals(string)) {
                            try {
                                documentation = schemaComponentFactory.createDocumentation();
                                documentation.setContentFragment(string);
                                annotation = schemaComponentFactory.createAnnotation();
                                annotation.addDocumentation(documentation);
                                enumeration.setAnnotation(annotation);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        this.states.set(i, State.UNMODIFIED);
                    }
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum State {
            ADDED,
            REMOVED,
            MODIFIED,
            UNMODIFIED;

        }
    }
}

