/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.refactoring;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.refactoring.Element;
import org.netbeans.modules.bpel.refactoring.Plugin;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.modules.soa.ui.util.UI;
import org.netbeans.modules.xml.refactoring.ErrorItem;
import org.netbeans.modules.xml.refactoring.XMLRefactoringPlugin;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.spi.RefactoringUtil;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Mover
extends Plugin {
    private MoveRefactoring myRequest;

    Mover(MoveRefactoring moveRefactoring) {
        this.myRequest = moveRefactoring;
    }

    public Problem fastCheckParameters() {
        URL uRL = (URL)this.myRequest.getTarget().lookup(URL.class);
        if (uRL == null) {
            return null;
        }
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject != null && !fileObject.canWrite()) {
            return new Problem(true, UI.i18n(Mover.class, (String)"ERR_PackageIsReadOnly"));
        }
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Object object;
        Referenceable referenceable = (Referenceable)this.myRequest.getRefactoringSource().lookup(Referenceable.class);
        if (referenceable == null) {
            return null;
        }
        if (!(referenceable instanceof Model)) {
            return null;
        }
        Set<Component> set = this.getRoots(referenceable);
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            List<Element> object3 = this.find(referenceable, (Component)object);
            if (object3 == null) continue;
            arrayList.addAll(object3);
        }
        if (arrayList.size() > 0 && (object = RefactoringUtil.precheckUsageModels((List)(object2 = this.getModels(arrayList)), (boolean)true)) != null && object.size() > 0) {
            return this.processErrors((List<ErrorItem>)object);
        }
        object2 = (XMLRefactoringTransaction)this.myRequest.getContext().lookup(XMLRefactoringTransaction.class);
        object2.register((XMLRefactoringPlugin)this, arrayList);
        refactoringElementsBag.registerTransaction((Transaction)object2);
        for (Element element : arrayList) {
            element.setTransactionObject((XMLRefactoringTransaction)object2);
            refactoringElementsBag.add((AbstractRefactoring)this.myRequest, (RefactoringElementImplementation)element);
        }
        return null;
    }

    public void doRefactoring(List<RefactoringElementImplementation> list) throws IOException {
        Map<Model, Set<RefactoringElementImplementation>> map = this.getModelMap(list);
        Set<Model> set = map.keySet();
        Referenceable referenceable = (Referenceable)this.myRequest.getRefactoringSource().lookup(Referenceable.class);
        for (Model model : set) {
            if (!(referenceable instanceof Model)) continue;
            this.rename(model, this.getComponents(map.get(model)));
        }
    }

    @Override
    public String getModelReference(Component component) {
        if (component instanceof Import) {
            return ((Import)component).getLocation();
        }
        return null;
    }

    private Map<Model, Set<RefactoringElementImplementation>> getModelMap(List<RefactoringElementImplementation> list) {
        HashMap<Model, Set<RefactoringElementImplementation>> hashMap = new HashMap<Model, Set<RefactoringElementImplementation>>();
        for (RefactoringElementImplementation refactoringElementImplementation : list) {
            Model model = ((Component)refactoringElementImplementation.getLookup().lookup(Component.class)).getModel();
            HashSet<RefactoringElementImplementation> hashSet = (HashSet<RefactoringElementImplementation>)hashMap.get(model);
            if (hashSet == null) {
                hashSet = new HashSet<RefactoringElementImplementation>();
                hashSet.add(refactoringElementImplementation);
                hashMap.put(model, hashSet);
                continue;
            }
            hashSet.add(refactoringElementImplementation);
        }
        return hashMap;
    }

    private List<Component> getComponents(Set<RefactoringElementImplementation> set) {
        ArrayList<Component> arrayList = new ArrayList<Component>(set.size());
        for (RefactoringElementImplementation refactoringElementImplementation : set) {
            arrayList.add((Component)refactoringElementImplementation.getLookup().lookup(Component.class));
        }
        return arrayList;
    }

    private void rename(Model model, List<Component> list) throws IOException {
        if (list == null) {
            return;
        }
        for (Component component : list) {
            this.renameFile(model, component);
        }
    }

    private void renameFile(Model model, Component component) throws IOException {
        if (!(component instanceof Import)) {
            return;
        }
        try {
            Import import_ = (Import)component;
            String string = import_.getLocation();
            try {
                string = SharedUtils.calculateNewLocationString((Model)model, (MoveRefactoring)this.myRequest);
            }
            catch (URISyntaxException uRISyntaxException) {
                return;
            }
            import_.setLocation(string);
        }
        catch (VetoException vetoException) {
            throw new IOException(vetoException.getMessage());
        }
    }
}

