/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.refactoring;

import javax.swing.Icon;
import javax.swing.text.Position;
import org.netbeans.modules.bpel.editors.api.utils.RefactorUtil;
import org.netbeans.modules.bpel.editors.api.utils.Util;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.spi.SharedUtils;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentModel;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.netbeans.modules.xml.xam.dom.DocumentModelAccess;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

final class Element
extends SimpleRefactoringElementImplementation
implements TreeElement {
    private Component myComponent;
    private XMLRefactoringTransaction myTransaction;

    Element(Component component) {
        this.myComponent = component;
    }

    public Lookup getLookup() {
        return Lookups.singleton((Object)this.myComponent);
    }

    public FileObject getParentFile() {
        return (FileObject)this.myComponent.getModel().getModelSource().getLookup().lookup(FileObject.class);
    }

    public TreeElement getParent(boolean bl) {
        if (this.myComponent.getParent() != null) {
            return TreeElementFactory.getTreeElement((Object)this.myComponent.getParent());
        }
        return TreeElementFactory.getTreeElement((Object)this.getParentFile());
    }

    public String getText() {
        return RefactorUtil.getName((Component)this.myComponent);
    }

    public String getText(boolean bl) {
        return this.getText();
    }

    public String getDisplayText() {
        return RefactorUtil.getHtmlName((Component)this.myComponent);
    }

    public Icon getIcon() {
        return RefactorUtil.getIcon((Component)this.myComponent);
    }

    public PositionBounds getPosition() {
        if (!(this.myComponent.getModel() instanceof AbstractDocumentModel)) {
            return null;
        }
        DocumentModelAccess documentModelAccess = ((AbstractDocumentModel)this.myComponent.getModel()).getAccess();
        String string = documentModelAccess.getXmlFragmentInclusive(((DocumentComponent)this.myComponent).getPeer());
        int n = ((DocumentComponent)this.myComponent).findPosition();
        int n2 = n + string.length();
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)((FileObject)this.myComponent.getModel().getModelSource().getLookup().lookup(FileObject.class)));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        CloneableEditorSupport cloneableEditorSupport = SharedUtils.findCloneableEditorSupport((DataObject)dataObject);
        if (cloneableEditorSupport == null) {
            return null;
        }
        PositionRef positionRef = cloneableEditorSupport.createPositionRef(n, Position.Bias.Forward);
        PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Forward);
        return new PositionBounds(positionRef, positionRef2);
    }

    public void openInEditor() {
        Util.goToSource((Component)this.myComponent);
    }

    public Object getUserObject() {
        return this.myComponent;
    }

    void setTransactionObject(XMLRefactoringTransaction xMLRefactoringTransaction) {
        this.myTransaction = xMLRefactoringTransaction;
    }

    protected String getNewFileContent() {
        if (this.myComponent.getModel() instanceof AbstractDocumentModel && this.myTransaction != null) {
            return this.myTransaction.refactorForPreview(this.myComponent.getModel());
        }
        return null;
    }

    public void performChange() {
    }
}

