/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.nbprefuse;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import prefuse.Display;
import prefuse.controls.ControlAdapter;
import prefuse.visual.AggregateItem;
import prefuse.visual.VisualItem;

public class AggregateDragControl
extends ControlAdapter {
    private VisualItem activeItem;
    protected Point2D down = new Point2D.Double();
    protected Point2D temp = new Point2D.Double();
    protected boolean dragged;

    public void itemEntered(VisualItem visualItem, MouseEvent mouseEvent) {
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getPredefinedCursor(12));
        this.activeItem = visualItem;
        if (!(visualItem instanceof AggregateItem)) {
            AggregateDragControl.setFixed(visualItem, true);
        }
    }

    public void itemExited(VisualItem visualItem, MouseEvent mouseEvent) {
        if (this.activeItem == visualItem) {
            this.activeItem = null;
            AggregateDragControl.setFixed(visualItem, false);
        }
        Display display = (Display)mouseEvent.getSource();
        display.setCursor(Cursor.getDefaultCursor());
    }

    public void itemPressed(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.dragged = false;
        Display display = (Display)mouseEvent.getComponent();
        display.getAbsoluteCoordinate((Point2D)mouseEvent.getPoint(), this.down);
        if (visualItem instanceof AggregateItem) {
            AggregateDragControl.setFixed(visualItem, true);
        }
    }

    public void itemReleased(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this.dragged) {
            this.activeItem = null;
            AggregateDragControl.setFixed(visualItem, false);
            this.dragged = false;
            visualItem.getVisualization().run("action-update-aggregate-layout-repaint");
        }
    }

    public void itemDragged(VisualItem visualItem, MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.dragged = true;
        Display display = (Display)mouseEvent.getComponent();
        display.getAbsoluteCoordinate((Point2D)mouseEvent.getPoint(), this.temp);
        double d = this.temp.getX() - this.down.getX();
        double d2 = this.temp.getY() - this.down.getY();
        AggregateDragControl.move(visualItem, d, d2);
        this.down.setLocation(this.temp);
        visualItem.getVisualization().run("action-update-aggregate-layout-repaint");
    }

    protected static void setFixed(VisualItem visualItem, boolean bl) {
        if (visualItem instanceof AggregateItem) {
            Iterator iterator = ((AggregateItem)visualItem).items();
            while (iterator.hasNext()) {
                AggregateDragControl.setFixed((VisualItem)iterator.next(), bl);
            }
        } else {
            visualItem.setFixed(bl);
        }
    }

    protected static void move(VisualItem visualItem, double d, double d2) {
        if (visualItem instanceof AggregateItem) {
            Iterator iterator = ((AggregateItem)visualItem).items();
            while (iterator.hasNext()) {
                AggregateDragControl.move((VisualItem)iterator.next(), d, d2);
            }
        } else {
            double d3 = visualItem.getX();
            double d4 = visualItem.getY();
            visualItem.setStartX(d3);
            visualItem.setStartY(d4);
            visualItem.setX(d3 + d);
            visualItem.setY(d4 + d2);
            visualItem.setEndX(d3 + d);
            visualItem.setEndY(d4 + d2);
        }
    }
}

