/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.CreateCapability;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WelcomeFileList;
import org.netbeans.modules.spring.api.SpringUtilities;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.api.beans.ConfigFileManager;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.webmvc.SpringConfigPanelVisual;
import org.netbeans.modules.spring.webmvc.SpringWebFrameworkProvider;
import org.netbeans.modules.spring.webmvc.utils.SpringWebFrameworkUtils;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringWebModuleExtender
extends WebModuleExtender
implements ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(SpringWebModuleExtender.class.getName());
    private final SpringWebFrameworkProvider framework;
    private final ExtenderController controller;
    private final boolean customizer;
    private SpringConfigPanelVisual component;
    private String dispatcherName = "dispatcher";
    private String dispatcherMapping = "*.htm";
    private boolean includeJstl = true;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public SpringWebModuleExtender(SpringWebFrameworkProvider springWebFrameworkProvider, ExtenderController extenderController, boolean bl) {
        this.framework = springWebFrameworkProvider;
        this.controller = extenderController;
        this.customizer = bl;
    }

    public ExtenderController getController() {
        return this.controller;
    }

    public String getDispatcherName() {
        return this.dispatcherName;
    }

    public String getDispatcherMapping() {
        return this.dispatcherMapping;
    }

    public boolean getIncludeJstl() {
        return this.includeJstl;
    }

    public SpringConfigPanelVisual getComponent() {
        if (this.component == null) {
            this.component = new SpringConfigPanelVisual(this);
            this.component.setEnabled(!this.customizer);
        }
        return this.component;
    }

    public boolean isValid() {
        if (this.dispatcherName == null || this.dispatcherName.trim().length() == 0) {
            this.controller.setErrorMessage(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"MSG_DispatcherNameIsEmpty"));
            return false;
        }
        if (!SpringWebFrameworkUtils.isDispatcherServletConfigFilenameValid(this.dispatcherName)) {
            this.controller.setErrorMessage(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"MSG_DispatcherServletConfigFilenameIsNotValid"));
            return false;
        }
        if (this.dispatcherMapping == null || this.dispatcherMapping.trim().length() == 0) {
            this.controller.setErrorMessage(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"MSG_DispatcherMappingPatternIsEmpty"));
            return false;
        }
        if (!SpringWebFrameworkUtils.isDispatcherMappingPatternValid(this.dispatcherMapping)) {
            this.controller.setErrorMessage(NbBundle.getMessage(SpringConfigPanelVisual.class, (String)"MSG_DispatcherMappingPatternIsNotValid"));
            return false;
        }
        this.controller.setErrorMessage(null);
        return true;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(SpringWebModuleExtender.class);
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.dispatcherName = this.getComponent().getDispatcherName();
        this.dispatcherMapping = this.getComponent().getDispatcherMapping();
        this.includeJstl = this.getComponent().getIncludeJstl();
        this.changeSupport.fireChange();
    }

    public void update() {
    }

    public Set<FileObject> extend(WebModule webModule) {
        CreateSpringConfig createSpringConfig = new CreateSpringConfig(webModule);
        FileObject fileObject = webModule.getWebInf();
        if (fileObject != null) {
            try {
                FileSystem fileSystem = fileObject.getFileSystem();
                fileSystem.runAtomicAction((FileSystem.AtomicAction)createSpringConfig);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return null;
            }
        }
        return createSpringConfig.getFilesToOpen();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CreateSpringConfig
    implements FileSystem.AtomicAction {
        public static final String CONTEXT_LOADER = "org.springframework.web.context.ContextLoaderListener";
        public static final String DISPATCHER_SERVLET = "org.springframework.web.servlet.DispatcherServlet";
        public static final String ENCODING = "UTF-8";
        private Set<FileObject> filesToOpen = new LinkedHashSet<FileObject>();
        private WebModule webModule;

        public CreateSpringConfig(WebModule webModule) {
            this.webModule = webModule;
        }

        public void run() throws IOException {
            ConfigFileManager configFileManager;
            Library library;
            FileObject fileObject = this.webModule.getDeploymentDescriptor();
            WebApp webApp = DDProvider.getDefault().getDDRoot(fileObject);
            this.addContextParam(webApp, "contextConfigLocation", "/WEB-INF/applicationContext.xml");
            this.addListener(webApp, CONTEXT_LOADER);
            this.addServlet(webApp, SpringWebModuleExtender.this.getComponent().getDispatcherName(), DISPATCHER_SERVLET, SpringWebModuleExtender.this.getComponent().getDispatcherMapping(), "2");
            WelcomeFileList welcomeFileList = webApp.getSingleWelcomeFileList();
            if (welcomeFileList == null) {
                try {
                    welcomeFileList = (WelcomeFileList)webApp.createBean("WelcomeFileList");
                    webApp.setWelcomeFileList(welcomeFileList);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Exceptions.printStackTrace((Throwable)classNotFoundException);
                }
            }
            if (welcomeFileList.sizeWelcomeFile() == 0) {
                welcomeFileList.addWelcomeFile("redirect.jsp");
            }
            webApp.write(fileObject);
            ArrayList<Library> arrayList = new ArrayList<Library>(3);
            Library library2 = SpringUtilities.findSpringWebMVCLibrary();
            Library library3 = null;
            if (library2 != null) {
                arrayList.add(library2);
                if (SpringUtilities.isSpringLibrary((Library)library2)) {
                    library3 = library2;
                }
            } else {
                LOGGER.log(Level.WARNING, null, new Error("No Spring Web MVC library found."));
            }
            if (library3 == null) {
                library3 = SpringUtilities.findSpringLibrary();
                if (library3 != null) {
                    arrayList.add(library3);
                } else {
                    LOGGER.log(Level.WARNING, null, new Error("No Spring Framework library found."));
                }
            }
            if (SpringWebModuleExtender.this.includeJstl) {
                library = SpringUtilities.findJSTLibrary();
                if (library != null) {
                    arrayList.add(library);
                } else {
                    LOGGER.log(Level.WARNING, null, new Error("No JSTL library found."));
                }
            }
            if (!arrayList.isEmpty()) {
                this.addLibrariesToWebModule(arrayList, this.webModule);
            }
            library = this.webModule.getWebInf();
            FileObject fileObject2 = FileUtil.createFolder((FileObject)library, (String)"jsp");
            DataFolder dataFolder = DataFolder.findFolder((FileObject)library);
            final ArrayList<File> arrayList2 = new ArrayList<File>(2);
            FileObject fileObject3 = this.createFromTemplate("applicationContext.xml", dataFolder, "applicationContext");
            this.addFileToOpen(fileObject3);
            arrayList2.add(FileUtil.toFile((FileObject)fileObject3));
            fileObject3 = this.createFromTemplate("dispatcher-servlet.xml", dataFolder, SpringWebModuleExtender.this.getComponent().getDispatcherName() + "-servlet");
            this.addFileToOpen(fileObject3);
            arrayList2.add(FileUtil.toFile((FileObject)fileObject3));
            FileObject fileObject4 = this.updateViewPage("index.jsp", DataFolder.findFolder((FileObject)fileObject2), "index");
            this.addFileToOpen(fileObject4);
            arrayList2.add(FileUtil.toFile((FileObject)fileObject4));
            SpringScope springScope = SpringScope.getSpringScope((FileObject)fileObject3);
            if (springScope != null) {
                configFileManager = springScope.getConfigFileManager();
                try {
                    configFileManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws IOException {
                            List list = configFileManager.getConfigFiles();
                            list.addAll(arrayList2);
                            List list2 = configFileManager.getConfigFileGroups();
                            String string = NbBundle.getMessage(SpringWebModuleExtender.class, (String)"LBL_DefaultGroup");
                            ConfigFileGroup configFileGroup = ConfigFileGroup.create((String)string, (List)arrayList2);
                            list2.add(configFileGroup);
                            configFileManager.putConfigFilesAndGroups(list, list2);
                            configFileManager.save();
                            return null;
                        }
                    });
                }
                catch (MutexException mutexException) {
                    throw (IOException)mutexException.getException();
                }
            } else {
                LOGGER.log(Level.WARNING, "Could not find a SpringScope for file {0}", fileObject3);
            }
            configFileManager = this.webModule.getDocumentBase();
            FileObject fileObject5 = configFileManager.getFileObject("redirect.jsp");
            if (fileObject5 == null) {
                fileObject5 = FileUtil.createData((FileObject)configFileManager, (String)"redirect.jsp");
            }
            this.addFileToOpen(this.copyResource("redirect.jsp", fileObject5));
        }

        public void addFileToOpen(FileObject fileObject) {
            this.filesToOpen.add(fileObject);
        }

        public Set<FileObject> getFilesToOpen() {
            return this.filesToOpen;
        }

        private FileObject createFromTemplate(String string, DataFolder dataFolder, String string2) throws IOException {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("SpringFramework/Templates/" + string);
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            return dataObject.createFromTemplate(dataFolder, string2).getPrimaryFile();
        }

        private FileObject updateViewPage(String string, DataFolder dataFolder, String string2) throws IOException {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject("SpringFramework/Templates/" + string);
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("welcomeText", NbBundle.getMessage(SpringWebModuleExtender.class, (String)"MSG_WELCOME_PAGE_TEXT"));
            return dataObject.createFromTemplate(dataFolder, string2, hashMap).getPrimaryFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected FileObject copyResource(String string, FileObject fileObject) throws UnsupportedEncodingException, IOException {
            String string2;
            InputStream inputStream = this.getClass().getResourceAsStream("resources/templates/" + string);
            String string3 = System.getProperty("line.separator");
            StringBuffer stringBuffer = new StringBuffer();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, ENCODING));
            try {
                string2 = bufferedReader.readLine();
                while (string2 != null) {
                    if (string.contains("-servlet.xml") || string.equals("redirect.jsp")) {
                        string2 = SpringWebFrameworkUtils.replaceExtensionInTemplates(string2, SpringWebModuleExtender.this.dispatcherMapping);
                    }
                    if (string.equals("redirect.jsp")) {
                        string2 = SpringWebFrameworkUtils.reviseRedirectJsp(string2, SpringWebModuleExtender.this.dispatcherMapping);
                    }
                    stringBuffer.append(string2);
                    stringBuffer.append(string3);
                    string2 = bufferedReader.readLine();
                }
            }
            finally {
                bufferedReader.close();
            }
            string2 = fileObject.lock();
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileObject.getOutputStream((FileLock)string2), ENCODING));
                try {
                    bufferedWriter.write(stringBuffer.toString());
                }
                finally {
                    bufferedWriter.close();
                }
            }
            finally {
                string2.releaseLock();
            }
            return fileObject;
        }

        protected boolean addLibrariesToWebModule(List<Library> list, WebModule webModule) throws IOException, UnsupportedOperationException {
            FileObject fileObject = webModule.getDocumentBase();
            Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (project == null) {
                return false;
            }
            boolean bl = false;
            try {
                SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)project);
                if (sourceGroupArray.length == 0) {
                    return false;
                }
                bl = ProjectClassPathModifier.addLibraries((Library[])list.toArray(new Library[list.size()]), (FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, "Libraries required for the Spring MVC project not added", iOException);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                LOGGER.log(Level.WARNING, "This project does not support adding these types of libraries to the classpath", unsupportedOperationException);
            }
            return bl;
        }

        protected Listener addListener(WebApp webApp, String string) throws IOException {
            Listener listener = (Listener)this.createBean((CreateCapability)webApp, "Listener");
            listener.setListenerClass(string);
            webApp.addListener(listener);
            return listener;
        }

        protected Servlet addServlet(WebApp webApp, String string, String string2, String string3, String string4) throws IOException {
            Servlet servlet = (Servlet)this.createBean((CreateCapability)webApp, "Servlet");
            servlet.setServletName(string);
            servlet.setServletClass(string2);
            if (string4 != null) {
                servlet.setLoadOnStartup(new BigInteger(string4));
            }
            webApp.addServlet(servlet);
            if (string3 != null) {
                this.addServletMapping(webApp, string, string3);
            }
            return servlet;
        }

        protected ServletMapping addServletMapping(WebApp webApp, String string, String string2) throws IOException {
            ServletMapping servletMapping = (ServletMapping)this.createBean((CreateCapability)webApp, "ServletMapping");
            servletMapping.setServletName(string);
            servletMapping.setUrlPattern(string2);
            webApp.addServletMapping(servletMapping);
            return servletMapping;
        }

        protected InitParam addContextParam(WebApp webApp, String string, String string2) throws IOException {
            InitParam initParam = (InitParam)this.createBean((CreateCapability)webApp, "InitParam");
            initParam.setParamName(string);
            initParam.setParamValue(string2);
            webApp.addContextParam(initParam);
            return initParam;
        }

        protected CommonDDBean createBean(CreateCapability createCapability, String string) throws IOException {
            CommonDDBean commonDDBean = null;
            try {
                commonDDBean = createCapability.createBean(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorManager.getDefault().notify(4096, (Throwable)classNotFoundException);
                throw new IOException("Error creating bean with name:" + string);
            }
            return commonDDBean;
        }
    }
}

