/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.core.api.support.SourceGroups;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.SourceGroupUISupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigUtilities;
import org.netbeans.modules.web.jsf.dialogs.BrowseFolders;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class PersistenceClientSetupPanelVisual
extends JPanel
implements DocumentListener {
    private WizardDescriptor wizard;
    private Project project;
    private JTextComponent packageComboBoxEditor;
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton browseFolderButton;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField jsfFolder;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JComboBox packageComboBox;
    private JLabel packageLabel;
    private JLabel projectLabel;
    private JTextField projectTextField;

    public PersistenceClientSetupPanelVisual(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        this.initComponents();
        this.packageComboBoxEditor = (JTextComponent)this.packageComboBox.getEditor().getEditorComponent();
        Document document = this.packageComboBoxEditor.getDocument();
        document.addDocumentListener(this);
        this.jsfFolder.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                PersistenceClientSetupPanelVisual.this.changeSupport.fireChange();
            }

            public void keyReleased(KeyEvent keyEvent) {
                PersistenceClientSetupPanelVisual.this.changeSupport.fireChange();
            }

            public void keyTyped(KeyEvent keyEvent) {
                PersistenceClientSetupPanelVisual.this.changeSupport.fireChange();
            }
        });
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jsfFolder = new JTextField();
        this.browseFolderButton = new JButton();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.packageLabel = new JLabel();
        this.packageComboBox = new JComboBox();
        this.setName(NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"LBL_JSFPagesAndClasses"));
        this.jLabel2.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_JSF_Pages").charAt(0));
        this.jLabel2.setLabelFor(this.jsfFolder);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle");
        this.jLabel2.setText(resourceBundle.getString("LBL_JSF_pages_folder"));
        this.browseFolderButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_Browse2").charAt(0));
        this.browseFolderButton.setText(resourceBundle.getString("LBL_Browse"));
        this.browseFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceClientSetupPanelVisual.this.browseFolderButtonActionPerformed(actionEvent);
            }
        });
        this.jLabel3.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_Controller").charAt(0));
        this.jLabel3.setText(resourceBundle.getString("LBL_JSF_Managed_bean"));
        this.jLabel4.setText(resourceBundle.getString("MSG_Jsf_Pages_Location"));
        this.jLabel5.setText(resourceBundle.getString("MSG_Folders"));
        this.projectLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_Project").charAt(0));
        this.projectLabel.setLabelFor(this.projectTextField);
        this.projectLabel.setText(NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"LBL_Project"));
        this.projectTextField.setEditable(false);
        this.locationLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_Location").charAt(0));
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"LBL_SrcLocation"));
        this.locationComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PersistenceClientSetupPanelVisual.this.locationComboBoxActionPerformed(actionEvent);
            }
        });
        this.packageLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/web/jsf/wizards/Bundle").getString("MNE_Package").charAt(0));
        this.packageLabel.setLabelFor(this.packageComboBox);
        this.packageLabel.setText(NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"LBL_Package"));
        this.packageComboBox.setEditable(true);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel4).addContainerGap(331, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jsfFolder, -1, 353, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.browseFolderButton)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.projectLabel).add((Component)this.locationLabel).add((Component)this.packageLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.locationComboBox, 0, 498, Short.MAX_VALUE).add((Component)this.projectTextField, -1, 498, Short.MAX_VALUE).add((Component)this.packageComboBox, 0, 498, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel3).addContainerGap()).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel5).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel4).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jsfFolder, -2, -1, -2).add((Component)this.browseFolderButton)).add(27, 27, 27).add((Component)this.jLabel5).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectLabel).add((Component)this.projectTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.locationLabel).add((Component)this.locationComboBox, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.packageLabel).add((Component)this.packageComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.jLabel3).addContainerGap(70, Short.MAX_VALUE)));
        this.jsfFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"ACSD_JSF_Pages"));
        this.browseFolderButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"ACSD_Browser"));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"ACSD_Project"));
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"ACSD_Location"));
        this.packageComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"ACSD_Package"));
    }

    private void locationComboBoxActionPerformed(ActionEvent actionEvent) {
        this.locationChanged();
    }

    private void browseFolderButtonActionPerformed(ActionEvent actionEvent) {
        Sources sources = (Sources)Templates.getProject((WizardDescriptor)this.wizard).getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("doc_root");
        FileObject fileObject = BrowseFolders.showDialog(sourceGroupArray);
        if (fileObject != null) {
            String string = "/" + JSFConfigUtilities.getResourcePath(sourceGroupArray, fileObject, '/', true);
            this.jsfFolder.setText(string);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    boolean valid(WizardDescriptor wizardDescriptor) {
        String string;
        ClassPath classPath = ClassPath.getClassPath((FileObject)this.getLocationValue().getRootFolder(), (String)"classpath/compile");
        ClassLoader classLoader = classPath.getClassLoader(true);
        try {
            Class.forName("javax.transaction.UserTransaction", false, classLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"ERR_UserTransactionUnavailable"));
            return false;
        }
        Sources sources = (Sources)this.project.getLookup().lookup(Sources.class);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("doc_root");
        FileObject fileObject = sourceGroupArray[0].getRootFolder();
        File file = FileUtil.toFile((FileObject)fileObject);
        String string2 = this.jsfFolder.getText();
        try {
            string = new File(file, string2).getCanonicalPath();
        }
        catch (IOException iOException) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"ERR_JsfTargetChooser_InvalidJsfFolder"));
            return false;
        }
        string = this.getPackage();
        if (string.trim().equals("")) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"ERR_JavaTargetChooser_CantUseDefaultPackage"));
            return false;
        }
        if (!JavaIdentifiers.isValidPackageName((String)string)) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"ERR_JavaTargetChooser_InvalidPackage"));
            return false;
        }
        if (!SourceGroups.isFolderWritable((SourceGroup)this.getLocationValue(), (String)string)) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientSetupPanelVisual.class, (String)"ERR_JavaTargetChooser_UnwritablePackage"));
            return false;
        }
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    public SourceGroup getLocationValue() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getPackage() {
        return this.packageComboBoxEditor.getText();
    }

    private void locationChanged() {
        this.updateSourceGroupPackages();
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.jsfFolder.setText((String)wizardDescriptor.getProperty("JSFFolder"));
        this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)wizardDescriptor);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        SourceGroup[] sourceGroupArray = SourceGroups.getJavaSourceGroups((Project)this.project);
        SourceGroupUISupport.connect((JComboBox)this.locationComboBox, (SourceGroup[])sourceGroupArray);
        this.packageComboBox.setRenderer(PackageView.listRenderer());
        this.updateSourceGroupPackages();
        if (fileObject != null && FileUtil.isParentOf((FileObject)WebModule.getWebModule((FileObject)fileObject).getDocumentBase(), (FileObject)fileObject)) {
            Sources sources = (Sources)Templates.getProject((WizardDescriptor)this.wizard).getLookup().lookup(Sources.class);
            SourceGroup[] sourceGroupArray2 = sources.getSourceGroups("doc_root");
            this.jsfFolder.setText("/" + JSFConfigUtilities.getResourcePath(sourceGroupArray2, fileObject, '/', true));
        }
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("JSFFolder", (Object)this.jsfFolder.getText());
        String string = this.getPackage();
        wizardDescriptor.putProperty("ControllerBean", (Object)string);
        try {
            FileObject fileObject = this.getLocationValue().getRootFolder();
            String string2 = string.replace('.', '/');
            FileObject fileObject2 = fileObject.getFileObject(string2);
            if (fileObject2 == null) {
                fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)string2);
            }
            Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)fileObject2);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private void updateSourceGroupPackages() {
        SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
        ComboBoxModel comboBoxModel = PackageView.createListView((SourceGroup)sourceGroup);
        if (comboBoxModel.getSelectedItem() != null && comboBoxModel.getSelectedItem().toString().startsWith("META-INF") && comboBoxModel.getSize() > 1) {
            comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(1));
        }
        this.packageComboBox.setModel(comboBoxModel);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changeSupport.fireChange();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changeSupport.fireChange();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.changeSupport.fireChange();
    }
}

