/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.windows.CloneableOpenSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Utils {
    private static final RequestProcessor vcsRequestProcessor = new RequestProcessor("Versioning", 1);
    private static final RequestProcessor vcsBlockingRequestProcessor = new RequestProcessor("Versioning long tasks", 1);
    private static File[] unversionedFolders;
    private static Map<File, Charset> fileToCharset;

    private Utils() {
    }

    public static RequestProcessor.Task createTask(Runnable runnable) {
        return vcsBlockingRequestProcessor.create(runnable);
    }

    public static void post(Runnable runnable) {
        vcsRequestProcessor.post(runnable);
    }

    public static boolean isAncestorOrEqual(File file, File file2) {
        if (VersioningSupport.isFlat((File)file)) {
            return file.equals(file2) || file.equals(file2.getParentFile()) && !file2.isDirectory();
        }
        while (file2 != null) {
            if (file2.equals(file)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        return false;
    }

    public static boolean shareCommonDataObject(File[] fileArray) {
        if (fileArray == null || fileArray.length < 2) {
            return true;
        }
        DataObject dataObject = Utils.findDataObject(fileArray[0]);
        for (int i = 1; i < fileArray.length; ++i) {
            DataObject dataObject2 = Utils.findDataObject(fileArray[i]);
            if (dataObject2 == dataObject || dataObject2 != null && dataObject2.equals(dataObject)) continue;
            return false;
        }
        return true;
    }

    public static Set<File> getAllDataObjectFiles(File file) {
        HashSet<File> hashSet = new HashSet<File>(2);
        hashSet.add(file);
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                Set set = dataObject.files();
                for (FileObject fileObject2 : set) {
                    hashSet.add(FileUtil.toFile((FileObject)fileObject2));
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return hashSet;
    }

    private static DataObject findDataObject(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            try {
                return DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isFileContentText(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return false;
        }
        if (fileObject.getMIMEType().startsWith("text")) {
            return true;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            return dataObject.getLookup().lookupItem(new Lookup.Template(EditorCookie.class)) != null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
    }

    public static void copyStreamsCloseAll(OutputStream outputStream, InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.close();
        inputStream.close();
    }

    public static void copyStreamsCloseAll(Writer writer, Reader reader) throws IOException {
        int n;
        char[] cArray = new char[4096];
        while ((n = reader.read(cArray)) != -1) {
            writer.write(cArray, 0, n);
        }
        writer.close();
        reader.close();
    }

    public static List<String> getStringList(Preferences preferences, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String[] stringArray = preferences.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || !string2.startsWith(string)) continue;
                int n = Integer.parseInt(string2.substring(string2.lastIndexOf(46) + 1));
                arrayList.add(n + "." + preferences.get(string2, null));
            }
            ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
            arrayList2.addAll(arrayList);
            for (String string3 : arrayList) {
                int n = string3.indexOf(46);
                int n2 = Integer.parseInt(string3.substring(0, n));
                arrayList2.set(n2, string3.substring(n + 1));
            }
            return arrayList2;
        }
        catch (Exception exception) {
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, null, exception);
            return new ArrayList<String>(0);
        }
    }

    public static void put(Preferences preferences, String string, List<String> list) {
        try {
            int n;
            String[] stringArray = preferences.keys();
            for (n = 0; n < stringArray.length; ++n) {
                String string2 = stringArray[n];
                if (string2 == null || !string2.startsWith(string + ".")) continue;
                preferences.remove(string2);
            }
            n = 0;
            for (String string3 : list) {
                preferences.put(string + "." + n++, string3);
            }
        }
        catch (BackingStoreException backingStoreException) {
            Logger.getLogger(Utils.class.getName()).log(Level.INFO, null, backingStoreException);
        }
    }

    public static void insert(Preferences preferences, String string, String string2, int n) {
        List<String> list = Utils.getStringList(preferences, string);
        if (list.contains(string2)) {
            list.remove(string2);
        }
        list.add(0, string2);
        if (n > -1 && list.size() > n) {
            list.subList(n, list.size()).clear();
        }
        Utils.put(preferences, string, list);
    }

    public static void removeFromArray(Preferences preferences, String string, List<String> list) {
        List<String> list2 = Utils.getStringList(preferences, string);
        list2.removeAll(list);
        Utils.put(preferences, string, list2);
    }

    public static void removeFromArray(Preferences preferences, String string, String string2) {
        List<String> list = Utils.getStringList(preferences, string);
        list.remove(string2);
        Utils.put(preferences, string, list);
    }

    public static File[][] splitFlatOthers(File[] fileArray) {
        HashSet<File> hashSet = new HashSet<File>(1);
        for (int i = 0; i < fileArray.length; ++i) {
            if (!VersioningSupport.isFlat((File)fileArray[i])) continue;
            hashSet.add(fileArray[i]);
        }
        if (hashSet.size() == 0) {
            return new File[][]{new File[0], fileArray};
        }
        HashSet<File> hashSet2 = new HashSet<File>(Arrays.asList(fileArray));
        hashSet2.removeAll(hashSet);
        return new File[][]{hashSet.toArray(new File[hashSet.size()]), hashSet2.toArray(new File[hashSet2.size()])};
    }

    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                Utils.deleteRecursively(fileArray[i]);
            }
        }
        file.delete();
    }

    public static File getCommonParent(File file, File file2) {
        do {
            if (!file.equals(file2)) continue;
            return file;
        } while (!(file.getAbsolutePath().length() > file2.getAbsolutePath().length() ? (file = file.getParentFile()) == null : (file2 = file2.getParentFile()) == null));
        return null;
    }

    public static String getStackTrace() {
        Exception exception = new Exception();
        exception.fillInStackTrace();
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static Reader getDocumentReader(final Document document) {
        final String[] stringArray = new String[1];
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    stringArray[0] = document.getText(0, document.getLength());
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        };
        document.render(runnable);
        return new StringReader(stringArray[0]);
    }

    public static Point getPositionForPopup(JTable jTable) {
        int n = jTable.getSelectedRow();
        if (n == -1) {
            n = 0;
        }
        Rectangle rectangle = jTable.getCellRect(n, 1, true);
        return rectangle.getLocation();
    }

    public static Point getPositionForPopup(JList jList) {
        int n = jList.getSelectedIndex();
        if (n == -1) {
            n = 0;
        }
        Rectangle rectangle = jList.getCellBounds(n, n);
        rectangle.x += 10;
        rectangle.y += rectangle.height;
        return rectangle.getLocation();
    }

    public static JMenuItem toMenuItem(Action action) {
        JMenuItem jMenuItem;
        if (action instanceof Presenter.Menu) {
            jMenuItem = ((Presenter.Menu)action).getMenuPresenter();
        } else {
            jMenuItem = new JMenuItem();
            Actions.connect((JMenuItem)jMenuItem, (Action)action, (boolean)false);
        }
        return jMenuItem;
    }

    public static File getTempFolder() {
        File file;
        File file2 = new File(System.getProperty("java.io.tmpdir"));
        while ((file = new File(file2, "vcs-" + Long.toString(System.currentTimeMillis()))).exists() || !file.mkdirs()) {
        }
        file.deleteOnExit();
        return FileUtil.normalizeFile((File)file);
    }

    public static String wordWrap(String string, int n) {
        int n2 = string.length() - 1;
        if (n < 1 || n2 < n) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = 0;
        while (true) {
            int n4;
            if ((n4 = n3 + n - 1) >= n2) break;
            int n5 = string.lastIndexOf(32, n4 + 1);
            if (n5 > n3) {
                stringBuilder.append(string.substring(n3, n5).trim());
                n3 = n5 + 1;
            } else {
                stringBuilder.append(string.substring(n3, n4 + 1));
                n3 = n4 + 1;
            }
            stringBuilder.append('\n');
        }
        stringBuilder.append(string.substring(n3));
        return stringBuilder.toString();
    }

    public static String getActionName(Class clazz, String string, VCSContext vCSContext) {
        Project project;
        Node node;
        Set set = vCSContext.getRootFiles();
        int n = set.size();
        Node[] nodeArray = vCSContext.getElements().lookupAll(Node.class).toArray(new Node[0]);
        boolean bl = true;
        for (int i = 0; i < nodeArray.length; ++i) {
            node = nodeArray[i];
            project = (Project)node.getLookup().lookup(Project.class);
            if (project != null) continue;
            bl = false;
            break;
        }
        if (bl) {
            n = nodeArray.length;
        }
        if (n == 0) {
            return NbBundle.getBundle((Class)clazz).getString(string);
        }
        if (n == 1) {
            String string2;
            if (bl) {
                String string3 = ProjectUtils.getInformation((Project)((Project)nodeArray[0].getLookup().lookup(Project.class))).getDisplayName();
                return NbBundle.getMessage((Class)clazz, (String)(string + "_Context"), (Object)string3);
            }
            node = (FileObject)nodeArray[0].getLookup().lookup(FileObject.class);
            if (node != null) {
                string2 = node.getNameExt();
            } else {
                project = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
                if (project instanceof DataShadow) {
                    project = ((DataShadow)project).getOriginal();
                }
                string2 = project != null ? project.getPrimaryFile().getNameExt() : nodeArray[0].getDisplayName();
            }
            return MessageFormat.format(NbBundle.getBundle((Class)clazz).getString(string + "_Context"), string2);
        }
        if (bl) {
            try {
                return MessageFormat.format(NbBundle.getBundle((Class)clazz).getString(string + "_Projects"), n);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getBundle((Class)clazz).getString(string + "_Context_Multiple"), n);
    }

    public static String getContextDisplayName(VCSContext vCSContext) {
        Node node;
        Set set = vCSContext.getFiles();
        int n = set.size();
        Node[] nodeArray = vCSContext.getElements().lookupAll(Node.class).toArray(new Node[0]);
        boolean bl = true;
        for (int i = 0; i < nodeArray.length; ++i) {
            node = nodeArray[i];
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project != null) continue;
            bl = false;
            break;
        }
        if (bl) {
            n = nodeArray.length;
        }
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            if (bl) {
                return ProjectUtils.getInformation((Project)((Project)nodeArray[0].getLookup().lookup(Project.class))).getDisplayName();
            }
            FileObject fileObject = (FileObject)nodeArray[0].getLookup().lookup(FileObject.class);
            if (fileObject != null) {
                return fileObject.getNameExt();
            }
            node = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
            if (node instanceof DataShadow) {
                node = ((DataShadow)node).getOriginal();
            }
            if (node != null) {
                return node.getPrimaryFile().getNameExt();
            }
            return nodeArray[0].getDisplayName();
        }
        if (bl) {
            try {
                return MessageFormat.format(NbBundle.getBundle(Utils.class).getString("MSG_ActionContext_MultipleProjects"), n);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return MessageFormat.format(NbBundle.getBundle(Utils.class).getString("MSG_ActionContext_MultipleFiles"), n);
    }

    public static void openFile(FileObject fileObject, String string) {
        ViewEnv viewEnv = new ViewEnv(fileObject);
        ViewCES viewCES = new ViewCES(viewEnv, fileObject.getNameExt() + " @ " + string, FileEncodingQuery.getEncoding((FileObject)fileObject));
        viewCES.view();
    }

    public static boolean isScanForbidden(File file) {
        for (File file2 : unversionedFolders) {
            if (!Utils.isAncestorOrEqual(file2, file)) continue;
            return true;
        }
        return false;
    }

    public static void openFile(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
                if (openCookie != null) {
                    openCookie.open();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void associateEncoding(File file, File file2) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || fileObject.isFolder()) {
            return;
        }
        Charset charset = FileEncodingQuery.getEncoding((FileObject)fileObject);
        if (charset == null) {
            return;
        }
        if (fileToCharset == null) {
            fileToCharset = new WeakHashMap<File, Charset>();
        }
        Map<File, Charset> map = fileToCharset;
        synchronized (map) {
            fileToCharset.put(file2, charset);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset getAssociatedEncoding(FileObject fileObject) {
        try {
            if (fileToCharset == null || fileToCharset.isEmpty() || fileObject == null || fileObject.isFolder()) {
                return null;
            }
            File file = FileUtil.toFile((FileObject)fileObject);
            if (file == null) {
                return null;
            }
            Map<File, Charset> map = fileToCharset;
            synchronized (map) {
                return fileToCharset.get(file);
            }
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(1, throwable);
            return null;
        }
    }

    public static Reader createReader(File file) throws FileNotFoundException {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return new FileReader(file);
        }
        return Utils.createReader(fileObject);
    }

    public static Reader createReader(FileObject fileObject) throws FileNotFoundException {
        return new InputStreamReader(fileObject.getInputStream(), FileEncodingQuery.getEncoding((FileObject)fileObject));
    }

    public static void logWarn(Class clazz, Throwable throwable) {
        Logger.getLogger(clazz.getName()).log(Level.WARNING, throwable.getMessage(), throwable);
    }

    public static void logError(Object object, Throwable throwable) {
        Logger.getLogger(object.getClass().getName()).log(Level.SEVERE, throwable.getMessage(), throwable);
    }

    public static void logFine(Object object, Exception exception) {
        Logger.getLogger(object.getClass().getName()).log(Level.FINE, exception.getMessage(), exception);
    }

    public static void logWarn(Object object, Throwable throwable) {
        Utils.logWarn(object.getClass(), throwable);
    }

    public static void setReadOnly(File file, boolean bl) {
        String[] stringArray = Utilities.isWindows() ? new String[]{"attrib", bl ? "+r" : "-r", file.getName()} : new String[]{"chmod", bl ? "u-w" : "u+w", file.getName()};
        try {
            Process process = Runtime.getRuntime().exec(stringArray, null, file.getParentFile());
            process.waitFor();
        }
        catch (Exception exception) {
            Utils.logWarn(Utils.class, (Throwable)exception);
        }
    }

    static {
        try {
            String string = VersioningSupport.getPreferences().get("unversionedFolders", null);
            if (string == null || string.length() == 0) {
                unversionedFolders = new File[0];
            } else {
                String[] stringArray = string.split("\\;");
                unversionedFolders = new File[stringArray.length];
                int n = 0;
                for (String string2 : stringArray) {
                    Utils.unversionedFolders[n++] = new File(string2);
                }
            }
        }
        catch (Exception exception) {
            unversionedFolders = new File[0];
            Logger.getLogger(Utils.class.getName()).log(Level.WARNING, exception.getMessage(), exception);
        }
    }

    private static class ViewCES
    extends CloneableEditorSupport {
        private final String name;
        private final Charset charset;

        public ViewCES(CloneableEditorSupport.Env env, String string, Charset charset) {
            super(env);
            this.name = string;
            this.charset = charset;
        }

        protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
            editorKit.read(new InputStreamReader(inputStream, this.charset), (Document)styledDocument, 0);
        }

        protected String messageSave() {
            return this.name;
        }

        protected String messageName() {
            return this.name;
        }

        protected String messageToolTip() {
            return this.name;
        }

        protected String messageOpening() {
            return this.name;
        }

        protected String messageOpened() {
            return this.name;
        }
    }

    private static class ViewEnv
    implements CloneableEditorSupport.Env {
        private final FileObject file;

        public ViewEnv(FileObject fileObject) {
            this.file = fileObject;
        }

        public InputStream inputStream() throws IOException {
            return this.file.getInputStream();
        }

        public OutputStream outputStream() throws IOException {
            throw new IOException();
        }

        public Date getTime() {
            return this.file.lastModified();
        }

        public String getMimeType() {
            return this.file.getMIMEType();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        }

        public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        }

        public boolean isValid() {
            return this.file.isValid();
        }

        public boolean isModified() {
            return false;
        }

        public void markModified() throws IOException {
            throw new IOException();
        }

        public void unmarkModified() {
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return null;
        }
    }
}

