/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.proxy;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.netbeans.modules.proxy.Base64Encoder;
import org.netbeans.modules.proxy.ConnectivitySettings;
import org.netbeans.modules.proxy.InterruptibleInputStream;
import org.openide.util.NbPreferences;

public class ProxySocketFactory
extends SocketFactory {
    private static final int CONNECT_TIMEOUT = 20000;
    private static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    private static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
    private static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
    private static final String AUTH_NONE = "<none>";
    private static final String AUTH_BASIC = "Basic";
    private static final Pattern sConnectionEstablishedPattern = Pattern.compile("HTTP\\/\\d+\\.\\d+\\s+200\\s+");
    private static final Pattern sProxyAuthRequiredPattern = Pattern.compile("HTTP\\/\\d+\\.\\d+\\s+407\\s+");
    private static final ProxySocketFactory instance = new ProxySocketFactory();
    private final Map<InetSocketAddress, ConnectivitySettings> lastKnownSettings = Collections.synchronizedMap(new HashMap(2));

    public static ProxySocketFactory getDefault() {
        return instance;
    }

    private ProxySocketFactory() {
    }

    public Socket createSocket() throws IOException {
        return new Socket(){

            public void connect(SocketAddress socketAddress, int n) throws IOException {
                Socket socket = ProxySocketFactory.this.createSocket((InetSocketAddress)socketAddress, n);
                socket.close();
            }

            public void bind(SocketAddress socketAddress) {
                throw new UnsupportedOperationException();
            }

            protected Object clone() {
                throw new UnsupportedOperationException();
            }

            public synchronized void close() {
            }

            public void connect(SocketAddress socketAddress) {
                throw new UnsupportedOperationException();
            }

            public SocketChannel getChannel() {
                throw new UnsupportedOperationException();
            }

            public InetAddress getInetAddress() {
                throw new UnsupportedOperationException();
            }

            public InputStream getInputStream() {
                throw new UnsupportedOperationException();
            }

            public boolean getKeepAlive() {
                throw new UnsupportedOperationException();
            }

            public InetAddress getLocalAddress() {
                throw new UnsupportedOperationException();
            }

            public int getLocalPort() {
                throw new UnsupportedOperationException();
            }

            public SocketAddress getLocalSocketAddress() {
                throw new UnsupportedOperationException();
            }

            public boolean getOOBInline() {
                throw new UnsupportedOperationException();
            }

            public OutputStream getOutputStream() {
                throw new UnsupportedOperationException();
            }

            public int getPort() {
                throw new UnsupportedOperationException();
            }

            public synchronized int getReceiveBufferSize() {
                throw new UnsupportedOperationException();
            }

            public SocketAddress getRemoteSocketAddress() {
                throw new UnsupportedOperationException();
            }

            public boolean getReuseAddress() {
                throw new UnsupportedOperationException();
            }

            public synchronized int getSendBufferSize() {
                throw new UnsupportedOperationException();
            }

            public int getSoLinger() {
                throw new UnsupportedOperationException();
            }

            public synchronized int getSoTimeout() {
                throw new UnsupportedOperationException();
            }

            public boolean getTcpNoDelay() {
                throw new UnsupportedOperationException();
            }

            public int getTrafficClass() {
                throw new UnsupportedOperationException();
            }

            public boolean isBound() {
                throw new UnsupportedOperationException();
            }

            public boolean isClosed() {
                throw new UnsupportedOperationException();
            }

            public boolean isConnected() {
                throw new UnsupportedOperationException();
            }

            public boolean isInputShutdown() {
                throw new UnsupportedOperationException();
            }

            public boolean isOutputShutdown() {
                throw new UnsupportedOperationException();
            }

            public void sendUrgentData(int n) {
                throw new UnsupportedOperationException();
            }

            public void setKeepAlive(boolean bl) {
                throw new UnsupportedOperationException();
            }

            public void setOOBInline(boolean bl) {
                throw new UnsupportedOperationException();
            }

            public synchronized void setReceiveBufferSize(int n) {
                throw new UnsupportedOperationException();
            }

            public void setReuseAddress(boolean bl) {
                throw new UnsupportedOperationException();
            }

            public synchronized void setSendBufferSize(int n) {
                throw new UnsupportedOperationException();
            }

            public void setSoLinger(boolean bl, int n) {
                throw new UnsupportedOperationException();
            }

            public synchronized void setSoTimeout(int n) {
                throw new UnsupportedOperationException();
            }

            public void setTcpNoDelay(boolean bl) {
                throw new UnsupportedOperationException();
            }

            public void setTrafficClass(int n) {
                throw new UnsupportedOperationException();
            }

            public void shutdownInput() {
                throw new UnsupportedOperationException();
            }

            public void shutdownOutput() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Socket createSocket(String string, int n) throws IOException {
        return this.createSocket(new InetSocketAddress(string, n), 20000);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.createSocket(new InetSocketAddress(inetAddress, n), 20000);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        throw new IOException("Unsupported operation");
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        throw new IOException("Unsupported operation");
    }

    private Socket getHttpsTunnelSocket(InetSocketAddress inetSocketAddress, ConnectivitySettings connectivitySettings, int n) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(connectivitySettings.getProxyHost(), connectivitySettings.getProxyPort()), n);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new InterruptibleInputStream(socket.getInputStream())));
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        dataOutputStream.writeBytes("CONNECT ");
        dataOutputStream.writeBytes(inetSocketAddress.getHostName() + ":" + inetSocketAddress.getPort());
        dataOutputStream.writeBytes(" HTTP/1.0\r\n");
        dataOutputStream.writeBytes("Connection: Keep-Alive\r\n\r\n");
        dataOutputStream.flush();
        String string = bufferedReader.readLine();
        if (sConnectionEstablishedPattern.matcher(string).find()) {
            while ((string = bufferedReader.readLine()).length() != 0) {
            }
            return socket;
        }
        if (sProxyAuthRequiredPattern.matcher(string).find()) {
            boolean bl = false;
            String string2 = AUTH_NONE;
            while ((string = bufferedReader.readLine()).length() != 0) {
                if (!string.startsWith("Proxy-Authenticate:") || bl || !(string2 = string.substring(19).trim()).equals(AUTH_BASIC)) continue;
                bl = true;
            }
            socket.close();
            if (string2.startsWith(AUTH_BASIC)) {
                return this.authenticateBasic(inetSocketAddress, connectivitySettings);
            }
            throw new IOException("Unsupported authentication method: " + string2);
        }
        socket.close();
        throw new IOException("HTTP proxy does not support CONNECT command. Received reply: " + string);
    }

    private Socket authenticateBasic(InetSocketAddress inetSocketAddress, ConnectivitySettings connectivitySettings) throws IOException {
        Socket socket = new Socket(connectivitySettings.getProxyHost(), connectivitySettings.getProxyPort());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new InterruptibleInputStream(socket.getInputStream())));
        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
        String string = connectivitySettings.getProxyUsername() == null ? "" : connectivitySettings.getProxyUsername();
        String string2 = connectivitySettings.getProxyPassword() == null ? "" : String.valueOf(connectivitySettings.getProxyPassword());
        String string3 = string + ":" + string2;
        String string4 = Base64Encoder.encode(string3.getBytes("US-ASCII"));
        dataOutputStream.writeBytes("CONNECT ");
        dataOutputStream.writeBytes(inetSocketAddress.getHostName() + ":" + inetSocketAddress.getPort());
        dataOutputStream.writeBytes(" HTTP/1.0\r\n");
        dataOutputStream.writeBytes("Connection: Keep-Alive\r\n");
        dataOutputStream.writeBytes("Proxy-Authorization: Basic " + string4 + "\r\n");
        dataOutputStream.writeBytes("\r\n");
        dataOutputStream.flush();
        String string5 = bufferedReader.readLine();
        if (sConnectionEstablishedPattern.matcher(string5).find()) {
            while ((string5 = bufferedReader.readLine()).length() != 0) {
            }
            return socket;
        }
        throw new IOException("Basic authentication failed: " + string5);
    }

    /*
     * Exception decompiling
     */
    private Socket createSocket(InetSocketAddress var1_1, int var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private URI addressToURI(InetSocketAddress inetSocketAddress, String string) {
        URI uRI;
        try {
            uRI = inetSocketAddress.isUnresolved() ? new URI(string + "://" + inetSocketAddress.getHostName() + ":" + inetSocketAddress.getPort()) : new URI(string + "://" + inetSocketAddress.getAddress().getHostAddress() + ":" + inetSocketAddress.getPort());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        return uRI;
    }

    private Socket createSocket(URI uRI, InetSocketAddress inetSocketAddress, int n) throws IOException {
        List<Proxy> list = ProxySelector.getDefault().select(uRI);
        IOException iOException = null;
        for (Proxy proxy : list) {
            ConnectivitySettings connectivitySettings = this.proxyToCs(proxy);
            try {
                Socket socket = this.createSocket(connectivitySettings, inetSocketAddress, n);
                this.lastKnownSettings.put(inetSocketAddress, connectivitySettings);
                return socket;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        throw iOException;
    }

    private ConnectivitySettings proxyToCs(Proxy proxy) {
        ConnectivitySettings connectivitySettings = new ConnectivitySettings();
        InetSocketAddress inetSocketAddress = (InetSocketAddress)proxy.address();
        switch (proxy.type()) {
            case HTTP: {
                this.setupProxy(connectivitySettings, 2, inetSocketAddress);
                break;
            }
            case SOCKS: {
                this.setupProxy(connectivitySettings, 1, inetSocketAddress);
                break;
            }
        }
        Preferences preferences = NbPreferences.root().node("org/netbeans/core");
        if (preferences.getBoolean(USE_PROXY_AUTHENTICATION, false)) {
            connectivitySettings.setProxyUsername(preferences.get(PROXY_AUTHENTICATION_USERNAME, null));
            connectivitySettings.setProxyPassword(preferences.get(PROXY_AUTHENTICATION_PASSWORD, null).toCharArray());
        }
        return connectivitySettings;
    }

    private void setupProxy(ConnectivitySettings connectivitySettings, int n, InetSocketAddress inetSocketAddress) {
        connectivitySettings.setConnectionType(n);
        InetAddress inetAddress = inetSocketAddress.getAddress();
        connectivitySettings.setProxyHost(inetAddress != null ? inetAddress.getHostAddress() : inetSocketAddress.getHostName());
        connectivitySettings.setProxyPort(inetSocketAddress.getPort());
    }

    private Socket createSocket(ConnectivitySettings connectivitySettings, InetSocketAddress inetSocketAddress, int n) throws IOException {
        switch (connectivitySettings.getConnectionType()) {
            case 0: 
            case 1: {
                Socket socket = new Socket();
                socket.connect(inetSocketAddress, n);
                return socket;
            }
            case 2: {
                return this.getHttpsTunnelSocket(inetSocketAddress, connectivitySettings, n);
            }
        }
        throw new IllegalArgumentException("Illegal connection type: " + connectivitySettings.getConnectionType());
    }
}

