/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xslt.core;

import java.awt.EventQueue;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.api.xml.cookies.CookieObserver;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.modules.soa.ui.UndoRedoManagerProvider;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.validation.ShowCookie;
import org.netbeans.modules.xml.validation.ui.ValidationAnnotation;
import org.netbeans.modules.xml.xam.AbstractModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.netbeans.modules.xml.xam.ui.undo.QuietUndoManager;
import org.netbeans.modules.xslt.core.XSLTDataObject;
import org.netbeans.modules.xslt.core.context.MapperContextFactory;
import org.netbeans.modules.xslt.core.multiview.XsltMultiViewSupport;
import org.netbeans.modules.xslt.mapper.model.MapperContext;
import org.netbeans.modules.xslt.model.XslModel;
import org.netbeans.modules.xslt.model.spi.XslModelFactory;
import org.netbeans.modules.xslt.tmap.util.Util;
import org.openide.ErrorManager;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.UserCancelException;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XSLTDataEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
ShowCookie,
UndoRedoManagerProvider {
    private transient Task prepareTask;
    private ValidationAnnotation myAnnotation = new ValidationAnnotation();

    public XSLTDataEditorSupport(XSLTDataObject xSLTDataObject) {
        super((DataObject)xSLTDataObject, (CloneableEditorSupport.Env)new XSLTEnv(xSLTDataObject));
        this.setMIMEType("application/xslt+xml");
    }

    public UndoRedo.Manager getUndoRedoManager() {
        return this.getUndoManager();
    }

    public void saveDocument() throws IOException {
        super.saveDocument();
        this.syncModel();
        this.getDataObject().setModified(false);
    }

    public void syncModel() {
        try {
            XslModel xslModel = this.getXslModel();
            if (xslModel != null) {
                xslModel.sync();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
    }

    public QuietUndoManager getUndoManager() {
        return (QuietUndoManager)this.getUndoRedo();
    }

    public XslModel getXslModel() {
        XSLTDataObject xSLTDataObject = this.getEnv().getXsltDataObject();
        ModelSource modelSource = Utilities.getModelSource((FileObject)xSLTDataObject.getPrimaryFile(), (boolean)true);
        return this.getModelFactory().getModel(modelSource);
    }

    public void show(final Validator.ResultItem resultItem) {
        if (!(resultItem.getModel() instanceof AbstractModel)) {
            return;
        }
        Component component = resultItem.getComponents();
        DataObject dataObject = this.getDataObject();
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        final EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
        if (lineCookie == null || editCookie == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                editCookie.edit();
                TopComponent topComponent = WindowManager.getDefault().getRegistry().getActivated();
                MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
                if (multiViewHandler == null) {
                    return;
                }
                if (resultItem.getModel().getState().equals((Object)Model.State.NOT_WELL_FORMED) || resultItem.getComponents() == null) {
                    for (int i = 0; i < multiViewHandler.getPerspectives().length; ++i) {
                        if (!multiViewHandler.getPerspectives()[i].preferredID().equals("xsltsource")) continue;
                        multiViewHandler.requestActive(multiViewHandler.getPerspectives()[i]);
                    }
                }
            }
        });
    }

    public MapperContext getMapperContext() {
        return this.getEnv().getMapperContext();
    }

    private List<TopComponent> getAssociatedTopComponents() {
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        DataObject dataObject = this.getDataObject();
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null && dataObject == (DataObject)topComponent.getLookup().lookup(DataObject.class)) {
            arrayList.add(topComponent);
        }
        Set set = TopComponent.getRegistry().getOpened();
        for (Object e : set) {
            TopComponent topComponent2 = (TopComponent)e;
            if (dataObject != (DataObject)topComponent2.getLookup().lookup(DataObject.class)) continue;
            arrayList.add(topComponent2);
        }
        return arrayList;
    }

    public boolean validateXML(CookieObserver cookieObserver) {
        return true;
    }

    protected CloneableEditorSupport.Pane createPane() {
        CloneableTopComponent cloneableTopComponent = XsltMultiViewSupport.createMultiView((XSLTDataObject)this.getDataObject());
        Mode mode = WindowManager.getDefault().findMode("editor");
        if (mode != null) {
            mode.dockInto((TopComponent)cloneableTopComponent);
        }
        return (CloneableEditorSupport.Pane)cloneableTopComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyClosed() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            XslModel xslModel;
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.endCompound();
                quietUndoManager.setDocument(null);
            }
            if ((xslModel = this.getXslModel()) != null) {
                xslModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            }
            quietUndoManager.setModel(null);
        }
        super.notifyClosed();
        this.getUndoManager().discardAllEdits();
        this.prepareTask = null;
    }

    protected boolean notifyModified() {
        boolean bl = super.notifyModified();
        if (!bl) {
            return false;
        }
        XSLTDataObject xSLTDataObject = this.getEnv().getXsltDataObject();
        if (xSLTDataObject.getCookie(SaveCookie.class) == null) {
            xSLTDataObject.addSaveCookie(new SaveCookie(){

                public void save() throws IOException {
                    try {
                        XSLTDataEditorSupport.this.saveDocument();
                    }
                    catch (UserCancelException userCancelException) {
                        // empty catch block
                    }
                }
            });
        }
        return true;
    }

    protected void updateTitles() {
        super.updateTitles();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                List list = XSLTDataEditorSupport.this.getAssociatedTopComponents();
                for (TopComponent topComponent : list) {
                    MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
                    if (multiViewHandler == null || topComponent == null) continue;
                    topComponent.setHtmlDisplayName(XSLTDataEditorSupport.this.messageHtmlName());
                    String string = XSLTDataEditorSupport.this.messageName();
                    topComponent.setDisplayName(string);
                    topComponent.setName(string);
                    topComponent.setToolTipText(XSLTDataEditorSupport.this.messageToolTip());
                }
            }
        });
    }

    protected XSLTEnv getEnv() {
        return (XSLTEnv)this.env;
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        return new QuietUndoManager(super.createUndoRedoManager());
    }

    public void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        super.initializeCloneableEditor(cloneableEditor);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                XSLTDataEditorSupport.this.updateTitles();
            }
        });
    }

    public Task prepareDocument() {
        Task task = super.prepareDocument();
        if (task == this.prepareTask) {
            return task;
        }
        task.addTaskListener(new TaskListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void taskFinished(Task task) {
                QuietUndoManager quietUndoManager = (QuietUndoManager)XSLTDataEditorSupport.this.getUndoRedo();
                StyledDocument styledDocument = XSLTDataEditorSupport.this.getDocument();
                QuietUndoManager quietUndoManager2 = quietUndoManager;
                synchronized (quietUndoManager2) {
                    quietUndoManager.setDocument((AbstractDocument)((Object)styledDocument));
                    if (!quietUndoManager.isCompound()) {
                        styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                        XSLTDataEditorSupport.this.addUndoManagerToModel(quietUndoManager);
                    }
                }
            }
        });
        return task;
    }

    public Task reloadDocument() {
        Task task = super.reloadDocument();
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                EventQueue.invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        QuietUndoManager quietUndoManager = XSLTDataEditorSupport.this.getUndoManager();
                        StyledDocument styledDocument = XSLTDataEditorSupport.this.getDocument();
                        QuietUndoManager quietUndoManager2 = quietUndoManager;
                        synchronized (quietUndoManager2) {
                            if (!quietUndoManager.isCompound() && styledDocument != null) {
                                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                            }
                        }
                    }
                });
            }
        });
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUndoManagerToDocument() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            this.removeUndoManagerFromModel();
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                styledDocument.addUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.beginCompound();
            }
        }
    }

    public void addUndoManagerToModel(QuietUndoManager quietUndoManager) {
        XslModel xslModel = this.getXslModel();
        if (xslModel != null) {
            this.removeUndoManagerFromModel();
            xslModel.addUndoableEditListener((UndoableEditListener)quietUndoManager);
            quietUndoManager.setModel((Model)xslModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUndoManagerFromDocument() {
        QuietUndoManager quietUndoManager = this.getUndoManager();
        StyledDocument styledDocument = this.getDocument();
        QuietUndoManager quietUndoManager2 = quietUndoManager;
        synchronized (quietUndoManager2) {
            if (styledDocument != null) {
                styledDocument.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
                quietUndoManager.endCompound();
            }
            this.addUndoManagerToModel(quietUndoManager);
        }
    }

    private void removeUndoManagerFromModel() {
        XslModel xslModel = this.getXslModel();
        if (xslModel != null) {
            QuietUndoManager quietUndoManager = this.getUndoManager();
            xslModel.removeUndoableEditListener((UndoableEditListener)quietUndoManager);
            quietUndoManager.setModel(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean suspendUndoRedo() {
        boolean bl;
        QuietUndoManager quietUndoManager;
        QuietUndoManager quietUndoManager2 = quietUndoManager = this.getUndoManager();
        synchronized (quietUndoManager2) {
            bl = quietUndoManager.isCompound();
            if (bl) {
                this.removeUndoManagerFromDocument();
            }
            this.removeUndoManagerFromModel();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeUndoRedo(boolean bl) {
        if (bl) {
            this.addUndoManagerToDocument();
        } else {
            QuietUndoManager quietUndoManager;
            QuietUndoManager quietUndoManager2 = quietUndoManager = this.getUndoManager();
            synchronized (quietUndoManager2) {
                this.addUndoManagerToModel(quietUndoManager);
            }
        }
    }

    private XslModelFactory getModelFactory() {
        XslModelFactory xslModelFactory = (XslModelFactory)Lookup.getDefault().lookup(XslModelFactory.class);
        return xslModelFactory;
    }

    public boolean silentClose() {
        return super.close(false);
    }

    public static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = -4621077799099893176L;
        private XSLTDataObject myDataObject;

        private CloseHandler() {
        }

        public CloseHandler(XSLTDataObject xSLTDataObject) {
            this.myDataObject = xSLTDataObject;
        }

        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            XSLTDataEditorSupport xSLTDataEditorSupport;
            XSLTDataEditorSupport xSLTDataEditorSupport2 = xSLTDataEditorSupport = this.myDataObject == null ? null : (XSLTDataEditorSupport)this.myDataObject.getCookie(XSLTDataEditorSupport.class);
            if (xSLTDataEditorSupport == null) {
                return true;
            }
            boolean bl = xSLTDataEditorSupport.canClose();
            if (bl) {
                if (this.myDataObject.isValid()) {
                    xSLTDataEditorSupport.reloadDocument().waitFinished();
                }
                this.myDataObject.setModified(false);
            }
            return bl;
        }
    }

    private static class XSLTEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 835762240381934851L;

        public XSLTEnv(XSLTDataObject xSLTDataObject) {
            super((DataObject)xSLTDataObject);
        }

        public XSLTDataObject getXsltDataObject() {
            return (XSLTDataObject)this.getDataObject();
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public MapperContext getMapperContext() {
            FileObject fileObject = this.getFile();
            Project project = Util.getProject((FileObject)fileObject);
            MapperContext mapperContext = null;
            mapperContext = MapperContextFactory.getInstance().createMapperContext(fileObject, project);
            return mapperContext;
        }
    }
}

