/*
 * Decompiled with CFR 0.152.
 */
package ricoh.util.dom;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ricoh.util.dom.DOMHandler;

public class DalpDOMHandler
extends DOMHandler {
    public static final String DEFAULT_DALP_VERSION_STR = "0.10";
    public static final String DEFAULT_BASEPATH = "current";
    public static final String DEFAULT_LOCATION = "jar";
    public static final String DSDK_VERSION_STR = "1.0";
    public static final String APP_VISIBLE_STR = "true";
    public static final String INSTALL_MODE = "manual";
    public static final String INSTALL_DEST = "hdd";
    public static final int DIGITS_IN_UID = 8;
    private String appName = null;
    private String appVersion = null;
    private String email = null;
    private String description = null;
    private String detailDescription = null;
    private String fax = null;
    private String iconPath = null;
    private String mainClass = null;
    private String phone = null;
    private String targetJar = null;
    private String uid = null;
    private String vendor = null;
    private String dalpSpecVer = null;
    private String seperator;

    public DalpDOMHandler() {
        this.setCompression(false);
    }

    public void setDalpSpecVersion(String string) {
        this.dalpSpecVer = string;
    }

    public String getDalpSpecVersion() {
        return this.dalpSpecVer;
    }

    public void setAppID(String string) {
        this.uid = string;
    }

    public String getAppID() {
        return this.uid;
    }

    public void setXletClass(String string) {
        this.mainClass = string;
    }

    public String getXletClass() {
        return this.mainClass;
    }

    public void setEmail(String string) {
        this.email = string;
    }

    public String getEmail() {
        return this.email;
    }

    public void setFax(String string) {
        this.fax = string;
    }

    public String getFax() {
        return this.fax;
    }

    public void setTelephone(String string) {
        this.phone = string;
    }

    public String getTelephone() {
        return this.phone;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String string) {
        this.appName = string;
    }

    public void setAppVersion(String string) {
        this.appVersion = string;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setIconPath(String string) {
        this.iconPath = string;
        this.seperator = string.indexOf("/") == -1 ? "\\" : "/";
    }

    public void setTargetJar(String string) {
        this.targetJar = string;
    }

    public String getTargetJar() {
        return this.targetJar;
    }

    public boolean failRequiredInfo() {
        return !DalpDOMHandler.isValidUid(this.uid);
    }

    public static boolean isValidUid(String string) {
        if (string == null) {
            return false;
        }
        try {
            if (Integer.parseInt(string) < 0) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public Document loadDocument(File file) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(file);
            return document;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Document makeDocument() {
        Element element;
        if (this.failRequiredInfo()) {
            return null;
        }
        Element element2 = this.document.createElement("dalp");
        element2.setAttribute("dsdk", "");
        element2.setAttribute("version", DEFAULT_DALP_VERSION_STR);
        this.document.appendChild(element2);
        Element element3 = this.document.createElement("information");
        element2.appendChild(element3);
        Element element4 = this.document.createElement("product-id");
        element4.setTextContent(this.uid);
        element3.appendChild(element4);
        Element element5 = this.document.createElement("title");
        element3.appendChild(element5);
        element5.setTextContent(this.appName);
        Element element6 = this.document.createElement("vendor");
        element3.appendChild(element6);
        element6.setTextContent(this.vendor);
        if (this.iconPath != null && !this.iconPath.trim().equals("")) {
            element = this.document.createElement("icon");
            element3.appendChild(element);
            element.setAttribute("href", "./" + this.targetJar + ".jar");
            element.setAttribute("basepath", DEFAULT_BASEPATH);
            element.setAttribute("location", DEFAULT_LOCATION);
            element.setTextContent(this.iconPath.substring(this.iconPath.lastIndexOf(this.seperator) + 1));
        }
        element = this.document.createElement("description");
        Element element7 = this.document.createElement("description");
        element3.appendChild(element);
        element3.appendChild(element7);
        element.setTextContent(this.description);
        element7.setAttribute("type", "detail");
        element7.setTextContent(this.detailDescription);
        Element element8 = this.document.createElement("telephone");
        Element element9 = this.document.createElement("fax");
        Element element10 = this.document.createElement("e-mail");
        element8.setTextContent(this.phone);
        element9.setTextContent(this.fax);
        element10.setTextContent(this.email);
        element3.appendChild(element8);
        element3.appendChild(element9);
        element3.appendChild(element10);
        Element element11 = this.document.createElement("application-ver");
        element11.setTextContent(this.appVersion);
        element3.appendChild(element11);
        Element element12 = this.document.createElement("offline-allowed");
        element3.appendChild(element12);
        Element element13 = this.document.createElement("security");
        element2.appendChild(element13);
        Element element14 = this.document.createElement("all-permissions");
        element13.appendChild(element14);
        Element element15 = this.document.createElement("resources");
        element2.appendChild(element15);
        Element element16 = this.document.createElement("dsdk");
        element16.setAttribute("version", DSDK_VERSION_STR);
        element15.appendChild(element16);
        Element element17 = this.document.createElement(DEFAULT_LOCATION);
        element17.setAttribute("href", "./" + this.targetJar + ".jar");
        element17.setAttribute("version", this.appVersion);
        element17.setAttribute("basepath", DEFAULT_BASEPATH);
        element15.appendChild(element17);
        Element element18 = this.document.createElement("encode-file");
        if (this.targetJar.contains(".jar")) {
            element18.setTextContent(this.targetJar.substring(0, this.targetJar.indexOf(".jar")).toLowerCase());
        } else {
            element18.setTextContent(this.targetJar.toLowerCase());
        }
        element15.appendChild(element18);
        Element element19 = this.document.createElement("application-desc");
        element19.setAttribute("main-class", this.mainClass);
        element19.setAttribute("visible", APP_VISIBLE_STR);
        element2.appendChild(element19);
        Element element20 = this.document.createElement("install");
        element20.setAttribute("mode", INSTALL_MODE);
        element20.setAttribute("destination", INSTALL_DEST);
        element2.appendChild(element20);
        return this.document;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String string) {
        this.vendor = string;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDetailDescription() {
        return this.detailDescription;
    }

    public void setDetailDescription(String string) {
        this.detailDescription = string;
    }
}

