/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.wizards;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBColumn;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBTable;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.impl.DBTableImpl;
import org.netbeans.modules.jdbcwizard.wizards.ChosenColumnPanel;
import org.netbeans.modules.jdbcwizard.wizards.InsertColumnPanel;
import org.netbeans.modules.jdbcwizard.wizards.PolledColumnPanel;
import org.netbeans.modules.jdbcwizard.wizards.UpdateColumnPanel;
import org.openide.util.NbBundle;

public class JDBCWizardTablePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel headerPnl;
    private MetaTableComponent metaDataTable;
    private JScrollPane tableScroll;
    private static final String SEPARATOR = " - ";

    public JDBCWizardTablePanel() {
    }

    public JDBCWizardTablePanel(List list) {
        this.setOpaque(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setOpaque(false);
        this.headerPnl = new JPanel();
        this.headerPnl.setLayout(new BorderLayout());
        this.headerPnl.setOpaque(false);
        this.headerPnl.add((Component)jPanel, "North");
        this.addTable(list);
    }

    public JTable getTable() {
        return this.metaDataTable;
    }

    public List getTables() {
        MyTableModel myTableModel = (MyTableModel)this.metaDataTable.getModel();
        return myTableModel.getTables();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void resetTable(List list) {
        MyTableModel myTableModel = new MyTableModel(list);
        this.metaDataTable.setModel(myTableModel);
        this.metaDataTable.getColumn(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"LBL_PROP")).setCellRenderer(new MyButtonRenderer());
        this.metaDataTable.getColumn(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"LBL_PROP")).setCellEditor(new MyButtonRenderer());
        TableColumn tableColumn = this.metaDataTable.getColumnModel().getColumn(0);
        tableColumn.setResizable(true);
        tableColumn.setPreferredWidth(80);
        TableColumn tableColumn2 = this.metaDataTable.getColumnModel().getColumn(2);
        tableColumn2.setResizable(true);
        tableColumn2.setPreferredWidth(80);
    }

    public void addTable(List list) {
        this.metaDataTable = new MetaTableComponent();
        MyTableModel myTableModel = new MyTableModel(list);
        this.metaDataTable.setModel(myTableModel);
        this.metaDataTable.getColumn(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"LBL_PROP")).setCellRenderer(new MyButtonRenderer());
        this.metaDataTable.getColumn(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"LBL_PROP")).setCellEditor(new MyButtonRenderer());
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(100, 100));
        this.setMaximumSize(new Dimension(150, 150));
        TableColumn tableColumn = this.metaDataTable.getColumnModel().getColumn(0);
        tableColumn.setResizable(true);
        tableColumn.setPreferredWidth(40);
        this.tableScroll = new JScrollPane(this.metaDataTable);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.GRAY));
        this.tableScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), compoundBorder));
        this.add((Component)this.tableScroll, "Center");
    }

    class RowDataWrapper {
        private DBTable table;

        public RowDataWrapper(DBTable dBTable) {
            this.table = dBTable;
        }

        public Object getTable() {
            return this.table;
        }

        public Boolean isEditable() {
            return this.table.isEditable() ? Boolean.TRUE : Boolean.FALSE;
        }

        public Boolean isSelected() {
            return this.table.isSelected() ? Boolean.TRUE : Boolean.FALSE;
        }

        public void setEditable(Boolean bl) {
            this.table.setEditable(bl);
        }

        public void setSelected(Boolean bl) {
            this.table.setSelected(bl);
        }
    }

    static class MyTableModelCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        protected static Border noFocusBorder1 = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            MyTableModel myTableModel = (MyTableModel)jTable.getModel();
            RowDataWrapper rowDataWrapper = myTableModel.getRowDataWrapper(n);
            if (rowDataWrapper != null && !rowDataWrapper.isEditable().booleanValue()) {
                jLabel.setEnabled(false);
                jLabel.setBackground(Color.lightGray);
                Object object2 = rowDataWrapper.getTable();
                DBTable dBTable = (DBTable)object2;
                if (!dBTable.isSelected()) {
                    jLabel.setToolTipText(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"TOOLTIP_source_table_disabled_unselected", (Object)rowDataWrapper.getTable()));
                }
                jLabel.setBorder(noFocusBorder1);
                jLabel.setFocusable(false);
            } else {
                DBTable dBTable;
                if (bl) {
                    jLabel.setForeground(jTable.getSelectionForeground());
                    jLabel.setBackground(jTable.getSelectionBackground());
                } else {
                    jLabel.setForeground(jTable.getForeground());
                    jLabel.setBackground(jTable.getBackground());
                }
                if (object instanceof DBTable && (dBTable = (DBTable)object).getName() != null) {
                    this.setText(dBTable.getName());
                }
                jLabel.setToolTipText("");
                jLabel.setEnabled(true);
                jLabel.setFocusable(true);
            }
            return jLabel;
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] columnNames = new String[]{NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"LBL_SEL"), NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"LBL_TAB_NAME"), NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"LBL_PROP")};
        private List rowList = new ArrayList();

        public MyTableModel(List list) {
            for (int i = 0; i < list.size(); ++i) {
                RowDataWrapper rowDataWrapper = new RowDataWrapper((DBTable)list.get(i));
                this.rowList.add(rowDataWrapper);
            }
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public int getRowCount() {
            return this.rowList.size();
        }

        public RowDataWrapper getRowDataWrapper(int n) {
            if (n < this.rowList.size()) {
                return (RowDataWrapper)this.rowList.get(n);
            }
            return null;
        }

        public ArrayList getTables() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < this.rowList.size(); ++i) {
                RowDataWrapper rowDataWrapper = (RowDataWrapper)this.rowList.get(i);
                arrayList.add(rowDataWrapper.getTable());
            }
            return arrayList;
        }

        public Object getValueAt(int n, int n2) {
            RowDataWrapper rowDataWrapper = (RowDataWrapper)this.rowList.get(n);
            switch (n2) {
                case 0: {
                    return rowDataWrapper.isSelected();
                }
                case 1: {
                    return rowDataWrapper.getTable();
                }
            }
            return String.valueOf(n2 + "?");
        }

        public boolean isCellEditable(int n, int n2) {
            Object e = this.rowList.get(n);
            return true;
        }

        public void setCellEditable(int n, int n2, boolean bl) {
            Object e = this.rowList.get(n);
            if (e != null) {
                ((RowDataWrapper)e).setEditable(bl ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void setValueAt(Object object, int n, int n2) {
            RowDataWrapper rowDataWrapper = (RowDataWrapper)this.rowList.get(n);
            switch (n2) {
                case 0: {
                    rowDataWrapper.setSelected((Boolean)object);
                    this.fireTableRowsUpdated(n, n);
                }
            }
        }
    }

    class ColumnAction
    implements ActionListener {
        protected JButton okbutton = new JButton(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"LABEL_BTN_OK"));
        protected JButton cancelbutton = new JButton(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"LABEL_BTN_CANCEL"));
        protected JButton selectallbutton = new JButton(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"LABEL_BTN_SELECT_ALL"));
        protected JButton clearallbutton = new JButton(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"LABEL_BTN_CLEAR_ALL"));
        protected JPanel buttonpanel = new JPanel();
        protected InsertColumnPanel correspInsertCol;
        protected UpdateColumnPanel correspUpdateCol;
        protected ChosenColumnPanel correspChosenCol;
        protected PolledColumnPanel correspPolledCol;
        protected JTabbedPane myTabpane;
        ColumnDialog columnDisplayDialog = null;
        protected String title = NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"TITLE_COLS");
        RowDataWrapper takes;

        public ColumnAction(RowDataWrapper rowDataWrapper) {
            this.takes = rowDataWrapper;
            this.columnDisplayDialog = new ColumnDialog(new JDialog(), true);
            this.columnDisplayDialog.setAlwaysOnTop(true);
            this.columnDisplayDialog.setResizable(true);
            this.columnDisplayDialog.setEnabled(true);
            this.columnDisplayDialog.setFocusable(true);
            this.okbutton.setMnemonic(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"MNE_BTN_OK").charAt(0));
            this.cancelbutton.setMnemonic(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"MNE_BTN_CANCEL").charAt(0));
            this.selectallbutton.setMnemonic(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"MNE_BTN_SELECT_ALL").charAt(0));
            this.clearallbutton.setMnemonic(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"MNE_BTN_CLEAR_ALL").charAt(0));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.takes != null && this.takes.isSelected().booleanValue()) {
                this.correspInsertCol = new InsertColumnPanel();
                this.correspInsertCol.addColumnTable(((DBTable)this.takes.getTable()).getColumnList());
                this.correspUpdateCol = new UpdateColumnPanel();
                this.correspUpdateCol.addColumnTable(((DBTable)this.takes.getTable()).getColumnList());
                this.correspChosenCol = new ChosenColumnPanel();
                this.correspChosenCol.addColumnTable(((DBTable)this.takes.getTable()).getColumnList());
                this.correspPolledCol = new PolledColumnPanel();
                this.correspPolledCol.addColumnTable(((DBTable)this.takes.getTable()).getColumnList());
                this.title = this.title.concat(JDBCWizardTablePanel.SEPARATOR + ((DBTable)this.takes.getTable()).getName());
                this.initializeColumn();
            } else {
                JOptionPane.showMessageDialog(null, "Please select the table to select additional properties", "Column Selection", 2);
            }
        }

        public void initializeColumn() {
            this.columnDisplayDialog.setTitle(this.title);
            this.correspInsertCol.setName(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"TITLE_INS"));
            this.correspUpdateCol.setName(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"TITLE_UPDT"));
            this.correspChosenCol.setName(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"TITLE_FIND"));
            this.correspPolledCol.setName(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"TITLE_POLL"));
            this.myTabpane = new JTabbedPane();
            this.myTabpane.add(this.correspInsertCol);
            this.myTabpane.add(this.correspUpdateCol);
            this.myTabpane.add(this.correspChosenCol);
            this.myTabpane.add(this.correspPolledCol);
            this.columnDisplayDialog.add((Component)this.myTabpane, "Center");
            this.cancelbutton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColumnAction.this.cleanUp();
                }
            });
            this.okbutton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColumnAction.this.okAction();
                }
            });
            this.selectallbutton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColumnAction.this.selectAllAction(ColumnAction.this.myTabpane.getSelectedIndex());
                }
            });
            this.clearallbutton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ColumnAction.this.clearAllAction(ColumnAction.this.myTabpane.getSelectedIndex());
                }
            });
            this.buttonpanel.add((Component)this.selectallbutton, "Before");
            this.buttonpanel.add((Component)this.clearallbutton, "West");
            this.buttonpanel.add((Component)this.okbutton, "East");
            this.buttonpanel.add((Component)this.cancelbutton, "After");
            this.columnDisplayDialog.add((Component)this.buttonpanel, "South");
            this.centerWindowOnScreen(this.columnDisplayDialog);
            this.columnDisplayDialog.setSize(new Dimension(400, 300));
            this.columnDisplayDialog.setVisible(true);
        }

        public void cleanUp() {
            for (int i = 0; i < this.correspInsertCol.getColumnTable().getModel().getRowCount(); ++i) {
                ((DBColumn)this.correspInsertCol.getColumnTables().get(i)).setSelected(true);
            }
            this.columnDisplayDialog.dispose();
            this.title = NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"TITLE_COLS");
        }

        public void okAction() {
            this.columnDisplayDialog.dispose();
            this.title = NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"TITLE_COLS");
        }

        public void selectAllAction(int n) {
            switch (n) {
                case 0: {
                    int n2;
                    for (n2 = 0; n2 < this.correspInsertCol.getColumnTable().getModel().getRowCount(); ++n2) {
                        DBColumn dBColumn = (DBColumn)this.correspInsertCol.getColumnTables().get(n2);
                        dBColumn.setInsertSelected(true);
                    }
                    this.correspInsertCol.repaint();
                    break;
                }
                case 1: {
                    int n2;
                    while (n2 < this.correspUpdateCol.getColumnTable().getModel().getRowCount()) {
                        DBColumn dBColumn = (DBColumn)this.correspUpdateCol.getColumnTables().get(n2);
                        dBColumn.setUpdateSelected(true);
                        ++n2;
                    }
                    this.correspUpdateCol.repaint();
                    break;
                }
                case 2: {
                    int n2;
                    while (n2 < this.correspChosenCol.getColumnTable().getModel().getRowCount()) {
                        DBColumn dBColumn = (DBColumn)this.correspChosenCol.getColumnTables().get(n2);
                        dBColumn.setChooseSelected(true);
                        ++n2;
                    }
                    this.correspChosenCol.repaint();
                    break;
                }
                case 3: {
                    int n2;
                    while (n2 < this.correspPolledCol.getColumnTable().getModel().getRowCount()) {
                        DBColumn dBColumn = (DBColumn)this.correspPolledCol.getColumnTables().get(n2);
                        dBColumn.setPollSelected(true);
                        ++n2;
                    }
                    this.correspPolledCol.repaint();
                }
            }
        }

        public void clearAllAction(int n) {
            switch (n) {
                case 0: {
                    int n2;
                    for (n2 = 0; n2 < this.correspInsertCol.getColumnTable().getModel().getRowCount(); ++n2) {
                        DBColumn dBColumn = (DBColumn)this.correspInsertCol.getColumnTables().get(n2);
                        if (!dBColumn.isNullable()) continue;
                        dBColumn.setInsertSelected(false);
                    }
                    this.correspInsertCol.repaint();
                    break;
                }
                case 1: {
                    int n2;
                    while (n2 < this.correspUpdateCol.getColumnTable().getModel().getRowCount()) {
                        DBColumn dBColumn = (DBColumn)this.correspUpdateCol.getColumnTables().get(n2);
                        dBColumn.setUpdateSelected(false);
                        ++n2;
                    }
                    this.correspUpdateCol.repaint();
                    break;
                }
                case 2: {
                    int n2;
                    while (n2 < this.correspChosenCol.getColumnTable().getModel().getRowCount()) {
                        DBColumn dBColumn = (DBColumn)this.correspChosenCol.getColumnTables().get(n2);
                        dBColumn.setChooseSelected(false);
                        ++n2;
                    }
                    this.correspChosenCol.repaint();
                    break;
                }
                case 3: {
                    int n2;
                    while (n2 < this.correspPolledCol.getColumnTable().getModel().getRowCount()) {
                        DBColumn dBColumn = (DBColumn)this.correspPolledCol.getColumnTables().get(n2);
                        dBColumn.setPollSelected(false);
                        ++n2;
                    }
                    this.correspPolledCol.repaint();
                }
            }
        }

        public void centerWindowOnScreen(Window window) {
            window.pack();
            Rectangle rectangle = window.getBounds();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            rectangle.x = Math.max(0, (dimension.width - rectangle.width) / 3);
            rectangle.y = Math.max(0, (dimension.height - rectangle.height) / 3);
            window.setBounds(rectangle);
        }

        protected class ColumnDialog
        extends JDialog {
            private static final long serialVersionUID = 1L;

            ColumnDialog(JDialog jDialog, boolean bl) {
                super((Dialog)jDialog, bl);
            }
        }
    }

    class MyButtonRenderer
    extends JButton
    implements TableCellRenderer,
    TableCellEditor {
        private static final long serialVersionUID = 1L;
        private JPanel myButPanel;

        MyButtonRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.myButPanel = new JPanel();
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.myButPanel.setLayout(new BorderLayout());
            this.myButPanel.add((Component)this, "Center");
            this.myButPanel.setOpaque(true);
            this.myButPanel.setEnabled(false);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            RowDataWrapper rowDataWrapper = ((MyTableModel)jTable.getModel()).getRowDataWrapper(n);
            if (rowDataWrapper != null && !rowDataWrapper.isEditable().booleanValue()) {
                DBTable dBTable;
                this.setEnabled(false);
                this.setFocusable(false);
                this.setBackground(Color.LIGHT_GRAY);
                Object object2 = rowDataWrapper.getTable();
                if (object2 instanceof DBTable && !(dBTable = (DBTable)object2).isSelected()) {
                    this.setToolTipText(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"TOOLTIP_source_table_disabled_unselected", (Object)rowDataWrapper.getTable()));
                }
            } else {
                if (bl) {
                    this.myButPanel.setBackground(Color.LIGHT_GRAY);
                    this.setForeground(jTable.getSelectionForeground());
                    this.setBackground(jTable.getSelectionBackground());
                    this.myButPanel.setForeground(jTable.getSelectionForeground());
                    this.myButPanel.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setForeground(jTable.getForeground());
                    this.setBackground(jTable.getBackground());
                    this.myButPanel.setForeground(jTable.getForeground());
                    this.myButPanel.setBackground(jTable.getBackground());
                }
                if (bl2) {
                    this.myButPanel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                    if (jTable.isCellEditable(n, n2)) {
                        this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                        this.setBackground(UIManager.getColor("Table.focusCellBackground"));
                    }
                    this.myButPanel.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    this.myButPanel.setBackground(UIManager.getColor("Table.focusCellBackground"));
                }
                this.setEnabled(true);
                this.setFocusable(true);
                this.setText(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"LABEL_BTN_ADV"));
                this.setMnemonic(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"MNE_BTN_ADV").charAt(0));
            }
            return this.myButPanel;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            RowDataWrapper rowDataWrapper = ((MyTableModel)jTable.getModel()).getRowDataWrapper(n);
            this.addActionListener(new ColumnAction(rowDataWrapper));
            if (rowDataWrapper != null && !rowDataWrapper.isEditable().booleanValue()) {
                DBTable dBTable;
                this.setEnabled(false);
                this.setFocusable(false);
                this.setBackground(Color.LIGHT_GRAY);
                Object object2 = rowDataWrapper.getTable();
                if (object2 instanceof DBTable && !(dBTable = (DBTable)object2).isSelected()) {
                    this.setToolTipText(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"TOOLTIP_source_table_disabled_unselected", (Object)rowDataWrapper.getTable()));
                }
            } else {
                if (bl) {
                    this.myButPanel.setBackground(Color.LIGHT_GRAY);
                    this.myButPanel.add((Component)this, "Center");
                    this.setEnabled(true);
                    this.myButPanel.setEnabled(true);
                    this.myButPanel.setOpaque(true);
                    this.setForeground(jTable.getSelectionForeground());
                    this.setBackground(jTable.getSelectionBackground());
                    this.myButPanel.setForeground(jTable.getSelectionForeground());
                    this.myButPanel.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setForeground(jTable.getForeground());
                    this.setBackground(jTable.getBackground());
                    this.myButPanel.setForeground(jTable.getForeground());
                    this.myButPanel.setBackground(jTable.getBackground());
                }
                this.setFocusable(true);
                this.setText(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"LABEL_BTN_ADV"));
                this.setMnemonic(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"MNE_BTN_ADV").charAt(0));
            }
            return this.myButPanel;
        }

        public Object getCellEditorValue() {
            return this.getCellEditorValue();
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void cancelCellEditing() {
            this.cancelCellEditing();
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        }
    }

    static class MyBooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        protected static Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private JPanel myPanel;

        public MyBooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.myPanel = new JPanel();
            this.myPanel.setLayout(new BorderLayout());
            this.myPanel.add((Component)this, "Center");
            this.myPanel.setOpaque(true);
            this.myPanel.setBorder(noFocusBorder);
            this.setSelected(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            RowDataWrapper rowDataWrapper = ((MyTableModel)jTable.getModel()).getRowDataWrapper(n);
            if (rowDataWrapper != null && !rowDataWrapper.isEditable().booleanValue()) {
                DBTable dBTable;
                this.setEnabled(false);
                this.setFocusable(false);
                this.setBackground(Color.LIGHT_GRAY);
                Object object2 = rowDataWrapper.getTable();
                if (object2 instanceof DBTable && !(dBTable = (DBTable)object2).isSelected()) {
                    this.setToolTipText(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"TOOLTIP_source_table_disabled_unselected", (Object)rowDataWrapper.getTable()));
                }
                this.myPanel.setBorder(noFocusBorder);
                this.myPanel.setBackground(Color.LIGHT_GRAY);
            } else {
                if (bl) {
                    this.setForeground(jTable.getSelectionForeground());
                    this.setBackground(jTable.getSelectionBackground());
                    this.myPanel.setForeground(jTable.getSelectionForeground());
                    this.myPanel.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setForeground(jTable.getForeground());
                    this.setBackground(jTable.getBackground());
                    this.myPanel.setForeground(jTable.getForeground());
                    this.myPanel.setBackground(jTable.getBackground());
                }
                if (bl2) {
                    this.myPanel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                    if (jTable.isCellEditable(n, n2)) {
                        this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                        this.setBackground(UIManager.getColor("Table.focusCellBackground"));
                    }
                    this.myPanel.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    this.myPanel.setBackground(UIManager.getColor("Table.focusCellBackground"));
                } else {
                    this.myPanel.setBorder(noFocusBorder);
                }
                this.setEnabled(true);
                this.setFocusable(true);
                this.setToolTipText("");
            }
            this.setSelected(object != null && (Boolean)object != false);
            return this.myPanel;
        }

        public void setBackground(Color color) {
            super.setBackground(color);
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
        }

        public void setForeground(Color color) {
            super.setForeground(color);
        }
    }

    class MetaTableComponent
    extends JTable {
        private static final long serialVersionUID = 1L;
        protected MyTableModelCellRenderer mytabmod = new MyTableModelCellRenderer();
        protected MyBooleanRenderer mybool = new MyBooleanRenderer();

        public MetaTableComponent() {
            this.setDefaultRenderer(DBTableImpl.class, this.mytabmod);
            this.setDefaultRenderer(Boolean.class, this.mybool);
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setReorderingAllowed(false);
            jTableHeader.setResizingAllowed(true);
        }
    }
}

