/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.wizards;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBColumn;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.impl.DBColumnImpl;
import org.netbeans.modules.jdbcwizard.wizards.JDBCTableColumnDisplayable;
import org.netbeans.modules.jdbcwizard.wizards.JDBCWizardTablePanel;
import org.openide.util.NbBundle;

public class ChosenColumnPanel
extends JPanel
implements JDBCTableColumnDisplayable {
    private static final long serialVersionUID = 1L;
    private JPanel headerPnl;
    private MetaTColumnComponent metaDataTColumn;
    private JScrollPane tableScroll;

    public ChosenColumnPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setOpaque(false);
        this.headerPnl = new JPanel();
        this.headerPnl.setLayout(new BorderLayout());
        this.headerPnl.setOpaque(false);
        this.headerPnl.add((Component)jPanel, "North");
    }

    public JTable getColumnTable() {
        return this.metaDataTColumn;
    }

    public List getColumnTables() {
        MyTColumnModel myTColumnModel = (MyTColumnModel)this.metaDataTColumn.getModel();
        return myTColumnModel.getTColumns();
    }

    public List getSelectedColumnTables() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < ((MyTColumnModel)this.metaDataTColumn.getModel()).getRowCount(); ++i) {
            if (!((MyTColumnModel)this.metaDataTColumn.getModel()).getRowDataWrapper(i).isSelected().booleanValue()) continue;
            arrayList.add(((MyTColumnModel)this.metaDataTColumn.getModel()).getRowDataWrapper(i).getTColumn());
        }
        return arrayList;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
    }

    public void resetColumnTable(List list) {
        MyTColumnModel myTColumnModel = new MyTColumnModel(list);
        this.metaDataTColumn.setModel(myTColumnModel);
        TableColumn tableColumn = this.metaDataTColumn.getColumnModel().getColumn(0);
        tableColumn.setResizable(true);
        tableColumn.setPreferredWidth(80);
    }

    public void addColumnTable(List list) {
        this.metaDataTColumn = new MetaTColumnComponent();
        MyTColumnModel myTColumnModel = new MyTColumnModel(list);
        this.metaDataTColumn.setModel(myTColumnModel);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(100, 100));
        this.setMaximumSize(new Dimension(150, 150));
        TableColumn tableColumn = this.metaDataTColumn.getColumnModel().getColumn(0);
        tableColumn.setResizable(true);
        tableColumn.setPreferredWidth(80);
        this.tableScroll = new JScrollPane(this.metaDataTColumn);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.GRAY));
        this.tableScroll.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), compoundBorder));
        this.add((Component)this.tableScroll, "Center");
    }

    class RowDataWrapper {
        private DBColumn tcolumn;

        public RowDataWrapper(DBColumn dBColumn) {
            this.tcolumn = dBColumn;
        }

        public Object getTColumn() {
            return this.tcolumn;
        }

        public Boolean isEditable() {
            return this.tcolumn.isEditable() ? Boolean.TRUE : Boolean.FALSE;
        }

        public Boolean isSelected() {
            return this.tcolumn.isChooseSelected() ? Boolean.TRUE : Boolean.FALSE;
        }

        public void setEditable(Boolean bl) {
            this.tcolumn.setEditable(bl);
        }

        public void setSelected(Boolean bl) {
            this.tcolumn.setChooseSelected(bl);
        }
    }

    static class MyTColumnModelCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        protected static Border noFocusBorder1 = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            MyTColumnModel myTColumnModel = (MyTColumnModel)jTable.getModel();
            RowDataWrapper rowDataWrapper = myTColumnModel.getRowDataWrapper(n);
            if (rowDataWrapper != null && !rowDataWrapper.isEditable().booleanValue()) {
                jLabel.setEnabled(false);
                jLabel.setBackground(Color.lightGray);
                Object object2 = rowDataWrapper.getTColumn();
                DBColumn dBColumn = (DBColumn)object2;
                if (!dBColumn.isInsertSelected()) {
                    jLabel.setToolTipText(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"TOOLTIP_source_table_disabled_unselected", (Object)rowDataWrapper.getTColumn()));
                }
                jLabel.setBorder(noFocusBorder1);
                jLabel.setFocusable(false);
            } else {
                DBColumn dBColumn;
                if (bl) {
                    jLabel.setForeground(jTable.getSelectionForeground());
                    jLabel.setBackground(jTable.getSelectionBackground());
                } else {
                    jLabel.setForeground(jTable.getForeground());
                    jLabel.setBackground(jTable.getBackground());
                }
                if (object instanceof DBColumn && (dBColumn = (DBColumn)object).getName() != null) {
                    this.setText(dBColumn.getName());
                }
                jLabel.setToolTipText("");
                jLabel.setEnabled(true);
                jLabel.setFocusable(true);
            }
            return jLabel;
        }
    }

    class MyTColumnModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private final String[] tcolumnNames = new String[]{NbBundle.getMessage(ChosenColumnPanel.class, (String)"LBL_SEL"), NbBundle.getMessage(ChosenColumnPanel.class, (String)"LBL_COL_NAME")};
        private List rowList = new ArrayList();

        public MyTColumnModel(List list) {
            for (int i = 0; i < list.size(); ++i) {
                RowDataWrapper rowDataWrapper = new RowDataWrapper((DBColumn)list.get(i));
                this.rowList.add(rowDataWrapper);
            }
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public int getColumnCount() {
            return this.tcolumnNames.length;
        }

        public String getColumnName(int n) {
            return this.tcolumnNames[n];
        }

        public int getRowCount() {
            return this.rowList.size();
        }

        public RowDataWrapper getRowDataWrapper(int n) {
            if (n < this.rowList.size()) {
                return (RowDataWrapper)this.rowList.get(n);
            }
            return null;
        }

        public ArrayList getTColumns() {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i = 0; i < this.rowList.size(); ++i) {
                RowDataWrapper rowDataWrapper = (RowDataWrapper)this.rowList.get(i);
                arrayList.add(rowDataWrapper.getTColumn());
            }
            return arrayList;
        }

        public Object getValueAt(int n, int n2) {
            RowDataWrapper rowDataWrapper = (RowDataWrapper)this.rowList.get(n);
            switch (n2) {
                case 0: {
                    return rowDataWrapper.isSelected();
                }
                case 1: {
                    return rowDataWrapper.getTColumn();
                }
            }
            return String.valueOf(n2 + "?");
        }

        public boolean isCellEditable(int n, int n2) {
            Object e = this.rowList.get(n);
            return e != null ? ((RowDataWrapper)e).isEditable().booleanValue() && n2 == 0 : false;
        }

        public void setCellEditable(int n, int n2, boolean bl) {
            Object e = this.rowList.get(n);
            if (e != null) {
                ((RowDataWrapper)e).setEditable(bl ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void setValueAt(Object object, int n, int n2) {
            RowDataWrapper rowDataWrapper = (RowDataWrapper)this.rowList.get(n);
            switch (n2) {
                case 0: {
                    rowDataWrapper.setSelected((Boolean)object);
                    this.fireTableRowsUpdated(n, n);
                }
            }
        }
    }

    static class MyBooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;
        protected static Border noFocusBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private JPanel myPanel;

        public MyBooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.myPanel = new JPanel();
            this.myPanel.setLayout(new BorderLayout());
            this.myPanel.add((Component)this, "Center");
            this.setEnabled(true);
            this.myPanel.setOpaque(true);
            this.myPanel.setBorder(noFocusBorder);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            RowDataWrapper rowDataWrapper = ((MyTColumnModel)jTable.getModel()).getRowDataWrapper(n);
            if (rowDataWrapper != null && !rowDataWrapper.isEditable().booleanValue()) {
                DBColumn dBColumn;
                this.setEnabled(false);
                this.setFocusable(false);
                this.setBackground(Color.LIGHT_GRAY);
                Object object2 = rowDataWrapper.getTColumn();
                if (object2 instanceof DBColumn && !(dBColumn = (DBColumn)object2).isChooseSelected()) {
                    this.setToolTipText(NbBundle.getMessage(JDBCWizardTablePanel.class, (String)"TOOLTIP_source_table_disabled_unselected", (Object)rowDataWrapper.getTColumn()));
                }
                this.myPanel.setBorder(noFocusBorder);
                this.myPanel.setBackground(Color.LIGHT_GRAY);
            } else {
                if (bl) {
                    this.setForeground(jTable.getSelectionForeground());
                    this.setBackground(jTable.getSelectionBackground());
                    this.myPanel.setForeground(jTable.getSelectionForeground());
                    this.myPanel.setBackground(jTable.getSelectionBackground());
                } else {
                    this.setForeground(jTable.getForeground());
                    this.setBackground(jTable.getBackground());
                    this.myPanel.setForeground(jTable.getForeground());
                    this.myPanel.setBackground(jTable.getBackground());
                }
                if (bl2) {
                    this.myPanel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                    if (jTable.isCellEditable(n, n2)) {
                        this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                        this.setBackground(UIManager.getColor("Table.focusCellBackground"));
                    }
                    this.myPanel.setForeground(UIManager.getColor("Table.focusCellForeground"));
                    this.myPanel.setBackground(UIManager.getColor("Table.focusCellBackground"));
                } else {
                    this.myPanel.setBorder(noFocusBorder);
                }
                this.setFocusable(true);
                this.setSelected(true);
                this.setToolTipText("");
            }
            this.setSelected(object != null && (Boolean)object != false);
            return this.myPanel;
        }

        public void setBackground(Color color) {
            super.setBackground(color);
        }

        public void setForeground(Color color) {
            super.setForeground(color);
        }
    }

    class MetaTColumnComponent
    extends JTable {
        private static final long serialVersionUID = 1L;

        public MetaTColumnComponent() {
            this.setDefaultRenderer(DBColumnImpl.class, new MyTColumnModelCellRenderer());
            this.setDefaultRenderer(Boolean.class, new MyBooleanRenderer());
            JTableHeader jTableHeader = this.getTableHeader();
            jTableHeader.setReorderingAllowed(false);
            jTableHeader.setResizingAllowed(true);
        }
    }
}

