/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.SearchScope;
import org.netbeans.modules.search.SearchTask;
import org.openide.loaders.DataObject;
import org.openidex.search.DataObjectSearchGroup;
import org.openidex.search.SearchType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SpecialSearchGroup
extends DataObjectSearchGroup {
    final BasicSearchCriteria basicCriteria;
    final boolean hasExtraSearchTypes;
    private final SearchScope searchScope;
    private SearchTask listeningSearchTask;

    SpecialSearchGroup(BasicSearchCriteria basicSearchCriteria, Collection<SearchType> collection, SearchScope searchScope) {
        this.basicCriteria = basicSearchCriteria;
        this.hasExtraSearchTypes = !collection.isEmpty();
        this.searchScope = searchScope;
        if (basicSearchCriteria == null && !this.hasExtraSearchTypes) {
            assert (false);
            throw new IllegalArgumentException();
        }
        if (this.hasExtraSearchTypes) {
            for (SearchType searchType : collection) {
                this.add(searchType);
            }
        }
    }

    public void doSearch() {
        Iterator iterator = this.searchScope.getSearchInfo().objectsToSearch();
        while (iterator.hasNext()) {
            if (this.stopped) {
                return;
            }
            this.processSearchObject(iterator.next());
        }
    }

    protected void processSearchObject(Object object) {
        if (!this.hasExtraSearchTypes) {
            assert (this.basicCriteria != null);
            DataObject dataObject = (DataObject)object;
            if (this.basicCriteria.matches(dataObject)) {
                this.notifyMatchingObjectFound(dataObject);
            }
            return;
        }
        if (this.basicCriteria == null || this.basicCriteria.matches((DataObject)object)) {
            super.processSearchObject(object);
        }
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.notifyMatchingObjectFound((DataObject)object2);
    }

    private void notifyMatchingObjectFound(DataObject dataObject) {
        if (this.listeningSearchTask != null) {
            Charset charset = this.basicCriteria != null ? this.basicCriteria.getLastUsedCharset() : null;
            this.listeningSearchTask.matchingObjectFound(dataObject, charset);
        } else assert (false);
    }

    void setListeningSearchTask(SearchTask searchTask) {
        this.listeningSearchTask = searchTask;
    }
}

