/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.openfile.OpenFile;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.windows.ExternalDropHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExternalDropHandler
extends ExternalDropHandler {
    private static DataFlavor uriListDataFlavor;

    public boolean canDrop(DropTargetDragEvent dropTargetDragEvent) {
        return this.canDrop(dropTargetDragEvent.getCurrentDataFlavors());
    }

    public boolean canDrop(DropTargetDropEvent dropTargetDropEvent) {
        return this.canDrop(dropTargetDropEvent.getCurrentDataFlavors());
    }

    boolean canDrop(DataFlavor[] dataFlavorArray) {
        for (int i = 0; null != dataFlavorArray && i < dataFlavorArray.length; ++i) {
            if (!DataFlavor.javaFileListFlavor.equals(dataFlavorArray[i]) && !this.getUriListDataFlavor().equals(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean handleDrop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (null == transferable) {
            return false;
        }
        List<File> list = this.getFileList(transferable);
        if (list == null || list.isEmpty()) {
            return false;
        }
        Object object = null;
        if (list.size() == 1) {
            object = this.openFile(list.get(0));
        } else {
            Object object2;
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<String> arrayList = null;
            for (File object3 : list) {
                object2 = this.openFile(object3);
                if (object2 == null) {
                    bl = true;
                    continue;
                }
                if (!OpenFile.isSpecifiedByUNCPath(object3)) {
                    bl2 = true;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<String>(list.size());
                }
                arrayList.add((String)object2);
            }
            if (arrayList != null) {
                Object object4;
                if (!bl && !bl2) {
                    object4 = "MSG_could_not_open_any_file_all_UNC";
                    arrayList = null;
                } else {
                    object4 = bl ? "MSG_could_not_open_some_files" : "MSG_could_not_open_any_file";
                }
                String string = NbBundle.getMessage(OpenFile.class, (String)object4);
                if (arrayList == null) {
                    object = string;
                } else {
                    object2 = new JPanel();
                    ((Container)object2).setLayout(new BoxLayout((Container)object2, 3));
                    ((Container)object2).add(new JLabel(string));
                    ((Container)object2).add(Box.createVerticalStrut(12));
                    for (String string2 : arrayList) {
                        ((Container)object2).add(new JLabel(string2));
                    }
                    object = object2;
                }
            }
        }
        if (object != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message(object, 2));
            return false;
        }
        return true;
    }

    List<File> getFileList(Transferable transferable) {
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            }
            if (transferable.isDataFlavorSupported(this.getUriListDataFlavor())) {
                String string = (String)transferable.getTransferData(this.getUriListDataFlavor());
                return this.textURIListToFileList(string);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            ErrorManager.getDefault().notify(1, (Throwable)unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Logger.getLogger(DefaultExternalDropHandler.class.getName()).log(Level.FINE, null, iOException);
        }
        return null;
    }

    String openFile(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        if (fileObject == null) {
            String string = OpenFile.isSpecifiedByUNCPath(file) ? "MSG_UncNotSupported" : "MSG_FilePathTypeNotSupported";
            return NbBundle.getMessage(OpenFile.class, (String)string, (Object)file.toString());
        }
        return OpenFile.open(fileObject, -1);
    }

    DataFlavor getUriListDataFlavor() {
        if (null == uriListDataFlavor) {
            try {
                uriListDataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }
        return uriListDataFlavor;
    }

    List<File> textURIListToFileList(String string) {
        ArrayList<File> arrayList = new ArrayList<File>(1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) continue;
            try {
                URI uRI = new URI(string2);
                File file = new File(uRI);
                arrayList.add(file);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return arrayList;
    }
}

