/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.monitor;

import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.results.DataManager;

public class VMTelemetryDataManager
extends DataManager {
    public long[] freeMemory;
    public long[] gcFinishs;
    public long[] gcStarts;
    public long[] lastGCPauseInMS;
    public long[] loadedClassesCount;
    public long[] nSurvivingGenerations;
    public long[] nSystemThreads;
    public long[] nTotalThreads;
    public long[] nUserThreads;
    public long[] relativeGCTimeInPerMil;
    public long[] timeStamps;
    public long[] totalMemory;
    public long[] usedMemory;
    public long maxHeapSize = Long.MAX_VALUE;
    private MonitoredData lastData = null;
    private int arrayBufferSize;
    private int currentArraysSize;
    private int currentGCArraysSize;
    private int gcItemCount;
    private int itemCount;

    public VMTelemetryDataManager() {
        this(50);
    }

    public VMTelemetryDataManager(int n) {
        this.arrayBufferSize = n;
        this.reset();
    }

    public synchronized void setArrayBufferSize(int n) {
        this.arrayBufferSize = n;
    }

    public synchronized int getArrayBufferSize() {
        return this.arrayBufferSize;
    }

    public synchronized int getGCItemCount() {
        return this.gcItemCount;
    }

    public synchronized int getItemCount() {
        return this.itemCount;
    }

    public synchronized MonitoredData getLastData() {
        return this.lastData;
    }

    public synchronized void processData(MonitoredData monitoredData) {
        this.addValuesInternal(monitoredData.getTimestamp(), monitoredData.getFreeMemory(), monitoredData.getTotalMemory(), monitoredData.getNUserThreads(), monitoredData.getNSystemThreads(), monitoredData.getNSurvivingGenerations(), monitoredData.getRelativeGCTimeInPerMil(), monitoredData.getLastGCPauseInMS(), monitoredData.getLoadedClassesCount(), monitoredData.getGCStarts(), monitoredData.getGCFinishs());
        this.lastData = monitoredData;
    }

    public synchronized void reset() {
        this.lastData = null;
        this.itemCount = 0;
        this.gcItemCount = 0;
        this.timeStamps = new long[this.arrayBufferSize];
        this.freeMemory = new long[this.arrayBufferSize];
        this.totalMemory = new long[this.arrayBufferSize];
        this.usedMemory = new long[this.arrayBufferSize];
        this.nUserThreads = new long[this.arrayBufferSize];
        this.nSystemThreads = new long[this.arrayBufferSize];
        this.nTotalThreads = new long[this.arrayBufferSize];
        this.nSurvivingGenerations = new long[this.arrayBufferSize];
        this.relativeGCTimeInPerMil = new long[this.arrayBufferSize];
        this.lastGCPauseInMS = new long[this.arrayBufferSize];
        this.loadedClassesCount = new long[this.arrayBufferSize];
        this.currentArraysSize = this.arrayBufferSize;
        this.currentGCArraysSize = this.arrayBufferSize;
        this.gcStarts = new long[this.arrayBufferSize];
        this.gcFinishs = new long[this.arrayBufferSize];
        this.fireDataReset();
    }

    private void addValuesInternal(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9, long[] lArray, long[] lArray2) {
        this.checkArraysSize();
        this.timeStamps[this.itemCount] = l;
        this.freeMemory[this.itemCount] = l2;
        this.totalMemory[this.itemCount] = l3;
        this.usedMemory[this.itemCount] = l3 - l2;
        this.nUserThreads[this.itemCount] = l4;
        this.nSystemThreads[this.itemCount] = l5;
        this.nTotalThreads[this.itemCount] = l5 + l4;
        this.nSurvivingGenerations[this.itemCount] = l6;
        this.relativeGCTimeInPerMil[this.itemCount] = l7;
        this.lastGCPauseInMS[this.itemCount] = l8;
        this.loadedClassesCount[this.itemCount] = l9;
        ++this.itemCount;
        int n = Math.min(lArray.length, lArray2.length);
        for (int i = 0; i < n; ++i) {
            this.gcStarts[this.gcItemCount] = lArray[i];
            this.gcFinishs[this.gcItemCount] = lArray2[i];
            ++this.gcItemCount;
            this.checkArraysSize();
        }
        this.fireDataChanged();
    }

    private void checkArraysSize() {
        if (this.currentArraysSize == this.itemCount) {
            this.timeStamps = VMTelemetryDataManager.extendArray(this.timeStamps, this.arrayBufferSize);
            this.freeMemory = VMTelemetryDataManager.extendArray(this.freeMemory, this.arrayBufferSize);
            this.totalMemory = VMTelemetryDataManager.extendArray(this.totalMemory, this.arrayBufferSize);
            this.usedMemory = VMTelemetryDataManager.extendArray(this.usedMemory, this.arrayBufferSize);
            this.nUserThreads = VMTelemetryDataManager.extendArray(this.nUserThreads, this.arrayBufferSize);
            this.nSystemThreads = VMTelemetryDataManager.extendArray(this.nSystemThreads, this.arrayBufferSize);
            this.nTotalThreads = VMTelemetryDataManager.extendArray(this.nTotalThreads, this.arrayBufferSize);
            this.nSurvivingGenerations = VMTelemetryDataManager.extendArray(this.nSurvivingGenerations, this.arrayBufferSize);
            this.relativeGCTimeInPerMil = VMTelemetryDataManager.extendArray(this.relativeGCTimeInPerMil, this.arrayBufferSize);
            this.lastGCPauseInMS = VMTelemetryDataManager.extendArray(this.lastGCPauseInMS, this.arrayBufferSize);
            this.loadedClassesCount = VMTelemetryDataManager.extendArray(this.loadedClassesCount, this.arrayBufferSize);
            this.currentArraysSize += this.arrayBufferSize;
        }
        if (this.currentGCArraysSize == this.gcItemCount) {
            this.gcStarts = VMTelemetryDataManager.extendArray(this.gcStarts, this.arrayBufferSize);
            this.gcFinishs = VMTelemetryDataManager.extendArray(this.gcFinishs, this.arrayBufferSize);
            this.currentGCArraysSize += this.arrayBufferSize;
        }
    }

    private static long[] extendArray(long[] lArray, int n) {
        int n2 = lArray.length;
        long[] lArray2 = new long[n2 + n];
        System.arraycopy(lArray, 0, lArray2, 0, n2);
        return lArray2;
    }
}

