/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.marking;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapper;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;

public class MarkingEngine {
    private static MarkingEngine instance;
    private final Object mapperGuard = new Object();
    private final Object markGuard = new Object();
    private Mark defaultMark = null;
    private MarkMapper mapper = null;
    private Set observers = new HashSet();
    private String[] labels;
    private Mark[] markBackMap;
    private MarkMapping[] marks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MarkingEngine() {
        Object object = this.mapperGuard;
        synchronized (object) {
            this.mapper = new MarkMapper();
            this.addStateObserver(this.mapper);
        }
    }

    public static synchronized MarkingEngine getDefault() {
        if (instance == null) {
            instance = new MarkingEngine();
        }
        return instance;
    }

    public static synchronized void configure(Mark mark, MarkMapping[] markMappingArray) {
        MarkingEngine.getDefault().defaultMark = mark;
        MarkingEngine.getDefault().setMarks(markMappingArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabelForId(char c) {
        Object object = this.markGuard;
        synchronized (object) {
            if (this.marks == null) {
                return null;
            }
            if (c > '\u0000' && c <= this.labels.length) {
                return this.labels[c - '\u0001'];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mark getMarkForId(char c) {
        Object object = this.markGuard;
        synchronized (object) {
            if (this.marks == null) {
                return null;
            }
            if (c > '\u0000' && c <= this.labels.length) {
                return this.markBackMap[c - '\u0001'];
            }
            return this.defaultMark != null ? this.defaultMark : Mark.DEFAULT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMarkId(Mark mark) {
        Object object = this.markGuard;
        synchronized (object) {
            if (mark.isDefault) {
                return 0;
            }
            for (int i = 0; i < this.labels.length; ++i) {
                if (!this.labels[i].equals(mark.label)) continue;
                return (char)(i + 1);
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarkMapper getMarker() {
        Object object = this.mapperGuard;
        synchronized (object) {
            return this.mapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientUtils.SourceCodeSelection[] getMarkerMethods() {
        Object object = this.markGuard;
        synchronized (object) {
            if (this.marks == null) {
                return new ClientUtils.SourceCodeSelection[0];
            }
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = new ClientUtils.SourceCodeSelection[this.marks.length];
            for (int i = 0; i < this.marks.length; ++i) {
                sourceCodeSelectionArray[i] = this.marks[i].markMask;
            }
            return sourceCodeSelectionArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNMarks() {
        Object object = this.markGuard;
        synchronized (object) {
            return this.labels != null ? this.labels.length : 0;
        }
    }

    public void addStateObserver(StateObserver stateObserver) {
        this.observers.add(stateObserver);
    }

    public void removeStateObserver(StateObserver stateObserver) {
        this.observers.remove(stateObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Mark mark(int n, ProfilingSessionStatus profilingSessionStatus) {
        ClientUtils.SourceCodeSelection sourceCodeSelection = null;
        Object object = this.markGuard;
        synchronized (object) {
            if (this.marks == null) {
                return Mark.DEFAULT;
            }
            profilingSessionStatus.beginTrans(false);
            try {
                sourceCodeSelection = new ClientUtils.SourceCodeSelection(profilingSessionStatus.getInstrMethodClasses()[n], profilingSessionStatus.getInstrMethodNames()[n], profilingSessionStatus.getInstrMethodSignatures()[n]);
            }
            finally {
                profilingSessionStatus.endTrans();
            }
            String string = sourceCodeSelection.toFlattened();
            for (int i = 0; i < this.marks.length; ++i) {
                if (!string.startsWith(this.marks[i].markSig)) continue;
                return this.marks[i].mark;
            }
            return Mark.DEFAULT;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setMarks(MarkMapping[] markMappingArray) {
        boolean bl = false;
        Object object = this.markGuard;
        synchronized (object) {
            bl = (this.marks != null || markMappingArray != null) && (this.marks == null && markMappingArray != null || this.marks != null && markMappingArray == null || !this.marks.equals(markMappingArray));
            this.marks = markMappingArray;
            if (markMappingArray != null) {
                int n;
                LinkedHashSet linkedHashSet = new LinkedHashSet();
                for (n = 0; n < markMappingArray.length; ++n) {
                    linkedHashSet.addAll(markMappingArray[n].mark.getLabels());
                }
                this.labels = new String[linkedHashSet.size()];
                this.labels = linkedHashSet.toArray(this.labels);
                this.markBackMap = new Mark[this.labels.length];
                block4: for (n = 0; n < this.labels.length; ++n) {
                    for (int i = 0; i < markMappingArray.length; ++i) {
                        if (!markMappingArray[i].mark.getLabel().equals(this.labels[n])) continue;
                        this.markBackMap[n] = markMappingArray[i].mark;
                        continue block4;
                    }
                }
            }
        }
        if (bl) {
            this.fireStateChanged();
        }
    }

    private void fireStateChanged() {
        Iterator iterator = this.observers.iterator();
        while (iterator.hasNext()) {
            ((StateObserver)iterator.next()).stateChanged(this);
        }
    }

    public static interface StateObserver {
        public void stateChanged(MarkingEngine var1);
    }
}

