/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.TagBounds;

class StringSegment
extends TagBounds {
    final int UTF8CharsOffset;
    final int lengthOffset;
    final int stringIDOffset;
    final int timeOffset;
    Map stringIDMap;
    private HprofHeap hprofHeap;

    StringSegment(HprofHeap hprofHeap, long l, long l2) {
        super(1, l, l2);
        int n = hprofHeap.dumpBuffer.getIDSize();
        this.hprofHeap = hprofHeap;
        this.timeOffset = 1;
        this.lengthOffset = this.timeOffset + 4;
        this.stringIDOffset = this.lengthOffset + 4;
        this.UTF8CharsOffset = this.stringIDOffset + n;
    }

    String getString(long l) {
        HprofByteBuffer hprofByteBuffer = this.getDumpBuffer();
        if (l == -1L) {
            return "<unknown string>";
        }
        int n = hprofByteBuffer.getInt(l + (long)this.lengthOffset);
        byte[] byArray = new byte[n - hprofByteBuffer.getIDSize()];
        hprofByteBuffer.get(l + (long)this.UTF8CharsOffset, byArray);
        String string = "Error";
        try {
            string = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string;
    }

    String getStringByID(long l) {
        return this.getString(this.getStringOffsetByID(l));
    }

    long getStringOffsetByID(long l) {
        Long l2;
        if (this.stringIDMap == null) {
            this.stringIDMap = new HashMap(8000);
            long[] lArray = new long[]{this.startOffset};
            while (lArray[0] < this.endOffset) {
                long l3 = lArray[0];
                long l4 = this.readStringTag(lArray);
                this.stringIDMap.put(new Long(l4), new Long(l3));
            }
        }
        if ((l2 = (Long)this.stringIDMap.get(new Long(l))) == null) {
            return -1L;
        }
        return l2;
    }

    private HprofByteBuffer getDumpBuffer() {
        HprofByteBuffer hprofByteBuffer = this.hprofHeap.dumpBuffer;
        return hprofByteBuffer;
    }

    private long readStringTag(long[] lArray) {
        long l = lArray[0];
        if (this.hprofHeap.readTag(lArray) != 1) {
            return 0L;
        }
        return this.getDumpBuffer().getID(l + (long)this.stringIDOffset);
    }
}

