/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpInstance;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofGCRoot;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;

class NearestGCRoot {
    private static final int BUFFER_SIZE = 8192;
    private Field referentFiled;
    private HprofHeap heap;
    private LongBuffer readBuffer;
    private LongBuffer writeBuffer;
    private Set referenceClasses;
    private boolean gcRootsComputed;

    NearestGCRoot(HprofHeap hprofHeap) {
        this.heap = hprofHeap;
    }

    synchronized Instance getNearestGCRootPointer(Instance instance) {
        if (this.heap.getGCRoot(instance) != null) {
            return instance;
        }
        long l = this.heap.idToOffsetMap.get(instance.getInstanceId()).getNearestGCRootPointer();
        if (l == 0L) {
            l = this.computeGCRootsFor(instance);
        }
        if (l != 0L) {
            return this.heap.getInstanceByID(l);
        }
        return null;
    }

    private boolean isWeakOrSoftReference(FieldValue fieldValue, Instance instance) {
        Field field = fieldValue.getField();
        return field.equals(this.referentFiled) && this.referenceClasses.contains(instance.getJavaClass());
    }

    private long computeGCRootsFor(Instance instance) {
        if (this.gcRootsComputed) {
            return 0L;
        }
        JavaClass javaClass = this.heap.getJavaClassByName("java.lang.ref.WeakReference");
        JavaClass javaClass2 = this.heap.getJavaClassByName("java.lang.ref.SoftReference");
        this.referenceClasses = new HashSet();
        this.referenceClasses.add(javaClass);
        this.referenceClasses.addAll(javaClass.getSubClasses());
        this.referenceClasses.add(javaClass2);
        this.referenceClasses.addAll(javaClass2.getSubClasses());
        this.referentFiled = this.computeReferentFiled();
        try {
            this.createBuffers();
            this.fillZeroLevel();
            do {
                this.switchBuffers();
                this.computeOneLevel();
            } while (this.hasMoreLevels());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.deleteBuffers();
        this.gcRootsComputed = true;
        return this.heap.idToOffsetMap.get(instance.getInstanceId()).getNearestGCRootPointer();
    }

    private void computeOneLevel() throws IOException {
        long l;
        while ((l = this.readLong()) != 0L) {
            List list;
            Instance instance;
            Object object;
            Instance instance2 = this.heap.getInstanceByID(l);
            if (instance2 instanceof ObjectArrayInstance) {
                object = ((ObjectArrayInstance)instance2).getValues().iterator();
                while (object.hasNext()) {
                    instance = (Instance)object.next();
                    this.writeConnection(l, instance);
                }
                continue;
            }
            if (instance2 instanceof PrimitiveArrayInstance) continue;
            if (instance2 instanceof ClassDumpInstance) {
                object = ((ClassDumpInstance)instance2).classDump;
                list = ((ClassDump)object).getStaticFieldValues();
            } else if (instance2 instanceof InstanceDump) {
                list = instance2.getFieldValues();
            } else {
                if (instance2 == null) {
                    System.err.println("HeapWalker Warning - null instance for " + l);
                    continue;
                }
                throw new IllegalArgumentException("Illegal type " + instance2.getClass());
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (FieldValue)iterator.next();
                if (!(object instanceof ObjectFieldValue) || this.isWeakOrSoftReference((FieldValue)object, instance2)) continue;
                instance = ((ObjectFieldValue)object).getInstance();
                this.writeConnection(l, instance);
            }
        }
    }

    private Field computeReferentFiled() {
        JavaClass javaClass = this.heap.getJavaClassByName("java.lang.ref.Reference");
        Iterator iterator = javaClass.getFields().iterator();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            if (!field.getName().equals("referent")) continue;
            return field;
        }
        throw new IllegalArgumentException("reference field not found in " + javaClass.getName());
    }

    private void createBuffers() {
        this.readBuffer = new LongBuffer(8192);
        this.writeBuffer = new LongBuffer(8192);
    }

    private void deleteBuffers() {
        this.readBuffer.delete();
        this.writeBuffer.delete();
    }

    private void fillZeroLevel() throws IOException {
        Iterator iterator = this.heap.getGCRoots().iterator();
        while (iterator.hasNext()) {
            HprofGCRoot hprofGCRoot = (HprofGCRoot)iterator.next();
            this.writeLong(hprofGCRoot.getInstanceId());
        }
    }

    private boolean hasMoreLevels() {
        return this.writeBuffer.hasData();
    }

    private long readLong() throws IOException {
        return this.readBuffer.readLong();
    }

    private void switchBuffers() {
        LongBuffer longBuffer = this.readBuffer;
        this.readBuffer = this.writeBuffer;
        this.writeBuffer = longBuffer;
        this.readBuffer.startReading();
        this.writeBuffer.reset();
    }

    private void writeConnection(long l, Instance instance) throws IOException {
        long l2;
        LongMap.Entry entry;
        if (instance != null && (entry = this.heap.idToOffsetMap.get(l2 = instance.getInstanceId())).getNearestGCRootPointer() == 0L) {
            this.writeLong(l2);
            entry.setNearestGCRootPointer(l);
        }
    }

    private void writeLong(long l) throws IOException {
        this.writeBuffer.writeLong(l);
    }
}

