/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.update;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.repository.ChangesetPanel;
import org.netbeans.modules.mercurial.ui.update.RevertModificationsPanel;
import org.netbeans.modules.mercurial.ui.update.Update;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UpdatePanel
extends JPanel {
    private File repository;
    private RequestProcessor.Task refreshViewTask;
    private static final RequestProcessor rp = new RequestProcessor("MercurialUpdate", 1);
    private Thread refreshViewThread;
    private HgLogMessage[] messages;
    private int fetchRevisionLimit = 7;
    private boolean bGettingRevisions = false;
    private File[] roots;
    private ChangesetPanel changesetPanel1;
    private JCheckBox forcedUpdateChxBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JComboBox revisionsComboBox;
    private JLabel revisionsLabel;

    public UpdatePanel(File file, File[] fileArray) {
        this.repository = file;
        this.roots = fileArray;
        this.refreshViewTask = rp.create((Runnable)new RefreshViewTask());
        this.initComponents();
        this.revisionsComboBox.setMaximumRowCount(10);
        this.refreshViewTask.schedule(0);
    }

    public String getSelectedRevision() {
        String string = (String)this.revisionsComboBox.getSelectedItem();
        if (string != null) {
            string = string.equals(NbBundle.getMessage(RevertModificationsPanel.class, (String)"MSG_Revision_Default")) || string.equals(NbBundle.getMessage(RevertModificationsPanel.class, (String)"MSG_Fetching_Revisions")) ? null : string.substring(0, string.indexOf(" "));
        }
        return string;
    }

    public boolean isForcedUpdateRequested() {
        return this.forcedUpdateChxBox.isSelected();
    }

    private void initComponents() {
        this.revisionsLabel = new JLabel();
        this.revisionsComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.forcedUpdateChxBox = new JCheckBox();
        this.changesetPanel1 = new ChangesetPanel();
        this.revisionsLabel.setLabelFor(this.revisionsComboBox);
        Mnemonics.setLocalizedText((JLabel)this.revisionsLabel, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.revisionsLabel.text"));
        this.revisionsComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UpdatePanel.this.revisionsComboBoxActionPerformed(actionEvent);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 1, 11));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.infoLabel.text"));
        this.jLabel2.setForeground(new Color(153, 153, 153));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.infoLabel2.text"));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.jPanel1.border.title")));
        Mnemonics.setLocalizedText((AbstractButton)this.forcedUpdateChxBox, (String)NbBundle.getMessage(UpdatePanel.class, (String)"UpdatePanel.forcedUpdateChxBox.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.forcedUpdateChxBox).addContainerGap(66, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.forcedUpdateChxBox).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel1, -1, 396, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(30, 30, 30).add((Component)this.revisionsLabel).addPreferredGap(0).add((Component)this.revisionsComboBox, 0, 221, Short.MAX_VALUE)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.changesetPanel1, -1, 396, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.jLabel1, -2, 25, -2).add(4, 4, 4).add((Component)this.jLabel2).add(17, 17, 17).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.revisionsComboBox, -2, 27, -2).add((Component)this.revisionsLabel)).addPreferredGap(0).add((Component)this.changesetPanel1, -2, 152, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2)));
    }

    private void revisionsComboBoxActionPerformed(ActionEvent actionEvent) {
        int n = this.revisionsComboBox.getSelectedIndex();
        if (this.getMore((String)this.revisionsComboBox.getSelectedItem())) {
            return;
        }
        if (this.messages != null && n >= 0 && n < this.messages.length) {
            this.changesetPanel1.setInfo(this.messages[n]);
        }
    }

    private boolean getMore(String string) {
        if (this.bGettingRevisions) {
            return false;
        }
        boolean bl = false;
        int n = -1;
        if (string != null && string.equals(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_20_Revisions"))) {
            bl = true;
            n = 20;
        } else if (string != null && string.equals(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_50_Revisions"))) {
            bl = true;
            n = 50;
        } else if (string != null && string.equals(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_All_Revisions"))) {
            bl = true;
            n = -1;
        }
        if (bl && !this.bGettingRevisions) {
            this.fetchRevisionLimit = n;
            RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(this.repository);
            HgProgressSupport hgProgressSupport = new HgProgressSupport(){

                public void perform() {
                    UpdatePanel.this.changesetPanel1.clearInfo();
                    UpdatePanel.this.refreshRevisions();
                }
            };
            hgProgressSupport.start(requestProcessor, this.repository.getAbsolutePath(), NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetching_Revisions"));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupModels() {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(RevertModificationsPanel.class, (String)"MSG_Refreshing_Update_Versions"));
        try {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            linkedHashSet.add(NbBundle.getMessage(RevertModificationsPanel.class, (String)"MSG_Fetching_Revisions"));
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(linkedHashSet));
            this.revisionsComboBox.setModel(defaultComboBoxModel);
            this.refreshViewThread = Thread.currentThread();
            Thread.interrupted();
            progressHandle.start();
            this.refreshRevisions();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            SwingUtilities.invokeLater(new Runnable(progressHandle){
                final /* synthetic */ ProgressHandle val$ph;
                {
                    this.val$ph = progressHandle;
                }

                public void run() {
                    this.val$ph.finish();
                    UpdatePanel.this.refreshViewThread = null;
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void refreshRevisions() {
        this.bGettingRevisions = true;
        OutputLogger outputLogger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
        HashSet<File> hashSet = new HashSet<File>(Arrays.asList(this.roots));
        this.messages = HgCommand.getLogMessagesNoFileInfo(this.repository.getAbsolutePath(), hashSet, this.fetchRevisionLimit, outputLogger);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (this.messages == null) {
            boolean bl = false;
            linkedHashSet.add(NbBundle.getMessage(Update.class, (String)"MSG_Revision_Default"));
        } else {
            int n = this.messages.length;
            for (int i = 0; i < n; ++i) {
                linkedHashSet.add(this.messages[i].getRevision() + " (" + this.messages[i].getCSetShortID() + ")");
            }
        }
        if (linkedHashSet.size() > 0) {
            linkedHashSet.add(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_20_Revisions"));
            linkedHashSet.add(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_50_Revisions"));
            linkedHashSet.add(NbBundle.getMessage(Mercurial.class, (String)"MSG_Fetch_All_Revisions"));
        }
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(linkedHashSet));
        this.revisionsComboBox.setModel(defaultComboBoxModel);
        if (linkedHashSet.size() > 0) {
            this.revisionsComboBox.setSelectedIndex(0);
        }
        this.bGettingRevisions = false;
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        public void run() {
            UpdatePanel.this.setupModels();
        }
    }
}

