/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.status;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.commit.CommitAction;
import org.netbeans.modules.mercurial.ui.diff.DiffAction;
import org.netbeans.modules.mercurial.ui.status.HgVersioningTopComponent;
import org.netbeans.modules.mercurial.ui.status.StatusAction;
import org.netbeans.modules.mercurial.ui.status.SyncFileNode;
import org.netbeans.modules.mercurial.ui.status.SyncTable;
import org.netbeans.modules.mercurial.ui.update.UpdateAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.NoContentPanel;
import org.openide.LifecycleManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class VersioningPanel
extends JPanel
implements ExplorerManager.Provider,
PreferenceChangeListener,
PropertyChangeListener,
ActionListener {
    private ExplorerManager explorerManager;
    private final HgVersioningTopComponent parentTopComponent;
    private final Mercurial mercurial;
    private VCSContext context;
    private int displayStatuses;
    private String branchInfo;
    private SyncTable syncTable;
    private RequestProcessor.Task refreshViewTask;
    private Thread refreshViewThread;
    private HgProgressSupport hgProgressSupport;
    private static final RequestProcessor rp = new RequestProcessor("MercurialView", 1, true);
    private final NoContentPanel noContentComponent = new NoContentPanel();
    private static final int HG_UPDATE_TARGET_LIMIT = 100;
    private JButton btnCommit;
    private JButton btnDiff;
    private JButton btnRefresh;
    private JButton btnUpdate;
    private JComboBox jComboBox1;
    private JPanel jPanel1;
    private JToolBar jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel statusLabel;

    public VersioningPanel(HgVersioningTopComponent hgVersioningTopComponent) {
        this.parentTopComponent = hgVersioningTopComponent;
        this.mercurial = Mercurial.getInstance();
        this.refreshViewTask = rp.create((Runnable)new RefreshViewTask());
        this.explorerManager = new ExplorerManager();
        this.displayStatuses = 6612;
        this.noContentComponent.setLabel(NbBundle.getMessage(VersioningPanel.class, (String)"MSG_No_Changes_All"));
        this.syncTable = new SyncTable();
        this.initComponents();
        this.setVersioningComponent(this.syncTable.getComponent());
        this.reScheduleRefresh(0);
        this.jPanel2.setFloatable(false);
        this.jPanel2.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.jPanel2.setLayout(new ToolbarLayout());
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().startsWith("commitExclusions")) {
            this.repaint();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "status.changed") {
            FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)propertyChangeEvent.getNewValue();
            Mercurial.LOG.log(Level.FINE, "Status.propertyChange(): {0} file:  {1}", new Object[]{this.parentTopComponent.getContentTitle(), changedEvent.getFile()});
            if (this.affectsView(propertyChangeEvent)) {
                this.reScheduleRefresh(1000);
            }
            return;
        }
        if (propertyChangeEvent.getPropertyName() == "changesetChanged") {
            Object object = propertyChangeEvent.getOldValue();
            File file = HgUtils.getRootFile(this.context);
            Mercurial.LOG.log(Level.FINE, "Mercurial.changesetChanged: source {0} repo {1} ", new Object[]{object, file});
            if (file != null && file.equals(object)) {
                this.reScheduleRefresh(1000);
            }
            return;
        }
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            TopComponent topComponent = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (topComponent != null) {
                topComponent.setActivatedNodes((Node[])propertyChangeEvent.getNewValue());
            }
            return;
        }
    }

    void setContext(VCSContext vCSContext) {
        this.context = vCSContext;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public void addNotify() {
        super.addNotify();
        HgModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        this.mercurial.getFileStatusCache().addPropertyChangeListener(this);
        this.mercurial.addPropertyChangeListener(this);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.reScheduleRefresh(0);
    }

    public void removeNotify() {
        HgModuleConfig.getDefault().getPreferences().removePreferenceChangeListener(this);
        this.mercurial.getFileStatusCache().removePropertyChangeListener(this);
        this.mercurial.removePropertyChangeListener(this);
        this.explorerManager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    private void setVersioningComponent(JComponent jComponent) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component component = componentArray[i];
            if (component == this.jPanel2) continue;
            if (component == jComponent) {
                return;
            }
            this.remove(component);
            break;
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jComponent, gridBagConstraints);
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setupModels() {
        ProgressHandle progressHandle;
        block10: {
            block9: {
                block8: {
                    if (this.context == null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                VersioningPanel.this.syncTable.setTableModel(new SyncFileNode[0]);
                                File file = HgUtils.getRootFile(HgUtils.getCurrentContext(null));
                            }
                        });
                        return;
                    }
                    progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(VersioningPanel.class, (String)"MSG_Refreshing_Versioning_View"));
                    try {
                        String[] stringArray;
                        this.refreshViewThread = Thread.currentThread();
                        Thread.interrupted();
                        progressHandle.start();
                        final SyncFileNode[] syncFileNodeArray = this.getNodes(this.context, this.displayStatuses);
                        if (syncFileNodeArray == null) {
                            Object var9_3 = null;
                            break block8;
                        }
                        File[] fileArray = this.context.getRootFiles().toArray(new File[this.context.getRootFiles().size()]);
                        if (fileArray == null) break block9;
                        if (fileArray.length == 0) {
                            break block9;
                        }
                        if (syncFileNodeArray.length > 0) {
                            boolean bl = false;
                            for (int i = 1; i < syncFileNodeArray.length; ++i) {
                                if (!Thread.interrupted()) continue;
                                Object var9_5 = null;
                                SwingUtilities.invokeLater(new Runnable(progressHandle){
                                    final /* synthetic */ ProgressHandle val$ph;
                                    {
                                        this.val$ph = progressHandle;
                                    }

                                    public void run() {
                                        this.val$ph.finish();
                                    }
                                });
                                return;
                            }
                            stringArray = new String[]{"name", "status", "path"};
                        } else {
                            stringArray = null;
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (syncFileNodeArray.length > 0) {
                                    VersioningPanel.this.syncTable.setColumns(stringArray);
                                    VersioningPanel.this.setVersioningComponent(VersioningPanel.this.syncTable.getComponent());
                                } else {
                                    VersioningPanel.this.setVersioningComponent((JComponent)VersioningPanel.this.noContentComponent);
                                }
                                VersioningPanel.this.syncTable.setTableModel(syncFileNodeArray);
                            }
                        });
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var9_7 = null;
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                return;
            }
            Object var9_4 = null;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            return;
        }
        Object var9_6 = null;
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void setRepositoryBranchInfo(String string, String string2) {
        String string3 = null;
        string3 = string != null && !string.equals("-1") ? NbBundle.getMessage(VersioningPanel.class, (String)"CTL_VersioningView_BranchInfo", (Object)string, (Object)string2) : NbBundle.getMessage(VersioningPanel.class, (String)"CTL_VersioningView_BranchInfoNotCommitted");
        String string4 = NbBundle.getMessage(VersioningPanel.class, (String)"CTL_VersioningView_StatusTitle", (Object)string3);
        if (!string4.equals(this.statusLabel.getText())) {
            this.statusLabel.setText(string4);
        }
    }

    private String[] getRepositoryBranchInfo(File file) {
        String string = null;
        try {
            string = HgCommand.getBranchInfo(file);
        }
        catch (HgException hgException) {
            Exceptions.printStackTrace((Throwable)hgException);
        }
        return string == null ? null : string.split(":");
    }

    private SyncFileNode[] getNodes(VCSContext vCSContext, int n) {
        HgFileNode[] hgFileNodeArray = this.mercurial.getNodes(vCSContext, n);
        SyncFileNode[] syncFileNodeArray = new SyncFileNode[hgFileNodeArray.length];
        for (int i = 0; i < hgFileNodeArray.length; ++i) {
            if (Thread.interrupted()) {
                return null;
            }
            HgFileNode hgFileNode = hgFileNodeArray[i];
            syncFileNodeArray[i] = new SyncFileNode(hgFileNode, this);
        }
        return syncFileNodeArray;
    }

    public int getDisplayStatuses() {
        return this.displayStatuses;
    }

    public String getDisplayBranchInfo() {
        return this.branchInfo;
    }

    private void onCommitAction() {
        LifecycleManager.getDefault().saveAll();
        CommitAction.commit(this.parentTopComponent.getContentTitle(), this.context);
    }

    private void onUpdateAction() {
        UpdateAction.update(this.context);
        this.parentTopComponent.contentRefreshed();
    }

    private void onRefreshAction() {
        LifecycleManager.getDefault().saveAll();
        if (this.context == null || this.context.getRootFiles().size() == 0) {
            return;
        }
        this.refreshStatuses();
    }

    void performRefreshAction() {
        this.refreshStatuses();
    }

    private void refreshStatuses() {
        String string;
        if (this.hgProgressSupport != null) {
            this.hgProgressSupport.cancel();
            this.hgProgressSupport = null;
        }
        if ((string = HgUtils.getRootPath(this.context)) == null) {
            return;
        }
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(string);
        this.hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                StatusAction.executeStatus(VersioningPanel.this.context, this);
                VersioningPanel.this.setupModels();
            }
        };
        this.parentTopComponent.contentRefreshed();
        this.hgProgressSupport.start(requestProcessor, string, NbBundle.getMessage(VersioningPanel.class, (String)"LBL_Refresh_Progress"));
    }

    private void onDiffAction() {
        String string = this.parentTopComponent.getContentTitle();
        if (this.displayStatuses == 6612) {
            LifecycleManager.getDefault().saveAll();
            DiffAction.diff(this.context, 0, string);
        } else if (this.displayStatuses == 1696) {
            DiffAction.diff(this.context, 1, string);
        } else {
            LifecycleManager.getDefault().saveAll();
            DiffAction.diff(this.context, 2, string);
        }
    }

    private void onDisplayedStatusChanged() {
        this.setDisplayStatuses(8180);
        this.noContentComponent.setLabel(NbBundle.getMessage(VersioningPanel.class, (String)"MSG_No_Changes_All"));
    }

    private void setDisplayStatuses(int n) {
        this.displayStatuses = n;
        this.reScheduleRefresh(0);
    }

    private boolean affectsView(PropertyChangeEvent propertyChangeEvent) {
        FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)propertyChangeEvent.getNewValue();
        File file = changedEvent.getFile();
        FileInformation fileInformation = changedEvent.getOldInfo();
        FileInformation fileInformation2 = changedEvent.getNewInfo();
        if (fileInformation == null ? (fileInformation2.getStatus() & this.displayStatuses) == 0 : (fileInformation.getStatus() & this.displayStatuses) + (fileInformation2.getStatus() & this.displayStatuses) == 0) {
            return false;
        }
        return this.context == null ? false : this.context.contains(file);
    }

    private void reScheduleRefresh(int n) {
        this.refreshViewTask.schedule(n);
    }

    void deserialize() {
        if (this.syncTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    VersioningPanel.this.syncTable.setDefaultColumnSizes();
                }
            });
        }
    }

    void focus() {
        this.syncTable.focus();
    }

    public void cancelRefresh() {
        this.refreshViewTask.cancel();
    }

    private void initComponents() {
        this.jComboBox1 = new JComboBox();
        this.jPanel2 = new JToolBar();
        this.jPanel4 = new JPanel();
        this.statusLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.btnRefresh = new JButton();
        this.btnDiff = new JButton();
        this.jPanel3 = new JPanel();
        this.btnUpdate = new JButton();
        this.btnCommit = new JButton();
        this.jPanel5 = new JPanel();
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.setLayout(new GridBagLayout());
        this.jPanel2.setBorderPainted(false);
        this.jPanel4.setOpaque(false);
        this.jPanel2.add(this.jPanel4);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/mercurial/ui/status/Bundle");
        this.statusLabel.setText(resourceBundle.getString("CTL_Versioning_Status_Table_Title"));
        this.statusLabel.setHorizontalTextPosition(0);
        this.jPanel2.add(this.statusLabel);
        this.statusLabel.getAccessibleContext().setAccessibleName(resourceBundle.getString("CTL_Versioning_Status_Table_Title"));
        this.jPanel1.setOpaque(false);
        this.jPanel1.add(this.jSeparator1);
        this.jPanel2.add(this.jPanel1);
        this.jSeparator2.setOrientation(1);
        this.jPanel2.add(this.jSeparator2);
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/refresh.png")));
        this.btnRefresh.setToolTipText(NbBundle.getMessage(VersioningPanel.class, (String)"CTL_Synchronize_Action_Refresh_Tooltip"));
        this.btnRefresh.setFocusable(false);
        this.btnRefresh.setPreferredSize(new Dimension(22, 25));
        this.btnRefresh.addActionListener(this);
        this.jPanel2.add(this.btnRefresh);
        this.btnRefresh.getAccessibleContext().setAccessibleName("Refresh Status");
        this.btnDiff.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/diff.png")));
        this.btnDiff.setToolTipText(resourceBundle.getString("CTL_Synchronize_Action_Diff_Tooltip"));
        this.btnDiff.setFocusable(false);
        this.btnDiff.setPreferredSize(new Dimension(22, 25));
        this.btnDiff.addActionListener(this);
        this.jPanel2.add(this.btnDiff);
        this.btnDiff.getAccessibleContext().setAccessibleName("Diff All");
        this.jPanel3.setOpaque(false);
        this.jPanel2.add(this.jPanel3);
        this.btnUpdate.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/update.png")));
        this.btnUpdate.setToolTipText(resourceBundle.getString("CTL_Synchronize_Action_Update_Tooltip"));
        this.btnUpdate.setFocusable(false);
        this.btnUpdate.setPreferredSize(new Dimension(22, 25));
        this.btnUpdate.addActionListener(this);
        this.jPanel2.add(this.btnUpdate);
        this.btnUpdate.getAccessibleContext().setAccessibleName("Update");
        this.btnCommit.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/mercurial/resources/icons/commit.png")));
        this.btnCommit.setToolTipText(resourceBundle.getString("CTL_CommitForm_Action_Commit_Tooltip"));
        this.btnCommit.setFocusable(false);
        this.btnCommit.setPreferredSize(new Dimension(22, 25));
        this.btnCommit.addActionListener(this);
        this.jPanel2.add(this.btnCommit);
        this.btnCommit.getAccessibleContext().setAccessibleName("Commit");
        this.jPanel5.setOpaque(false);
        this.jPanel2.add(this.jPanel5);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnRefresh) {
            this.btnRefreshActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.btnDiff) {
            this.btnDiffActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.btnUpdate) {
            this.btnUpdateActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.btnCommit) {
            this.btnCommitActionPerformed(actionEvent);
        }
    }

    private void btnRefreshActionPerformed(ActionEvent actionEvent) {
        this.onRefreshAction();
    }

    private void btnDiffActionPerformed(ActionEvent actionEvent) {
        this.onDiffAction();
    }

    private void btnUpdateActionPerformed(ActionEvent actionEvent) {
        this.onUpdateAction();
    }

    private void btnCommitActionPerformed(ActionEvent actionEvent) {
        this.onCommitAction();
    }

    private class ToolbarLayout
    implements LayoutManager {
        private int TOOLBAR_HEIGHT_ADJUSTMENT = 4;
        private int TOOLBAR_SEPARATOR_MIN_WIDTH = 12;
        private int toolbarHeight = -1;
        private Dimension parentSize;
        private Set<JComponent> adjusted = new HashSet<JComponent>();

        private ToolbarLayout() {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            Dimension dimension = VersioningPanel.this.getSize();
            Dimension dimension2 = container.getSize();
            int n = dimension2.width - this.minimumLayoutSize((Container)container).width;
            int n2 = container.getComponentCount();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                JComponent jComponent = (JComponent)container.getComponent(i);
                if (!jComponent.isVisible()) continue;
                jComponent.setLocation(n3, 0);
                Dimension dimension3 = jComponent.getPreferredSize();
                int n4 = dimension3.width;
                if (jComponent instanceof JSeparator && dimension.height - dimension.width <= 0) {
                    n4 = Math.max(n4, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                }
                if (jComponent instanceof JProgressBar && n > 0) {
                    n4 += n;
                }
                int n5 = this.getToolbarHeight(dimension) - 1;
                jComponent.setSize(n4, n5);
                n3 += n4;
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = VersioningPanel.this.getSize();
            int n = this.getToolbarHeight(dimension);
            int n2 = container.getComponentCount();
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                if (component instanceof AbstractButton) {
                    this.adjustToobarButton((AbstractButton)component);
                } else {
                    this.adjustToolbarComponentSize((JComponent)component);
                }
                Dimension dimension2 = component.getPreferredSize();
                int n4 = dimension2.width;
                if (component instanceof JSeparator && dimension.height - dimension.width <= 0) {
                    n4 = Math.max(n4, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                }
                n3 += n4;
            }
            return new Dimension(n3, n);
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = VersioningPanel.this.getSize();
            int n = this.getToolbarHeight(dimension);
            return new Dimension(Integer.MAX_VALUE, n);
        }

        private int getToolbarHeight(Dimension dimension) {
            if (this.parentSize == null || !this.parentSize.equals(dimension)) {
                this.parentSize = dimension;
                this.toolbarHeight = -1;
            }
            if (this.toolbarHeight == -1) {
                BufferedImage bufferedImage = new BufferedImage(1, 1, 10);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
                int n = 0;
                String[] stringArray = new String[]{"Label.font", "Button.font", "ToggleButton.font"};
                for (int i = 0; i < stringArray.length; ++i) {
                    Font font = uIDefaults.getFont(stringArray[i]);
                    FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
                    n = Math.max(n, fontMetrics.getHeight());
                }
                this.toolbarHeight = n + this.TOOLBAR_HEIGHT_ADJUSTMENT;
                if (dimension.height - dimension.width > 0) {
                    this.toolbarHeight += this.TOOLBAR_HEIGHT_ADJUSTMENT;
                }
            }
            return this.toolbarHeight;
        }

        private void adjustToobarButton(final AbstractButton abstractButton) {
            if (this.adjusted.contains(abstractButton)) {
                return;
            }
            if (!(abstractButton instanceof JToggleButton)) {
                abstractButton.setContentAreaFilled(false);
                abstractButton.setMargin(new Insets(0, 3, 0, 3));
                abstractButton.setBorderPainted(false);
                abstractButton.addMouseListener(new MouseAdapter(){

                    public void mouseEntered(MouseEvent mouseEvent) {
                        abstractButton.setContentAreaFilled(true);
                        abstractButton.setBorderPainted(true);
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                        abstractButton.setContentAreaFilled(false);
                        abstractButton.setBorderPainted(false);
                    }
                });
            }
            this.adjustToolbarComponentSize(abstractButton);
        }

        private void adjustToolbarComponentSize(JComponent jComponent) {
            if (this.adjusted.contains(jComponent)) {
                return;
            }
            if (jComponent.getBorder() instanceof CompoundBorder) {
                Dimension dimension = jComponent.getPreferredSize();
                if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                    dimension.width += 9;
                }
                jComponent.setPreferredSize(dimension);
            }
            this.adjusted.add(jComponent);
        }
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        public void run() {
            VersioningPanel.this.setupModels();
        }
    }
}

