/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.ui.repository.RepositoryConnection;
import org.netbeans.modules.mercurial.ui.repository.RepositoryDialogPanel;
import org.netbeans.modules.mercurial.ui.repository.RepositoryPanel;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository
implements ActionListener,
DocumentListener,
FocusListener,
ItemListener {
    public static final int FLAG_URL_EDITABLE = 2;
    public static final int FLAG_URL_ENABLED = 4;
    public static final int FLAG_ACCEPT_REVISION = 8;
    public static final int FLAG_SHOW_REMOVE = 16;
    public static final int FLAG_SHOW_HINTS = 32;
    public static final int FLAG_SHOW_PROXY = 64;
    private static final String LOCAL_URL_HELP = "file:///repository_path";
    private static final String HTTP_URL_HELP = "http://[username[:password]@]hostname/repository_path";
    private static final String HTTPS_URL_HELP = "https://[username[:password]@]hostname/repository_path";
    private static final String STATIC_HTTP_URL_HELP = "static-http://hostname/repository_path";
    private static final String SSH_URL_HELP = "ssh://hostname/repository_path";
    private RepositoryPanel repositoryPanel;
    private boolean valid = true;
    private List<PropertyChangeListener> listeners;
    private RepositoryConnection editedRC;
    public static final String PROP_VALID = "valid";
    private String message;
    private int modeMask;
    private Dimension maxNeededSize;
    private boolean bPushPull;
    private static int HG_PUSH_PULL_VERT_PADDING = 30;

    public Repository(String string) {
        this(0, string, false);
    }

    public Repository(int n, String string, boolean bl) {
        this.modeMask = n;
        this.initPanel();
        this.repositoryPanel.titleLabel.setText(string);
        this.repositoryPanel.urlComboBox.setEditable(this.isSet(2));
        this.repositoryPanel.urlComboBox.setEnabled(this.isSet(4));
        this.repositoryPanel.tunnelHelpLabel.setVisible(this.isSet(32));
        this.repositoryPanel.tipLabel.setVisible(this.isSet(32));
        this.repositoryPanel.removeButton.setVisible(this.isSet(16));
        if (bl) {
            this.updateVisibility("foo:");
        } else {
            this.updateVisibility("https:");
        }
        this.maxNeededSize = this.repositoryPanel.getPreferredSize();
        this.repositoryPanel.savePasswordCheckBox.setSelected(HgModuleConfig.getDefault().getSavePassword());
        this.refreshUrlHistory();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.repositoryPanel.proxySettingsButton) {
            this.onProxyConfiguration();
        } else if (actionEvent.getSource() == this.repositoryPanel.removeButton) {
            this.onRemoveClick();
        } else if (actionEvent.getSource() == this.repositoryPanel.savePasswordCheckBox) {
            this.onSavePasswordChange();
        }
    }

    private void onProxyConfiguration() {
        OptionsDisplayer.getDefault().open("General");
    }

    private void initPanel() {
        this.repositoryPanel = new RepositoryPanel();
        this.repositoryPanel.proxySettingsButton.addActionListener(this);
        this.repositoryPanel.removeButton.addActionListener(this);
        this.repositoryPanel.urlComboBox.addActionListener(this);
        this.getUrlComboEditor().getDocument().addDocumentListener(this);
        this.repositoryPanel.userPasswordField.getDocument().addDocumentListener(this);
        this.repositoryPanel.userPasswordField.addFocusListener(this);
        this.repositoryPanel.userTextField.getDocument().addDocumentListener(this);
        this.repositoryPanel.tunnelCommandTextField.getDocument().addDocumentListener(this);
        this.repositoryPanel.savePasswordCheckBox.addActionListener(this);
        this.repositoryPanel.urlComboBox.addItemListener(this);
        this.onSelectedRepositoryChange();
    }

    public void refreshUrlHistory() {
        List<RepositoryConnection> list = HgModuleConfig.getDefault().getRecentUrls();
        LinkedHashSet<RepositoryConnection> linkedHashSet = new LinkedHashSet<RepositoryConnection>();
        linkedHashSet.addAll(list);
        if (this.repositoryPanel.urlComboBox.isEditable()) {
            linkedHashSet.add(new RepositoryConnection("file:///"));
            linkedHashSet.add(new RepositoryConnection("http://"));
            linkedHashSet.add(new RepositoryConnection("https://"));
            linkedHashSet.add(new RepositoryConnection("static-http://"));
            linkedHashSet.add(new RepositoryConnection("ssh://"));
        }
        RepositoryModel repositoryModel = new RepositoryModel(new Vector(linkedHashSet));
        this.repositoryPanel.urlComboBox.setModel(repositoryModel);
        if (linkedHashSet.size() > 0) {
            this.repositoryPanel.urlComboBox.setSelectedIndex(0);
            this.refresh(this.getSelectedRC());
        }
        if (this.repositoryPanel.urlComboBox.isEditable()) {
            JTextComponent jTextComponent = this.getUrlComboEditor();
            jTextComponent.selectAll();
        }
        this.updateVisibility();
    }

    public void storeRecentUrls() {
        HgModuleConfig.getDefault().setRecentUrls(this.getRecentUrls());
    }

    private List<RepositoryConnection> getRecentUrls() {
        ComboBoxModel comboBoxModel = this.repositoryPanel.urlComboBox.getModel();
        ArrayList<RepositoryConnection> arrayList = new ArrayList<RepositoryConnection>(comboBoxModel.getSize());
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            arrayList.add((RepositoryConnection)comboBoxModel.getElementAt(i));
        }
        return arrayList;
    }

    private JTextComponent getUrlComboEditor() {
        Component component = this.repositoryPanel.urlComboBox.getEditor().getEditorComponent();
        JTextComponent jTextComponent = (JTextComponent)component;
        return jTextComponent;
    }

    public void setEditable(boolean bl) {
        this.repositoryPanel.urlComboBox.setEditable(bl);
        this.repositoryPanel.userPasswordField.setEditable(bl);
        this.repositoryPanel.userTextField.setEditable(bl);
        this.repositoryPanel.proxySettingsButton.setEnabled(bl);
    }

    public void storeConfigValues() {
        RepositoryConnection repositoryConnection = this.getSelectedRC();
        if (repositoryConnection == null) {
            return;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.textChanged(documentEvent);
    }

    private void textChanged(final DocumentEvent documentEvent) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (documentEvent.getDocument() == ((Repository)Repository.this).repositoryPanel.userTextField.getDocument()) {
                    Repository.this.onUsernameChange();
                } else if (documentEvent.getDocument() == ((Repository)Repository.this).repositoryPanel.userPasswordField.getDocument()) {
                    Repository.this.onPasswordChange();
                } else if (documentEvent.getDocument() == ((JTextComponent)((Repository)Repository.this).repositoryPanel.urlComboBox.getEditor().getEditorComponent()).getDocument()) {
                    Repository.this.onSelectedRepositoryChange();
                } else if (documentEvent.getDocument() == ((Repository)Repository.this).repositoryPanel.tunnelCommandTextField.getDocument()) {
                    Repository.this.onTunnelCommandChange();
                }
                Repository.this.validateHgUrl();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void validateHgUrl() {
        boolean bl = true;
        RepositoryConnection repositoryConnection = null;
        try {
            repositoryConnection = this.getSelectedRC();
            repositoryConnection.getHgUrl();
        }
        catch (Exception exception) {
            this.message = exception.getLocalizedMessage();
            bl = false;
        }
        if (bl) {
            bl = repositoryConnection != null && !repositoryConnection.getUrl().equals("");
        }
        this.setValid(bl, this.message);
        this.repositoryPanel.proxySettingsButton.setEnabled(bl);
        this.repositoryPanel.userPasswordField.setEnabled(bl);
        this.repositoryPanel.userTextField.setEnabled(bl);
        this.repositoryPanel.removeButton.setEnabled(repositoryConnection != null && repositoryConnection.getUrl().length() > 0);
    }

    private void onSelectedRepositoryChange() {
        this.setValid(true, "");
        String string = "";
        try {
            string = this.getUrlString();
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (string != null) {
            RepositoryConnection repositoryConnection = this.getEditedRC();
            repositoryConnection.setUrl(string);
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.repositoryPanel.urlComboBox.getModel();
            int n = defaultComboBoxModel.getIndexOf(repositoryConnection);
            if (n > -1) {
                this.refresh((RepositoryConnection)defaultComboBoxModel.getElementAt(n));
            }
            if (string.startsWith("svn+")) {
                String string2 = this.getTunnelName(string).trim();
                if (!this.repositoryPanel.tunnelCommandTextField.getText().trim().equals("") || string2 == null || !string2.equals("")) {
                    // empty if block
                }
            }
            repositoryConnection.setUsername(this.repositoryPanel.userTextField.getText());
            repositoryConnection.setPassword(new String(this.repositoryPanel.userPasswordField.getPassword()));
            repositoryConnection.setExternalCommand(this.repositoryPanel.tunnelCommandTextField.getText());
            repositoryConnection.setSavePassword(this.repositoryPanel.savePasswordCheckBox.isSelected());
        }
        this.message = "";
        this.updateVisibility();
    }

    private RepositoryConnection getEditedRC() {
        if (this.editedRC == null) {
            this.editedRC = new RepositoryConnection("");
        }
        return this.editedRC;
    }

    private void updateVisibility() {
        try {
            this.updateVisibility(this.getUrlString());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    private void updateVisibility(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (string.startsWith("http:")) {
            this.repositoryPanel.tipLabel.setText(HTTP_URL_HELP);
            bl = true;
            bl2 = true;
        } else if (string.startsWith("https:")) {
            this.repositoryPanel.tipLabel.setText(HTTPS_URL_HELP);
            bl2 = true;
        } else if (string.startsWith("static-http:")) {
            this.repositoryPanel.tipLabel.setText(STATIC_HTTP_URL_HELP);
            bl = true;
            bl2 = true;
        } else if (string.startsWith("ssh")) {
            this.repositoryPanel.tipLabel.setText(this.getSVNTunnelTip(string));
            bl3 = true;
        } else if (string.startsWith("file:")) {
            this.repositoryPanel.tipLabel.setText(LOCAL_URL_HELP);
        } else {
            this.repositoryPanel.tipLabel.setText(NbBundle.getMessage(Repository.class, (String)"MSG_Repository_Url_Help", (Object[])new Object[]{LOCAL_URL_HELP, HTTP_URL_HELP, HTTPS_URL_HELP, STATIC_HTTP_URL_HELP, SSH_URL_HELP}));
        }
        this.repositoryPanel.userPasswordField.setVisible(false);
        this.repositoryPanel.passwordLabel.setVisible(false);
        this.repositoryPanel.userTextField.setVisible(false);
        this.repositoryPanel.leaveBlankLabel.setVisible(false);
        this.repositoryPanel.userLabel.setVisible(false);
        this.repositoryPanel.savePasswordCheckBox.setVisible(false);
        this.repositoryPanel.proxySettingsButton.setVisible(bl2 && (this.modeMask & 0x40) != 0);
        this.repositoryPanel.savePasswordCheckBox.setVisible(false);
        this.repositoryPanel.tunnelCommandTextField.setVisible(false);
        this.repositoryPanel.tunnelCommandLabel.setVisible(false);
        this.repositoryPanel.tunnelLabel.setVisible(false);
        this.repositoryPanel.tunnelHelpLabel.setVisible(false);
    }

    private String getSVNTunnelTip(String string) {
        return SSH_URL_HELP;
    }

    private String getTunnelName(String string) {
        int n = string.indexOf(":", 4);
        if (n < 0) {
            n = string.length();
        }
        return string.substring(4, n);
    }

    private String getUrlString() throws InterruptedException {
        if (!this.repositoryPanel.urlComboBox.isEditable()) {
            Object object = this.repositoryPanel.urlComboBox.getSelectedItem();
            if (object != null) {
                return object.toString().trim();
            }
            return "";
        }
        final String[] stringArray = new String[1];
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    stringArray[0] = ((Repository)Repository.this).repositoryPanel.urlComboBox.getEditor().getItem().toString().trim();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
            return stringArray[0].trim();
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager errorManager = ErrorManager.getDefault();
            errorManager.notify((Throwable)invocationTargetException);
            return null;
        }
    }

    public RepositoryConnection getSelectedRC() {
        String string;
        try {
            string = this.getUrlString();
        }
        catch (InterruptedException interruptedException) {
            ErrorManager.getDefault().notify((Throwable)interruptedException);
            return null;
        }
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.repositoryPanel.urlComboBox.getModel();
        int n = defaultComboBoxModel.getIndexOf(string);
        if (n > -1) {
            return (RepositoryConnection)defaultComboBoxModel.getElementAt(n);
        }
        return this.getEditedRC();
    }

    public boolean savePassword() {
        return this.repositoryPanel.savePasswordCheckBox.isSelected();
    }

    private void onUsernameChange() {
        RepositoryConnection repositoryConnection = this.getSelectedRC();
        if (repositoryConnection != null) {
            repositoryConnection.setUsername(this.repositoryPanel.userTextField.getText());
        }
        this.setValid(true, "");
    }

    private void onPasswordChange() {
        RepositoryConnection repositoryConnection = this.getSelectedRC();
        if (repositoryConnection != null) {
            repositoryConnection.setPassword(new String(this.repositoryPanel.userPasswordField.getPassword()));
        }
        this.setValid(true, "");
    }

    private void onTunnelCommandChange() {
        RepositoryConnection repositoryConnection = this.getSelectedRC();
        if (repositoryConnection != null) {
            repositoryConnection.setExternalCommand(this.repositoryPanel.tunnelCommandTextField.getText());
        }
    }

    private void onRemoveClick() {
        RepositoryConnection repositoryConnection = this.getSelectedRC();
        if (repositoryConnection != null) {
            this.remove(repositoryConnection);
        }
    }

    private void onSavePasswordChange() {
        Runnable runnable = new Runnable(){

            public void run() {
                RepositoryConnection repositoryConnection = Repository.this.getSelectedRC();
                if (repositoryConnection != null) {
                    repositoryConnection.setSavePassword(((Repository)Repository.this).repositoryPanel.savePasswordCheckBox.isSelected());
                }
                Repository.this.validateHgUrl();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public RepositoryPanel getPanel() {
        return this.repositoryPanel;
    }

    public boolean isValid() {
        return this.valid;
    }

    private void setValid(boolean bl, String string) {
        boolean bl2 = this.valid;
        this.message = string;
        this.valid = bl;
        this.fireValidPropertyChanged(bl2, bl);
    }

    private void fireValidPropertyChanged(boolean bl, boolean bl2) {
        if (this.listeners == null) {
            return;
        }
        for (PropertyChangeListener propertyChangeListener : this.listeners) {
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, PROP_VALID, new Boolean(bl), new Boolean(bl2)));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        this.listeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(propertyChangeListener);
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.repositoryPanel.userPasswordField) {
            this.repositoryPanel.userPasswordField.selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    public void remove(RepositoryConnection repositoryConnection) {
        RepositoryModel repositoryModel = (RepositoryModel)this.repositoryPanel.urlComboBox.getModel();
        repositoryModel.removeElement(repositoryConnection);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            RepositoryConnection repositoryConnection = (RepositoryConnection)itemEvent.getItem();
            this.refresh(repositoryConnection);
            this.updateVisibility();
            this.editedRC = new RepositoryConnection(repositoryConnection);
        } else if (itemEvent.getStateChange() == 2) {
            this.updateVisibility();
        }
    }

    private void refresh(RepositoryConnection repositoryConnection) {
        this.repositoryPanel.userTextField.setText(repositoryConnection.getUsername());
        this.repositoryPanel.userPasswordField.setText(repositoryConnection.getPassword());
        this.repositoryPanel.tunnelCommandTextField.setText(repositoryConnection.getExternalCommand());
        this.repositoryPanel.savePasswordCheckBox.setSelected(repositoryConnection.getSavePassword());
    }

    public void setTipVisible(Boolean bl) {
        this.repositoryPanel.tipLabel.setVisible(bl);
    }

    public boolean show(String string, HelpCtx helpCtx, boolean bl) {
        RepositoryDialogPanel repositoryDialogPanel = new RepositoryDialogPanel();
        repositoryDialogPanel.panel.setLayout(new BorderLayout());
        RepositoryPanel repositoryPanel = this.getPanel();
        if (bl) {
            if (this.bPushPull) {
                this.maxNeededSize.setSize(this.maxNeededSize.width, this.maxNeededSize.height + HG_PUSH_PULL_VERT_PADDING);
            }
            repositoryPanel.setPreferredSize(this.maxNeededSize);
        }
        repositoryDialogPanel.panel.add((Component)repositoryPanel, "North");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)repositoryDialogPanel, string);
        this.showDialog(dialogDescriptor, helpCtx, null);
        return dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION;
    }

    public Object show(String string, HelpCtx helpCtx, Object[] objectArray, boolean bl, String string2) {
        RepositoryDialogPanel repositoryDialogPanel = new RepositoryDialogPanel();
        repositoryDialogPanel.panel.setLayout(new BorderLayout());
        repositoryDialogPanel.panel.add((Component)this.getPanel(), "North");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)repositoryDialogPanel, string);
        RepositoryPanel repositoryPanel = this.getPanel();
        if (bl) {
            if (this.bPushPull) {
                this.maxNeededSize.setSize(this.maxNeededSize.width, this.maxNeededSize.height + HG_PUSH_PULL_VERT_PADDING);
            }
            repositoryPanel.setPreferredSize(this.maxNeededSize);
        }
        if (objectArray != null) {
            dialogDescriptor.setOptions(objectArray);
        }
        this.showDialog(dialogDescriptor, helpCtx, string2);
        return dialogDescriptor.getValue();
    }

    private void showDialog(DialogDescriptor dialogDescriptor, HelpCtx helpCtx, String string) {
        dialogDescriptor.setModal(true);
        dialogDescriptor.setHelpCtx(helpCtx);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        if (string != null) {
            dialog.addWindowListener((WindowListener)new DialogBoundsPreserver(HgModuleConfig.getDefault().getPreferences(), string));
        }
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(Repository.class, (String)"ACSD_RepositoryPanel"));
        dialog.setVisible(true);
    }

    private boolean isSet(int n) {
        return (this.modeMask & n) != 0;
    }

    public class RepositoryModel
    extends DefaultComboBoxModel {
        public RepositoryModel(Vector vector) {
            super(vector);
        }

        public void setSelectedItem(Object object) {
            if (object instanceof String) {
                int n = this.getIndexOf(object);
                object = n > -1 ? this.getElementAt(n) : this.createNewRepositoryConnection((String)object);
            }
            super.setSelectedItem(object);
        }

        public int getIndexOf(Object object) {
            if (object instanceof String) {
                object = this.createNewRepositoryConnection((String)object);
            }
            return super.getIndexOf(object);
        }

        public void addElement(Object object) {
            if (object instanceof String) {
                object = this.createNewRepositoryConnection((String)object);
            }
            super.addElement(object);
        }

        public void insertElementAt(Object object, int n) {
            if (object instanceof String) {
                String string = (String)object;
                RepositoryConnection repositoryConnection = null;
                try {
                    repositoryConnection = (RepositoryConnection)this.getElementAt(n);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (repositoryConnection != null) {
                    repositoryConnection.setUrl(string);
                    object = repositoryConnection;
                }
                object = this.createNewRepositoryConnection(string);
            }
            super.insertElementAt(object, n);
        }

        public void removeElement(Object object) {
            int n = this.getIndexOf(object);
            if (n != -1) {
                this.removeElementAt(n);
            }
        }

        private RepositoryConnection createNewRepositoryConnection(String string) {
            Repository.this.editedRC.setUrl(string);
            return new RepositoryConnection(Repository.this.editedRC);
        }
    }
}

