/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.pull;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FetchAction
extends ContextAction {
    private final VCSContext context;

    public FetchAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        final File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            return;
        }
        RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file);
        HgProgressSupport hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                FetchAction.performFetch(file, this.getLogger());
            }
        };
        hgProgressSupport.start(requestProcessor, file.getAbsolutePath(), NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_PROGRESS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performFetch(File file, OutputLogger outputLogger) {
        try {
            block4: {
                try {
                    outputLogger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_TITLE"));
                    outputLogger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_TITLE_SEP"));
                    outputLogger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_LAUNCH_INFO", (Object)file.getAbsolutePath()));
                    List<String> list = HgCommand.doFetch(file, outputLogger);
                    if (list == null || list.isEmpty()) break block4;
                    outputLogger.output(HgUtils.replaceHttpPassword(list));
                }
                catch (HgException hgException) {
                    NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                    Object var5_5 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_DONE"));
                    outputLogger.output("");
                }
            }
            Object var5_4 = null;
            outputLogger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_DONE"));
            outputLogger.output("");
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            outputLogger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_DONE"));
            outputLogger.output("");
            throw throwable;
        }
    }

    public boolean isEnabled() {
        return HgUtils.getRootFile(this.context) != null;
    }
}

