/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.create;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CreateAction
extends ContextAction {
    private final VCSContext context;
    Map<File, FileInformation> repositoryFiles = new HashMap<File, FileInformation>();

    public CreateAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public boolean isEnabled() {
        File file = HgUtils.getRootFile(this.context);
        File[] fileArray = this.context.getRootFiles().toArray(new File[this.context.getRootFiles().size()]);
        if (fileArray == null || fileArray.length == 0) {
            return false;
        }
        return file == null;
    }

    private File getCommonAncestor(File file, File file2) {
        if (file.equals(file2)) {
            return file;
        }
        for (File file3 = file; file3 != null; file3 = file3.getParentFile()) {
            for (File file4 = file2; file4 != null; file4 = file4.getParentFile()) {
                if (!file3.equals(file4)) continue;
                return file4;
            }
        }
        return null;
    }

    private File getCommonAncestor(File[] fileArray) {
        File file = fileArray[0];
        for (int i = 1; i < fileArray.length; ++i) {
            if ((file = this.getCommonAncestor(file, fileArray[i])) != null) continue;
            Mercurial.LOG.log(Level.SEVERE, "Unable to get common parent of {0} and {1} ", new Object[]{file.getAbsolutePath(), fileArray[i].getAbsolutePath()});
        }
        return file;
    }

    public void performAction(ActionEvent actionEvent) {
        Object object;
        HgProgressSupport hgProgressSupport;
        OutputLogger outputLogger;
        File file2;
        final Mercurial mercurial = Mercurial.getInstance();
        Project project = this.context.getRootFiles().toArray(new File[this.context.getRootFiles().size()]);
        if (project == null || ((File[])project).length == 0) {
            return;
        }
        for (File file2 : project) {
            if (!file2.isDirectory()) {
                file2 = file2.getParentFile();
            }
            if (mercurial.getTopmostManagedParent(file2) == null) continue;
            Mercurial.LOG.log(Level.SEVERE, "Found .hg directory in ancestor of {0} ", file2);
            return;
        }
        final Project project2 = HgUtils.getProject(this.context);
        final File file3 = HgUtils.getProjectFile(project2);
        if (file3 == null) {
            OutputLogger outputLogger2 = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            outputLogger2.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_TITLE"));
            outputLogger2.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_TITLE_SEP"));
            outputLogger2.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_NOT_SUPPORTED_INVIEW_INFO"));
            outputLogger2.output("");
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            outputLogger2.closeLog();
            return;
        }
        String string = HgProjectUtils.getProjectName(file3);
        file2 = null;
        file2 = this.getCommonAncestor((File[])project);
        if ((file2 = this.getCommonAncestor(file2, file3)) == null) {
            return;
        }
        final File file4 = file2;
        final String string2 = string;
        if (file4.getAbsolutePath().indexOf(file3.getAbsolutePath()) != 0) {
            outputLogger = OutputLogger.getLogger(file4.getAbsolutePath());
            outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_TITLE"));
            outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_TITLE_SEP"));
            outputLogger.output(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_INFO1", (Object)file3.getAbsolutePath()));
            for (1 var14_18 : project) {
                if (((File)((Object)var14_18)).getAbsolutePath().indexOf(file3.getAbsolutePath()) == 0) continue;
                outputLogger.output("        " + ((File)((Object)var14_18)).getAbsolutePath());
            }
            outputLogger.output(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_INFO2", (Object)file4.getAbsolutePath()));
            hgProgressSupport = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_CONFIRM_QUERY", (Object)file4.getAbsolutePath()));
            hgProgressSupport.setTitle(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_CONFIRM_TITLE"));
            hgProgressSupport.setMessageType(1);
            hgProgressSupport.setOptionType(2);
            object = DialogDisplayer.getDefault().notify((NotifyDescriptor)hgProgressSupport);
            if (object == NotifyDescriptor.CANCEL_OPTION) {
                outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_CANCELED", (Object)file4.getAbsolutePath()));
                outputLogger.output("");
                return;
            }
        }
        outputLogger = mercurial.getRequestProcessor(file4.getAbsolutePath());
        hgProgressSupport = new HgProgressSupport(){

            public void perform() {
                try {
                    OutputLogger outputLogger = this.getLogger();
                    if (file4.getAbsolutePath().indexOf(file3.getAbsolutePath()) == 0) {
                        outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_TITLE"));
                        outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_TITLE_SEP"));
                    }
                    outputLogger.output(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_INIT", (Object)string2, (Object)file4));
                    HgCommand.doCreate(file4, outputLogger);
                    mercurial.versionedFilesChanged();
                    mercurial.refreshAllAnnotations();
                }
                catch (HgException hgException) {
                    NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                }
            }
        };
        hgProgressSupport.start((RequestProcessor)outputLogger, file4.getAbsolutePath(), NbBundle.getMessage(CreateAction.class, (String)"MSG_Create_Progress"));
        object = new HgProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform() {
                OutputLogger outputLogger = this.getLogger();
                try {
                    try {
                        File[] fileArray = HgUtils.getProjectRootFiles(project2);
                        FileStatusCache fileStatusCache = mercurial.getFileStatusCache();
                        FileInformation fileInformation = new FileInformation(4, null, false);
                        for (int i = 0; i < fileArray.length; ++i) {
                            File file = fileArray[i];
                            Calendar calendar = Calendar.getInstance();
                            CreateAction.this.repositoryFiles = HgCommand.getUnknownStatus(file4, file);
                            Calendar calendar2 = Calendar.getInstance();
                            Mercurial.LOG.log(Level.FINE, "getUnknownStatus took {0} millisecs", calendar2.getTimeInMillis() - calendar.getTimeInMillis());
                            outputLogger.output(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_ADD", (Object)CreateAction.this.repositoryFiles.keySet().size(), (Object)file.getAbsolutePath()));
                            calendar = Calendar.getInstance();
                            fileStatusCache.addToCache(CreateAction.this.repositoryFiles.keySet());
                            calendar2 = Calendar.getInstance();
                            Mercurial.LOG.log(Level.FINE, "addUnknownsToCache took {0} millisecs", calendar2.getTimeInMillis() - calendar.getTimeInMillis());
                            if (CreateAction.this.repositoryFiles.keySet().size() >= 500) continue;
                            for (File file2 : CreateAction.this.repositoryFiles.keySet()) {
                                outputLogger.output("\t" + file2.getAbsolutePath());
                            }
                        }
                        HgUtils.createIgnored(file4);
                        outputLogger.output("");
                        outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_DONE_WARNING"));
                    }
                    catch (HgException hgException) {
                        NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                        Object var12_14 = null;
                        outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_DONE"));
                        outputLogger.output("");
                    }
                    Object var12_13 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_DONE"));
                    outputLogger.output("");
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    outputLogger.outputInRed(NbBundle.getMessage(CreateAction.class, (String)"MSG_CREATE_DONE"));
                    outputLogger.output("");
                    throw throwable;
                }
            }
        };
        ((HgProgressSupport)object).start((RequestProcessor)outputLogger, file4.getAbsolutePath(), NbBundle.getMessage(CreateAction.class, (String)"MSG_Create_Add_Progress"));
    }
}

